# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class GenerativevalidationStartTestRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'url': 'str',
        'http_headers': 'dict(str, str)',
        'endpoint_payload_template': 'str',
        'response_json_path': 'str',
        'http_auth_integration_id': 'RimeUUID',
        'name': 'str',
        'mutual_tls_integration_id': 'RimeUUID',
        'system_prompt': 'str',
        'aws_integration_id': 'RimeUUID',
        'model_id': 'str',
        'body': 'GenerativevalidationBody'
    }

    attribute_map = {
        'url': 'url',
        'http_headers': 'httpHeaders',
        'endpoint_payload_template': 'endpointPayloadTemplate',
        'response_json_path': 'responseJsonPath',
        'http_auth_integration_id': 'httpAuthIntegrationId',
        'name': 'name',
        'mutual_tls_integration_id': 'mutualTlsIntegrationId',
        'system_prompt': 'systemPrompt',
        'aws_integration_id': 'awsIntegrationId',
        'model_id': 'modelId',
        'body': 'body'
    }

    def __init__(self, url=None, http_headers=None, endpoint_payload_template=None, response_json_path=None, http_auth_integration_id=None, name=None, mutual_tls_integration_id=None, system_prompt=None, aws_integration_id=None, model_id=None, body=None):  # noqa: E501
        """GenerativevalidationStartTestRequest - a model defined in Swagger"""  # noqa: E501
        self._url = None
        self._http_headers = None
        self._endpoint_payload_template = None
        self._response_json_path = None
        self._http_auth_integration_id = None
        self._name = None
        self._mutual_tls_integration_id = None
        self._system_prompt = None
        self._aws_integration_id = None
        self._model_id = None
        self._body = None
        self.discriminator = None
        if url is not None:
            self.url = url
        if http_headers is not None:
            self.http_headers = http_headers
        if endpoint_payload_template is not None:
            self.endpoint_payload_template = endpoint_payload_template
        if response_json_path is not None:
            self.response_json_path = response_json_path
        if http_auth_integration_id is not None:
            self.http_auth_integration_id = http_auth_integration_id
        if name is not None:
            self.name = name
        if mutual_tls_integration_id is not None:
            self.mutual_tls_integration_id = mutual_tls_integration_id
        if system_prompt is not None:
            self.system_prompt = system_prompt
        if aws_integration_id is not None:
            self.aws_integration_id = aws_integration_id
        if model_id is not None:
            self.model_id = model_id
        if body is not None:
            self.body = body

    @property
    def url(self):
        """Gets the url of this GenerativevalidationStartTestRequest.  # noqa: E501

        Parameters for connecting to the user's generative model.  # noqa: E501

        :return: The url of this GenerativevalidationStartTestRequest.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this GenerativevalidationStartTestRequest.

        Parameters for connecting to the user's generative model.  # noqa: E501

        :param url: The url of this GenerativevalidationStartTestRequest.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def http_headers(self):
        """Gets the http_headers of this GenerativevalidationStartTestRequest.  # noqa: E501


        :return: The http_headers of this GenerativevalidationStartTestRequest.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._http_headers

    @http_headers.setter
    def http_headers(self, http_headers):
        """Sets the http_headers of this GenerativevalidationStartTestRequest.


        :param http_headers: The http_headers of this GenerativevalidationStartTestRequest.  # noqa: E501
        :type: dict(str, str)
        """

        self._http_headers = http_headers

    @property
    def endpoint_payload_template(self):
        """Gets the endpoint_payload_template of this GenerativevalidationStartTestRequest.  # noqa: E501

        A string template that will be used to create the json payload sent to the LLM endpoint. This template must contain one and only one variable -- prompt_string. This will be replaced at runtime with the prompt used to send to the model. Used for arbitrary HTTP requests to models.  The template uses \" and \" as the opening and closing delimiters around the prompt_string variable name.  Example: '{ \"prompt\": \"{{prompt_string}}\" }' Example: '{ \"message\": { \"llm_prompt\": \"{{prompt_string}}\" } }'  # noqa: E501

        :return: The endpoint_payload_template of this GenerativevalidationStartTestRequest.  # noqa: E501
        :rtype: str
        """
        return self._endpoint_payload_template

    @endpoint_payload_template.setter
    def endpoint_payload_template(self, endpoint_payload_template):
        """Sets the endpoint_payload_template of this GenerativevalidationStartTestRequest.

        A string template that will be used to create the json payload sent to the LLM endpoint. This template must contain one and only one variable -- prompt_string. This will be replaced at runtime with the prompt used to send to the model. Used for arbitrary HTTP requests to models.  The template uses \" and \" as the opening and closing delimiters around the prompt_string variable name.  Example: '{ \"prompt\": \"{{prompt_string}}\" }' Example: '{ \"message\": { \"llm_prompt\": \"{{prompt_string}}\" } }'  # noqa: E501

        :param endpoint_payload_template: The endpoint_payload_template of this GenerativevalidationStartTestRequest.  # noqa: E501
        :type: str
        """

        self._endpoint_payload_template = endpoint_payload_template

    @property
    def response_json_path(self):
        """Gets the response_json_path of this GenerativevalidationStartTestRequest.  # noqa: E501

        A json path specifying where in the HTTP response json payload we can find the LLM's response string. Note that the path must point to a string value in the json payload. Whitespace and other special characters can be encoded as unicode (\\u0020). Periods in json fields can be escaped with a backslash.  Example (top level field): - Endpoint response json: {\"response\": \"I am an AI Chatbot, how can I assist you?\"} - response_json_path: \"response\"  Example (nested json field): - Endpoint response json: {\"response\": {\"llmResponse\": \"I am an AI Chatbot, how can I assist you?\"}} - response_json_path: \"response.llmResponse\"  Example (extract string from array): - Endpoint response: {\"response\": {\"options\": [\"Hi\", \"Hello there\"], \"count\": 2}} - response_json_path: \"response.options.1\"  Example (periods in field names): - Endpoint response: {\"llm.response\": \"hello\"} - response_json_path: \"llm\\\\.response\"  The syntax uses dot notation only, such as \"myfield.myotherfield\" or \"myarray.1\".  # noqa: E501

        :return: The response_json_path of this GenerativevalidationStartTestRequest.  # noqa: E501
        :rtype: str
        """
        return self._response_json_path

    @response_json_path.setter
    def response_json_path(self, response_json_path):
        """Sets the response_json_path of this GenerativevalidationStartTestRequest.

        A json path specifying where in the HTTP response json payload we can find the LLM's response string. Note that the path must point to a string value in the json payload. Whitespace and other special characters can be encoded as unicode (\\u0020). Periods in json fields can be escaped with a backslash.  Example (top level field): - Endpoint response json: {\"response\": \"I am an AI Chatbot, how can I assist you?\"} - response_json_path: \"response\"  Example (nested json field): - Endpoint response json: {\"response\": {\"llmResponse\": \"I am an AI Chatbot, how can I assist you?\"}} - response_json_path: \"response.llmResponse\"  Example (extract string from array): - Endpoint response: {\"response\": {\"options\": [\"Hi\", \"Hello there\"], \"count\": 2}} - response_json_path: \"response.options.1\"  Example (periods in field names): - Endpoint response: {\"llm.response\": \"hello\"} - response_json_path: \"llm\\\\.response\"  The syntax uses dot notation only, such as \"myfield.myotherfield\" or \"myarray.1\".  # noqa: E501

        :param response_json_path: The response_json_path of this GenerativevalidationStartTestRequest.  # noqa: E501
        :type: str
        """

        self._response_json_path = response_json_path

    @property
    def http_auth_integration_id(self):
        """Gets the http_auth_integration_id of this GenerativevalidationStartTestRequest.  # noqa: E501


        :return: The http_auth_integration_id of this GenerativevalidationStartTestRequest.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._http_auth_integration_id

    @http_auth_integration_id.setter
    def http_auth_integration_id(self, http_auth_integration_id):
        """Sets the http_auth_integration_id of this GenerativevalidationStartTestRequest.


        :param http_auth_integration_id: The http_auth_integration_id of this GenerativevalidationStartTestRequest.  # noqa: E501
        :type: RimeUUID
        """

        self._http_auth_integration_id = http_auth_integration_id

    @property
    def name(self):
        """Gets the name of this GenerativevalidationStartTestRequest.  # noqa: E501

        The name to identify the generative model testing job.  # noqa: E501

        :return: The name of this GenerativevalidationStartTestRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this GenerativevalidationStartTestRequest.

        The name to identify the generative model testing job.  # noqa: E501

        :param name: The name of this GenerativevalidationStartTestRequest.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def mutual_tls_integration_id(self):
        """Gets the mutual_tls_integration_id of this GenerativevalidationStartTestRequest.  # noqa: E501


        :return: The mutual_tls_integration_id of this GenerativevalidationStartTestRequest.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._mutual_tls_integration_id

    @mutual_tls_integration_id.setter
    def mutual_tls_integration_id(self, mutual_tls_integration_id):
        """Sets the mutual_tls_integration_id of this GenerativevalidationStartTestRequest.


        :param mutual_tls_integration_id: The mutual_tls_integration_id of this GenerativevalidationStartTestRequest.  # noqa: E501
        :type: RimeUUID
        """

        self._mutual_tls_integration_id = mutual_tls_integration_id

    @property
    def system_prompt(self):
        """Gets the system_prompt of this GenerativevalidationStartTestRequest.  # noqa: E501

        The system prompt that is currently active on the provided endpoint.  # noqa: E501

        :return: The system_prompt of this GenerativevalidationStartTestRequest.  # noqa: E501
        :rtype: str
        """
        return self._system_prompt

    @system_prompt.setter
    def system_prompt(self, system_prompt):
        """Sets the system_prompt of this GenerativevalidationStartTestRequest.

        The system prompt that is currently active on the provided endpoint.  # noqa: E501

        :param system_prompt: The system_prompt of this GenerativevalidationStartTestRequest.  # noqa: E501
        :type: str
        """

        self._system_prompt = system_prompt

    @property
    def aws_integration_id(self):
        """Gets the aws_integration_id of this GenerativevalidationStartTestRequest.  # noqa: E501


        :return: The aws_integration_id of this GenerativevalidationStartTestRequest.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._aws_integration_id

    @aws_integration_id.setter
    def aws_integration_id(self, aws_integration_id):
        """Sets the aws_integration_id of this GenerativevalidationStartTestRequest.


        :param aws_integration_id: The aws_integration_id of this GenerativevalidationStartTestRequest.  # noqa: E501
        :type: RimeUUID
        """

        self._aws_integration_id = aws_integration_id

    @property
    def model_id(self):
        """Gets the model_id of this GenerativevalidationStartTestRequest.  # noqa: E501

        If aws_integration_id is set, this field will be the model id used for generative validation for bedrock.  # noqa: E501

        :return: The model_id of this GenerativevalidationStartTestRequest.  # noqa: E501
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """Sets the model_id of this GenerativevalidationStartTestRequest.

        If aws_integration_id is set, this field will be the model id used for generative validation for bedrock.  # noqa: E501

        :param model_id: The model_id of this GenerativevalidationStartTestRequest.  # noqa: E501
        :type: str
        """

        self._model_id = model_id

    @property
    def body(self):
        """Gets the body of this GenerativevalidationStartTestRequest.  # noqa: E501


        :return: The body of this GenerativevalidationStartTestRequest.  # noqa: E501
        :rtype: GenerativevalidationBody
        """
        return self._body

    @body.setter
    def body(self, body):
        """Sets the body of this GenerativevalidationStartTestRequest.


        :param body: The body of this GenerativevalidationStartTestRequest.  # noqa: E501
        :type: GenerativevalidationBody
        """

        self._body = body

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GenerativevalidationStartTestRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GenerativevalidationStartTestRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
