# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ListMonitorsRequestFilter(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'included_monitor_types': 'list[MonitorMonitorType]',
        'included_risk_category_types': 'list[RiskscoreRiskCategoryType]',
        'pinned_monitors_only': 'bool'
    }

    attribute_map = {
        'included_monitor_types': 'includedMonitorTypes',
        'included_risk_category_types': 'includedRiskCategoryTypes',
        'pinned_monitors_only': 'pinnedMonitorsOnly'
    }

    def __init__(self, included_monitor_types=None, included_risk_category_types=None, pinned_monitors_only=None):  # noqa: E501
        """ListMonitorsRequestFilter - a model defined in Swagger"""  # noqa: E501
        self._included_monitor_types = None
        self._included_risk_category_types = None
        self._pinned_monitors_only = None
        self.discriminator = None
        if included_monitor_types is not None:
            self.included_monitor_types = included_monitor_types
        if included_risk_category_types is not None:
            self.included_risk_category_types = included_risk_category_types
        if pinned_monitors_only is not None:
            self.pinned_monitors_only = pinned_monitors_only

    @property
    def included_monitor_types(self):
        """Gets the included_monitor_types of this ListMonitorsRequestFilter.  # noqa: E501

        Specifies a list of monitor types. Filters results to match the specified monitor types.  # noqa: E501

        :return: The included_monitor_types of this ListMonitorsRequestFilter.  # noqa: E501
        :rtype: list[MonitorMonitorType]
        """
        return self._included_monitor_types

    @included_monitor_types.setter
    def included_monitor_types(self, included_monitor_types):
        """Sets the included_monitor_types of this ListMonitorsRequestFilter.

        Specifies a list of monitor types. Filters results to match the specified monitor types.  # noqa: E501

        :param included_monitor_types: The included_monitor_types of this ListMonitorsRequestFilter.  # noqa: E501
        :type: list[MonitorMonitorType]
        """

        self._included_monitor_types = included_monitor_types

    @property
    def included_risk_category_types(self):
        """Gets the included_risk_category_types of this ListMonitorsRequestFilter.  # noqa: E501

        Specifies a list of risk category types. Filters results to match the specified risk category types.  # noqa: E501

        :return: The included_risk_category_types of this ListMonitorsRequestFilter.  # noqa: E501
        :rtype: list[RiskscoreRiskCategoryType]
        """
        return self._included_risk_category_types

    @included_risk_category_types.setter
    def included_risk_category_types(self, included_risk_category_types):
        """Sets the included_risk_category_types of this ListMonitorsRequestFilter.

        Specifies a list of risk category types. Filters results to match the specified risk category types.  # noqa: E501

        :param included_risk_category_types: The included_risk_category_types of this ListMonitorsRequestFilter.  # noqa: E501
        :type: list[RiskscoreRiskCategoryType]
        """

        self._included_risk_category_types = included_risk_category_types

    @property
    def pinned_monitors_only(self):
        """Gets the pinned_monitors_only of this ListMonitorsRequestFilter.  # noqa: E501

        When the value of this Boolean is True, this endpoint returns a list of pinned Monitors. Otherwise, this endpoint does not filter Monitors by pinned status.  # noqa: E501

        :return: The pinned_monitors_only of this ListMonitorsRequestFilter.  # noqa: E501
        :rtype: bool
        """
        return self._pinned_monitors_only

    @pinned_monitors_only.setter
    def pinned_monitors_only(self, pinned_monitors_only):
        """Sets the pinned_monitors_only of this ListMonitorsRequestFilter.

        When the value of this Boolean is True, this endpoint returns a list of pinned Monitors. Otherwise, this endpoint does not filter Monitors by pinned status.  # noqa: E501

        :param pinned_monitors_only: The pinned_monitors_only of this ListMonitorsRequestFilter.  # noqa: E501
        :type: bool
        """

        self._pinned_monitors_only = pinned_monitors_only

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ListMonitorsRequestFilter, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ListMonitorsRequestFilter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
