# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class NotificationDigestConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'frequency': 'DigestConfigDigestFrequency',
        'hour_offset': 'int',
        'last_digest_time': 'datetime'
    }

    attribute_map = {
        'frequency': 'frequency',
        'hour_offset': 'hourOffset',
        'last_digest_time': 'lastDigestTime'
    }

    def __init__(self, frequency=None, hour_offset=None, last_digest_time=None):  # noqa: E501
        """NotificationDigestConfig - a model defined in Swagger"""  # noqa: E501
        self._frequency = None
        self._hour_offset = None
        self._last_digest_time = None
        self.discriminator = None
        if frequency is not None:
            self.frequency = frequency
        if hour_offset is not None:
            self.hour_offset = hour_offset
        if last_digest_time is not None:
            self.last_digest_time = last_digest_time

    @property
    def frequency(self):
        """Gets the frequency of this NotificationDigestConfig.  # noqa: E501


        :return: The frequency of this NotificationDigestConfig.  # noqa: E501
        :rtype: DigestConfigDigestFrequency
        """
        return self._frequency

    @frequency.setter
    def frequency(self, frequency):
        """Sets the frequency of this NotificationDigestConfig.


        :param frequency: The frequency of this NotificationDigestConfig.  # noqa: E501
        :type: DigestConfigDigestFrequency
        """

        self._frequency = frequency

    @property
    def hour_offset(self):
        """Gets the hour_offset of this NotificationDigestConfig.  # noqa: E501

        The offset in the day when the digest starts. The offset is taken in the configured timezone for the workspace. Uses a default value of 08:00 when not provided.  # noqa: E501

        :return: The hour_offset of this NotificationDigestConfig.  # noqa: E501
        :rtype: int
        """
        return self._hour_offset

    @hour_offset.setter
    def hour_offset(self, hour_offset):
        """Sets the hour_offset of this NotificationDigestConfig.

        The offset in the day when the digest starts. The offset is taken in the configured timezone for the workspace. Uses a default value of 08:00 when not provided.  # noqa: E501

        :param hour_offset: The hour_offset of this NotificationDigestConfig.  # noqa: E501
        :type: int
        """

        self._hour_offset = hour_offset

    @property
    def last_digest_time(self):
        """Gets the last_digest_time of this NotificationDigestConfig.  # noqa: E501

        The last time that the RI platform sent the digest. This timestamp is zero when no digests have ever been sent.  # noqa: E501

        :return: The last_digest_time of this NotificationDigestConfig.  # noqa: E501
        :rtype: datetime
        """
        return self._last_digest_time

    @last_digest_time.setter
    def last_digest_time(self, last_digest_time):
        """Sets the last_digest_time of this NotificationDigestConfig.

        The last time that the RI platform sent the digest. This timestamp is zero when no digests have ever been sent.  # noqa: E501

        :param last_digest_time: The last_digest_time of this NotificationDigestConfig.  # noqa: E501
        :type: datetime
        """

        self._last_digest_time = last_digest_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NotificationDigestConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NotificationDigestConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
