# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ProjectListProjectsRequestQuery(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_published': 'bool',
        'creation_time_range': 'RimeTimeInterval',
        'last_test_run_time_range': 'RimeTimeInterval',
        'stress_test_categories': 'list[TestrunTestCategoryType]',
        'continuous_test_categories': 'list[TestrunTestCategoryType]',
        'owner_email': 'str',
        'model_tasks': 'list[RimeModelTask]',
        'status': 'ProjectProjectStatus',
        'sort': 'RimeSortSpec',
        'search': 'RimeSearchSpec'
    }

    attribute_map = {
        'is_published': 'isPublished',
        'creation_time_range': 'creationTimeRange',
        'last_test_run_time_range': 'lastTestRunTimeRange',
        'stress_test_categories': 'stressTestCategories',
        'continuous_test_categories': 'continuousTestCategories',
        'owner_email': 'ownerEmail',
        'model_tasks': 'modelTasks',
        'status': 'status',
        'sort': 'sort',
        'search': 'search'
    }

    def __init__(self, is_published=None, creation_time_range=None, last_test_run_time_range=None, stress_test_categories=None, continuous_test_categories=None, owner_email=None, model_tasks=None, status=None, sort=None, search=None):  # noqa: E501
        """ProjectListProjectsRequestQuery - a model defined in Swagger"""  # noqa: E501
        self._is_published = None
        self._creation_time_range = None
        self._last_test_run_time_range = None
        self._stress_test_categories = None
        self._continuous_test_categories = None
        self._owner_email = None
        self._model_tasks = None
        self._status = None
        self._sort = None
        self._search = None
        self.discriminator = None
        if is_published is not None:
            self.is_published = is_published
        if creation_time_range is not None:
            self.creation_time_range = creation_time_range
        if last_test_run_time_range is not None:
            self.last_test_run_time_range = last_test_run_time_range
        if stress_test_categories is not None:
            self.stress_test_categories = stress_test_categories
        if continuous_test_categories is not None:
            self.continuous_test_categories = continuous_test_categories
        if owner_email is not None:
            self.owner_email = owner_email
        if model_tasks is not None:
            self.model_tasks = model_tasks
        if status is not None:
            self.status = status
        if sort is not None:
            self.sort = sort
        if search is not None:
            self.search = search

    @property
    def is_published(self):
        """Gets the is_published of this ProjectListProjectsRequestQuery.  # noqa: E501

        Optional: If true, return published projects. If false, return unpublished projects. If not specified, return all projects.  # noqa: E501

        :return: The is_published of this ProjectListProjectsRequestQuery.  # noqa: E501
        :rtype: bool
        """
        return self._is_published

    @is_published.setter
    def is_published(self, is_published):
        """Sets the is_published of this ProjectListProjectsRequestQuery.

        Optional: If true, return published projects. If false, return unpublished projects. If not specified, return all projects.  # noqa: E501

        :param is_published: The is_published of this ProjectListProjectsRequestQuery.  # noqa: E501
        :type: bool
        """

        self._is_published = is_published

    @property
    def creation_time_range(self):
        """Gets the creation_time_range of this ProjectListProjectsRequestQuery.  # noqa: E501


        :return: The creation_time_range of this ProjectListProjectsRequestQuery.  # noqa: E501
        :rtype: RimeTimeInterval
        """
        return self._creation_time_range

    @creation_time_range.setter
    def creation_time_range(self, creation_time_range):
        """Sets the creation_time_range of this ProjectListProjectsRequestQuery.


        :param creation_time_range: The creation_time_range of this ProjectListProjectsRequestQuery.  # noqa: E501
        :type: RimeTimeInterval
        """

        self._creation_time_range = creation_time_range

    @property
    def last_test_run_time_range(self):
        """Gets the last_test_run_time_range of this ProjectListProjectsRequestQuery.  # noqa: E501


        :return: The last_test_run_time_range of this ProjectListProjectsRequestQuery.  # noqa: E501
        :rtype: RimeTimeInterval
        """
        return self._last_test_run_time_range

    @last_test_run_time_range.setter
    def last_test_run_time_range(self, last_test_run_time_range):
        """Sets the last_test_run_time_range of this ProjectListProjectsRequestQuery.


        :param last_test_run_time_range: The last_test_run_time_range of this ProjectListProjectsRequestQuery.  # noqa: E501
        :type: RimeTimeInterval
        """

        self._last_test_run_time_range = last_test_run_time_range

    @property
    def stress_test_categories(self):
        """Gets the stress_test_categories of this ProjectListProjectsRequestQuery.  # noqa: E501

        Optional: When specified, return all projects whose ST categories are a superset of the ST categories provided here.  # noqa: E501

        :return: The stress_test_categories of this ProjectListProjectsRequestQuery.  # noqa: E501
        :rtype: list[TestrunTestCategoryType]
        """
        return self._stress_test_categories

    @stress_test_categories.setter
    def stress_test_categories(self, stress_test_categories):
        """Sets the stress_test_categories of this ProjectListProjectsRequestQuery.

        Optional: When specified, return all projects whose ST categories are a superset of the ST categories provided here.  # noqa: E501

        :param stress_test_categories: The stress_test_categories of this ProjectListProjectsRequestQuery.  # noqa: E501
        :type: list[TestrunTestCategoryType]
        """

        self._stress_test_categories = stress_test_categories

    @property
    def continuous_test_categories(self):
        """Gets the continuous_test_categories of this ProjectListProjectsRequestQuery.  # noqa: E501

        Optional: When specified, return all projects whose CT categories are a superset of the CT categories provided here.  # noqa: E501

        :return: The continuous_test_categories of this ProjectListProjectsRequestQuery.  # noqa: E501
        :rtype: list[TestrunTestCategoryType]
        """
        return self._continuous_test_categories

    @continuous_test_categories.setter
    def continuous_test_categories(self, continuous_test_categories):
        """Sets the continuous_test_categories of this ProjectListProjectsRequestQuery.

        Optional: When specified, return all projects whose CT categories are a superset of the CT categories provided here.  # noqa: E501

        :param continuous_test_categories: The continuous_test_categories of this ProjectListProjectsRequestQuery.  # noqa: E501
        :type: list[TestrunTestCategoryType]
        """

        self._continuous_test_categories = continuous_test_categories

    @property
    def owner_email(self):
        """Gets the owner_email of this ProjectListProjectsRequestQuery.  # noqa: E501

        Optional: When specified, return all projects whose owner email matches.  # noqa: E501

        :return: The owner_email of this ProjectListProjectsRequestQuery.  # noqa: E501
        :rtype: str
        """
        return self._owner_email

    @owner_email.setter
    def owner_email(self, owner_email):
        """Sets the owner_email of this ProjectListProjectsRequestQuery.

        Optional: When specified, return all projects whose owner email matches.  # noqa: E501

        :param owner_email: The owner_email of this ProjectListProjectsRequestQuery.  # noqa: E501
        :type: str
        """

        self._owner_email = owner_email

    @property
    def model_tasks(self):
        """Gets the model_tasks of this ProjectListProjectsRequestQuery.  # noqa: E501

        Optional: When specified, return all projects whose model task is the provided model task.  # noqa: E501

        :return: The model_tasks of this ProjectListProjectsRequestQuery.  # noqa: E501
        :rtype: list[RimeModelTask]
        """
        return self._model_tasks

    @model_tasks.setter
    def model_tasks(self, model_tasks):
        """Sets the model_tasks of this ProjectListProjectsRequestQuery.

        Optional: When specified, return all projects whose model task is the provided model task.  # noqa: E501

        :param model_tasks: The model_tasks of this ProjectListProjectsRequestQuery.  # noqa: E501
        :type: list[RimeModelTask]
        """

        self._model_tasks = model_tasks

    @property
    def status(self):
        """Gets the status of this ProjectListProjectsRequestQuery.  # noqa: E501


        :return: The status of this ProjectListProjectsRequestQuery.  # noqa: E501
        :rtype: ProjectProjectStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ProjectListProjectsRequestQuery.


        :param status: The status of this ProjectListProjectsRequestQuery.  # noqa: E501
        :type: ProjectProjectStatus
        """

        self._status = status

    @property
    def sort(self):
        """Gets the sort of this ProjectListProjectsRequestQuery.  # noqa: E501


        :return: The sort of this ProjectListProjectsRequestQuery.  # noqa: E501
        :rtype: RimeSortSpec
        """
        return self._sort

    @sort.setter
    def sort(self, sort):
        """Sets the sort of this ProjectListProjectsRequestQuery.


        :param sort: The sort of this ProjectListProjectsRequestQuery.  # noqa: E501
        :type: RimeSortSpec
        """

        self._sort = sort

    @property
    def search(self):
        """Gets the search of this ProjectListProjectsRequestQuery.  # noqa: E501


        :return: The search of this ProjectListProjectsRequestQuery.  # noqa: E501
        :rtype: RimeSearchSpec
        """
        return self._search

    @search.setter
    def search(self, search):
        """Sets the search of this ProjectListProjectsRequestQuery.


        :param search: The search of this ProjectListProjectsRequestQuery.  # noqa: E501
        :type: RimeSearchSpec
        """

        self._search = search

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProjectListProjectsRequestQuery, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProjectListProjectsRequestQuery):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
