# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RegistryDataParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'label_col': 'str',
        'timestamp_col': 'str',
        'class_names': 'list[str]',
        'ranking_info': 'DataParamsRankingInfo',
        'nrows': 'str',
        'nrows_per_time_bin': 'str',
        'sample': 'bool',
        'categorical_features': 'list[str]',
        'protected_features': 'list[str]',
        'features_not_in_model': 'list[str]',
        'text_features': 'list[str]',
        'image_features': 'list[str]',
        'prompt_col': 'str',
        'intersections': 'list[DataParamsFeatureIntersection]',
        'loading_kwargs': 'str',
        'feature_type_path': 'str',
        'image_load_path': 'str',
        'experimental_fields': 'dict(str, object)'
    }

    attribute_map = {
        'label_col': 'labelCol',
        'timestamp_col': 'timestampCol',
        'class_names': 'classNames',
        'ranking_info': 'rankingInfo',
        'nrows': 'nrows',
        'nrows_per_time_bin': 'nrowsPerTimeBin',
        'sample': 'sample',
        'categorical_features': 'categoricalFeatures',
        'protected_features': 'protectedFeatures',
        'features_not_in_model': 'featuresNotInModel',
        'text_features': 'textFeatures',
        'image_features': 'imageFeatures',
        'prompt_col': 'promptCol',
        'intersections': 'intersections',
        'loading_kwargs': 'loadingKwargs',
        'feature_type_path': 'featureTypePath',
        'image_load_path': 'imageLoadPath',
        'experimental_fields': 'experimentalFields'
    }

    def __init__(self, label_col=None, timestamp_col=None, class_names=None, ranking_info=None, nrows=None, nrows_per_time_bin=None, sample=None, categorical_features=None, protected_features=None, features_not_in_model=None, text_features=None, image_features=None, prompt_col=None, intersections=None, loading_kwargs=None, feature_type_path=None, image_load_path=None, experimental_fields=None):  # noqa: E501
        """RegistryDataParams - a model defined in Swagger"""  # noqa: E501
        self._label_col = None
        self._timestamp_col = None
        self._class_names = None
        self._ranking_info = None
        self._nrows = None
        self._nrows_per_time_bin = None
        self._sample = None
        self._categorical_features = None
        self._protected_features = None
        self._features_not_in_model = None
        self._text_features = None
        self._image_features = None
        self._prompt_col = None
        self._intersections = None
        self._loading_kwargs = None
        self._feature_type_path = None
        self._image_load_path = None
        self._experimental_fields = None
        self.discriminator = None
        if label_col is not None:
            self.label_col = label_col
        if timestamp_col is not None:
            self.timestamp_col = timestamp_col
        if class_names is not None:
            self.class_names = class_names
        if ranking_info is not None:
            self.ranking_info = ranking_info
        if nrows is not None:
            self.nrows = nrows
        if nrows_per_time_bin is not None:
            self.nrows_per_time_bin = nrows_per_time_bin
        if sample is not None:
            self.sample = sample
        if categorical_features is not None:
            self.categorical_features = categorical_features
        if protected_features is not None:
            self.protected_features = protected_features
        if features_not_in_model is not None:
            self.features_not_in_model = features_not_in_model
        if text_features is not None:
            self.text_features = text_features
        if image_features is not None:
            self.image_features = image_features
        if prompt_col is not None:
            self.prompt_col = prompt_col
        if intersections is not None:
            self.intersections = intersections
        if loading_kwargs is not None:
            self.loading_kwargs = loading_kwargs
        if feature_type_path is not None:
            self.feature_type_path = feature_type_path
        if image_load_path is not None:
            self.image_load_path = image_load_path
        if experimental_fields is not None:
            self.experimental_fields = experimental_fields

    @property
    def label_col(self):
        """Gets the label_col of this RegistryDataParams.  # noqa: E501

        Naming of special columns.  # noqa: E501

        :return: The label_col of this RegistryDataParams.  # noqa: E501
        :rtype: str
        """
        return self._label_col

    @label_col.setter
    def label_col(self, label_col):
        """Sets the label_col of this RegistryDataParams.

        Naming of special columns.  # noqa: E501

        :param label_col: The label_col of this RegistryDataParams.  # noqa: E501
        :type: str
        """

        self._label_col = label_col

    @property
    def timestamp_col(self):
        """Gets the timestamp_col of this RegistryDataParams.  # noqa: E501

        Column to look at for CT timestamp.  # noqa: E501

        :return: The timestamp_col of this RegistryDataParams.  # noqa: E501
        :rtype: str
        """
        return self._timestamp_col

    @timestamp_col.setter
    def timestamp_col(self, timestamp_col):
        """Sets the timestamp_col of this RegistryDataParams.

        Column to look at for CT timestamp.  # noqa: E501

        :param timestamp_col: The timestamp_col of this RegistryDataParams.  # noqa: E501
        :type: str
        """

        self._timestamp_col = timestamp_col

    @property
    def class_names(self):
        """Gets the class_names of this RegistryDataParams.  # noqa: E501

        List of label class names.  # noqa: E501

        :return: The class_names of this RegistryDataParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._class_names

    @class_names.setter
    def class_names(self, class_names):
        """Sets the class_names of this RegistryDataParams.

        List of label class names.  # noqa: E501

        :param class_names: The class_names of this RegistryDataParams.  # noqa: E501
        :type: list[str]
        """

        self._class_names = class_names

    @property
    def ranking_info(self):
        """Gets the ranking_info of this RegistryDataParams.  # noqa: E501


        :return: The ranking_info of this RegistryDataParams.  # noqa: E501
        :rtype: DataParamsRankingInfo
        """
        return self._ranking_info

    @ranking_info.setter
    def ranking_info(self, ranking_info):
        """Sets the ranking_info of this RegistryDataParams.


        :param ranking_info: The ranking_info of this RegistryDataParams.  # noqa: E501
        :type: DataParamsRankingInfo
        """

        self._ranking_info = ranking_info

    @property
    def nrows(self):
        """Gets the nrows of this RegistryDataParams.  # noqa: E501

        Dataset size parameters. Number of rows of data to load and test. If null, will load all rows.  # noqa: E501

        :return: The nrows of this RegistryDataParams.  # noqa: E501
        :rtype: str
        """
        return self._nrows

    @nrows.setter
    def nrows(self, nrows):
        """Sets the nrows of this RegistryDataParams.

        Dataset size parameters. Number of rows of data to load and test. If null, will load all rows.  # noqa: E501

        :param nrows: The nrows of this RegistryDataParams.  # noqa: E501
        :type: str
        """

        self._nrows = nrows

    @property
    def nrows_per_time_bin(self):
        """Gets the nrows_per_time_bin of this RegistryDataParams.  # noqa: E501

        Number of rows of data per time bin to load and test in CT. If null, will load all rows.  # noqa: E501

        :return: The nrows_per_time_bin of this RegistryDataParams.  # noqa: E501
        :rtype: str
        """
        return self._nrows_per_time_bin

    @nrows_per_time_bin.setter
    def nrows_per_time_bin(self, nrows_per_time_bin):
        """Sets the nrows_per_time_bin of this RegistryDataParams.

        Number of rows of data per time bin to load and test in CT. If null, will load all rows.  # noqa: E501

        :param nrows_per_time_bin: The nrows_per_time_bin of this RegistryDataParams.  # noqa: E501
        :type: str
        """

        self._nrows_per_time_bin = nrows_per_time_bin

    @property
    def sample(self):
        """Gets the sample of this RegistryDataParams.  # noqa: E501

        Whether to sample rows in the data. Default is True.  # noqa: E501

        :return: The sample of this RegistryDataParams.  # noqa: E501
        :rtype: bool
        """
        return self._sample

    @sample.setter
    def sample(self, sample):
        """Sets the sample of this RegistryDataParams.

        Whether to sample rows in the data. Default is True.  # noqa: E501

        :param sample: The sample of this RegistryDataParams.  # noqa: E501
        :type: bool
        """

        self._sample = sample

    @property
    def categorical_features(self):
        """Gets the categorical_features of this RegistryDataParams.  # noqa: E501

        Feature types and relations.  # noqa: E501

        :return: The categorical_features of this RegistryDataParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._categorical_features

    @categorical_features.setter
    def categorical_features(self, categorical_features):
        """Sets the categorical_features of this RegistryDataParams.

        Feature types and relations.  # noqa: E501

        :param categorical_features: The categorical_features of this RegistryDataParams.  # noqa: E501
        :type: list[str]
        """

        self._categorical_features = categorical_features

    @property
    def protected_features(self):
        """Gets the protected_features of this RegistryDataParams.  # noqa: E501

        Features that are protected attributes. If Bias and Fairness category is specified, these tests will run only over protected_features.  # noqa: E501

        :return: The protected_features of this RegistryDataParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._protected_features

    @protected_features.setter
    def protected_features(self, protected_features):
        """Sets the protected_features of this RegistryDataParams.

        Features that are protected attributes. If Bias and Fairness category is specified, these tests will run only over protected_features.  # noqa: E501

        :param protected_features: The protected_features of this RegistryDataParams.  # noqa: E501
        :type: list[str]
        """

        self._protected_features = protected_features

    @property
    def features_not_in_model(self):
        """Gets the features_not_in_model of this RegistryDataParams.  # noqa: E501


        :return: The features_not_in_model of this RegistryDataParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._features_not_in_model

    @features_not_in_model.setter
    def features_not_in_model(self, features_not_in_model):
        """Sets the features_not_in_model of this RegistryDataParams.


        :param features_not_in_model: The features_not_in_model of this RegistryDataParams.  # noqa: E501
        :type: list[str]
        """

        self._features_not_in_model = features_not_in_model

    @property
    def text_features(self):
        """Gets the text_features of this RegistryDataParams.  # noqa: E501

        Text features to run NLP tests over.  # noqa: E501

        :return: The text_features of this RegistryDataParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._text_features

    @text_features.setter
    def text_features(self, text_features):
        """Sets the text_features of this RegistryDataParams.

        Text features to run NLP tests over.  # noqa: E501

        :param text_features: The text_features of this RegistryDataParams.  # noqa: E501
        :type: list[str]
        """

        self._text_features = text_features

    @property
    def image_features(self):
        """Gets the image_features of this RegistryDataParams.  # noqa: E501

        Image features to run CV tests over.  # noqa: E501

        :return: The image_features of this RegistryDataParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._image_features

    @image_features.setter
    def image_features(self, image_features):
        """Sets the image_features of this RegistryDataParams.

        Image features to run CV tests over.  # noqa: E501

        :param image_features: The image_features of this RegistryDataParams.  # noqa: E501
        :type: list[str]
        """

        self._image_features = image_features

    @property
    def prompt_col(self):
        """Gets the prompt_col of this RegistryDataParams.  # noqa: E501

        Prompt template column for Generative tasks.  # noqa: E501

        :return: The prompt_col of this RegistryDataParams.  # noqa: E501
        :rtype: str
        """
        return self._prompt_col

    @prompt_col.setter
    def prompt_col(self, prompt_col):
        """Sets the prompt_col of this RegistryDataParams.

        Prompt template column for Generative tasks.  # noqa: E501

        :param prompt_col: The prompt_col of this RegistryDataParams.  # noqa: E501
        :type: str
        """

        self._prompt_col = prompt_col

    @property
    def intersections(self):
        """Gets the intersections of this RegistryDataParams.  # noqa: E501

        A list of arrays of features. Each array represents the intersection of features on which certain subset and fairness tests are run.  # noqa: E501

        :return: The intersections of this RegistryDataParams.  # noqa: E501
        :rtype: list[DataParamsFeatureIntersection]
        """
        return self._intersections

    @intersections.setter
    def intersections(self, intersections):
        """Sets the intersections of this RegistryDataParams.

        A list of arrays of features. Each array represents the intersection of features on which certain subset and fairness tests are run.  # noqa: E501

        :param intersections: The intersections of this RegistryDataParams.  # noqa: E501
        :type: list[DataParamsFeatureIntersection]
        """

        self._intersections = intersections

    @property
    def loading_kwargs(self):
        """Gets the loading_kwargs of this RegistryDataParams.  # noqa: E501

        Paths for external resources. Keyword arguments to be passed to the pandas loading function (either pd.read_CSV or pd.read_Parquet, depending on your data format). NOTE: if you wish to specify nrows, this should NOT be done with kwargs.  # noqa: E501

        :return: The loading_kwargs of this RegistryDataParams.  # noqa: E501
        :rtype: str
        """
        return self._loading_kwargs

    @loading_kwargs.setter
    def loading_kwargs(self, loading_kwargs):
        """Sets the loading_kwargs of this RegistryDataParams.

        Paths for external resources. Keyword arguments to be passed to the pandas loading function (either pd.read_CSV or pd.read_Parquet, depending on your data format). NOTE: if you wish to specify nrows, this should NOT be done with kwargs.  # noqa: E501

        :param loading_kwargs: The loading_kwargs of this RegistryDataParams.  # noqa: E501
        :type: str
        """

        self._loading_kwargs = loading_kwargs

    @property
    def feature_type_path(self):
        """Gets the feature_type_path of this RegistryDataParams.  # noqa: E501

        Path to a CSV file that specifies the data type of each feature. The file should have two columns: FeatureName and FeatureType.  # noqa: E501

        :return: The feature_type_path of this RegistryDataParams.  # noqa: E501
        :rtype: str
        """
        return self._feature_type_path

    @feature_type_path.setter
    def feature_type_path(self, feature_type_path):
        """Sets the feature_type_path of this RegistryDataParams.

        Path to a CSV file that specifies the data type of each feature. The file should have two columns: FeatureName and FeatureType.  # noqa: E501

        :param feature_type_path: The feature_type_path of this RegistryDataParams.  # noqa: E501
        :type: str
        """

        self._feature_type_path = feature_type_path

    @property
    def image_load_path(self):
        """Gets the image_load_path of this RegistryDataParams.  # noqa: E501

        Path to a python file containing a custom function for loading images in the dataset.  # noqa: E501

        :return: The image_load_path of this RegistryDataParams.  # noqa: E501
        :rtype: str
        """
        return self._image_load_path

    @image_load_path.setter
    def image_load_path(self, image_load_path):
        """Sets the image_load_path of this RegistryDataParams.

        Path to a python file containing a custom function for loading images in the dataset.  # noqa: E501

        :param image_load_path: The image_load_path of this RegistryDataParams.  # noqa: E501
        :type: str
        """

        self._image_load_path = image_load_path

    @property
    def experimental_fields(self):
        """Gets the experimental_fields of this RegistryDataParams.  # noqa: E501

        Fields that enable experimental functionality.  WARNING: these fields are experimental; ie, their functionality may not be reliable or backwards-compatible. Do not use these fields in production.  # noqa: E501

        :return: The experimental_fields of this RegistryDataParams.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._experimental_fields

    @experimental_fields.setter
    def experimental_fields(self, experimental_fields):
        """Sets the experimental_fields of this RegistryDataParams.

        Fields that enable experimental functionality.  WARNING: these fields are experimental; ie, their functionality may not be reliable or backwards-compatible. Do not use these fields in production.  # noqa: E501

        :param experimental_fields: The experimental_fields of this RegistryDataParams.  # noqa: E501
        :type: dict(str, object)
        """

        self._experimental_fields = experimental_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RegistryDataParams, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RegistryDataParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
