# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RegistryHuggingFaceDataInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'dataset_uri': 'str',
        'split_name': 'str',
        'loading_params_json': 'str'
    }

    attribute_map = {
        'dataset_uri': 'datasetUri',
        'split_name': 'splitName',
        'loading_params_json': 'loadingParamsJson'
    }

    def __init__(self, dataset_uri=None, split_name=None, loading_params_json=None):  # noqa: E501
        """RegistryHuggingFaceDataInfo - a model defined in Swagger"""  # noqa: E501
        self._dataset_uri = None
        self._split_name = None
        self._loading_params_json = None
        self.discriminator = None
        self.dataset_uri = dataset_uri
        self.split_name = split_name
        if loading_params_json is not None:
            self.loading_params_json = loading_params_json

    @property
    def dataset_uri(self):
        """Gets the dataset_uri of this RegistryHuggingFaceDataInfo.  # noqa: E501

        The unique identifier of the dataset.  # noqa: E501

        :return: The dataset_uri of this RegistryHuggingFaceDataInfo.  # noqa: E501
        :rtype: str
        """
        return self._dataset_uri

    @dataset_uri.setter
    def dataset_uri(self, dataset_uri):
        """Sets the dataset_uri of this RegistryHuggingFaceDataInfo.

        The unique identifier of the dataset.  # noqa: E501

        :param dataset_uri: The dataset_uri of this RegistryHuggingFaceDataInfo.  # noqa: E501
        :type: str
        """
        if dataset_uri is None:
            raise ValueError("Invalid value for `dataset_uri`, must not be `None`")  # noqa: E501

        self._dataset_uri = dataset_uri

    @property
    def split_name(self):
        """Gets the split_name of this RegistryHuggingFaceDataInfo.  # noqa: E501

        The string that represents the name of a predefined subset of data.  # noqa: E501

        :return: The split_name of this RegistryHuggingFaceDataInfo.  # noqa: E501
        :rtype: str
        """
        return self._split_name

    @split_name.setter
    def split_name(self, split_name):
        """Sets the split_name of this RegistryHuggingFaceDataInfo.

        The string that represents the name of a predefined subset of data.  # noqa: E501

        :param split_name: The split_name of this RegistryHuggingFaceDataInfo.  # noqa: E501
        :type: str
        """
        if split_name is None:
            raise ValueError("Invalid value for `split_name`, must not be `None`")  # noqa: E501

        self._split_name = split_name

    @property
    def loading_params_json(self):
        """Gets the loading_params_json of this RegistryHuggingFaceDataInfo.  # noqa: E501

        This is a JSON-serialized string from a map.  # noqa: E501

        :return: The loading_params_json of this RegistryHuggingFaceDataInfo.  # noqa: E501
        :rtype: str
        """
        return self._loading_params_json

    @loading_params_json.setter
    def loading_params_json(self, loading_params_json):
        """Sets the loading_params_json of this RegistryHuggingFaceDataInfo.

        This is a JSON-serialized string from a map.  # noqa: E501

        :param loading_params_json: The loading_params_json of this RegistryHuggingFaceDataInfo.  # noqa: E501
        :type: str
        """

        self._loading_params_json = loading_params_json

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RegistryHuggingFaceDataInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RegistryHuggingFaceDataInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
