# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RegistryPredictionParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'pred_col': 'str',
        'timestamp_col': 'str',
        'experimental_fields': 'dict(str, object)'
    }

    attribute_map = {
        'pred_col': 'predCol',
        'timestamp_col': 'timestampCol',
        'experimental_fields': 'experimentalFields'
    }

    def __init__(self, pred_col=None, timestamp_col=None, experimental_fields=None):  # noqa: E501
        """RegistryPredictionParams - a model defined in Swagger"""  # noqa: E501
        self._pred_col = None
        self._timestamp_col = None
        self._experimental_fields = None
        self.discriminator = None
        if pred_col is not None:
            self.pred_col = pred_col
        if timestamp_col is not None:
            self.timestamp_col = timestamp_col
        if experimental_fields is not None:
            self.experimental_fields = experimental_fields

    @property
    def pred_col(self):
        """Gets the pred_col of this RegistryPredictionParams.  # noqa: E501

        Column used for predictions.  # noqa: E501

        :return: The pred_col of this RegistryPredictionParams.  # noqa: E501
        :rtype: str
        """
        return self._pred_col

    @pred_col.setter
    def pred_col(self, pred_col):
        """Sets the pred_col of this RegistryPredictionParams.

        Column used for predictions.  # noqa: E501

        :param pred_col: The pred_col of this RegistryPredictionParams.  # noqa: E501
        :type: str
        """

        self._pred_col = pred_col

    @property
    def timestamp_col(self):
        """Gets the timestamp_col of this RegistryPredictionParams.  # noqa: E501

        Column used for CT timestamp.  # noqa: E501

        :return: The timestamp_col of this RegistryPredictionParams.  # noqa: E501
        :rtype: str
        """
        return self._timestamp_col

    @timestamp_col.setter
    def timestamp_col(self, timestamp_col):
        """Sets the timestamp_col of this RegistryPredictionParams.

        Column used for CT timestamp.  # noqa: E501

        :param timestamp_col: The timestamp_col of this RegistryPredictionParams.  # noqa: E501
        :type: str
        """

        self._timestamp_col = timestamp_col

    @property
    def experimental_fields(self):
        """Gets the experimental_fields of this RegistryPredictionParams.  # noqa: E501

        Fields that enable experimental functionality.  WARNING: these fields are experimental; ie, their functionality may not be reliable or backwards-compatible. Do not use these fields in production.  # noqa: E501

        :return: The experimental_fields of this RegistryPredictionParams.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._experimental_fields

    @experimental_fields.setter
    def experimental_fields(self, experimental_fields):
        """Sets the experimental_fields of this RegistryPredictionParams.

        Fields that enable experimental functionality.  WARNING: these fields are experimental; ie, their functionality may not be reliable or backwards-compatible. Do not use these fields in production.  # noqa: E501

        :param experimental_fields: The experimental_fields of this RegistryPredictionParams.  # noqa: E501
        :type: dict(str, object)
        """

        self._experimental_fields = experimental_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RegistryPredictionParams, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RegistryPredictionParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
