# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeAgent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'agent_id': 'RimeUUID',
        'name': 'str',
        'creation_time': 'datetime',
        'status': 'RimeAgentStatus',
        'internal': 'bool',
        'last_heartbeat_time': 'datetime',
        'version': 'str',
        'desired_state': 'RimeAgentDesiredState',
        'type': 'RimeAgentType',
        'url': 'str'
    }

    attribute_map = {
        'agent_id': 'agentId',
        'name': 'name',
        'creation_time': 'creationTime',
        'status': 'status',
        'internal': 'internal',
        'last_heartbeat_time': 'lastHeartbeatTime',
        'version': 'version',
        'desired_state': 'desiredState',
        'type': 'type',
        'url': 'url'
    }

    def __init__(self, agent_id=None, name=None, creation_time=None, status=None, internal=None, last_heartbeat_time=None, version=None, desired_state=None, type=None, url=None):  # noqa: E501
        """RimeAgent - a model defined in Swagger"""  # noqa: E501
        self._agent_id = None
        self._name = None
        self._creation_time = None
        self._status = None
        self._internal = None
        self._last_heartbeat_time = None
        self._version = None
        self._desired_state = None
        self._type = None
        self._url = None
        self.discriminator = None
        if agent_id is not None:
            self.agent_id = agent_id
        if name is not None:
            self.name = name
        if creation_time is not None:
            self.creation_time = creation_time
        if status is not None:
            self.status = status
        if internal is not None:
            self.internal = internal
        if last_heartbeat_time is not None:
            self.last_heartbeat_time = last_heartbeat_time
        if version is not None:
            self.version = version
        if desired_state is not None:
            self.desired_state = desired_state
        if type is not None:
            self.type = type
        if url is not None:
            self.url = url

    @property
    def agent_id(self):
        """Gets the agent_id of this RimeAgent.  # noqa: E501


        :return: The agent_id of this RimeAgent.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """Sets the agent_id of this RimeAgent.


        :param agent_id: The agent_id of this RimeAgent.  # noqa: E501
        :type: RimeUUID
        """

        self._agent_id = agent_id

    @property
    def name(self):
        """Gets the name of this RimeAgent.  # noqa: E501

        The user specified name of the agent.  # noqa: E501

        :return: The name of this RimeAgent.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RimeAgent.

        The user specified name of the agent.  # noqa: E501

        :param name: The name of this RimeAgent.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def creation_time(self):
        """Gets the creation_time of this RimeAgent.  # noqa: E501

        The time of creation of the agent.  # noqa: E501

        :return: The creation_time of this RimeAgent.  # noqa: E501
        :rtype: datetime
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this RimeAgent.

        The time of creation of the agent.  # noqa: E501

        :param creation_time: The creation_time of this RimeAgent.  # noqa: E501
        :type: datetime
        """

        self._creation_time = creation_time

    @property
    def status(self):
        """Gets the status of this RimeAgent.  # noqa: E501


        :return: The status of this RimeAgent.  # noqa: E501
        :rtype: RimeAgentStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this RimeAgent.


        :param status: The status of this RimeAgent.  # noqa: E501
        :type: RimeAgentStatus
        """

        self._status = status

    @property
    def internal(self):
        """Gets the internal of this RimeAgent.  # noqa: E501

        Specifies whether the agent is an internal agent. Internal agents come bundled with the deployment.  # noqa: E501

        :return: The internal of this RimeAgent.  # noqa: E501
        :rtype: bool
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """Sets the internal of this RimeAgent.

        Specifies whether the agent is an internal agent. Internal agents come bundled with the deployment.  # noqa: E501

        :param internal: The internal of this RimeAgent.  # noqa: E501
        :type: bool
        """

        self._internal = internal

    @property
    def last_heartbeat_time(self):
        """Gets the last_heartbeat_time of this RimeAgent.  # noqa: E501

        The time of the last heartbeat.  # noqa: E501

        :return: The last_heartbeat_time of this RimeAgent.  # noqa: E501
        :rtype: datetime
        """
        return self._last_heartbeat_time

    @last_heartbeat_time.setter
    def last_heartbeat_time(self, last_heartbeat_time):
        """Sets the last_heartbeat_time of this RimeAgent.

        The time of the last heartbeat.  # noqa: E501

        :param last_heartbeat_time: The last_heartbeat_time of this RimeAgent.  # noqa: E501
        :type: datetime
        """

        self._last_heartbeat_time = last_heartbeat_time

    @property
    def version(self):
        """Gets the version of this RimeAgent.  # noqa: E501

        Agent version.  # noqa: E501

        :return: The version of this RimeAgent.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this RimeAgent.

        Agent version.  # noqa: E501

        :param version: The version of this RimeAgent.  # noqa: E501
        :type: str
        """

        self._version = version

    @property
    def desired_state(self):
        """Gets the desired_state of this RimeAgent.  # noqa: E501


        :return: The desired_state of this RimeAgent.  # noqa: E501
        :rtype: RimeAgentDesiredState
        """
        return self._desired_state

    @desired_state.setter
    def desired_state(self, desired_state):
        """Sets the desired_state of this RimeAgent.


        :param desired_state: The desired_state of this RimeAgent.  # noqa: E501
        :type: RimeAgentDesiredState
        """

        self._desired_state = desired_state

    @property
    def type(self):
        """Gets the type of this RimeAgent.  # noqa: E501


        :return: The type of this RimeAgent.  # noqa: E501
        :rtype: RimeAgentType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this RimeAgent.


        :param type: The type of this RimeAgent.  # noqa: E501
        :type: RimeAgentType
        """

        self._type = type

    @property
    def url(self):
        """Gets the url of this RimeAgent.  # noqa: E501

        The url of the agent. E.g., https://dev.my-firewall.rbst.io This is used for firewall agents, which can have a different URL than the control plane.  # noqa: E501

        :return: The url of this RimeAgent.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this RimeAgent.

        The url of the agent. E.g., https://dev.my-firewall.rbst.io This is used for firewall agents, which can have a different URL than the control plane.  # noqa: E501

        :param url: The url of this RimeAgent.  # noqa: E501
        :type: str
        """

        self._url = url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeAgent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeAgent):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
