# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeAPITokenInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'RimeUUID',
        'name': 'str',
        'suffix': 'str',
        'creation_time': 'datetime',
        'expiration_time': 'datetime',
        'workspace_id': 'RimeUUID',
        'user_id': 'str',
        'token_type': 'RimeTokenType'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'suffix': 'suffix',
        'creation_time': 'creationTime',
        'expiration_time': 'expirationTime',
        'workspace_id': 'workspaceId',
        'user_id': 'userId',
        'token_type': 'tokenType'
    }

    def __init__(self, id=None, name=None, suffix=None, creation_time=None, expiration_time=None, workspace_id=None, user_id=None, token_type=None):  # noqa: E501
        """RimeAPITokenInfo - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._name = None
        self._suffix = None
        self._creation_time = None
        self._expiration_time = None
        self._workspace_id = None
        self._user_id = None
        self._token_type = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if suffix is not None:
            self.suffix = suffix
        if creation_time is not None:
            self.creation_time = creation_time
        if expiration_time is not None:
            self.expiration_time = expiration_time
        if workspace_id is not None:
            self.workspace_id = workspace_id
        if user_id is not None:
            self.user_id = user_id
        if token_type is not None:
            self.token_type = token_type

    @property
    def id(self):
        """Gets the id of this RimeAPITokenInfo.  # noqa: E501


        :return: The id of this RimeAPITokenInfo.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this RimeAPITokenInfo.


        :param id: The id of this RimeAPITokenInfo.  # noqa: E501
        :type: RimeUUID
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this RimeAPITokenInfo.  # noqa: E501

        The name of the API token.  # noqa: E501

        :return: The name of this RimeAPITokenInfo.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RimeAPITokenInfo.

        The name of the API token.  # noqa: E501

        :param name: The name of this RimeAPITokenInfo.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def suffix(self):
        """Gets the suffix of this RimeAPITokenInfo.  # noqa: E501

        The suffix of the API token, which is visible in the Robust Intelligence web application.  # noqa: E501

        :return: The suffix of this RimeAPITokenInfo.  # noqa: E501
        :rtype: str
        """
        return self._suffix

    @suffix.setter
    def suffix(self, suffix):
        """Sets the suffix of this RimeAPITokenInfo.

        The suffix of the API token, which is visible in the Robust Intelligence web application.  # noqa: E501

        :param suffix: The suffix of this RimeAPITokenInfo.  # noqa: E501
        :type: str
        """

        self._suffix = suffix

    @property
    def creation_time(self):
        """Gets the creation_time of this RimeAPITokenInfo.  # noqa: E501


        :return: The creation_time of this RimeAPITokenInfo.  # noqa: E501
        :rtype: datetime
        """
        return self._creation_time

    @creation_time.setter
    def creation_time(self, creation_time):
        """Sets the creation_time of this RimeAPITokenInfo.


        :param creation_time: The creation_time of this RimeAPITokenInfo.  # noqa: E501
        :type: datetime
        """

        self._creation_time = creation_time

    @property
    def expiration_time(self):
        """Gets the expiration_time of this RimeAPITokenInfo.  # noqa: E501


        :return: The expiration_time of this RimeAPITokenInfo.  # noqa: E501
        :rtype: datetime
        """
        return self._expiration_time

    @expiration_time.setter
    def expiration_time(self, expiration_time):
        """Sets the expiration_time of this RimeAPITokenInfo.


        :param expiration_time: The expiration_time of this RimeAPITokenInfo.  # noqa: E501
        :type: datetime
        """

        self._expiration_time = expiration_time

    @property
    def workspace_id(self):
        """Gets the workspace_id of this RimeAPITokenInfo.  # noqa: E501


        :return: The workspace_id of this RimeAPITokenInfo.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._workspace_id

    @workspace_id.setter
    def workspace_id(self, workspace_id):
        """Sets the workspace_id of this RimeAPITokenInfo.


        :param workspace_id: The workspace_id of this RimeAPITokenInfo.  # noqa: E501
        :type: RimeUUID
        """

        self._workspace_id = workspace_id

    @property
    def user_id(self):
        """Gets the user_id of this RimeAPITokenInfo.  # noqa: E501

        The ID of the user who created the API token.  # noqa: E501

        :return: The user_id of this RimeAPITokenInfo.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this RimeAPITokenInfo.

        The ID of the user who created the API token.  # noqa: E501

        :param user_id: The user_id of this RimeAPITokenInfo.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    @property
    def token_type(self):
        """Gets the token_type of this RimeAPITokenInfo.  # noqa: E501


        :return: The token_type of this RimeAPITokenInfo.  # noqa: E501
        :rtype: RimeTokenType
        """
        return self._token_type

    @token_type.setter
    def token_type(self, token_type):
        """Sets the token_type of this RimeAPITokenInfo.


        :param token_type: The token_type of this RimeAPITokenInfo.  # noqa: E501
        :type: RimeTokenType
        """

        self._token_type = token_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeAPITokenInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeAPITokenInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
