# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeCreateImageRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'pip_requirements': 'list[ManagedImagePipRequirement]',
        'package_requirements': 'list[ManagedImagePackageRequirement]',
        'python_version': 'str'
    }

    attribute_map = {
        'name': 'name',
        'pip_requirements': 'pipRequirements',
        'package_requirements': 'packageRequirements',
        'python_version': 'pythonVersion'
    }

    def __init__(self, name=None, pip_requirements=None, package_requirements=None, python_version=None):  # noqa: E501
        """RimeCreateImageRequest - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._pip_requirements = None
        self._package_requirements = None
        self._python_version = None
        self.discriminator = None
        self.name = name
        self.pip_requirements = pip_requirements
        if package_requirements is not None:
            self.package_requirements = package_requirements
        if python_version is not None:
            self.python_version = python_version

    @property
    def name(self):
        """Gets the name of this RimeCreateImageRequest.  # noqa: E501

        Name of the Managed Image.  # noqa: E501

        :return: The name of this RimeCreateImageRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RimeCreateImageRequest.

        Name of the Managed Image.  # noqa: E501

        :param name: The name of this RimeCreateImageRequest.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def pip_requirements(self):
        """Gets the pip_requirements of this RimeCreateImageRequest.  # noqa: E501

        List of `pip` requirements that specify the customization used for this Image.  # noqa: E501

        :return: The pip_requirements of this RimeCreateImageRequest.  # noqa: E501
        :rtype: list[ManagedImagePipRequirement]
        """
        return self._pip_requirements

    @pip_requirements.setter
    def pip_requirements(self, pip_requirements):
        """Sets the pip_requirements of this RimeCreateImageRequest.

        List of `pip` requirements that specify the customization used for this Image.  # noqa: E501

        :param pip_requirements: The pip_requirements of this RimeCreateImageRequest.  # noqa: E501
        :type: list[ManagedImagePipRequirement]
        """
        if pip_requirements is None:
            raise ValueError("Invalid value for `pip_requirements`, must not be `None`")  # noqa: E501

        self._pip_requirements = pip_requirements

    @property
    def package_requirements(self):
        """Gets the package_requirements of this RimeCreateImageRequest.  # noqa: E501

        List of system requirements that specify the customization used for this Image.  # noqa: E501

        :return: The package_requirements of this RimeCreateImageRequest.  # noqa: E501
        :rtype: list[ManagedImagePackageRequirement]
        """
        return self._package_requirements

    @package_requirements.setter
    def package_requirements(self, package_requirements):
        """Sets the package_requirements of this RimeCreateImageRequest.

        List of system requirements that specify the customization used for this Image.  # noqa: E501

        :param package_requirements: The package_requirements of this RimeCreateImageRequest.  # noqa: E501
        :type: list[ManagedImagePackageRequirement]
        """

        self._package_requirements = package_requirements

    @property
    def python_version(self):
        """Gets the python_version of this RimeCreateImageRequest.  # noqa: E501

        The version of the Python interpreter to use.  # noqa: E501

        :return: The python_version of this RimeCreateImageRequest.  # noqa: E501
        :rtype: str
        """
        return self._python_version

    @python_version.setter
    def python_version(self, python_version):
        """Sets the python_version of this RimeCreateImageRequest.

        The version of the Python interpreter to use.  # noqa: E501

        :param python_version: The python_version of this RimeCreateImageRequest.  # noqa: E501
        :type: str
        """

        self._python_version = python_version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeCreateImageRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeCreateImageRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
