# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeCreateScheduleRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'project_id': 'RimeUUID',
        'test_run_config': 'TestrunTestRunConfig',
        'frequency_cron_expr': 'str'
    }

    attribute_map = {
        'project_id': 'projectId',
        'test_run_config': 'testRunConfig',
        'frequency_cron_expr': 'frequencyCronExpr'
    }

    def __init__(self, project_id=None, test_run_config=None, frequency_cron_expr=None):  # noqa: E501
        """RimeCreateScheduleRequest - a model defined in Swagger"""  # noqa: E501
        self._project_id = None
        self._test_run_config = None
        self._frequency_cron_expr = None
        self.discriminator = None
        if project_id is not None:
            self.project_id = project_id
        if test_run_config is not None:
            self.test_run_config = test_run_config
        self.frequency_cron_expr = frequency_cron_expr

    @property
    def project_id(self):
        """Gets the project_id of this RimeCreateScheduleRequest.  # noqa: E501


        :return: The project_id of this RimeCreateScheduleRequest.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """Sets the project_id of this RimeCreateScheduleRequest.


        :param project_id: The project_id of this RimeCreateScheduleRequest.  # noqa: E501
        :type: RimeUUID
        """

        self._project_id = project_id

    @property
    def test_run_config(self):
        """Gets the test_run_config of this RimeCreateScheduleRequest.  # noqa: E501


        :return: The test_run_config of this RimeCreateScheduleRequest.  # noqa: E501
        :rtype: TestrunTestRunConfig
        """
        return self._test_run_config

    @test_run_config.setter
    def test_run_config(self, test_run_config):
        """Sets the test_run_config of this RimeCreateScheduleRequest.


        :param test_run_config: The test_run_config of this RimeCreateScheduleRequest.  # noqa: E501
        :type: TestrunTestRunConfig
        """

        self._test_run_config = test_run_config

    @property
    def frequency_cron_expr(self):
        """Gets the frequency_cron_expr of this RimeCreateScheduleRequest.  # noqa: E501

        Cron expression used to determine how often to run the schedule.  # noqa: E501

        :return: The frequency_cron_expr of this RimeCreateScheduleRequest.  # noqa: E501
        :rtype: str
        """
        return self._frequency_cron_expr

    @frequency_cron_expr.setter
    def frequency_cron_expr(self, frequency_cron_expr):
        """Sets the frequency_cron_expr of this RimeCreateScheduleRequest.

        Cron expression used to determine how often to run the schedule.  # noqa: E501

        :param frequency_cron_expr: The frequency_cron_expr of this RimeCreateScheduleRequest.  # noqa: E501
        :type: str
        """
        if frequency_cron_expr is None:
            raise ValueError("Invalid value for `frequency_cron_expr`, must not be `None`")  # noqa: E501

        self._frequency_cron_expr = frequency_cron_expr

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeCreateScheduleRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeCreateScheduleRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
