# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeCreateUserRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'email': 'str',
        'password': 'str',
        'full_name': 'str',
        'org_role': 'RimeActorRole'
    }

    attribute_map = {
        'email': 'email',
        'password': 'password',
        'full_name': 'fullName',
        'org_role': 'orgRole'
    }

    def __init__(self, email=None, password=None, full_name=None, org_role=None):  # noqa: E501
        """RimeCreateUserRequest - a model defined in Swagger"""  # noqa: E501
        self._email = None
        self._password = None
        self._full_name = None
        self._org_role = None
        self.discriminator = None
        self.email = email
        self.password = password
        self.full_name = full_name
        if org_role is not None:
            self.org_role = org_role

    @property
    def email(self):
        """Gets the email of this RimeCreateUserRequest.  # noqa: E501

        The email address of the user.  # noqa: E501

        :return: The email of this RimeCreateUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this RimeCreateUserRequest.

        The email address of the user.  # noqa: E501

        :param email: The email of this RimeCreateUserRequest.  # noqa: E501
        :type: str
        """
        if email is None:
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def password(self):
        """Gets the password of this RimeCreateUserRequest.  # noqa: E501

        The password of the user. This password will be changed on the first login.  # noqa: E501

        :return: The password of this RimeCreateUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this RimeCreateUserRequest.

        The password of the user. This password will be changed on the first login.  # noqa: E501

        :param password: The password of this RimeCreateUserRequest.  # noqa: E501
        :type: str
        """
        if password is None:
            raise ValueError("Invalid value for `password`, must not be `None`")  # noqa: E501

        self._password = password

    @property
    def full_name(self):
        """Gets the full_name of this RimeCreateUserRequest.  # noqa: E501

        The full name of the user.  # noqa: E501

        :return: The full_name of this RimeCreateUserRequest.  # noqa: E501
        :rtype: str
        """
        return self._full_name

    @full_name.setter
    def full_name(self, full_name):
        """Sets the full_name of this RimeCreateUserRequest.

        The full name of the user.  # noqa: E501

        :param full_name: The full_name of this RimeCreateUserRequest.  # noqa: E501
        :type: str
        """
        if full_name is None:
            raise ValueError("Invalid value for `full_name`, must not be `None`")  # noqa: E501

        self._full_name = full_name

    @property
    def org_role(self):
        """Gets the org_role of this RimeCreateUserRequest.  # noqa: E501


        :return: The org_role of this RimeCreateUserRequest.  # noqa: E501
        :rtype: RimeActorRole
        """
        return self._org_role

    @org_role.setter
    def org_role(self, org_role):
        """Sets the org_role of this RimeCreateUserRequest.


        :param org_role: The org_role of this RimeCreateUserRequest.  # noqa: E501
        :type: RimeActorRole
        """

        self._org_role = org_role

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeCreateUserRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeCreateUserRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
