# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeGetDatasetFileUploadURLRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'file_name': 'str',
        'upload_path': 'str'
    }

    attribute_map = {
        'file_name': 'fileName',
        'upload_path': 'uploadPath'
    }

    def __init__(self, file_name=None, upload_path=None):  # noqa: E501
        """RimeGetDatasetFileUploadURLRequest - a model defined in Swagger"""  # noqa: E501
        self._file_name = None
        self._upload_path = None
        self.discriminator = None
        self.file_name = file_name
        if upload_path is not None:
            self.upload_path = upload_path

    @property
    def file_name(self):
        """Gets the file_name of this RimeGetDatasetFileUploadURLRequest.  # noqa: E501

        Path of dataset file on the local file system.  # noqa: E501

        :return: The file_name of this RimeGetDatasetFileUploadURLRequest.  # noqa: E501
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name):
        """Sets the file_name of this RimeGetDatasetFileUploadURLRequest.

        Path of dataset file on the local file system.  # noqa: E501

        :param file_name: The file_name of this RimeGetDatasetFileUploadURLRequest.  # noqa: E501
        :type: str
        """
        if file_name is None:
            raise ValueError("Invalid value for `file_name`, must not be `None`")  # noqa: E501

        self._file_name = file_name

    @property
    def upload_path(self):
        """Gets the upload_path of this RimeGetDatasetFileUploadURLRequest.  # noqa: E501

        Specify a path in the blob store to use for data uploads.  # noqa: E501

        :return: The upload_path of this RimeGetDatasetFileUploadURLRequest.  # noqa: E501
        :rtype: str
        """
        return self._upload_path

    @upload_path.setter
    def upload_path(self, upload_path):
        """Sets the upload_path of this RimeGetDatasetFileUploadURLRequest.

        Specify a path in the blob store to use for data uploads.  # noqa: E501

        :param upload_path: The upload_path of this RimeGetDatasetFileUploadURLRequest.  # noqa: E501
        :type: str
        """

        self._upload_path = upload_path

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeGetDatasetFileUploadURLRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeGetDatasetFileUploadURLRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
