# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeGetUpgradeForAgentResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'desired_state': 'RimeAgentDesiredState',
        'rendered_manifests': 'list[str]'
    }

    attribute_map = {
        'desired_state': 'desiredState',
        'rendered_manifests': 'renderedManifests'
    }

    def __init__(self, desired_state=None, rendered_manifests=None):  # noqa: E501
        """RimeGetUpgradeForAgentResponse - a model defined in Swagger"""  # noqa: E501
        self._desired_state = None
        self._rendered_manifests = None
        self.discriminator = None
        if desired_state is not None:
            self.desired_state = desired_state
        if rendered_manifests is not None:
            self.rendered_manifests = rendered_manifests

    @property
    def desired_state(self):
        """Gets the desired_state of this RimeGetUpgradeForAgentResponse.  # noqa: E501


        :return: The desired_state of this RimeGetUpgradeForAgentResponse.  # noqa: E501
        :rtype: RimeAgentDesiredState
        """
        return self._desired_state

    @desired_state.setter
    def desired_state(self, desired_state):
        """Sets the desired_state of this RimeGetUpgradeForAgentResponse.


        :param desired_state: The desired_state of this RimeGetUpgradeForAgentResponse.  # noqa: E501
        :type: RimeAgentDesiredState
        """

        self._desired_state = desired_state

    @property
    def rendered_manifests(self):
        """Gets the rendered_manifests of this RimeGetUpgradeForAgentResponse.  # noqa: E501

        The rendered Kubernetes manifests for the agent, in stringified form. These are based on the desired state of the agent.  The DP does not have access to the helm chart, so these must be rendered by the AgentManager in the CP.  # noqa: E501

        :return: The rendered_manifests of this RimeGetUpgradeForAgentResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._rendered_manifests

    @rendered_manifests.setter
    def rendered_manifests(self, rendered_manifests):
        """Sets the rendered_manifests of this RimeGetUpgradeForAgentResponse.

        The rendered Kubernetes manifests for the agent, in stringified form. These are based on the desired state of the agent.  The DP does not have access to the helm chart, so these must be rendered by the AgentManager in the CP.  # noqa: E501

        :param rendered_manifests: The rendered_manifests of this RimeGetUpgradeForAgentResponse.  # noqa: E501
        :type: list[str]
        """

        self._rendered_manifests = rendered_manifests

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeGetUpgradeForAgentResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeGetUpgradeForAgentResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
