# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeJobData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'stress': 'JobDataStressTest',
        'continuous_inc': 'JobDataContinuousIncrementalTest',
        'file_scan': 'JobDataScan',
        'cross_plane_res': 'CrossplanetaskCrossPlaneResponse',
        'generative_model': 'RimeJobDataGenerativeModelTest'
    }

    attribute_map = {
        'stress': 'stress',
        'continuous_inc': 'continuousInc',
        'file_scan': 'fileScan',
        'cross_plane_res': 'crossPlaneRes',
        'generative_model': 'generativeModel'
    }

    def __init__(self, stress=None, continuous_inc=None, file_scan=None, cross_plane_res=None, generative_model=None):  # noqa: E501
        """RimeJobData - a model defined in Swagger"""  # noqa: E501
        self._stress = None
        self._continuous_inc = None
        self._file_scan = None
        self._cross_plane_res = None
        self._generative_model = None
        self.discriminator = None
        if stress is not None:
            self.stress = stress
        if continuous_inc is not None:
            self.continuous_inc = continuous_inc
        if file_scan is not None:
            self.file_scan = file_scan
        if cross_plane_res is not None:
            self.cross_plane_res = cross_plane_res
        if generative_model is not None:
            self.generative_model = generative_model

    @property
    def stress(self):
        """Gets the stress of this RimeJobData.  # noqa: E501


        :return: The stress of this RimeJobData.  # noqa: E501
        :rtype: JobDataStressTest
        """
        return self._stress

    @stress.setter
    def stress(self, stress):
        """Sets the stress of this RimeJobData.


        :param stress: The stress of this RimeJobData.  # noqa: E501
        :type: JobDataStressTest
        """

        self._stress = stress

    @property
    def continuous_inc(self):
        """Gets the continuous_inc of this RimeJobData.  # noqa: E501


        :return: The continuous_inc of this RimeJobData.  # noqa: E501
        :rtype: JobDataContinuousIncrementalTest
        """
        return self._continuous_inc

    @continuous_inc.setter
    def continuous_inc(self, continuous_inc):
        """Sets the continuous_inc of this RimeJobData.


        :param continuous_inc: The continuous_inc of this RimeJobData.  # noqa: E501
        :type: JobDataContinuousIncrementalTest
        """

        self._continuous_inc = continuous_inc

    @property
    def file_scan(self):
        """Gets the file_scan of this RimeJobData.  # noqa: E501


        :return: The file_scan of this RimeJobData.  # noqa: E501
        :rtype: JobDataScan
        """
        return self._file_scan

    @file_scan.setter
    def file_scan(self, file_scan):
        """Sets the file_scan of this RimeJobData.


        :param file_scan: The file_scan of this RimeJobData.  # noqa: E501
        :type: JobDataScan
        """

        self._file_scan = file_scan

    @property
    def cross_plane_res(self):
        """Gets the cross_plane_res of this RimeJobData.  # noqa: E501


        :return: The cross_plane_res of this RimeJobData.  # noqa: E501
        :rtype: CrossplanetaskCrossPlaneResponse
        """
        return self._cross_plane_res

    @cross_plane_res.setter
    def cross_plane_res(self, cross_plane_res):
        """Sets the cross_plane_res of this RimeJobData.


        :param cross_plane_res: The cross_plane_res of this RimeJobData.  # noqa: E501
        :type: CrossplanetaskCrossPlaneResponse
        """

        self._cross_plane_res = cross_plane_res

    @property
    def generative_model(self):
        """Gets the generative_model of this RimeJobData.  # noqa: E501


        :return: The generative_model of this RimeJobData.  # noqa: E501
        :rtype: RimeJobDataGenerativeModelTest
        """
        return self._generative_model

    @generative_model.setter
    def generative_model(self, generative_model):
        """Sets the generative_model of this RimeJobData.


        :param generative_model: The generative_model of this RimeJobData.  # noqa: E501
        :type: RimeJobDataGenerativeModelTest
        """

        self._generative_model = generative_model

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeJobData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeJobData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
