# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeListJobsForProjectRequestQuery(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'selected_statuses': 'list[RimeJobStatus]',
        'selected_types': 'list[RimeJobType]',
        'internal_created': 'bool',
        'schedule_id': 'RimeUUID'
    }

    attribute_map = {
        'selected_statuses': 'selectedStatuses',
        'selected_types': 'selectedTypes',
        'internal_created': 'internalCreated',
        'schedule_id': 'scheduleId'
    }

    def __init__(self, selected_statuses=None, selected_types=None, internal_created=None, schedule_id=None):  # noqa: E501
        """RimeListJobsForProjectRequestQuery - a model defined in Swagger"""  # noqa: E501
        self._selected_statuses = None
        self._selected_types = None
        self._internal_created = None
        self._schedule_id = None
        self.discriminator = None
        if selected_statuses is not None:
            self.selected_statuses = selected_statuses
        if selected_types is not None:
            self.selected_types = selected_types
        if internal_created is not None:
            self.internal_created = internal_created
        if schedule_id is not None:
            self.schedule_id = schedule_id

    @property
    def selected_statuses(self):
        """Gets the selected_statuses of this RimeListJobsForProjectRequestQuery.  # noqa: E501

        Specifies a set of statuses. The query only returns results with a status in the specified set. Specify no statuses to return all results.  # noqa: E501

        :return: The selected_statuses of this RimeListJobsForProjectRequestQuery.  # noqa: E501
        :rtype: list[RimeJobStatus]
        """
        return self._selected_statuses

    @selected_statuses.setter
    def selected_statuses(self, selected_statuses):
        """Sets the selected_statuses of this RimeListJobsForProjectRequestQuery.

        Specifies a set of statuses. The query only returns results with a status in the specified set. Specify no statuses to return all results.  # noqa: E501

        :param selected_statuses: The selected_statuses of this RimeListJobsForProjectRequestQuery.  # noqa: E501
        :type: list[RimeJobStatus]
        """

        self._selected_statuses = selected_statuses

    @property
    def selected_types(self):
        """Gets the selected_types of this RimeListJobsForProjectRequestQuery.  # noqa: E501

        Specifies a set of types. The query only returns jobs with types in the specified set. Specify no types to return all results. Job types not tied to projects will not be returned.  # noqa: E501

        :return: The selected_types of this RimeListJobsForProjectRequestQuery.  # noqa: E501
        :rtype: list[RimeJobType]
        """
        return self._selected_types

    @selected_types.setter
    def selected_types(self, selected_types):
        """Sets the selected_types of this RimeListJobsForProjectRequestQuery.

        Specifies a set of types. The query only returns jobs with types in the specified set. Specify no types to return all results. Job types not tied to projects will not be returned.  # noqa: E501

        :param selected_types: The selected_types of this RimeListJobsForProjectRequestQuery.  # noqa: E501
        :type: list[RimeJobType]
        """

        self._selected_types = selected_types

    @property
    def internal_created(self):
        """Gets the internal_created of this RimeListJobsForProjectRequestQuery.  # noqa: E501

        If true, the query only returns jobs created by internal workers. Otherwise, all jobs are returned.  # noqa: E501

        :return: The internal_created of this RimeListJobsForProjectRequestQuery.  # noqa: E501
        :rtype: bool
        """
        return self._internal_created

    @internal_created.setter
    def internal_created(self, internal_created):
        """Sets the internal_created of this RimeListJobsForProjectRequestQuery.

        If true, the query only returns jobs created by internal workers. Otherwise, all jobs are returned.  # noqa: E501

        :param internal_created: The internal_created of this RimeListJobsForProjectRequestQuery.  # noqa: E501
        :type: bool
        """

        self._internal_created = internal_created

    @property
    def schedule_id(self):
        """Gets the schedule_id of this RimeListJobsForProjectRequestQuery.  # noqa: E501


        :return: The schedule_id of this RimeListJobsForProjectRequestQuery.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._schedule_id

    @schedule_id.setter
    def schedule_id(self, schedule_id):
        """Sets the schedule_id of this RimeListJobsForProjectRequestQuery.


        :param schedule_id: The schedule_id of this RimeListJobsForProjectRequestQuery.  # noqa: E501
        :type: RimeUUID
        """

        self._schedule_id = schedule_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeListJobsForProjectRequestQuery, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeListJobsForProjectRequestQuery):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
