# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeSearchSpec(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'expression': 'str',
        'search_fields': 'list[str]'
    }

    attribute_map = {
        'expression': 'expression',
        'search_fields': 'searchFields'
    }

    def __init__(self, expression=None, search_fields=None):  # noqa: E501
        """RimeSearchSpec - a model defined in Swagger"""  # noqa: E501
        self._expression = None
        self._search_fields = None
        self.discriminator = None
        if expression is not None:
            self.expression = expression
        if search_fields is not None:
            self.search_fields = search_fields

    @property
    def expression(self):
        """Gets the expression of this RimeSearchSpec.  # noqa: E501


        :return: The expression of this RimeSearchSpec.  # noqa: E501
        :rtype: str
        """
        return self._expression

    @expression.setter
    def expression(self, expression):
        """Sets the expression of this RimeSearchSpec.


        :param expression: The expression of this RimeSearchSpec.  # noqa: E501
        :type: str
        """

        self._expression = expression

    @property
    def search_fields(self):
        """Gets the search_fields of this RimeSearchSpec.  # noqa: E501


        :return: The search_fields of this RimeSearchSpec.  # noqa: E501
        :rtype: list[str]
        """
        return self._search_fields

    @search_fields.setter
    def search_fields(self, search_fields):
        """Sets the search_fields of this RimeSearchSpec.


        :param search_fields: The search_fields of this RimeSearchSpec.  # noqa: E501
        :type: list[str]
        """

        self._search_fields = search_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeSearchSpec, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeSearchSpec):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
