# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeStartValidatePredictionsTaskRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'project_id': 'RimeUUID',
        'dataset_id': 'str',
        'model_id': 'RimeUUID',
        'agent_id': 'RimeUUID'
    }

    attribute_map = {
        'project_id': 'projectId',
        'dataset_id': 'datasetId',
        'model_id': 'modelId',
        'agent_id': 'agentId'
    }

    def __init__(self, project_id=None, dataset_id=None, model_id=None, agent_id=None):  # noqa: E501
        """RimeStartValidatePredictionsTaskRequest - a model defined in Swagger"""  # noqa: E501
        self._project_id = None
        self._dataset_id = None
        self._model_id = None
        self._agent_id = None
        self.discriminator = None
        if project_id is not None:
            self.project_id = project_id
        self.dataset_id = dataset_id
        if model_id is not None:
            self.model_id = model_id
        if agent_id is not None:
            self.agent_id = agent_id

    @property
    def project_id(self):
        """Gets the project_id of this RimeStartValidatePredictionsTaskRequest.  # noqa: E501


        :return: The project_id of this RimeStartValidatePredictionsTaskRequest.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """Sets the project_id of this RimeStartValidatePredictionsTaskRequest.


        :param project_id: The project_id of this RimeStartValidatePredictionsTaskRequest.  # noqa: E501
        :type: RimeUUID
        """

        self._project_id = project_id

    @property
    def dataset_id(self):
        """Gets the dataset_id of this RimeStartValidatePredictionsTaskRequest.  # noqa: E501


        :return: The dataset_id of this RimeStartValidatePredictionsTaskRequest.  # noqa: E501
        :rtype: str
        """
        return self._dataset_id

    @dataset_id.setter
    def dataset_id(self, dataset_id):
        """Sets the dataset_id of this RimeStartValidatePredictionsTaskRequest.


        :param dataset_id: The dataset_id of this RimeStartValidatePredictionsTaskRequest.  # noqa: E501
        :type: str
        """
        if dataset_id is None:
            raise ValueError("Invalid value for `dataset_id`, must not be `None`")  # noqa: E501

        self._dataset_id = dataset_id

    @property
    def model_id(self):
        """Gets the model_id of this RimeStartValidatePredictionsTaskRequest.  # noqa: E501


        :return: The model_id of this RimeStartValidatePredictionsTaskRequest.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """Sets the model_id of this RimeStartValidatePredictionsTaskRequest.


        :param model_id: The model_id of this RimeStartValidatePredictionsTaskRequest.  # noqa: E501
        :type: RimeUUID
        """

        self._model_id = model_id

    @property
    def agent_id(self):
        """Gets the agent_id of this RimeStartValidatePredictionsTaskRequest.  # noqa: E501


        :return: The agent_id of this RimeStartValidatePredictionsTaskRequest.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """Sets the agent_id of this RimeStartValidatePredictionsTaskRequest.


        :param agent_id: The agent_id of this RimeStartValidatePredictionsTaskRequest.  # noqa: E501
        :type: RimeUUID
        """

        self._agent_id = agent_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeStartValidatePredictionsTaskRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeStartValidatePredictionsTaskRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
