# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeUpdateBuildInfoRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'built_successfully': 'bool',
        'pip_libraries': 'list[ManagedImagePipLibrary]'
    }

    attribute_map = {
        'name': 'name',
        'built_successfully': 'builtSuccessfully',
        'pip_libraries': 'pipLibraries'
    }

    def __init__(self, name=None, built_successfully=None, pip_libraries=None):  # noqa: E501
        """RimeUpdateBuildInfoRequest - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._built_successfully = None
        self._pip_libraries = None
        self.discriminator = None
        if name is not None:
            self.name = name
        if built_successfully is not None:
            self.built_successfully = built_successfully
        if pip_libraries is not None:
            self.pip_libraries = pip_libraries

    @property
    def name(self):
        """Gets the name of this RimeUpdateBuildInfoRequest.  # noqa: E501

        This name must match the regexp described in managed_image.proto for `ManagedImage.name`.  # noqa: E501

        :return: The name of this RimeUpdateBuildInfoRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RimeUpdateBuildInfoRequest.

        This name must match the regexp described in managed_image.proto for `ManagedImage.name`.  # noqa: E501

        :param name: The name of this RimeUpdateBuildInfoRequest.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def built_successfully(self):
        """Gets the built_successfully of this RimeUpdateBuildInfoRequest.  # noqa: E501


        :return: The built_successfully of this RimeUpdateBuildInfoRequest.  # noqa: E501
        :rtype: bool
        """
        return self._built_successfully

    @built_successfully.setter
    def built_successfully(self, built_successfully):
        """Sets the built_successfully of this RimeUpdateBuildInfoRequest.


        :param built_successfully: The built_successfully of this RimeUpdateBuildInfoRequest.  # noqa: E501
        :type: bool
        """

        self._built_successfully = built_successfully

    @property
    def pip_libraries(self):
        """Gets the pip_libraries of this RimeUpdateBuildInfoRequest.  # noqa: E501


        :return: The pip_libraries of this RimeUpdateBuildInfoRequest.  # noqa: E501
        :rtype: list[ManagedImagePipLibrary]
        """
        return self._pip_libraries

    @pip_libraries.setter
    def pip_libraries(self, pip_libraries):
        """Sets the pip_libraries of this RimeUpdateBuildInfoRequest.


        :param pip_libraries: The pip_libraries of this RimeUpdateBuildInfoRequest.  # noqa: E501
        :type: list[ManagedImagePipLibrary]
        """

        self._pip_libraries = pip_libraries

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeUpdateBuildInfoRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeUpdateBuildInfoRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
