# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RuleEvaluationMetadataYaraInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'is_decisive_match': 'bool',
        'action': 'GenerativefirewallFirewallAction',
        'matched_by_rules': 'list[str]'
    }

    attribute_map = {
        'is_decisive_match': 'isDecisiveMatch',
        'action': 'action',
        'matched_by_rules': 'matchedByRules'
    }

    def __init__(self, is_decisive_match=None, action=None, matched_by_rules=None):  # noqa: E501
        """RuleEvaluationMetadataYaraInfo - a model defined in Swagger"""  # noqa: E501
        self._is_decisive_match = None
        self._action = None
        self._matched_by_rules = None
        self.discriminator = None
        if is_decisive_match is not None:
            self.is_decisive_match = is_decisive_match
        if action is not None:
            self.action = action
        if matched_by_rules is not None:
            self.matched_by_rules = matched_by_rules

    @property
    def is_decisive_match(self):
        """Gets the is_decisive_match of this RuleEvaluationMetadataYaraInfo.  # noqa: E501

        Whether we found a decisive YARA rule match. \"decisive\" means that the YARA result lead to a conclusive block or allow and we returned early in the detection pipeline.  # noqa: E501

        :return: The is_decisive_match of this RuleEvaluationMetadataYaraInfo.  # noqa: E501
        :rtype: bool
        """
        return self._is_decisive_match

    @is_decisive_match.setter
    def is_decisive_match(self, is_decisive_match):
        """Sets the is_decisive_match of this RuleEvaluationMetadataYaraInfo.

        Whether we found a decisive YARA rule match. \"decisive\" means that the YARA result lead to a conclusive block or allow and we returned early in the detection pipeline.  # noqa: E501

        :param is_decisive_match: The is_decisive_match of this RuleEvaluationMetadataYaraInfo.  # noqa: E501
        :type: bool
        """

        self._is_decisive_match = is_decisive_match

    @property
    def action(self):
        """Gets the action of this RuleEvaluationMetadataYaraInfo.  # noqa: E501


        :return: The action of this RuleEvaluationMetadataYaraInfo.  # noqa: E501
        :rtype: GenerativefirewallFirewallAction
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this RuleEvaluationMetadataYaraInfo.


        :param action: The action of this RuleEvaluationMetadataYaraInfo.  # noqa: E501
        :type: GenerativefirewallFirewallAction
        """

        self._action = action

    @property
    def matched_by_rules(self):
        """Gets the matched_by_rules of this RuleEvaluationMetadataYaraInfo.  # noqa: E501

        Which rules triggered on the text.  # noqa: E501

        :return: The matched_by_rules of this RuleEvaluationMetadataYaraInfo.  # noqa: E501
        :rtype: list[str]
        """
        return self._matched_by_rules

    @matched_by_rules.setter
    def matched_by_rules(self, matched_by_rules):
        """Sets the matched_by_rules of this RuleEvaluationMetadataYaraInfo.

        Which rules triggered on the text.  # noqa: E501

        :param matched_by_rules: The matched_by_rules of this RuleEvaluationMetadataYaraInfo.  # noqa: E501
        :type: list[str]
        """

        self._matched_by_rules = matched_by_rules

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RuleEvaluationMetadataYaraInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RuleEvaluationMetadataYaraInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
