# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RuleOutputRuleEvaluationMetadata(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'evaluation_models': 'dict(str, RuleOutputRuleEvaluationMetadataModelInfo)',
        'yara_hotfix': 'RuleEvaluationMetadataYaraInfo'
    }

    attribute_map = {
        'evaluation_models': 'evaluationModels',
        'yara_hotfix': 'yaraHotfix'
    }

    def __init__(self, evaluation_models=None, yara_hotfix=None):  # noqa: E501
        """RuleOutputRuleEvaluationMetadata - a model defined in Swagger"""  # noqa: E501
        self._evaluation_models = None
        self._yara_hotfix = None
        self.discriminator = None
        if evaluation_models is not None:
            self.evaluation_models = evaluation_models
        if yara_hotfix is not None:
            self.yara_hotfix = yara_hotfix

    @property
    def evaluation_models(self):
        """Gets the evaluation_models of this RuleOutputRuleEvaluationMetadata.  # noqa: E501

        Map from the name of the model (`prompt-injection`, `toxicity`) to information about how it was used in evaluation.  # noqa: E501

        :return: The evaluation_models of this RuleOutputRuleEvaluationMetadata.  # noqa: E501
        :rtype: dict(str, RuleOutputRuleEvaluationMetadataModelInfo)
        """
        return self._evaluation_models

    @evaluation_models.setter
    def evaluation_models(self, evaluation_models):
        """Sets the evaluation_models of this RuleOutputRuleEvaluationMetadata.

        Map from the name of the model (`prompt-injection`, `toxicity`) to information about how it was used in evaluation.  # noqa: E501

        :param evaluation_models: The evaluation_models of this RuleOutputRuleEvaluationMetadata.  # noqa: E501
        :type: dict(str, RuleOutputRuleEvaluationMetadataModelInfo)
        """

        self._evaluation_models = evaluation_models

    @property
    def yara_hotfix(self):
        """Gets the yara_hotfix of this RuleOutputRuleEvaluationMetadata.  # noqa: E501


        :return: The yara_hotfix of this RuleOutputRuleEvaluationMetadata.  # noqa: E501
        :rtype: RuleEvaluationMetadataYaraInfo
        """
        return self._yara_hotfix

    @yara_hotfix.setter
    def yara_hotfix(self, yara_hotfix):
        """Sets the yara_hotfix of this RuleOutputRuleEvaluationMetadata.


        :param yara_hotfix: The yara_hotfix of this RuleOutputRuleEvaluationMetadata.  # noqa: E501
        :type: RuleEvaluationMetadataYaraInfo
        """

        self._yara_hotfix = yara_hotfix

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RuleOutputRuleEvaluationMetadata, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RuleOutputRuleEvaluationMetadata):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
