# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class SchemafilescanningFileScanResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'file_scan_id': 'RimeUUID',
        'project_id': 'RimeUUID',
        'model_id': 'RimeUUID',
        'rime_agent_version': 'str',
        'upload_time': 'datetime',
        'file_security_reports': 'list[SchemafilescanningFileSecurityReport]',
        'repo_metadata': 'SchemafilescanningRepoMetadata',
        'unscanned_file_paths': 'list[str]',
        'severity': 'RimeSeverity'
    }

    attribute_map = {
        'file_scan_id': 'fileScanId',
        'project_id': 'projectId',
        'model_id': 'modelId',
        'rime_agent_version': 'rimeAgentVersion',
        'upload_time': 'uploadTime',
        'file_security_reports': 'fileSecurityReports',
        'repo_metadata': 'repoMetadata',
        'unscanned_file_paths': 'unscannedFilePaths',
        'severity': 'severity'
    }

    def __init__(self, file_scan_id=None, project_id=None, model_id=None, rime_agent_version=None, upload_time=None, file_security_reports=None, repo_metadata=None, unscanned_file_paths=None, severity=None):  # noqa: E501
        """SchemafilescanningFileScanResult - a model defined in Swagger"""  # noqa: E501
        self._file_scan_id = None
        self._project_id = None
        self._model_id = None
        self._rime_agent_version = None
        self._upload_time = None
        self._file_security_reports = None
        self._repo_metadata = None
        self._unscanned_file_paths = None
        self._severity = None
        self.discriminator = None
        if file_scan_id is not None:
            self.file_scan_id = file_scan_id
        if project_id is not None:
            self.project_id = project_id
        if model_id is not None:
            self.model_id = model_id
        if rime_agent_version is not None:
            self.rime_agent_version = rime_agent_version
        if upload_time is not None:
            self.upload_time = upload_time
        if file_security_reports is not None:
            self.file_security_reports = file_security_reports
        if repo_metadata is not None:
            self.repo_metadata = repo_metadata
        if unscanned_file_paths is not None:
            self.unscanned_file_paths = unscanned_file_paths
        if severity is not None:
            self.severity = severity

    @property
    def file_scan_id(self):
        """Gets the file_scan_id of this SchemafilescanningFileScanResult.  # noqa: E501


        :return: The file_scan_id of this SchemafilescanningFileScanResult.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._file_scan_id

    @file_scan_id.setter
    def file_scan_id(self, file_scan_id):
        """Sets the file_scan_id of this SchemafilescanningFileScanResult.


        :param file_scan_id: The file_scan_id of this SchemafilescanningFileScanResult.  # noqa: E501
        :type: RimeUUID
        """

        self._file_scan_id = file_scan_id

    @property
    def project_id(self):
        """Gets the project_id of this SchemafilescanningFileScanResult.  # noqa: E501


        :return: The project_id of this SchemafilescanningFileScanResult.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """Sets the project_id of this SchemafilescanningFileScanResult.


        :param project_id: The project_id of this SchemafilescanningFileScanResult.  # noqa: E501
        :type: RimeUUID
        """

        self._project_id = project_id

    @property
    def model_id(self):
        """Gets the model_id of this SchemafilescanningFileScanResult.  # noqa: E501


        :return: The model_id of this SchemafilescanningFileScanResult.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """Sets the model_id of this SchemafilescanningFileScanResult.


        :param model_id: The model_id of this SchemafilescanningFileScanResult.  # noqa: E501
        :type: RimeUUID
        """

        self._model_id = model_id

    @property
    def rime_agent_version(self):
        """Gets the rime_agent_version of this SchemafilescanningFileScanResult.  # noqa: E501

        The version of the RIME agent that was used to scan the model.  # noqa: E501

        :return: The rime_agent_version of this SchemafilescanningFileScanResult.  # noqa: E501
        :rtype: str
        """
        return self._rime_agent_version

    @rime_agent_version.setter
    def rime_agent_version(self, rime_agent_version):
        """Sets the rime_agent_version of this SchemafilescanningFileScanResult.

        The version of the RIME agent that was used to scan the model.  # noqa: E501

        :param rime_agent_version: The rime_agent_version of this SchemafilescanningFileScanResult.  # noqa: E501
        :type: str
        """

        self._rime_agent_version = rime_agent_version

    @property
    def upload_time(self):
        """Gets the upload_time of this SchemafilescanningFileScanResult.  # noqa: E501

        The time when the file scan result was uploaded.  # noqa: E501

        :return: The upload_time of this SchemafilescanningFileScanResult.  # noqa: E501
        :rtype: datetime
        """
        return self._upload_time

    @upload_time.setter
    def upload_time(self, upload_time):
        """Sets the upload_time of this SchemafilescanningFileScanResult.

        The time when the file scan result was uploaded.  # noqa: E501

        :param upload_time: The upload_time of this SchemafilescanningFileScanResult.  # noqa: E501
        :type: datetime
        """

        self._upload_time = upload_time

    @property
    def file_security_reports(self):
        """Gets the file_security_reports of this SchemafilescanningFileScanResult.  # noqa: E501

        The security reports for the files that were scanned.  # noqa: E501

        :return: The file_security_reports of this SchemafilescanningFileScanResult.  # noqa: E501
        :rtype: list[SchemafilescanningFileSecurityReport]
        """
        return self._file_security_reports

    @file_security_reports.setter
    def file_security_reports(self, file_security_reports):
        """Sets the file_security_reports of this SchemafilescanningFileScanResult.

        The security reports for the files that were scanned.  # noqa: E501

        :param file_security_reports: The file_security_reports of this SchemafilescanningFileScanResult.  # noqa: E501
        :type: list[SchemafilescanningFileSecurityReport]
        """

        self._file_security_reports = file_security_reports

    @property
    def repo_metadata(self):
        """Gets the repo_metadata of this SchemafilescanningFileScanResult.  # noqa: E501


        :return: The repo_metadata of this SchemafilescanningFileScanResult.  # noqa: E501
        :rtype: SchemafilescanningRepoMetadata
        """
        return self._repo_metadata

    @repo_metadata.setter
    def repo_metadata(self, repo_metadata):
        """Sets the repo_metadata of this SchemafilescanningFileScanResult.


        :param repo_metadata: The repo_metadata of this SchemafilescanningFileScanResult.  # noqa: E501
        :type: SchemafilescanningRepoMetadata
        """

        self._repo_metadata = repo_metadata

    @property
    def unscanned_file_paths(self):
        """Gets the unscanned_file_paths of this SchemafilescanningFileScanResult.  # noqa: E501

        The list of files that were not scanned.  # noqa: E501

        :return: The unscanned_file_paths of this SchemafilescanningFileScanResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._unscanned_file_paths

    @unscanned_file_paths.setter
    def unscanned_file_paths(self, unscanned_file_paths):
        """Sets the unscanned_file_paths of this SchemafilescanningFileScanResult.

        The list of files that were not scanned.  # noqa: E501

        :param unscanned_file_paths: The unscanned_file_paths of this SchemafilescanningFileScanResult.  # noqa: E501
        :type: list[str]
        """

        self._unscanned_file_paths = unscanned_file_paths

    @property
    def severity(self):
        """Gets the severity of this SchemafilescanningFileScanResult.  # noqa: E501


        :return: The severity of this SchemafilescanningFileScanResult.  # noqa: E501
        :rtype: RimeSeverity
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this SchemafilescanningFileScanResult.


        :param severity: The severity of this SchemafilescanningFileScanResult.  # noqa: E501
        :type: RimeSeverity
        """

        self._severity = severity

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SchemafilescanningFileScanResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SchemafilescanningFileScanResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
