# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class SchemasecuritydbFileScanResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'result_update_time': 'datetime',
        'file_security_reports': 'list[SchemasecuritydbFileSecurityReport]',
        'scanned_file_paths': 'list[str]',
        'severity': 'LibgenerativeSeverity'
    }

    attribute_map = {
        'result_update_time': 'resultUpdateTime',
        'file_security_reports': 'fileSecurityReports',
        'scanned_file_paths': 'scannedFilePaths',
        'severity': 'severity'
    }

    def __init__(self, result_update_time=None, file_security_reports=None, scanned_file_paths=None, severity=None):  # noqa: E501
        """SchemasecuritydbFileScanResult - a model defined in Swagger"""  # noqa: E501
        self._result_update_time = None
        self._file_security_reports = None
        self._scanned_file_paths = None
        self._severity = None
        self.discriminator = None
        if result_update_time is not None:
            self.result_update_time = result_update_time
        if file_security_reports is not None:
            self.file_security_reports = file_security_reports
        if scanned_file_paths is not None:
            self.scanned_file_paths = scanned_file_paths
        if severity is not None:
            self.severity = severity

    @property
    def result_update_time(self):
        """Gets the result_update_time of this SchemasecuritydbFileScanResult.  # noqa: E501

        The time when the result was updated.  # noqa: E501

        :return: The result_update_time of this SchemasecuritydbFileScanResult.  # noqa: E501
        :rtype: datetime
        """
        return self._result_update_time

    @result_update_time.setter
    def result_update_time(self, result_update_time):
        """Sets the result_update_time of this SchemasecuritydbFileScanResult.

        The time when the result was updated.  # noqa: E501

        :param result_update_time: The result_update_time of this SchemasecuritydbFileScanResult.  # noqa: E501
        :type: datetime
        """

        self._result_update_time = result_update_time

    @property
    def file_security_reports(self):
        """Gets the file_security_reports of this SchemasecuritydbFileScanResult.  # noqa: E501

        The security reports for the files that were scanned.  # noqa: E501

        :return: The file_security_reports of this SchemasecuritydbFileScanResult.  # noqa: E501
        :rtype: list[SchemasecuritydbFileSecurityReport]
        """
        return self._file_security_reports

    @file_security_reports.setter
    def file_security_reports(self, file_security_reports):
        """Sets the file_security_reports of this SchemasecuritydbFileScanResult.

        The security reports for the files that were scanned.  # noqa: E501

        :param file_security_reports: The file_security_reports of this SchemasecuritydbFileScanResult.  # noqa: E501
        :type: list[SchemasecuritydbFileSecurityReport]
        """

        self._file_security_reports = file_security_reports

    @property
    def scanned_file_paths(self):
        """Gets the scanned_file_paths of this SchemasecuritydbFileScanResult.  # noqa: E501

        The list of files that were scanned.  # noqa: E501

        :return: The scanned_file_paths of this SchemasecuritydbFileScanResult.  # noqa: E501
        :rtype: list[str]
        """
        return self._scanned_file_paths

    @scanned_file_paths.setter
    def scanned_file_paths(self, scanned_file_paths):
        """Sets the scanned_file_paths of this SchemasecuritydbFileScanResult.

        The list of files that were scanned.  # noqa: E501

        :param scanned_file_paths: The scanned_file_paths of this SchemasecuritydbFileScanResult.  # noqa: E501
        :type: list[str]
        """

        self._scanned_file_paths = scanned_file_paths

    @property
    def severity(self):
        """Gets the severity of this SchemasecuritydbFileScanResult.  # noqa: E501


        :return: The severity of this SchemasecuritydbFileScanResult.  # noqa: E501
        :rtype: LibgenerativeSeverity
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this SchemasecuritydbFileScanResult.


        :param severity: The severity of this SchemasecuritydbFileScanResult.  # noqa: E501
        :type: LibgenerativeSeverity
        """

        self._severity = severity

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SchemasecuritydbFileScanResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SchemasecuritydbFileScanResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
