# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TestrunModelProfiling(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'nrows_for_summary': 'str',
        'nrows_for_feature_importance': 'str',
        'metric_configs_json': 'str',
        'impact_metric': 'str',
        'impact_label_threshold': 'float',
        'drift_impact_metric': 'str',
        'subset_summary_metric': 'str',
        'num_feats_for_subset_summary': 'str',
        'custom_metrics': 'list[TestrunCustomMetric]'
    }

    attribute_map = {
        'nrows_for_summary': 'nrowsForSummary',
        'nrows_for_feature_importance': 'nrowsForFeatureImportance',
        'metric_configs_json': 'metricConfigsJson',
        'impact_metric': 'impactMetric',
        'impact_label_threshold': 'impactLabelThreshold',
        'drift_impact_metric': 'driftImpactMetric',
        'subset_summary_metric': 'subsetSummaryMetric',
        'num_feats_for_subset_summary': 'numFeatsForSubsetSummary',
        'custom_metrics': 'customMetrics'
    }

    def __init__(self, nrows_for_summary=None, nrows_for_feature_importance=None, metric_configs_json=None, impact_metric=None, impact_label_threshold=None, drift_impact_metric=None, subset_summary_metric=None, num_feats_for_subset_summary=None, custom_metrics=None):  # noqa: E501
        """TestrunModelProfiling - a model defined in Swagger"""  # noqa: E501
        self._nrows_for_summary = None
        self._nrows_for_feature_importance = None
        self._metric_configs_json = None
        self._impact_metric = None
        self._impact_label_threshold = None
        self._drift_impact_metric = None
        self._subset_summary_metric = None
        self._num_feats_for_subset_summary = None
        self._custom_metrics = None
        self.discriminator = None
        if nrows_for_summary is not None:
            self.nrows_for_summary = nrows_for_summary
        if nrows_for_feature_importance is not None:
            self.nrows_for_feature_importance = nrows_for_feature_importance
        if metric_configs_json is not None:
            self.metric_configs_json = metric_configs_json
        if impact_metric is not None:
            self.impact_metric = impact_metric
        if impact_label_threshold is not None:
            self.impact_label_threshold = impact_label_threshold
        if drift_impact_metric is not None:
            self.drift_impact_metric = drift_impact_metric
        if subset_summary_metric is not None:
            self.subset_summary_metric = subset_summary_metric
        if num_feats_for_subset_summary is not None:
            self.num_feats_for_subset_summary = num_feats_for_subset_summary
        if custom_metrics is not None:
            self.custom_metrics = custom_metrics

    @property
    def nrows_for_summary(self):
        """Gets the nrows_for_summary of this TestrunModelProfiling.  # noqa: E501

        Number of rows to perform inference on the model if no predictions.  # noqa: E501

        :return: The nrows_for_summary of this TestrunModelProfiling.  # noqa: E501
        :rtype: str
        """
        return self._nrows_for_summary

    @nrows_for_summary.setter
    def nrows_for_summary(self, nrows_for_summary):
        """Sets the nrows_for_summary of this TestrunModelProfiling.

        Number of rows to perform inference on the model if no predictions.  # noqa: E501

        :param nrows_for_summary: The nrows_for_summary of this TestrunModelProfiling.  # noqa: E501
        :type: str
        """

        self._nrows_for_summary = nrows_for_summary

    @property
    def nrows_for_feature_importance(self):
        """Gets the nrows_for_feature_importance of this TestrunModelProfiling.  # noqa: E501

        Number of rows to calculate feature importance over.  # noqa: E501

        :return: The nrows_for_feature_importance of this TestrunModelProfiling.  # noqa: E501
        :rtype: str
        """
        return self._nrows_for_feature_importance

    @nrows_for_feature_importance.setter
    def nrows_for_feature_importance(self, nrows_for_feature_importance):
        """Sets the nrows_for_feature_importance of this TestrunModelProfiling.

        Number of rows to calculate feature importance over.  # noqa: E501

        :param nrows_for_feature_importance: The nrows_for_feature_importance of this TestrunModelProfiling.  # noqa: E501
        :type: str
        """

        self._nrows_for_feature_importance = nrows_for_feature_importance

    @property
    def metric_configs_json(self):
        """Gets the metric_configs_json of this TestrunModelProfiling.  # noqa: E501

        JSON map of metric API names to keyword arguments, which allows configuration of arbitrary metrics.  # noqa: E501

        :return: The metric_configs_json of this TestrunModelProfiling.  # noqa: E501
        :rtype: str
        """
        return self._metric_configs_json

    @metric_configs_json.setter
    def metric_configs_json(self, metric_configs_json):
        """Sets the metric_configs_json of this TestrunModelProfiling.

        JSON map of metric API names to keyword arguments, which allows configuration of arbitrary metrics.  # noqa: E501

        :param metric_configs_json: The metric_configs_json of this TestrunModelProfiling.  # noqa: E501
        :type: str
        """

        self._metric_configs_json = metric_configs_json

    @property
    def impact_metric(self):
        """Gets the impact_metric of this TestrunModelProfiling.  # noqa: E501

        Default impact metric.  # noqa: E501

        :return: The impact_metric of this TestrunModelProfiling.  # noqa: E501
        :rtype: str
        """
        return self._impact_metric

    @impact_metric.setter
    def impact_metric(self, impact_metric):
        """Sets the impact_metric of this TestrunModelProfiling.

        Default impact metric.  # noqa: E501

        :param impact_metric: The impact_metric of this TestrunModelProfiling.  # noqa: E501
        :type: str
        """

        self._impact_metric = impact_metric

    @property
    def impact_label_threshold(self):
        """Gets the impact_label_threshold of this TestrunModelProfiling.  # noqa: E501

        Specifies the threshold for measuring model impact using labeled performance metrics instead of prediction metrics, assuming partial labels.  # noqa: E501

        :return: The impact_label_threshold of this TestrunModelProfiling.  # noqa: E501
        :rtype: float
        """
        return self._impact_label_threshold

    @impact_label_threshold.setter
    def impact_label_threshold(self, impact_label_threshold):
        """Sets the impact_label_threshold of this TestrunModelProfiling.

        Specifies the threshold for measuring model impact using labeled performance metrics instead of prediction metrics, assuming partial labels.  # noqa: E501

        :param impact_label_threshold: The impact_label_threshold of this TestrunModelProfiling.  # noqa: E501
        :type: float
        """

        self._impact_label_threshold = impact_label_threshold

    @property
    def drift_impact_metric(self):
        """Gets the drift_impact_metric of this TestrunModelProfiling.  # noqa: E501

        Default drift impact metric.  # noqa: E501

        :return: The drift_impact_metric of this TestrunModelProfiling.  # noqa: E501
        :rtype: str
        """
        return self._drift_impact_metric

    @drift_impact_metric.setter
    def drift_impact_metric(self, drift_impact_metric):
        """Sets the drift_impact_metric of this TestrunModelProfiling.

        Default drift impact metric.  # noqa: E501

        :param drift_impact_metric: The drift_impact_metric of this TestrunModelProfiling.  # noqa: E501
        :type: str
        """

        self._drift_impact_metric = drift_impact_metric

    @property
    def subset_summary_metric(self):
        """Gets the subset_summary_metric of this TestrunModelProfiling.  # noqa: E501

        The subset performance degradation summary metric is calculated by taking the difference between the worst subset degradation and the overall degradation of the configured metric.  # noqa: E501

        :return: The subset_summary_metric of this TestrunModelProfiling.  # noqa: E501
        :rtype: str
        """
        return self._subset_summary_metric

    @subset_summary_metric.setter
    def subset_summary_metric(self, subset_summary_metric):
        """Sets the subset_summary_metric of this TestrunModelProfiling.

        The subset performance degradation summary metric is calculated by taking the difference between the worst subset degradation and the overall degradation of the configured metric.  # noqa: E501

        :param subset_summary_metric: The subset_summary_metric of this TestrunModelProfiling.  # noqa: E501
        :type: str
        """

        self._subset_summary_metric = subset_summary_metric

    @property
    def num_feats_for_subset_summary(self):
        """Gets the num_feats_for_subset_summary of this TestrunModelProfiling.  # noqa: E501

        Number of features over which the subset performance degradation summary metric is aggregated.  # noqa: E501

        :return: The num_feats_for_subset_summary of this TestrunModelProfiling.  # noqa: E501
        :rtype: str
        """
        return self._num_feats_for_subset_summary

    @num_feats_for_subset_summary.setter
    def num_feats_for_subset_summary(self, num_feats_for_subset_summary):
        """Sets the num_feats_for_subset_summary of this TestrunModelProfiling.

        Number of features over which the subset performance degradation summary metric is aggregated.  # noqa: E501

        :param num_feats_for_subset_summary: The num_feats_for_subset_summary of this TestrunModelProfiling.  # noqa: E501
        :type: str
        """

        self._num_feats_for_subset_summary = num_feats_for_subset_summary

    @property
    def custom_metrics(self):
        """Gets the custom_metrics of this TestrunModelProfiling.  # noqa: E501

        List of custom metrics.  # noqa: E501

        :return: The custom_metrics of this TestrunModelProfiling.  # noqa: E501
        :rtype: list[TestrunCustomMetric]
        """
        return self._custom_metrics

    @custom_metrics.setter
    def custom_metrics(self, custom_metrics):
        """Sets the custom_metrics of this TestrunModelProfiling.

        List of custom metrics.  # noqa: E501

        :param custom_metrics: The custom_metrics of this TestrunModelProfiling.  # noqa: E501
        :type: list[TestrunCustomMetric]
        """

        self._custom_metrics = custom_metrics

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TestrunModelProfiling, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TestrunModelProfiling):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
