# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TestrunTestSuiteConfig(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'global_test_sensitivity': 'TestrunTestSensitivity',
        'individual_tests_config': 'str',
        'custom_tests': 'list[str]',
        'global_exclude_columns': 'list[str]'
    }

    attribute_map = {
        'global_test_sensitivity': 'globalTestSensitivity',
        'individual_tests_config': 'individualTestsConfig',
        'custom_tests': 'customTests',
        'global_exclude_columns': 'globalExcludeColumns'
    }

    def __init__(self, global_test_sensitivity=None, individual_tests_config=None, custom_tests=None, global_exclude_columns=None):  # noqa: E501
        """TestrunTestSuiteConfig - a model defined in Swagger"""  # noqa: E501
        self._global_test_sensitivity = None
        self._individual_tests_config = None
        self._custom_tests = None
        self._global_exclude_columns = None
        self.discriminator = None
        if global_test_sensitivity is not None:
            self.global_test_sensitivity = global_test_sensitivity
        if individual_tests_config is not None:
            self.individual_tests_config = individual_tests_config
        if custom_tests is not None:
            self.custom_tests = custom_tests
        if global_exclude_columns is not None:
            self.global_exclude_columns = global_exclude_columns

    @property
    def global_test_sensitivity(self):
        """Gets the global_test_sensitivity of this TestrunTestSuiteConfig.  # noqa: E501


        :return: The global_test_sensitivity of this TestrunTestSuiteConfig.  # noqa: E501
        :rtype: TestrunTestSensitivity
        """
        return self._global_test_sensitivity

    @global_test_sensitivity.setter
    def global_test_sensitivity(self, global_test_sensitivity):
        """Sets the global_test_sensitivity of this TestrunTestSuiteConfig.


        :param global_test_sensitivity: The global_test_sensitivity of this TestrunTestSuiteConfig.  # noqa: E501
        :type: TestrunTestSensitivity
        """

        self._global_test_sensitivity = global_test_sensitivity

    @property
    def individual_tests_config(self):
        """Gets the individual_tests_config of this TestrunTestSuiteConfig.  # noqa: E501

        A serialized JSON blob including a config for each test.  # noqa: E501

        :return: The individual_tests_config of this TestrunTestSuiteConfig.  # noqa: E501
        :rtype: str
        """
        return self._individual_tests_config

    @individual_tests_config.setter
    def individual_tests_config(self, individual_tests_config):
        """Sets the individual_tests_config of this TestrunTestSuiteConfig.

        A serialized JSON blob including a config for each test.  # noqa: E501

        :param individual_tests_config: The individual_tests_config of this TestrunTestSuiteConfig.  # noqa: E501
        :type: str
        """

        self._individual_tests_config = individual_tests_config

    @property
    def custom_tests(self):
        """Gets the custom_tests of this TestrunTestSuiteConfig.  # noqa: E501

        A list of JSON custom test configurations.  # noqa: E501

        :return: The custom_tests of this TestrunTestSuiteConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._custom_tests

    @custom_tests.setter
    def custom_tests(self, custom_tests):
        """Sets the custom_tests of this TestrunTestSuiteConfig.

        A list of JSON custom test configurations.  # noqa: E501

        :param custom_tests: The custom_tests of this TestrunTestSuiteConfig.  # noqa: E501
        :type: list[str]
        """

        self._custom_tests = custom_tests

    @property
    def global_exclude_columns(self):
        """Gets the global_exclude_columns of this TestrunTestSuiteConfig.  # noqa: E501

        Features to exclude from all tests.  # noqa: E501

        :return: The global_exclude_columns of this TestrunTestSuiteConfig.  # noqa: E501
        :rtype: list[str]
        """
        return self._global_exclude_columns

    @global_exclude_columns.setter
    def global_exclude_columns(self, global_exclude_columns):
        """Sets the global_exclude_columns of this TestrunTestSuiteConfig.

        Features to exclude from all tests.  # noqa: E501

        :param global_exclude_columns: The global_exclude_columns of this TestrunTestSuiteConfig.  # noqa: E501
        :type: list[str]
        """

        self._global_exclude_columns = global_exclude_columns

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TestrunTestSuiteConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TestrunTestSuiteConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
