# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ValidateResponseProcessedRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'request_id': 'str',
        'user_input_text': 'str',
        'input_token_count': 'int',
        'contexts': 'list[str]',
        'contexts_token_count': 'int',
        'output_text': 'str',
        'output_token_count': 'int'
    }

    attribute_map = {
        'request_id': 'requestId',
        'user_input_text': 'userInputText',
        'input_token_count': 'inputTokenCount',
        'contexts': 'contexts',
        'contexts_token_count': 'contextsTokenCount',
        'output_text': 'outputText',
        'output_token_count': 'outputTokenCount'
    }

    def __init__(self, request_id=None, user_input_text=None, input_token_count=None, contexts=None, contexts_token_count=None, output_text=None, output_token_count=None):  # noqa: E501
        """ValidateResponseProcessedRequest - a model defined in Swagger"""  # noqa: E501
        self._request_id = None
        self._user_input_text = None
        self._input_token_count = None
        self._contexts = None
        self._contexts_token_count = None
        self._output_text = None
        self._output_token_count = None
        self.discriminator = None
        if request_id is not None:
            self.request_id = request_id
        if user_input_text is not None:
            self.user_input_text = user_input_text
        if input_token_count is not None:
            self.input_token_count = input_token_count
        if contexts is not None:
            self.contexts = contexts
        if contexts_token_count is not None:
            self.contexts_token_count = contexts_token_count
        if output_text is not None:
            self.output_text = output_text
        if output_token_count is not None:
            self.output_token_count = output_token_count

    @property
    def request_id(self):
        """Gets the request_id of this ValidateResponseProcessedRequest.  # noqa: E501

        Unique identifier of the request.  # noqa: E501

        :return: The request_id of this ValidateResponseProcessedRequest.  # noqa: E501
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """Sets the request_id of this ValidateResponseProcessedRequest.

        Unique identifier of the request.  # noqa: E501

        :param request_id: The request_id of this ValidateResponseProcessedRequest.  # noqa: E501
        :type: str
        """

        self._request_id = request_id

    @property
    def user_input_text(self):
        """Gets the user_input_text of this ValidateResponseProcessedRequest.  # noqa: E501

        Information about the `user_input_text`. The raw input is truncated if it exceeds a certain token length so we do not denial of service downstream logging and data systems.  # noqa: E501

        :return: The user_input_text of this ValidateResponseProcessedRequest.  # noqa: E501
        :rtype: str
        """
        return self._user_input_text

    @user_input_text.setter
    def user_input_text(self, user_input_text):
        """Sets the user_input_text of this ValidateResponseProcessedRequest.

        Information about the `user_input_text`. The raw input is truncated if it exceeds a certain token length so we do not denial of service downstream logging and data systems.  # noqa: E501

        :param user_input_text: The user_input_text of this ValidateResponseProcessedRequest.  # noqa: E501
        :type: str
        """

        self._user_input_text = user_input_text

    @property
    def input_token_count(self):
        """Gets the input_token_count of this ValidateResponseProcessedRequest.  # noqa: E501


        :return: The input_token_count of this ValidateResponseProcessedRequest.  # noqa: E501
        :rtype: int
        """
        return self._input_token_count

    @input_token_count.setter
    def input_token_count(self, input_token_count):
        """Sets the input_token_count of this ValidateResponseProcessedRequest.


        :param input_token_count: The input_token_count of this ValidateResponseProcessedRequest.  # noqa: E501
        :type: int
        """

        self._input_token_count = input_token_count

    @property
    def contexts(self):
        """Gets the contexts of this ValidateResponseProcessedRequest.  # noqa: E501

        Information about the `contexts`. The contexts are truncated if it exceeds a certain token length so we do not denial of service downstream logging and data systems.  # noqa: E501

        :return: The contexts of this ValidateResponseProcessedRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._contexts

    @contexts.setter
    def contexts(self, contexts):
        """Sets the contexts of this ValidateResponseProcessedRequest.

        Information about the `contexts`. The contexts are truncated if it exceeds a certain token length so we do not denial of service downstream logging and data systems.  # noqa: E501

        :param contexts: The contexts of this ValidateResponseProcessedRequest.  # noqa: E501
        :type: list[str]
        """

        self._contexts = contexts

    @property
    def contexts_token_count(self):
        """Gets the contexts_token_count of this ValidateResponseProcessedRequest.  # noqa: E501


        :return: The contexts_token_count of this ValidateResponseProcessedRequest.  # noqa: E501
        :rtype: int
        """
        return self._contexts_token_count

    @contexts_token_count.setter
    def contexts_token_count(self, contexts_token_count):
        """Sets the contexts_token_count of this ValidateResponseProcessedRequest.


        :param contexts_token_count: The contexts_token_count of this ValidateResponseProcessedRequest.  # noqa: E501
        :type: int
        """

        self._contexts_token_count = contexts_token_count

    @property
    def output_text(self):
        """Gets the output_text of this ValidateResponseProcessedRequest.  # noqa: E501

        Information about the `output_text`. The output text is truncated if it exceeds a certain token length so we do not denial of service downstream logging and data systems.  # noqa: E501

        :return: The output_text of this ValidateResponseProcessedRequest.  # noqa: E501
        :rtype: str
        """
        return self._output_text

    @output_text.setter
    def output_text(self, output_text):
        """Sets the output_text of this ValidateResponseProcessedRequest.

        Information about the `output_text`. The output text is truncated if it exceeds a certain token length so we do not denial of service downstream logging and data systems.  # noqa: E501

        :param output_text: The output_text of this ValidateResponseProcessedRequest.  # noqa: E501
        :type: str
        """

        self._output_text = output_text

    @property
    def output_token_count(self):
        """Gets the output_token_count of this ValidateResponseProcessedRequest.  # noqa: E501


        :return: The output_token_count of this ValidateResponseProcessedRequest.  # noqa: E501
        :rtype: int
        """
        return self._output_token_count

    @output_token_count.setter
    def output_token_count(self, output_token_count):
        """Sets the output_token_count of this ValidateResponseProcessedRequest.


        :param output_token_count: The output_token_count of this ValidateResponseProcessedRequest.  # noqa: E501
        :type: int
        """

        self._output_token_count = output_token_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ValidateResponseProcessedRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ValidateResponseProcessedRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
