# coding: utf-8

"""
    Robust Intelligence REST API

    API methods for Robust Intelligence. Users must authenticate using the `X-Firewall-Auth-Token` for all the firewall methods and `rime-api-key` for all other methods.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ValidateResponseProductMetadata(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vendor_name': 'str',
        'product': 'str',
        'firewall_instance_id': 'str',
        'version': 'str'
    }

    attribute_map = {
        'vendor_name': 'vendorName',
        'product': 'product',
        'firewall_instance_id': 'firewallInstanceId',
        'version': 'version'
    }

    def __init__(self, vendor_name=None, product=None, firewall_instance_id=None, version=None):  # noqa: E501
        """ValidateResponseProductMetadata - a model defined in Swagger"""  # noqa: E501
        self._vendor_name = None
        self._product = None
        self._firewall_instance_id = None
        self._version = None
        self.discriminator = None
        if vendor_name is not None:
            self.vendor_name = vendor_name
        if product is not None:
            self.product = product
        if firewall_instance_id is not None:
            self.firewall_instance_id = firewall_instance_id
        if version is not None:
            self.version = version

    @property
    def vendor_name(self):
        """Gets the vendor_name of this ValidateResponseProductMetadata.  # noqa: E501


        :return: The vendor_name of this ValidateResponseProductMetadata.  # noqa: E501
        :rtype: str
        """
        return self._vendor_name

    @vendor_name.setter
    def vendor_name(self, vendor_name):
        """Sets the vendor_name of this ValidateResponseProductMetadata.


        :param vendor_name: The vendor_name of this ValidateResponseProductMetadata.  # noqa: E501
        :type: str
        """

        self._vendor_name = vendor_name

    @property
    def product(self):
        """Gets the product of this ValidateResponseProductMetadata.  # noqa: E501


        :return: The product of this ValidateResponseProductMetadata.  # noqa: E501
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this ValidateResponseProductMetadata.


        :param product: The product of this ValidateResponseProductMetadata.  # noqa: E501
        :type: str
        """

        self._product = product

    @property
    def firewall_instance_id(self):
        """Gets the firewall_instance_id of this ValidateResponseProductMetadata.  # noqa: E501

        ID of the firewall instance the request is sent to.  # noqa: E501

        :return: The firewall_instance_id of this ValidateResponseProductMetadata.  # noqa: E501
        :rtype: str
        """
        return self._firewall_instance_id

    @firewall_instance_id.setter
    def firewall_instance_id(self, firewall_instance_id):
        """Sets the firewall_instance_id of this ValidateResponseProductMetadata.

        ID of the firewall instance the request is sent to.  # noqa: E501

        :param firewall_instance_id: The firewall_instance_id of this ValidateResponseProductMetadata.  # noqa: E501
        :type: str
        """

        self._firewall_instance_id = firewall_instance_id

    @property
    def version(self):
        """Gets the version of this ValidateResponseProductMetadata.  # noqa: E501

        Firewall semantic version.  # noqa: E501

        :return: The version of this ValidateResponseProductMetadata.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this ValidateResponseProductMetadata.

        Firewall semantic version.  # noqa: E501

        :param version: The version of this ValidateResponseProductMetadata.  # noqa: E501
        :type: str
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ValidateResponseProductMetadata, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ValidateResponseProductMetadata):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
