"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, NotRequired, TypedDict


class AccountUpdaterOptionsTypedDict(TypedDict):
    response_code: Nullable[Literal["updated"]]
    r"""The type of response to simulate."""
    account_number: NotRequired[Nullable[str]]
    r"""When the `response_code` is set to `updated`, the payment method's account number will be updated to this value."""
    expiration_month: NotRequired[Nullable[str]]
    r"""When the `response_code` is set to `updated`, the payment method's expiration month will be updated to this value."""
    expiration_year: NotRequired[Nullable[str]]
    r"""When the `response_code` is set to `updated`, the payment method's expiration year will be updated to this value."""
    error_code: NotRequired[Nullable[str]]
    r"""The type of error code to simulate."""


class AccountUpdaterOptions(BaseModel):
    RESPONSE_CODE: Annotated[
        Annotated[
            OptionalNullable[Literal["updated"]],
            AfterValidator(validate_const("updated")),
        ],
        pydantic.Field(alias="response_code"),
    ] = "updated"
    r"""The type of response to simulate."""

    account_number: OptionalNullable[str] = UNSET
    r"""When the `response_code` is set to `updated`, the payment method's account number will be updated to this value."""

    expiration_month: OptionalNullable[str] = UNSET
    r"""When the `response_code` is set to `updated`, the payment method's expiration month will be updated to this value."""

    expiration_year: OptionalNullable[str] = UNSET
    r"""When the `response_code` is set to `updated`, the payment method's expiration year will be updated to this value."""

    error_code: OptionalNullable[str] = UNSET
    r"""The type of error code to simulate."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "response_code",
            "account_number",
            "expiration_month",
            "expiration_year",
            "error_code",
        ]
        nullable_fields = [
            "response_code",
            "account_number",
            "expiration_month",
            "expiration_year",
            "error_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
