"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import date
from gr4vy.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Literal, Union
from typing_extensions import Annotated, NotRequired, TypedDict


AgeGroup = Union[
    Literal[
        "adult",
        "infant",
    ],
    UnrecognizedStr,
]


class AirlinePassengerTypedDict(TypedDict):
    age_group: NotRequired[Nullable[AgeGroup]]
    r"""The age group for the passenger."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The passenger's date of birth in YYYY-MM-YY format."""
    email_address: NotRequired[Nullable[str]]
    r"""The email address of the passenger."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name(s) or given name of the passenger."""
    frequent_flyer_number: NotRequired[Nullable[str]]
    r"""The passenger's frequent flyer number."""
    last_name: NotRequired[Nullable[str]]
    r"""The last name, or family name, of the passenger."""
    passport_number: NotRequired[Nullable[str]]
    r"""The passenger's unique passport number."""
    phone_number: NotRequired[Nullable[str]]
    r"""The phone number of the passenger. This number is formatted according to the E164 number standard."""
    ticket_number: NotRequired[Nullable[str]]
    r"""The ticket number for a flight."""
    title: NotRequired[Nullable[str]]
    r"""Title of the passenger."""
    country_code: NotRequired[Nullable[str]]
    r"""The country of residence of the passenger"""


class AirlinePassenger(BaseModel):
    age_group: Annotated[
        OptionalNullable[AgeGroup], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The age group for the passenger."""

    date_of_birth: OptionalNullable[date] = UNSET
    r"""The passenger's date of birth in YYYY-MM-YY format."""

    email_address: OptionalNullable[str] = UNSET
    r"""The email address of the passenger."""

    first_name: OptionalNullable[str] = UNSET
    r"""The first name(s) or given name of the passenger."""

    frequent_flyer_number: OptionalNullable[str] = UNSET
    r"""The passenger's frequent flyer number."""

    last_name: OptionalNullable[str] = UNSET
    r"""The last name, or family name, of the passenger."""

    passport_number: OptionalNullable[str] = UNSET
    r"""The passenger's unique passport number."""

    phone_number: OptionalNullable[str] = UNSET
    r"""The phone number of the passenger. This number is formatted according to the E164 number standard."""

    ticket_number: OptionalNullable[str] = UNSET
    r"""The ticket number for a flight."""

    title: OptionalNullable[str] = UNSET
    r"""Title of the passenger."""

    country_code: OptionalNullable[str] = UNSET
    r"""The country of residence of the passenger"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "age_group",
            "date_of_birth",
            "email_address",
            "first_name",
            "frequent_flyer_number",
            "last_name",
            "passport_number",
            "phone_number",
            "ticket_number",
            "title",
            "country_code",
        ]
        nullable_fields = [
            "age_group",
            "date_of_birth",
            "email_address",
            "first_name",
            "frequent_flyer_number",
            "last_name",
            "passport_number",
            "phone_number",
            "ticket_number",
            "title",
            "country_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
