"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .auditlogaction import AuditLogAction
from .auditlogentryresource import AuditLogEntryResource, AuditLogEntryResourceTypedDict
from .auditlogentryuser import AuditLogEntryUser, AuditLogEntryUserTypedDict
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AuditLogEntryTypedDict(TypedDict):
    resource: AuditLogEntryResourceTypedDict
    action: AuditLogAction
    user: AuditLogEntryUserTypedDict
    timestamp: datetime
    r"""The date and time that the action was performed."""
    type: Literal["audit-log"]
    r"""Always `audit-log`."""
    id: NotRequired[Nullable[str]]
    r"""The ID for the audit log entry."""
    merchant_account_id: NotRequired[Nullable[str]]
    r"""The ID of the merchant account this entry was created for."""


class AuditLogEntry(BaseModel):
    resource: AuditLogEntryResource

    action: Annotated[AuditLogAction, PlainValidator(validate_open_enum(False))]

    user: AuditLogEntryUser

    timestamp: datetime
    r"""The date and time that the action was performed."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["audit-log"]], AfterValidator(validate_const("audit-log"))
        ],
        pydantic.Field(alias="type"),
    ] = "audit-log"
    r"""Always `audit-log`."""

    id: OptionalNullable[str] = UNSET
    r"""The ID for the audit log entry."""

    merchant_account_id: OptionalNullable[str] = UNSET
    r"""The ID of the merchant account this entry was created for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type", "id", "merchant_account_id"]
        nullable_fields = ["id", "merchant_account_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
