"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Literal, Union
from typing_extensions import Annotated, NotRequired, TypedDict


UserDevice = Union[
    Literal[
        "desktop",
        "mobile",
    ],
    UnrecognizedStr,
]
r"""The platform that is being used to access the website."""


class BrowserInfoTypedDict(TypedDict):
    r"""Merchant provided browser info"""

    javascript_enabled: bool
    java_enabled: bool
    language: str
    color_depth: int
    screen_height: int
    screen_width: int
    time_zone_offset: int
    user_agent: str
    r"""Exact content of the HTTP user-agent header."""
    user_device: UserDevice
    r"""The platform that is being used to access the website."""
    accept_header: NotRequired[Nullable[str]]
    r"""The Accept header of the request from the buyer's browser."""


class BrowserInfo(BaseModel):
    r"""Merchant provided browser info"""

    javascript_enabled: bool

    java_enabled: bool

    language: str

    color_depth: int

    screen_height: int

    screen_width: int

    time_zone_offset: int

    user_agent: str
    r"""Exact content of the HTTP user-agent header."""

    user_device: Annotated[UserDevice, PlainValidator(validate_open_enum(False))]
    r"""The platform that is being used to access the website."""

    accept_header: OptionalNullable[str] = UNSET
    r"""The Accept header of the request from the buyer's browser."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["accept_header"]
        nullable_fields = ["accept_header"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
