"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Literal, Union
from typing_extensions import Annotated, NotRequired, TypedDict


ForterAntiFraudOptionsCartItemDeliveryDetailsDeliveryType = Union[
    Literal[
        "DIGITAL",
        "PHYSICAL",
        "HYBRID",
    ],
    UnrecognizedStr,
]


class ForterAntiFraudOptionsCartItemDeliveryDetailsTypedDict(TypedDict):
    delivery_type: NotRequired[
        Nullable[ForterAntiFraudOptionsCartItemDeliveryDetailsDeliveryType]
    ]
    r"""The type of delivery for this cart item."""
    delivery_method: NotRequired[Nullable[str]]
    r"""The method of delivery for this cart item."""


class ForterAntiFraudOptionsCartItemDeliveryDetails(BaseModel):
    delivery_type: Annotated[
        OptionalNullable[ForterAntiFraudOptionsCartItemDeliveryDetailsDeliveryType],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET
    r"""The type of delivery for this cart item."""

    delivery_method: OptionalNullable[str] = UNSET
    r"""The method of delivery for this cart item."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["delivery_type", "delivery_method"]
        nullable_fields = ["delivery_type", "delivery_method"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
