"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cancelstatus import CancelStatus
from .transaction import Transaction, TransactionTypedDict
from gr4vy.types import BaseModel, Nullable, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional
from typing_extensions import Annotated, TypedDict


class TransactionCancelTypedDict(TypedDict):
    status: CancelStatus
    code: Nullable[str]
    r"""The standardized error code set by Gr4vy."""
    raw_response_code: Nullable[str]
    r"""This is the response code received from the payment service. This can be set to any value and is not standardized across different payment services."""
    raw_response_description: Nullable[str]
    r"""This is the response description received from the payment service. This can be set to any value and is not standardized across different payment services."""
    transaction: TransactionTypedDict
    r"""A full transaction resource."""
    type: Literal["transaction-cancel"]
    r"""Always `transaction-cancel`."""


class TransactionCancel(BaseModel):
    status: Annotated[CancelStatus, PlainValidator(validate_open_enum(False))]

    code: Nullable[str]
    r"""The standardized error code set by Gr4vy."""

    raw_response_code: Nullable[str]
    r"""This is the response code received from the payment service. This can be set to any value and is not standardized across different payment services."""

    raw_response_description: Nullable[str]
    r"""This is the response description received from the payment service. This can be set to any value and is not standardized across different payment services."""

    transaction: Transaction
    r"""A full transaction resource."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["transaction-cancel"]],
            AfterValidator(validate_const("transaction-cancel")),
        ],
        pydantic.Field(alias="type"),
    ] = "transaction-cancel"
    r"""Always `transaction-cancel`."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type"]
        nullable_fields = ["code", "raw_response_code", "raw_response_description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
