# Code of Conduct

## Our Pledge

We as members, contributors, and leaders pledge to make participation in the n8n-deploy community a harassment-free experience for everyone, regardless of age, body size, visible or invisible disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, religion, or sexual identity and orientation.

We pledge to act and interact in ways that contribute to an open, welcoming, diverse, inclusive, and healthy community.

## Our Standards

### Positive Behavior

Examples of behavior that contributes to a positive environment:

- Demonstrating empathy and kindness toward others
- Being respectful of differing opinions, viewpoints, and experiences
- Giving and gracefully accepting constructive feedback
- Accepting responsibility and apologizing for mistakes
- Focusing on what is best for the overall community
- Using welcoming and inclusive language

### Unacceptable Behavior

Examples of unacceptable behavior include:

- The use of sexualized language or imagery, and sexual attention or advances
- Trolling, insulting or derogatory comments, and personal or political attacks
- Public or private harassment
- Publishing others' private information without explicit permission
- Conduct which could reasonably be considered inappropriate in a professional setting
- Dismissing or attacking inclusion-focused requests

## Engineering-Focused Communication

This is a technical project. We value:

- **Directness**: Clear, honest technical feedback
- **Objectivity**: Facts over emotions in technical discussions
- **Precision**: Accurate terminology and well-reasoned arguments
- **Respect**: Critique code and ideas, not people

Disagreement on technical approaches is healthy and encouraged. Personal attacks are not.

## Scope

This Code of Conduct applies within all project spaces, including:

- GitHub repository (issues, pull requests, discussions)
- Project documentation
- Official communication channels
- Events and meetups representing the project

It also applies when representing the project in public spaces.

## Enforcement

### Reporting

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported to the project maintainers at:

- **GitHub Issues**: For public technical disputes
- **Email**: [contact information to be added]

All reports will be reviewed and investigated promptly and fairly.

### Enforcement Guidelines

Project maintainers will follow these guidelines in determining consequences:

#### 1. Correction

**Community Impact**: Inappropriate language or unprofessional behavior.

**Consequence**: Private written warning with clarity around the violation and explanation of why the behavior was inappropriate. A public apology may be requested.

#### 2. Warning

**Community Impact**: A violation through a single incident or series of actions.

**Consequence**: Warning with consequences for continued behavior. No interaction with the people involved for a specified period. This includes avoiding project spaces and external channels. Violating these terms may lead to a temporary or permanent ban.

#### 3. Temporary Ban

**Community Impact**: Serious violation of community standards, including sustained inappropriate behavior.

**Consequence**: Temporary ban from any interaction or public communication with the community for a specified period. No public or private interaction with the people involved is allowed during this period. Violating these terms may lead to a permanent ban.

#### 4. Permanent Ban

**Community Impact**: Demonstrating a pattern of violation, sustained inappropriate behavior, harassment, or aggression toward individuals or groups.

**Consequence**: Permanent ban from any public interaction within the community.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant](https://www.contributor-covenant.org), version 2.1, available at <https://www.contributor-covenant.org/version/2/1/code_of_conduct.html>.

Community Impact Guidelines were inspired by [Mozilla's code of conduct enforcement ladder](https://github.com/mozilla/diversity).

## Questions

If you have questions about this Code of Conduct, please open an issue or contact the maintainers.

---

> "The best code is written with the understanding that someone else will need to maintain it." — Unknown

Remember: We're all here to build better tools and learn together. Treat others as you would want to be treated.
