from typing import Iterable, Union

import numpy as np
import numpy.typing as npt

import pmma.core.py_src.Utility as Utility
from pmma.build.NumberFormats import Color

Integer1D = Union[
    npt.NDArray[np.int32], # preferred
    npt.NDArray[np.int8],
    npt.NDArray[np.int16],
    npt.NDArray[np.int64],
    Iterable[int],
]

OptionalInteger = Union[
    int,
    None,
]

OptionalColor = Union[
    Color,
    None
]

OptionalBool = Union[
    bool,
    None
]

Float1D = Union[
    npt.NDArray[np.float32], # preferred
    npt.NDArray[np.float16],
    npt.NDArray[np.float64],
    Iterable[float]]

Numerical = Union[float, int]

NoneInt = Union[int, None]

class Display:
    def __init__(self, seed: OptionalInteger=None, octaves: int=2, lacunarity: float=0.75, gain: float=1.0) -> None: ...

    window_fill_color: Color

    def create(self, size: Integer1D=..., caption: str="PMMA Display", fullscreen: OptionalBool=True, resizable: bool=False, no_frame: bool=False, vsync: bool = True, icon: str="", centered: bool=True, maximized: bool=False, transparent: bool=False) -> None: ...

    def center_window(self) -> None: ...

    @Utility.require_render_thread
    def clear(self) -> None: ...

    def set_window_in_focus(self) -> None: ...
    def set_window_minimized(self, value: bool) -> None: ...
    def set_window_maximized(self, value: bool) -> None: ...
    def set_icon(self, icon_path: str) -> None: ...
    def set_caption(self, caption: str) -> None: ...
    def set_relative_window_position(self, position: Integer1D) -> None: ...
    def set_absolute_window_position(self, position: Integer1D) -> None: ...

    @Utility.require_render_thread
    def continuous_refresh(self,
        refresh_rate: int=60,
        lower_refresh_rate_on_minimize: bool=True,
        lower_refresh_rate_on_focus_loss: bool=True,
        lower_refresh_rate_on_low_battery: bool=True) -> None: ...

    @Utility.require_render_thread
    def event_refresh(self, refresh_rate: int=60,
        max_refresh_rate: int=60,
        lower_refresh_rate_on_minimize: bool=True,
        lower_refresh_rate_on_focus_loss: bool=True,
        lower_refresh_rate_on_low_battery: bool=True) -> None: ...

    def trigger_event_refresh(self) -> None: ...

    def get_caption(self) -> str: ...
    def get_center(self, object_size: Union[None, Integer1D]=None) -> Integer1D: ...
    def get_aspect_ratio(self) -> float: ...
    def get_frame_rate(self) -> int: ...
    def get_frame_time(self) -> float: ...
    def get_width(self) -> int: ...
    def get_height(self) -> int: ...
    def get_size(self) -> Integer1D: ...
    def get_msaa_samples(self) -> int: ...
    def get_current_monitor_refresh_rate(self) -> int: ...

    def toggle_full_screen(self) -> None: ...

    def is_window_in_focus(self) -> bool: ...
    def is_window_minimized(self) -> bool: ...
    def is_window_resizable(self) -> bool: ...
    def is_window_visible(self) -> bool: ...
    def is_window_always_on_top(self) -> bool: ...
    def is_window_auto_minimized(self) -> bool: ...
    def is_window_maximized(self) -> bool: ...
    def is_window_using_vsync(self) -> int: ...