from typing import Literal, Union, Tuple, Any, Callable

NoneFloat = Union[float, None]
NoneString = Union[str, None]

class General:
    @staticmethod
    def is_power_saving_mode_enabled() -> bool: ...

    @staticmethod
    def get_operating_system() -> Literal["windows", "linux", "macOS", "java", "android"]: ...

    @staticmethod
    def find_executable_nvidia_smi() -> str: ...

    @staticmethod
    def get_pmma_install_dir() -> str: ...

    @staticmethod
    def set_debug_mode(is_debug_mode: bool) -> None: ...

    @staticmethod
    def is_debug_mode_enabled() -> bool: ...

    @staticmethod
    def is_window_created() -> bool: ...

    @staticmethod
    def is_escape_key_to_close_window() -> bool: ...

    @staticmethod
    def set_escape_key_to_close_window(escape_key_to_close_window: bool) -> None: ...

    @staticmethod
    def is_f11_key_to_toggle_full_screen() -> bool: ...

    @staticmethod
    def set_f11_key_to_toggle_full_screen(f11_key_to_toggle_full_screen: bool) -> None: ...

    @staticmethod
    def is_application_running() -> None: ...

    @staticmethod
    def get_current_pmma_version() -> str: ...

    @staticmethod
    def get_latest_pmma_version() -> str: ...

    @staticmethod
    def is_update_available() -> bool: ...

    @staticmethod
    def get_application_start_time() -> float: ...

    @staticmethod
    def get_application_run_time() -> float: ...

    @staticmethod
    def get_shape_quality() -> float: ...

    @staticmethod
    def set_shape_quality(value: NoneFloat=None) -> None: ...

    @staticmethod
    def get_execution_time(function: Callable[..., Any], *args: Any, **kwargs: Any) -> Tuple[float, Any]: ...

    @staticmethod
    def get_execution_inverse_time(function: Callable[..., Any], *args: Any, **kwargs: Any) -> Tuple[float, Any]: ...

    @staticmethod
    def set_locale(locale: NoneString=None) -> None: ...

    @staticmethod
    def get_locale() -> str: ...

    @staticmethod
    def profile_start() -> None: ...

    @staticmethod
    def profile_end() -> None: ...