from typing import Iterable, Union

import numpy as np
import numpy.typing as npt

Numerical = Union[float, int]

Numerical1D = Union[
    npt.NDArray[np.float32], # preferred
    npt.NDArray[np.float16],
    npt.NDArray[np.float64],
    npt.NDArray[np.int32], # preferred
    npt.NDArray[np.int8],
    npt.NDArray[np.int16],
    npt.NDArray[np.int64],
    Iterable[float],  # preferred
    Iterable[int],  # preferred
]

class ButtonPressedEvent:
    def get_pressed(self) -> bool: ...
    def get_pressed_toggle(self) -> bool: ...
    def get_double_pressed(self) -> bool: ...
    def get_long_pressed(self) -> bool: ...

    def poll_long_pressed(self) -> bool: ...

    def get_repeat_press_duration(self) -> Numerical: ...
    def get_long_press_duration(self) -> Numerical: ...
    def get_double_press_duration(self) -> Numerical: ...

    def set_repeat_press_duration(self, duration: Numerical) -> None: ...
    def set_double_press_duration(self, duration: Numerical) -> None: ...
    def set_long_press_duration(self, duration: Numerical) -> None: ...

class MousePosition:
    def __init__(self) -> None: ...

    def get_position(self, using_numpy: bool=True) -> Numerical1D: ...

    def get_delta(self, using_numpy: bool=True) -> Numerical1D: ...
    def get_delta_toggle(self, using_numpy: bool=True) -> Numerical1D: ...

class MouseEnterWindow:
    def __init__(self) -> None: ...

    def get_entered(self) -> bool: ...
    def get_entered_toggle(self) -> bool: ...

class MouseButton_Left(ButtonPressedEvent):
    def __init__(self) -> None: ...

class MouseButton_Right(ButtonPressedEvent):
    def __init__(self) -> None: ...

class MouseButton_Middle(ButtonPressedEvent):
    def __init__(self) -> None: ...

class MouseButton_0(ButtonPressedEvent):
    def __init__(self) -> None: ...

class MouseButton_1(ButtonPressedEvent):
    def __init__(self) -> None: ...

class MouseButton_2(ButtonPressedEvent):
    def __init__(self) -> None: ...

class MouseButton_3(ButtonPressedEvent):
    def __init__(self) -> None: ...

class MouseButton_4(ButtonPressedEvent):
    def __init__(self) -> None: ...

class MouseScroll:
    def __init__(self) -> None: ...

    def get_position(self, using_numpy: bool=True) -> Numerical1D: ...
    def clear_position(self) -> None: ...
    def get_horizontal_position(self) -> Numerical: ...
    def get_vertical_position(self) -> Numerical: ...

    def get_delta(self, using_numpy: bool=True) -> Numerical1D: ...
    def get_horizontal_delta(self) -> Numerical: ...
    def get_vertical_delta(self) -> Numerical: ...

    def get_delta_toggle(self, using_numpy: bool=True) -> Numerical1D: ...
    def get_horizontal_delta_toggle(self) -> Numerical: ...
    def get_vertical_delta_toggle(self) -> Numerical: ...

    def get_enabled(self) -> bool: ...

    def set_enabled(self, value: bool) -> None: ...