from typing import Iterable, Union, Any

import numpy as np
import numpy.typing as npt

NPInteger1D = Union[
    npt.NDArray[np.int32], # preferred
    npt.NDArray[np.int8],
    npt.NDArray[np.int16],
    npt.NDArray[np.int64],
    Iterable[int],
]

NPFloat1D = Union[
    npt.NDArray[np.float32], # preferred
    npt.NDArray[np.float16],
    npt.NDArray[np.float64],
    Iterable[float]]

Integer1D = Union[
    Iterable[int],
]

Float1D = Union[
    Iterable[float]]

Numerical = Union[float, int]

NoneInt = Union[int, None]

class Color:
    def __init__(self) -> None: ...

    def configure(self, seed: NoneInt=None, octaves: int=2, lacunarity: float=0.75, gain: float=1.0) -> None: ...

    def get_seed(self) -> int: ...
    def get_octaves(self) -> int: ...
    def get_lacunarity(self) -> Numerical: ...
    def get_gain(self) -> Numerical: ...

    def get_set(self) -> bool: ...

    def generate_from_random(self, generate_alpha: bool=True) -> None: ...
    def generate_from_1D_perlin_noise(self, in_value: Numerical, generate_alpha: bool=True) -> None: ...
    def generate_from_2D_perlin_noise(self, in_value_one: Numerical, in_value_two: Numerical, generate_alpha: bool=True) -> None: ...
    def generate_from_3D_perlin_noise(self, in_value_one: Numerical, in_value_two: Numerical, in_value_three: Numerical, generate_alpha: bool=True) -> None: ...
    def generate_from_1D_fractal_brownian_motion(self, in_value: Numerical, generate_alpha: bool=True) -> None: ...
    def generate_from_2D_fractal_brownian_motion(self, in_value_one: Numerical, in_value_two: Numerical, generate_alpha: bool=True) -> None: ...
    def generate_from_3D_fractal_brownian_motion(self, in_value_one: Numerical, in_value_two: Numerical, in_value_three: Numerical, generate_alpha: bool=True) -> None: ...

    def set_RGBA_array(self, in_color: NPInteger1D) -> None: ...
    def set_rgba_array(self, in_color: NPFloat1D) -> None: ...
    def set_RGB_array(self, in_color: NPInteger1D) -> None: ...
    def set_rgb_array(self, in_color: NPFloat1D) -> None: ...
    def get_RGBA_array(self, detect_format: bool=True) -> NPInteger1D: ...
    def get_rgba_array(self, detect_format: bool=True) -> NPFloat1D: ...
    def get_RGB_array(self, detect_format: bool=True) -> NPInteger1D: ...
    def get_rgb_array(self, detect_format: bool=True) -> NPFloat1D: ...

    def set_RGBA(self, r: int, g: int, b: int, a: int) -> None: ...
    def set_rgba(self, r: float, g: float, b: float, a: float) -> None: ...
    def set_RGB(self, r: int, g: int, b: int, a: int) -> None: ...
    def set_rgb(self, r: float, g: float, b: float) -> None: ...
    def get_RGBA(self) -> Integer1D: ...
    def get_rgba(self) -> Float1D: ...
    def get_RGB(self) -> Integer1D: ...
    def get_rgb(self) -> Float1D: ...

class DisplayCoordinate:
    def __init__(self) -> None: ...

    def configure(self, seed: NoneInt=None, octaves: int=2, lacunarity: float=0.75, gain: float=1.0) -> None: ...

    def get_seed(self) -> int: ...
    def get_octaves(self) -> int: ...
    def get_lacunarity(self) -> Numerical: ...
    def get_gain(self) -> Numerical: ...
    def get_set(self) -> bool: ...

    def generate_from_random(self) -> None: ...
    def generate_from_1D_perlin_noise(self, in_value: Numerical) -> None: ...
    def generate_from_2D_perlin_noise(self, in_value_one: Numerical, in_value_two: Numerical) -> None: ...
    def generate_from_3D_perlin_noise(self, in_value_one: Numerical, in_value_two: Numerical, in_value_three: Numerical) -> None: ...
    def generate_from_1D_fractal_brownian_motion(self, in_value: Numerical) -> None: ...
    def generate_from_2D_fractal_brownian_motion(self, in_value_one: Numerical, in_value_two: Numerical) -> None: ...
    def generate_from_3D_fractal_brownian_motion(self, in_value_one: Numerical, in_value_two: Numerical, in_value_three: Numerical) -> None: ...

    def set_coord_array(self, in_coord: NPInteger1D) -> None: ...
    def get_coord_array(self, detect_format: bool=True) -> NPFloat1D: ...

    def set_coord(self, x: int, y: int) -> None: ...
    def get_coord(self) -> Float1D: ...

class Angle:
    def __init__(self) -> None: ...

    def configure(self, seed: NoneInt=None, octaves: int=2, lacunarity: float=0.75, gain: float=1.0) -> None: ...

    def get_seed(self) -> int: ...
    def get_octaves(self) -> int: ...
    def get_lacunarity(self) -> Numerical: ...
    def get_gain(self) -> Numerical: ...
    def get_set(self) -> bool: ...

    def generate_from_random(self) -> None: ...
    def generate_from_1D_perlin_noise(self, in_value: Numerical) -> None: ...
    def generate_from_2D_perlin_noise(self, in_value_one: Numerical, in_value_two: Numerical) -> None: ...
    def generate_from_3D_perlin_noise(self, in_value_one: Numerical, in_value_two: Numerical, in_value_three: Numerical) -> None: ...
    def generate_from_1D_fractal_brownian_motion(self, in_value: Numerical) -> None: ...
    def generate_from_2D_fractal_brownian_motion(self, in_value_one: Numerical, in_value_two: Numerical) -> None: ...
    def generate_from_3D_fractal_brownian_motion(self, in_value_one: Numerical, in_value_two: Numerical, in_value_three: Numerical) -> None: ...

    def set_degrees(self, value: Numerical) -> None: ...
    def set_radians(self, value: Numerical) -> None: ...

    def get_degrees(self) -> Numerical: ...
    def get_radians(self) -> Numerical: ...

class Proportion:
    def __init__(self) -> None: ...

    def configure(self, seed: NoneInt=None, octaves: int=2, lacunarity: float=0.75, gain: float=1.0) -> None: ...

    def get_seed(self) -> int: ...
    def get_octaves(self) -> int: ...
    def get_lacunarity(self) -> Numerical: ...
    def get_gain(self) -> Numerical: ...
    def get_set(self) -> bool: ...

    def generate_from_random(self) -> None: ...
    def generate_from_1D_perlin_noise(self, in_value: Numerical) -> None: ...
    def generate_from_2D_perlin_noise(self, in_value_one: Numerical, in_value_two: Numerical) -> None: ...
    def generate_from_3D_perlin_noise(self, in_value_one: Numerical, in_value_two: Numerical, in_value_three: Numerical) -> None: ...
    def generate_from_1D_fractal_brownian_motion(self, in_value: Numerical) -> None: ...
    def generate_from_2D_fractal_brownian_motion(self, in_value_one: Numerical, in_value_two: Numerical) -> None: ...
    def generate_from_3D_fractal_brownian_motion(self, in_value_one: Numerical, in_value_two: Numerical, in_value_three: Numerical) -> None: ...

    def set_percentage(self, value: Numerical) -> None: ...
    def set_decimal(self, value: Numerical) -> None: ...

    def get_percentage(self) -> Numerical: ...
    def get_decimal(self) -> Numerical: ...


class LinkedProportion(Proportion):
    def __init__(self, linked_class: Any, attr_name: str) -> None: ...