from typing import Iterable, Union

import numpy as np
import numpy.typing as npt

from pmma.build.NumberFormats import Color, DisplayCoordinate

Numerical1D = Union[
    npt.NDArray[np.float32], # preferred
    npt.NDArray[np.float16],
    npt.NDArray[np.float64],
    npt.NDArray[np.int32], # preferred
    npt.NDArray[np.int8],
    npt.NDArray[np.int16],
    npt.NDArray[np.int64],
    Iterable[float],  # preferred
    Iterable[int],  # preferred
]

Integer1D = Union[
    npt.NDArray[np.int32], # preferred
    npt.NDArray[np.int8],
    npt.NDArray[np.int16],
    npt.NDArray[np.int64],
    Iterable[int],
]

Integer2D = Union[
    npt.NDArray[np.int32], # preferred
    npt.NDArray[np.int8],
    npt.NDArray[np.int16],
    npt.NDArray[np.int64],
    Iterable[Iterable[int]],
]

Float1D = Union[
    npt.NDArray[np.float32], # preferred
    npt.NDArray[np.float16],
    npt.NDArray[np.float64],
    Iterable[float]]

Numerical = Union[
    float, int
]

NoneInt = Union[int, None]

class RadialPolygon:
    def __init__(self) -> None: ...

    shape_center: DisplayCoordinate
    shape_color: Color

    def render(self) -> None: ...

    def set_radius(self, radius: int) -> None: ...
    def set_point_count(self, point_count: int) -> None: ...
    def set_width(self, width: int) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...

    def get_radius(self) -> int: ...
    def get_point_count(self) -> int: ...
    def get_width(self) -> int: ...
    def get_rotation(self) -> Numerical: ...

class Rectangle:
    def __init__(self) -> None: ...

    shape_center: DisplayCoordinate
    shape_color: Color

    def render(self) -> None: ...

    def set_size(self, size: Integer1D) -> None: ...
    def set_corner_radius(self, radius: int) -> None: ...
    def set_width(self, width: int) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...

    def get_size(self) -> Integer1D: ...
    def get_corner_radius(self) -> int: ...
    def get_width(self) -> int: ...
    def get_rotation(self) -> Numerical: ...

class Pixel:
    def __init__(self) -> None: ...

    shape_center: DisplayCoordinate
    shape_color: Color

    def render(self) -> None: ...

class Line:
    def __init__(self) -> None: ...

    shape_color: Color
    shape_start: DisplayCoordinate
    shape_end: DisplayCoordinate

    def render(self) -> None: ...

    def set_width(self, width: int) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...

    def get_width(self) -> int: ...
    def get_rotation(self) -> Numerical: ...

class PolygonShape:
    def __init__(self) -> None: ...

    shape_color: Color

    def render(self) -> None: ...

    def set_points(self, points: Integer2D) -> None: ...
    def set_width(self, width: int) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...
    def set_closed(self, closed: bool) -> None: ...

    def get_points(self) -> Integer2D: ...
    def get_point_count(self) -> int: ...
    def get_width(self) -> int: ...
    def get_rotation(self) -> Numerical: ...
    def get_closed(self) -> bool: ...

class Arc:
    def __init__(self) -> None: ...

    shape_center: DisplayCoordinate
    shape_color: Color

    def render(self) -> None: ...

    def set_radius(self, radius: Numerical) -> None: ...
    def set_point_count(self, point_count: int) -> None: ...
    def set_width(self, width: Numerical) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...
    def set_start_angle(self, start_angle: Numerical) -> None: ...
    def set_end_angle(self, end_angle: Numerical) -> None: ...

    def get_radius(self) -> Numerical: ...
    def get_point_count(self) -> int: ...
    def get_width(self) -> Numerical: ...
    def get_rotation(self) -> Numerical: ...
    def get_start_angle(self) -> Numerical: ...
    def get_end_angle(self) -> Numerical: ...

class Ellipse:
    def __init__(self) -> None: ...

    shape_center: DisplayCoordinate
    shape_color: Color

    def render(self) -> None: ...

    def set_size(self, size: Integer1D) -> None: ...
    def set_point_count(self, point_count: int) -> None: ...
    def set_width(self, width: int) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...

    def get_size(self) -> Integer1D: ...
    def get_point_count(self) -> int: ...
    def get_width(self) -> int: ...
    def get_rotation(self) -> Numerical: ...

# Complex shapes

class Circle:
    def __init__(self) -> None: ...

    shape_center: DisplayCoordinate
    shape_color: Color

    def render(self) -> None: ...

    def set_radius(self, radius: int) -> None: ...
    def set_width(self, width: int) -> None: ...

class EquilateralTriangle:
    def __init__(self) -> None: ...

    shape_center: DisplayCoordinate
    shape_color: Color

    def render(self) -> None: ...

    def set_radius(self, radius: int) -> None: ...
    def set_width(self, width: int) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...

class RegularSquare:
    def __init__(self) -> None: ...

    shape_color: Color

    def render(self) -> None: ...

    def set_size(self, size: Numerical) -> None: ...
    def set_corner_radius(self, radius: int) -> None: ...
    def set_width(self, width: int) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...

class RegularPentagon:
    def __init__(self) -> None: ...

    shape_center: DisplayCoordinate
    shape_color: Color

    def render(self) -> None: ...

    def set_radius(self, radius: int) -> None: ...
    def set_width(self, width: int) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...

class RegularHexagon:
    def __init__(self) -> None: ...

    shape_center: DisplayCoordinate
    shape_color: Color

    def render(self) -> None: ...

    def set_radius(self, radius: int) -> None: ...
    def set_width(self, width: int) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...

class RegularHeptagon:
    def __init__(self) -> None: ...

    shape_center: DisplayCoordinate
    shape_color: Color

    def render(self) -> None: ...

    def set_radius(self, radius: int) -> None: ...
    def set_width(self, width: int) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...

class RegularOctagon:
    def __init__(self) -> None: ...

    shape_center: DisplayCoordinate
    shape_color: Color

    def render(self) -> None: ...

    def set_radius(self, radius: int) -> None: ...
    def set_width(self, width: int) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...

class RegularNonagon:
    def __init__(self) -> None: ...

    shape_center: DisplayCoordinate
    shape_color: Color

    def render(self) -> None: ...

    def set_radius(self, radius: int) -> None: ...
    def set_width(self, width: int) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...

class RegularDecagon:
    def __init__(self) -> None: ...

    shape_center: DisplayCoordinate
    shape_color: Color

    def render(self) -> None: ...

    def set_radius(self, radius: int) -> None: ...
    def set_width(self, width: int) -> None: ...
    def set_rotation(self, rotation: Numerical) -> None: ...