class Constants:
    HAT_NOT_PRESSED = "HAT NOT PRESSED"
    HAT_PRESSED_UP = "HAT PRESSED UP"
    HAT_PRESSED_RIGHT = "HAT PRESSED RIGHT"
    HAT_PRESSED_DOWN = "HAT PRESSED DOWN"
    HAT_PRESSED_LEFT = "HAT PRESSED LEFT"
    HAT_PRESSED_UP_RIGHT = "HAT PRESSED UP-RIGHT"
    HAT_PRESSED_DOWN_RIGHT = "HAT PRESSED DOWN-RIGHT"
    HAT_PRESSED_DOWN_LEFT = "HAT PRESSED DOWN-LEFT"
    HAT_PRESSED_UP_LEFT = "HAT PRESSED UP-LEFT"

    DECIMAL = "decimal"
    PERCENTAGE = "percentage"

    VALUE = "value"
    UPDATING = "updating"
    MANUALLY_SET = "manually_set"

    WINDOWS = "windows"
    LINUX = "linux"
    MACOS = "macOS"
    JAVA = "java"
    ANDROID = "android"

    TKINTER_STYLE_BUTTON = "TButton"
    TKINTER_STYLE_CHECKBUTTON = "TCheckbutton"
    TKINTER_STYLE_COMBOBOX = "TCombobox"
    TKINTER_STYLE_ENTRY = "TEntry"
    TKINTER_STYLE_FRAME = "TFrame"
    TKINTER_STYLE_LABEL = "TLabel"
    TKINTER_STYLE_LABELFRAME = "TLabelFrame"
    TKINTER_STYLE_MENUBUTTON = "TMenubutton"
    TKINTER_STYLE_NOTEBOOK = "TNotebook"
    TKINTER_STYLE_PANEDWINDOW = "TPanedwindow"
    TKINTER_STYLE_HORIZONTAL_PROGRESSBAR = "Horizontal.TProgressbar"
    TKINTER_STYLE_VERTICAL_PROGRESSBAR = "Vertical.TProgressbar"
    TKINTER_STYLE_RADIOBUTTON = "TRadiobutton"
    TKINTER_STYLE_HORIZONTAL_SCALE = "Horizontal.TScale"
    TKINTER_STYLE_VERTICAL_SCALE = "Vertical.TScale"
    TKINTER_STYLE_HORIZONTAL_SCROLLBAR = "Horizontal.TScrollbar"
    TKINTER_STYLE_VERTICAL_SCROLLBAR = "Vertical.TScrollbar"
    TKINTER_STYLE_SEPARATOR = "TSeparator"
    TKINTER_STYLE_SIZEGRIP = "TSizegrip"
    TKINTER_STYLE_TREEVIEW = "Treeview"

class InternalConstants:
    DATA_COLLECTION_METHODS = "data_collection_methods"

    SMI = "smi"
    WMI = "wmi"
    PYADL = "pyadl"

    CREATE_NO_WINDOW = 0x08000000

    TKINTER_STYLES = [
        Constants.TKINTER_STYLE_BUTTON,
        Constants.TKINTER_STYLE_CHECKBUTTON,
        Constants.TKINTER_STYLE_COMBOBOX,
        Constants.TKINTER_STYLE_ENTRY,
        Constants.TKINTER_STYLE_FRAME,
        Constants.TKINTER_STYLE_LABEL,
        Constants.TKINTER_STYLE_LABELFRAME,
        Constants.TKINTER_STYLE_MENUBUTTON,
        Constants.TKINTER_STYLE_NOTEBOOK,
        Constants.TKINTER_STYLE_PANEDWINDOW,
        Constants.TKINTER_STYLE_HORIZONTAL_PROGRESSBAR,
        Constants.TKINTER_STYLE_VERTICAL_PROGRESSBAR,
        Constants.TKINTER_STYLE_RADIOBUTTON,
        Constants.TKINTER_STYLE_HORIZONTAL_SCALE,
        Constants.TKINTER_STYLE_VERTICAL_SCALE,
        Constants.TKINTER_STYLE_HORIZONTAL_SCROLLBAR,
        Constants.TKINTER_STYLE_VERTICAL_SCROLLBAR,
        Constants.TKINTER_STYLE_SEPARATOR,
        Constants.TKINTER_STYLE_SIZEGRIP,
        Constants.TKINTER_STYLE_TREEVIEW
    ]

    SECONDS_PER_MINUTE = 60
    SECONDS_PER_HOUR = SECONDS_PER_MINUTE * 60
    SECONDS_PER_DAY = SECONDS_PER_HOUR * 24
    DAYS_PER_YEAR = 365.25  # accounting for leap years
    DAYS_PER_MONTH = DAYS_PER_YEAR / 12
    HOURS_PER_DAY = 24
    MINUTES_PER_HOUR = 60
    MICROSECONDS_PER_SECOND = 1e6