import numpy
from typing import Union, Any, Iterable

NoneInt = Union[int, None]
NumpyInt = Union[
    numpy.int32, # Preferred
    int, # Preferred
    numpy.int64,
    numpy.int16,
    numpy.int8,
]

class Stack:
    def __init__(self, max_size: NoneInt=None) -> None: ...
    def push(self, item: Any) -> None: ...
    def clear(self) -> None: ...

    def pop(self) -> Any: ...
    def peek(self) -> Any: ...

    def is_empty(self) -> bool: ...
    def is_full(self) -> bool: ...
    def changed(self) -> bool: ...

    def size(self) -> int: ...

class Queue:
    def __init__(self, max_size: NoneInt=None) -> None: ...
    def enqueue(self, item: Any) -> None: ...
    def clear(self) -> None: ...

    def dequeue(self) -> Any: ...
    def peek(self) -> Any: ...

    def is_empty(self) -> bool: ...
    def is_full(self) -> bool: ...
    def changed(self) -> bool: ...

    def size(self) -> int: ...

class CircularQueue:
    def __init__(self, size: int) -> None: ...
    def clear(self) -> None: ...
    def enqueue(self, item: Any) -> None: ...

    def dequeue(self) -> Any: ...
    def peek(self) -> Any: ...

    def size(self) -> int: ...

    def is_empty(self) -> bool: ...
    def is_full(self) -> bool: ...
    def changed(self) -> bool: ...

class PriorityQueue:
    def __init__(self) -> None: ...
    def enqueue(self, item: Any, priority: NumpyInt) -> None: ...
    def clear(self) -> None: ...

    def dequeue(self) -> Any: ...
    def peek(self) -> Any: ...

    def peek_next_priority(self) -> NumpyInt: ...
    def size(self) -> int: ...

    def is_empty(self) -> bool: ...
    def changed(self) -> bool: ...

class InvertedPriorityQueue:
    def __init__(self) -> None: ...
    def enqueue(self, item: Any, priority: NumpyInt) -> None: ...
    def clear(self) -> None: ...

    def dequeue(self) -> Any: ...
    def peek(self) -> Any: ...

    def peek_next_priority(self) -> NumpyInt: ...
    def size(self) -> int: ...

    def is_empty(self) -> bool: ...
    def changed(self) -> bool: ...

class PriorityList:
    def __init__(self) -> None: ...
    def add(self, item: Any, priority: NumpyInt) -> None: ...
    def remove_item(self, item: Any) -> None: ...
    def clear(self) -> None: ...
    def update_priority(self, item: Any, new_priority: NumpyInt) -> None: ...

    def remove_highest_priority(self) -> Iterable[Any]: ...

    def peek(self) -> Any: ...

    def peek_next_priority(self) -> NumpyInt: ...
    def size(self) -> int: ...

    def is_empty(self) -> bool: ...
    def changed(self) -> bool: ...

class InvertedPriorityList:
    def __init__(self) -> None: ...
    def add(self, item: Any, priority: NumpyInt) -> None: ...
    def update_priority(self, item: Any, new_priority: NumpyInt) -> None: ...
    def remove_item(self, item: Any) -> None: ...
    def clear(self) -> None: ...

    def remove_highest_priority(self) -> Iterable[Any]: ...

    def peek(self) -> Any: ...

    def peek_next_priority(self) -> NumpyInt: ...
    def size(self) -> int: ...

    def is_empty(self) -> bool: ...
    def changed(self) -> bool: ...