from typing import Iterable, Union

class GPUs:
    def __init__(self) -> None: ...

    def identify_gpus(self) -> None: ...

    def get_gpu(self, gpu_index: int) -> GPU: ...

    def all_gpus_are_unique(self) -> bool: ...

class GPU:
    def __init__(self, module_identification_indices: int) -> None: ...

    def update(self, everything: bool=False, data_points: Union[Iterable[str], None]=None, wait_for_completion: bool=False) -> None: ...

    def get_accelerator_capabilities(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_accounting_mode_enabled(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_accounting_mode_buffer_size(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_adapter_compatibility(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_adapter_DAC_type(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_adapter_id(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_adapter_index(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_addressing_mode(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_availability(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_capability_descriptions(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_caption(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_chip_to_chip_interconnect_mode(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_clock_event_reasons_as_bitmap(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_clock_event_reasons_application_setting(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_clock_event_reasons_is_hardware_limited(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_clock_event_reasons_gpu_idle_limited(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_clock_event_reasons_software_power_limited(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_clock_event_reasons_software_thermal_limited(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_clock_event_reasons_power_break_slowdown_limited(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_clock_event_reasons_supported(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_clock_event_reasons_sync_boost(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_clock_event_reasons_thermal_limited(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_color_table_entries(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_compute_cap(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_compute_mode(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_config_manager_error_code(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_config_manager_user_config(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_core_voltage(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_core_voltage_range(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_creation_class_name(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_current_bits_per_pixel(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_current_horizontal_resolution(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_current_number_of_colors(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_current_number_of_columns(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_current_number_of_rows(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_current_refresh_rate(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_current_scan_mode(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_current_vertical_resolution(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_description(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_device_id(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_device_specific_pens(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_display_active(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_display_mode(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_dither_type(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_driver_date(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_driver_model_current(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_driver_model_pending(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_driver_version(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_all_time_in_cbu(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_all_time_in_primary_cache(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_all_time_in_register_file(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_all_time_in_secondary_cache(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_all_time_in_shared_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_all_time_in_sram(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_all_time_in_texture_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_all_time_in_total(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_all_time_in_video_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_since_reboot_in_cbu(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_since_reboot_in_primary_cache(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_since_reboot_in_register_file(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_since_reboot_in_secondary_cache(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_since_reboot_in_shared_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_since_reboot_in_sram(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_since_reboot_in_texture_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_since_reboot_in_total(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_corrected_since_reboot_in_video_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_all_time_in_cbu(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_all_time_in_primary_cache(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_all_time_in_register_file(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_all_time_in_secondary_cache(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_all_time_in_shared_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_all_time_in_sram(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_all_time_in_texture_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_all_time_in_total(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_all_time_in_video_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_since_reboot_in_cbu(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_since_reboot_in_primary_cache(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_since_reboot_in_register_file(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_since_reboot_in_secondary_cache(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_since_reboot_in_shared_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_since_reboot_in_sram(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_since_reboot_in_texture_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_since_reboot_in_total(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_errors_uncorrected_since_reboot_in_video_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_mode_current(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ecc_mode_pending(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_encoder_average_FPS(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_encoder_average_latency(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_encoder_session_count(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_engine_clock_range(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_error_cleared(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_error_description(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_fabric_state(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_fabric_status(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_fan_speed_percentage(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_fan_speed_percentage_range(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_fan_speed_RPM(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_fan_speed_RPM_range(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_fractional_multi_vGPU(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_frequency_application_default_shader_clock(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_frequency_application_default_memory_clock(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_frequency_application_memory_clock(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_frequency_application_shader_clock(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_frequency_maximum_memory_clock(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_frequency_maximum_shader_clock(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_frequency_maximum_streaming_multiprocessor_clock(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_frequency_memory_clock(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_frequency_shader_clock(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_frequency_streaming_multiprocessor_clock(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_frequency_video_clock(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_heterogenous_multi_vGPU(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_heterogenous_time_slice_profile(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_heterogenous_time_slice_sizes(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ICM_indent(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_ICM_method(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_inf_filename(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_inf_section(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_info_ROM_ecc(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_info_ROM_oem(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_info_ROM_power(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_info_ROM_version(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_install_date(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_installed_display_drivers(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_last_error_code(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_max_memory_supported(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_max_number_controlled(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_max_refresh_rate(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_memory_clock_range(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_memory_free(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_memory_reserved(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_memory_total(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_memory_used(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_min_refresh_rate(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_monochrome(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_multi_instance_GPU_mode_current(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_multi_instance_GPU_mode_pending(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_name(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_number_of_color_planes(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_number_of_video_pages(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_operating_mode_current(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_operating_mode_pending(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_pci_bus(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_pci_bus_id(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_pci_device(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_pci_device_id(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_pci_domain(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_pci_link_generation_current(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_pci_link_generation_device_host_maximum(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_pci_link_generation_gpu_maximum(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_pci_link_generation_maximum(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_pci_link_width_current(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_pci_link_width_maximum(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_pci_sub_device_id(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_persistence_mode(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_PNP_device_id(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_power_draw(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_power_draw_average(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_power_draw_default_limit(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_power_draw_enforced_limit(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_power_draw_instant(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_power_draw_limit(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_power_draw_maximum(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_power_draw_minimum(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_power_management_capabilities(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_power_management_supported(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_protected_memory_free(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_protected_memory_total(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_protected_memory_used(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_protocol_supported(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_performance_state(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_retired_pages_double_bit_ecc_errors_count(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_retired_pages_single_bit_ecc_errors_count(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_retired_pages_pending(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_reserved_system_palette_entries(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_reset_required(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_reset_and_drain_recommended(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_serial(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_specification_version(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_status(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_status_info(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_system_creation_class_name(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_system_name(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_system_palette_entries(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_GPU_system_processor_mode_current(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_GPU_system_processor_mode_default(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_temperature_core(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_temperature_core_limit(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_temperature_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_time_of_last_reset(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_utilization_decoder(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_utilization_encoder(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_utilization_gpu(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_utilization_jpeg(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_utilization_memory(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_utilization_optical_flow(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_uuid(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_vbios_version(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_video_architecture(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_video_memory_type(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_video_mode(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_video_mode_description(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def get_video_processor(self, update: bool=False, wait_for_completion: bool=False) -> str: ...

    def set_accelerator_capabilities(self, value: Union[str, None]=None) -> None: ...

    def set_accounting_mode_enabled(self, value: Union[str, None]=None) -> None: ...

    def set_accounting_mode_buffer_size(self, value: Union[str, None]=None) -> None: ...

    def set_adapter_compatibility(self, value: Union[str, None]=None) -> None: ...

    def set_adapter_DAC_type(self, value: Union[str, None]=None) -> None: ...

    def set_adapter_id(self, value: Union[str, None]=None) -> None: ...

    def set_adapter_index(self, value: Union[str, None]=None) -> None: ...

    def set_addressing_mode(self, value: Union[str, None]=None) -> None: ...

    def set_availability(self, value: Union[str, None]=None) -> None: ...

    def set_capability_descriptions(self, value: Union[str, None]=None) -> None: ...

    def set_caption(self, value: Union[str, None]=None) -> None: ...

    def set_chip_to_chip_interconnect_mode(self, value: Union[str, None]=None) -> None: ...

    def set_clock_event_reasons_as_bitmap(self, value: Union[str, None]=None) -> None: ...

    def set_clock_event_reasons_application_setting(self, value: Union[str, None]=None) -> None: ...

    def set_clock_event_reasons_is_hardware_limited(self, value: Union[str, None]=None) -> None: ...

    def set_clock_event_reasons_gpu_idle_limited(self, value: Union[str, None]=None) -> None: ...

    def set_clock_event_reasons_software_power_limited(self, value: Union[str, None]=None) -> None: ...

    def set_clock_event_reasons_software_thermal_limited(self, value: Union[str, None]=None) -> None: ...

    def set_clock_event_reasons_power_break_slowdown_limited(self, value: Union[str, None]=None) -> None: ...

    def set_clock_event_reasons_supported(self, value: Union[str, None]=None) -> None: ...

    def set_clock_event_reasons_sync_boost(self, value: Union[str, None]=None) -> None: ...

    def set_clock_event_reasons_thermal_limited(self, value: Union[str, None]=None) -> None: ...

    def set_color_table_entries(self, value: Union[str, None]=None) -> None: ...

    def set_compute_cap(self, value: Union[str, None]=None) -> None: ...

    def set_compute_mode(self, value: Union[str, None]=None) -> None: ...

    def set_config_manager_error_code(self, value: Union[str, None]=None) -> None: ...

    def set_config_manager_user_config(self, value: Union[str, None]=None) -> None: ...

    def set_core_voltage(self, value: Union[str, None]=None) -> None: ...

    def set_core_voltage_range(self, value: Union[str, None]=None) -> None: ...

    def set_creation_class_name(self, value: Union[str, None]=None) -> None: ...

    def set_current_bits_per_pixel(self, value: Union[str, None]=None) -> None: ...

    def set_current_horizontal_resolution(self, value: Union[str, None]=None) -> None: ...

    def set_current_number_of_colors(self, value: Union[str, None]=None) -> None: ...

    def set_current_number_of_columns(self, value: Union[str, None]=None) -> None: ...

    def set_current_number_of_rows(self, value: Union[str, None]=None) -> None: ...

    def set_current_refresh_rate(self, value: Union[str, None]=None) -> None: ...

    def set_current_scan_mode(self, value: Union[str, None]=None) -> None: ...

    def set_current_vertical_resolution(self, value: Union[str, None]=None) -> None: ...

    def set_description(self, value: Union[str, None]=None) -> None: ...

    def set_device_id(self, value: Union[str, None]=None) -> None: ...

    def set_device_specific_pens(self, value: Union[str, None]=None) -> None: ...

    def set_display_active(self, value: Union[str, None]=None) -> None: ...

    def set_display_mode(self, value: Union[str, None]=None) -> None: ...

    def set_dither_type(self, value: Union[str, None]=None) -> None: ...

    def set_driver_date(self, value: Union[str, None]=None) -> None: ...

    def set_driver_model_current(self, value: Union[str, None]=None) -> None: ...

    def set_driver_model_pending(self, value: Union[str, None]=None) -> None: ...

    def set_driver_version(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_all_time_in_cbu(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_all_time_in_primary_cache(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_all_time_in_register_file(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_all_time_in_secondary_cache(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_all_time_in_shared_memory(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_all_time_in_sram(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_all_time_in_texture_memory(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_all_time_in_total(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_all_time_in_video_memory(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_since_reboot_in_cbu(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_since_reboot_in_primary_cache(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_since_reboot_in_register_file(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_since_reboot_in_secondary_cache(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_since_reboot_in_shared_memory(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_since_reboot_in_sram(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_since_reboot_in_texture_memory(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_since_reboot_in_total(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_corrected_since_reboot_in_video_memory(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_all_time_in_cbu(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_all_time_in_primary_cache(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_all_time_in_register_file(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_all_time_in_secondary_cache(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_all_time_in_shared_memory(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_all_time_in_sram(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_all_time_in_texture_memory(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_all_time_in_total(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_all_time_in_video_memory(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_since_reboot_in_cbu(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_since_reboot_in_primary_cache(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_since_reboot_in_register_file(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_since_reboot_in_secondary_cache(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_since_reboot_in_shared_memory(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_since_reboot_in_sram(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_since_reboot_in_texture_memory(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_since_reboot_in_total(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_errors_uncorrected_since_reboot_in_video_memory(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_mode_current(self, value: Union[str, None]=None) -> None: ...

    def set_ecc_mode_pending(self, value: Union[str, None]=None) -> None: ...

    def set_encoder_average_FPS(self, value: Union[str, None]=None) -> None: ...

    def set_encoder_average_latency(self, value: Union[str, None]=None) -> None: ...

    def set_encoder_session_count(self, value: Union[str, None]=None) -> None: ...

    def set_engine_clock_range(self, value: Union[str, None]=None) -> None: ...

    def set_error_cleared(self, value: Union[str, None]=None) -> None: ...

    def set_error_description(self, value: Union[str, None]=None) -> None: ...

    def set_fabric_state(self, value: Union[str, None]=None) -> None: ...

    def set_fabric_status(self, value: Union[str, None]=None) -> None: ...

    def set_fan_speed_percentage(self, value: Union[str, None]=None) -> None: ...

    def set_fan_speed_percentage_range(self, value: Union[str, None]=None) -> None: ...

    def set_fan_speed_RPM(self, value: Union[str, None]=None) -> None: ...

    def set_fan_speed_RPM_range(self, value: Union[str, None]=None) -> None: ...

    def set_fractional_multi_vGPU(self, value: Union[str, None]=None) -> None: ...

    def set_frequency_application_default_shader_clock(self, value: Union[str, None]=None) -> None: ...

    def set_frequency_application_default_memory_clock(self, value: Union[str, None]=None) -> None: ...

    def set_frequency_application_memory_clock(self, value: Union[str, None]=None) -> None: ...

    def set_frequency_application_shader_clock(self, value: Union[str, None]=None) -> None: ...

    def set_frequency_maximum_memory_clock(self, value: Union[str, None]=None) -> None: ...

    def set_frequency_maximum_shader_clock(self, value: Union[str, None]=None) -> None: ...

    def set_frequency_maximum_streaming_multiprocessor_clock(self, value: Union[str, None]=None) -> None: ...

    def set_frequency_memory_clock(self, value: Union[str, None]=None) -> None: ...

    def set_frequency_shader_clock(self, value: Union[str, None]=None) -> None: ...

    def set_frequency_streaming_multiprocessor_clock(self, value: Union[str, None]=None) -> None: ...

    def set_frequency_video_clock(self, value: Union[str, None]=None) -> None: ...

    def set_heterogenous_multi_vGPU(self, value: Union[str, None]=None) -> None: ...

    def set_heterogenous_time_slice_profile(self, value: Union[str, None]=None) -> None: ...

    def set_heterogenous_time_slice_sizes(self, value: Union[str, None]=None) -> None: ...

    def set_ICM_indent(self, value: Union[str, None]=None) -> None: ...

    def set_ICM_method(self, value: Union[str, None]=None) -> None: ...

    def set_inf_filename(self, value: Union[str, None]=None) -> None: ...

    def set_inf_section(self, value: Union[str, None]=None) -> None: ...

    def set_info_ROM_ecc(self, value: Union[str, None]=None) -> None: ...

    def set_info_ROM_oem(self, value: Union[str, None]=None) -> None: ...

    def set_info_ROM_power(self, value: Union[str, None]=None) -> None: ...

    def set_info_ROM_version(self, value: Union[str, None]=None) -> None: ...

    def set_install_date(self, value: Union[str, None]=None) -> None: ...

    def set_installed_display_drivers(self, value: Union[str, None]=None) -> None: ...

    def set_last_error_code(self, value: Union[str, None]=None) -> None: ...

    def set_max_memory_supported(self, value: Union[str, None]=None) -> None: ...

    def set_max_number_controlled(self, value: Union[str, None]=None) -> None: ...

    def set_max_refresh_rate(self, value: Union[str, None]=None) -> None: ...

    def set_memory_clock_range(self, value: Union[str, None]=None) -> None: ...

    def set_memory_free(self, value: Union[str, None]=None) -> None: ...

    def set_memory_reserved(self, value: Union[str, None]=None) -> None: ...

    def set_memory_total(self, value: Union[str, None]=None) -> None: ...

    def set_memory_used(self, value: Union[str, None]=None) -> None: ...

    def set_min_refresh_rate(self, value: Union[str, None]=None) -> None: ...

    def set_monochrome(self, value: Union[str, None]=None) -> None: ...

    def set_multi_instance_GPU_mode_current(self, value: Union[str, None]=None) -> None: ...

    def set_multi_instance_GPU_mode_pending(self, value: Union[str, None]=None) -> None: ...

    def set_name(self, value: Union[str, None]=None) -> None: ...

    def set_number_of_color_planes(self, value: Union[str, None]=None) -> None: ...

    def set_number_of_video_pages(self, value: Union[str, None]=None) -> None: ...

    def set_operating_mode_current(self, value: Union[str, None]=None) -> None: ...

    def set_operating_mode_pending(self, value: Union[str, None]=None) -> None: ...

    def set_pci_bus(self, value: Union[str, None]=None) -> None: ...

    def set_pci_bus_id(self, value: Union[str, None]=None) -> None: ...

    def set_pci_device(self, value: Union[str, None]=None) -> None: ...

    def set_pci_device_id(self, value: Union[str, None]=None) -> None: ...

    def set_pci_domain(self, value: Union[str, None]=None) -> None: ...

    def set_pci_link_generation_current(self, value: Union[str, None]=None) -> None: ...

    def set_pci_link_generation_device_host_maximum(self, value: Union[str, None]=None) -> None: ...

    def set_pci_link_generation_gpu_maximum(self, value: Union[str, None]=None) -> None: ...

    def set_pci_link_generation_maximum(self, value: Union[str, None]=None) -> None: ...

    def set_pci_link_width_current(self, value: Union[str, None]=None) -> None: ...

    def set_pci_link_width_maximum(self, value: Union[str, None]=None) -> None: ...

    def set_pci_sub_device_id(self, value: Union[str, None]=None) -> None: ...

    def set_persistence_mode(self, value: Union[str, None]=None) -> None: ...

    def set_PNP_device_id(self, value: Union[str, None]=None) -> None: ...

    def set_power_draw(self, value: Union[str, None]=None) -> None: ...

    def set_power_draw_average(self, value: Union[str, None]=None) -> None: ...

    def set_power_draw_default_limit(self, value: Union[str, None]=None) -> None: ...

    def set_power_draw_enforced_limit(self, value: Union[str, None]=None) -> None: ...

    def set_power_draw_instant(self, value: Union[str, None]=None) -> None: ...

    def set_power_draw_limit(self, value: Union[str, None]=None) -> None: ...

    def set_power_draw_maximum(self, value: Union[str, None]=None) -> None: ...

    def set_power_draw_minimum(self, value: Union[str, None]=None) -> None: ...

    def set_power_management_capabilities(self, value: Union[str, None]=None) -> None: ...

    def set_power_management_supported(self, value: Union[str, None]=None) -> None: ...

    def set_protected_memory_free(self, value: Union[str, None]=None) -> None: ...

    def set_protected_memory_total(self, value: Union[str, None]=None) -> None: ...

    def set_protected_memory_used(self, value: Union[str, None]=None) -> None: ...

    def set_protocol_supported(self, value: Union[str, None]=None) -> None: ...

    def set_performance_state(self, value: Union[str, None]=None) -> None: ...

    def set_retired_pages_double_bit_ecc_errors_count(self, value: Union[str, None]=None) -> None: ...

    def set_retired_pages_single_bit_ecc_errors_count(self, value: Union[str, None]=None) -> None: ...

    def set_retired_pages_pending(self, value: Union[str, None]=None) -> None: ...

    def set_reserved_system_palette_entries(self, value: Union[str, None]=None) -> None: ...

    def set_reset_required(self, value: Union[str, None]=None) -> None: ...

    def set_reset_and_drain_recommended(self, value: Union[str, None]=None) -> None: ...

    def set_serial(self, value: Union[str, None]=None) -> None: ...

    def set_specification_version(self, value: Union[str, None]=None) -> None: ...

    def set_status(self, value: Union[str, None]=None) -> None: ...

    def set_status_info(self, value: Union[str, None]=None) -> None: ...

    def set_system_creation_class_name(self, value: Union[str, None]=None) -> None: ...

    def set_system_name(self, value: Union[str, None]=None) -> None: ...

    def set_system_palette_entries(self, value: Union[str, None]=None) -> None: ...

    def set_GPU_system_processor_mode_current(self, value: Union[str, None]=None) -> None: ...

    def set_GPU_system_processor_mode_default(self, value: Union[str, None]=None) -> None: ...

    def set_temperature_core(self, value: Union[str, None]=None) -> None: ...

    def set_temperature_core_limit(self, value: Union[str, None]=None) -> None: ...

    def set_temperature_memory(self, value: Union[str, None]=None) -> None: ...

    def set_time_of_last_reset(self, value: Union[str, None]=None) -> None: ...

    def set_utilization_decoder(self, value: Union[str, None]=None) -> None: ...

    def set_utilization_encoder(self, value: Union[str, None]=None) -> None: ...

    def set_utilization_gpu(self, value: Union[str, None]=None) -> None: ...

    def set_utilization_jpeg(self, value: Union[str, None]=None) -> None: ...

    def set_utilization_memory(self, value: Union[str, None]=None) -> None: ...

    def set_utilization_optical_flow(self, value: Union[str, None]=None) -> None: ...

    def set_uuid(self, value: Union[str, None]=None) -> None: ...

    def set_vbios_version(self, value: Union[str, None]=None) -> None: ...

    def set_video_architecture(self, value: Union[str, None]=None) -> None: ...

    def set_video_memory_type(self, value: Union[str, None]=None) -> None: ...

    def set_video_mode(self, value: Union[str, None]=None) -> None: ...

    def set_video_mode_description(self, value: Union[str, None]=None) -> None: ...

    def set_video_processor(self, value: Union[str, None]=None) -> None: ...

    def update_accelerator_capabilities(self, wait_for_completion: bool=True) -> None: ...

    def update_accounting_mode_enabled(self, wait_for_completion: bool=True) -> None: ...

    def update_accounting_mode_buffer_size(self, wait_for_completion: bool=True) -> None: ...

    def update_adapter_compatibility(self, wait_for_completion: bool=True) -> None: ...

    def update_adapter_DAC_type(self, wait_for_completion: bool=True) -> None: ...

    def update_adapter_id(self, wait_for_completion: bool=True) -> None: ...

    def update_adapter_index(self, wait_for_completion: bool=True) -> None: ...

    def update_addressing_mode(self, wait_for_completion: bool=True) -> None: ...

    def update_availability(self, wait_for_completion: bool=True) -> None: ...

    def update_capability_descriptions(self, wait_for_completion: bool=True) -> None: ...

    def update_caption(self, wait_for_completion: bool=True) -> None: ...

    def update_chip_to_chip_interconnect_mode(self, wait_for_completion: bool=True) -> None: ...

    def update_clock_event_reasons_as_bitmap(self, wait_for_completion: bool=True) -> None: ...

    def update_clock_event_reasons_application_setting(self, wait_for_completion: bool=True) -> None: ...

    def update_clock_event_reasons_is_hardware_limited(self, wait_for_completion: bool=True) -> None: ...

    def update_clock_event_reasons_gpu_idle_limited(self, wait_for_completion: bool=True) -> None: ...

    def update_clock_event_reasons_software_power_limited(self, wait_for_completion: bool=True) -> None: ...

    def update_clock_event_reasons_software_thermal_limited(self, wait_for_completion: bool=True) -> None: ...

    def update_clock_event_reasons_power_break_slowdown_limited(self, wait_for_completion: bool=True) -> None: ...

    def update_clock_event_reasons_supported(self, wait_for_completion: bool=True) -> None: ...

    def update_clock_event_reasons_sync_boost(self, wait_for_completion: bool=True) -> None: ...

    def update_clock_event_reasons_thermal_limited(self, wait_for_completion: bool=True) -> None: ...

    def update_color_table_entries(self, wait_for_completion: bool=True) -> None: ...

    def update_compute_cap(self, wait_for_completion: bool=True) -> None: ...

    def update_compute_mode(self, wait_for_completion: bool=True) -> None: ...

    def update_config_manager_error_code(self, wait_for_completion: bool=True) -> None: ...

    def update_config_manager_user_config(self, wait_for_completion: bool=True) -> None: ...

    def update_core_voltage(self, wait_for_completion: bool=True) -> None: ...

    def update_core_voltage_range(self, wait_for_completion: bool=True) -> None: ...

    def update_creation_class_name(self, wait_for_completion: bool=True) -> None: ...

    def update_current_bits_per_pixel(self, wait_for_completion: bool=True) -> None: ...

    def update_current_horizontal_resolution(self, wait_for_completion: bool=True) -> None: ...

    def update_current_number_of_colors(self, wait_for_completion: bool=True) -> None: ...

    def update_current_number_of_columns(self, wait_for_completion: bool=True) -> None: ...

    def update_current_number_of_rows(self, wait_for_completion: bool=True) -> None: ...

    def update_current_refresh_rate(self, wait_for_completion: bool=True) -> None: ...

    def update_current_scan_mode(self, wait_for_completion: bool=True) -> None: ...

    def update_current_vertical_resolution(self, wait_for_completion: bool=True) -> None: ...

    def update_description(self, wait_for_completion: bool=True) -> None: ...

    def update_device_id(self, wait_for_completion: bool=True) -> None: ...

    def update_device_specific_pens(self, wait_for_completion: bool=True) -> None: ...

    def update_display_active(self, wait_for_completion: bool=True) -> None: ...

    def update_display_mode(self, wait_for_completion: bool=True) -> None: ...

    def update_dither_type(self, wait_for_completion: bool=True) -> None: ...

    def update_driver_date(self, wait_for_completion: bool=True) -> None: ...

    def update_driver_model_current(self, wait_for_completion: bool=True) -> None: ...

    def update_driver_model_pending(self, wait_for_completion: bool=True) -> None: ...

    def update_driver_version(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_all_time_in_cbu(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_all_time_in_primary_cache(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_all_time_in_register_file(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_all_time_in_secondary_cache(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_all_time_in_shared_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_all_time_in_sram(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_all_time_in_texture_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_all_time_in_total(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_all_time_in_video_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_since_reboot_in_cbu(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_since_reboot_in_primary_cache(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_since_reboot_in_register_file(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_since_reboot_in_secondary_cache(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_since_reboot_in_shared_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_since_reboot_in_sram(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_since_reboot_in_texture_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_since_reboot_in_total(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_corrected_since_reboot_in_video_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_all_time_in_cbu(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_all_time_in_primary_cache(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_all_time_in_register_file(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_all_time_in_secondary_cache(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_all_time_in_shared_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_all_time_in_sram(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_all_time_in_texture_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_all_time_in_total(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_all_time_in_video_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_since_reboot_in_cbu(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_since_reboot_in_primary_cache(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_since_reboot_in_register_file(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_since_reboot_in_secondary_cache(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_since_reboot_in_shared_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_since_reboot_in_sram(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_since_reboot_in_texture_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_since_reboot_in_total(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_errors_uncorrected_since_reboot_in_video_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_mode_current(self, wait_for_completion: bool=True) -> None: ...

    def update_ecc_mode_pending(self, wait_for_completion: bool=True) -> None: ...

    def update_encoder_average_FPS(self, wait_for_completion: bool=True) -> None: ...

    def update_encoder_average_latency(self, wait_for_completion: bool=True) -> None: ...

    def update_encoder_session_count(self, wait_for_completion: bool=True) -> None: ...

    def update_engine_clock_range(self, wait_for_completion: bool=True) -> None: ...

    def update_error_cleared(self, wait_for_completion: bool=True) -> None: ...

    def update_error_description(self, wait_for_completion: bool=True) -> None: ...

    def update_fabric_state(self, wait_for_completion: bool=True) -> None: ...

    def update_fabric_status(self, wait_for_completion: bool=True) -> None: ...

    def update_fan_speed_percentage(self, wait_for_completion: bool=True) -> None: ...

    def update_fan_speed_percentage_range(self, wait_for_completion: bool=True) -> None: ...

    def update_fan_speed_RPM(self, wait_for_completion: bool=True) -> None: ...

    def update_fan_speed_RPM_range(self, wait_for_completion: bool=True) -> None: ...

    def update_fractional_multi_vGPU(self, wait_for_completion: bool=True) -> None: ...

    def update_frequency_application_default_shader_clock(self, wait_for_completion: bool=True) -> None: ...

    def update_frequency_application_default_memory_clock(self, wait_for_completion: bool=True) -> None: ...

    def update_frequency_application_memory_clock(self, wait_for_completion: bool=True) -> None: ...

    def update_frequency_application_shader_clock(self, wait_for_completion: bool=True) -> None: ...

    def update_frequency_maximum_memory_clock(self, wait_for_completion: bool=True) -> None: ...

    def update_frequency_maximum_shader_clock(self, wait_for_completion: bool=True) -> None: ...

    def update_frequency_maximum_streaming_multiprocessor_clock(self, wait_for_completion: bool=True) -> None: ...

    def update_frequency_memory_clock(self, wait_for_completion: bool=True) -> None: ...

    def update_frequency_shader_clock(self, wait_for_completion: bool=True) -> None: ...

    def update_frequency_streaming_multiprocessor_clock(self, wait_for_completion: bool=True) -> None: ...

    def update_frequency_video_clock(self, wait_for_completion: bool=True) -> None: ...

    def update_heterogenous_multi_vGPU(self, wait_for_completion: bool=True) -> None: ...

    def update_heterogenous_time_slice_profile(self, wait_for_completion: bool=True) -> None: ...

    def update_heterogenous_time_slice_sizes(self, wait_for_completion: bool=True) -> None: ...

    def update_ICM_indent(self, wait_for_completion: bool=True) -> None: ...

    def update_ICM_method(self, wait_for_completion: bool=True) -> None: ...

    def update_inf_filename(self, wait_for_completion: bool=True) -> None: ...

    def update_inf_section(self, wait_for_completion: bool=True) -> None: ...

    def update_info_ROM_ecc(self, wait_for_completion: bool=True) -> None: ...

    def update_info_ROM_oem(self, wait_for_completion: bool=True) -> None: ...

    def update_info_ROM_power(self, wait_for_completion: bool=True) -> None: ...

    def update_info_ROM_version(self, wait_for_completion: bool=True) -> None: ...

    def update_install_date(self, wait_for_completion: bool=True) -> None: ...

    def update_installed_display_drivers(self, wait_for_completion: bool=True) -> None: ...

    def update_last_error_code(self, wait_for_completion: bool=True) -> None: ...

    def update_max_memory_supported(self, wait_for_completion: bool=True) -> None: ...

    def update_max_number_controlled(self, wait_for_completion: bool=True) -> None: ...

    def update_max_refresh_rate(self, wait_for_completion: bool=True) -> None: ...

    def update_memory_clock_range(self, wait_for_completion: bool=True) -> None: ...

    def update_memory_free(self, wait_for_completion: bool=True) -> None: ...

    def update_memory_reserved(self, wait_for_completion: bool=True) -> None: ...

    def update_memory_total(self, wait_for_completion: bool=True) -> None: ...

    def update_memory_used(self, wait_for_completion: bool=True) -> None: ...

    def update_min_refresh_rate(self, wait_for_completion: bool=True) -> None: ...

    def update_monochrome(self, wait_for_completion: bool=True) -> None: ...

    def update_multi_instance_GPU_mode_current(self, wait_for_completion: bool=True) -> None: ...

    def update_multi_instance_GPU_mode_pending(self, wait_for_completion: bool=True) -> None: ...

    def update_name(self, wait_for_completion: bool=True) -> None: ...

    def update_number_of_color_planes(self, wait_for_completion: bool=True) -> None: ...

    def update_number_of_video_pages(self, wait_for_completion: bool=True) -> None: ...

    def update_operating_mode_current(self, wait_for_completion: bool=True) -> None: ...

    def update_operating_mode_pending(self, wait_for_completion: bool=True) -> None: ...

    def update_pci_bus(self, wait_for_completion: bool=True) -> None: ...

    def update_pci_bus_id(self, wait_for_completion: bool=True) -> None: ...

    def update_pci_device(self, wait_for_completion: bool=True) -> None: ...

    def update_pci_device_id(self, wait_for_completion: bool=True) -> None: ...

    def update_pci_domain(self, wait_for_completion: bool=True) -> None: ...

    def update_pci_link_generation_current(self, wait_for_completion: bool=True) -> None: ...

    def update_pci_link_generation_device_host_maximum(self, wait_for_completion: bool=True) -> None: ...

    def update_pci_link_generation_gpu_maximum(self, wait_for_completion: bool=True) -> None: ...

    def update_pci_link_generation_maximum(self, wait_for_completion: bool=True) -> None: ...

    def update_pci_link_width_current(self, wait_for_completion: bool=True) -> None: ...

    def update_pci_link_width_maximum(self, wait_for_completion: bool=True) -> None: ...

    def update_pci_sub_device_id(self, wait_for_completion: bool=True) -> None: ...

    def update_persistence_mode(self, wait_for_completion: bool=True) -> None: ...

    def update_PNP_device_id(self, wait_for_completion: bool=True) -> None: ...

    def update_power_draw(self, wait_for_completion: bool=True) -> None: ...

    def update_power_draw_average(self, wait_for_completion: bool=True) -> None: ...

    def update_power_draw_default_limit(self, wait_for_completion: bool=True) -> None: ...

    def update_power_draw_enforced_limit(self, wait_for_completion: bool=True) -> None: ...

    def update_power_draw_instant(self, wait_for_completion: bool=True) -> None: ...

    def update_power_draw_limit(self, wait_for_completion: bool=True) -> None: ...

    def update_power_draw_maximum(self, wait_for_completion: bool=True) -> None: ...

    def update_power_draw_minimum(self, wait_for_completion: bool=True) -> None: ...

    def update_power_management_capabilities(self, wait_for_completion: bool=True) -> None: ...

    def update_power_management_supported(self, wait_for_completion: bool=True) -> None: ...

    def update_protected_memory_free(self, wait_for_completion: bool=True) -> None: ...

    def update_protected_memory_total(self, wait_for_completion: bool=True) -> None: ...

    def update_protected_memory_used(self, wait_for_completion: bool=True) -> None: ...

    def update_protocol_supported(self, wait_for_completion: bool=True) -> None: ...

    def update_performance_state(self, wait_for_completion: bool=True) -> None: ...

    def update_retired_pages_double_bit_ecc_errors_count(self, wait_for_completion: bool=True) -> None: ...

    def update_retired_pages_single_bit_ecc_errors_count(self, wait_for_completion: bool=True) -> None: ...

    def update_retired_pages_pending(self, wait_for_completion: bool=True) -> None: ...

    def update_reserved_system_palette_entries(self, wait_for_completion: bool=True) -> None: ...

    def update_reset_required(self, wait_for_completion: bool=True) -> None: ...

    def update_reset_and_drain_recommended(self, wait_for_completion: bool=True) -> None: ...

    def update_serial(self, wait_for_completion: bool=True) -> None: ...

    def update_specification_version(self, wait_for_completion: bool=True) -> None: ...

    def update_status(self, wait_for_completion: bool=True) -> None: ...

    def update_status_info(self, wait_for_completion: bool=True) -> None: ...

    def update_system_creation_class_name(self, wait_for_completion: bool=True) -> None: ...

    def update_system_name(self, wait_for_completion: bool=True) -> None: ...

    def update_system_palette_entries(self, wait_for_completion: bool=True) -> None: ...

    def update_GPU_system_processor_mode_current(self, wait_for_completion: bool=True) -> None: ...

    def update_GPU_system_processor_mode_default(self, wait_for_completion: bool=True) -> None: ...

    def update_temperature_core(self, wait_for_completion: bool=True) -> None: ...

    def update_temperature_core_limit(self, wait_for_completion: bool=True) -> None: ...

    def update_temperature_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_time_of_last_reset(self, wait_for_completion: bool=True) -> None: ...

    def update_utilization_decoder(self, wait_for_completion: bool=True) -> None: ...

    def update_utilization_encoder(self, wait_for_completion: bool=True) -> None: ...

    def update_utilization_gpu(self, wait_for_completion: bool=True) -> None: ...

    def update_utilization_jpeg(self, wait_for_completion: bool=True) -> None: ...

    def update_utilization_memory(self, wait_for_completion: bool=True) -> None: ...

    def update_utilization_optical_flow(self, wait_for_completion: bool=True) -> None: ...

    def update_uuid(self, wait_for_completion: bool=True) -> None: ...

    def update_vbios_version(self, wait_for_completion: bool=True) -> None: ...

    def update_video_architecture(self, wait_for_completion: bool=True) -> None: ...

    def update_video_memory_type(self, wait_for_completion: bool=True) -> None: ...

    def update_video_mode(self, wait_for_completion: bool=True) -> None: ...

    def update_video_mode_description(self, wait_for_completion: bool=True) -> None: ...

    def update_video_processor(self, wait_for_completion: bool=True) -> None: ...
