from typing import Union, Iterable

import numpy
from numpy.typing import NDArray

NoneInt = Union[int, None]
NoneFloat = Union[float, None]

class Sampler:
    def __init__(self, chunk_size: int=2048, sampling_rate: int=44100, input_device_id: NoneInt=None) -> None: ...
    def print_input_devices(self) -> None: ...
    def sampler(self, wait_time: NoneFloat) -> None: ...
    def start(self, wait_time: NoneFloat=None) -> None: ...
    def stop(self, wait_until_stopped: bool=True) -> None: ...
    def pause(self) -> None: ...
    def unpause(self) -> None: ...
    def set_input_device(self, input_device_id: NoneInt=None) -> None: ...

    def get_input_devices(self) -> Iterable[int]: ...

    def get_default_input_device(self) -> int: ...
    def get_loudest_frequency(self) -> int: ...

    def get_frequency(self) -> NDArray[numpy.float64]: ...

    def get_volume(self) -> float: ...

    def is_sampling(self) -> bool: ...