"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import sys
import typing

import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import proto.clarifai.api.status.status_code_pb2
import proto.clarifai.api.status.status_pb2
import proto.clarifai.api.utils.matrix_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _WorkflowModelUseCase:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _WorkflowModelUseCaseEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_WorkflowModelUseCase.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    WORKFLOW_MODEL_USE_CASE_NOT_SET: _WorkflowModelUseCase.ValueType  # 0
    CLASSIFICATION: _WorkflowModelUseCase.ValueType  # 1
    """Classifier models without a detector parent (recursive check) in a workflow
    are used for classification.
    """
    DETECTION: _WorkflowModelUseCase.ValueType  # 2
    """Detector models in a workflow are used for detection.
    Classifier models that run after a detector model are also used for detection.
    """

class WorkflowModelUseCase(
    _WorkflowModelUseCase, metaclass=_WorkflowModelUseCaseEnumTypeWrapper
): ...

WORKFLOW_MODEL_USE_CASE_NOT_SET: WorkflowModelUseCase.ValueType  # 0
CLASSIFICATION: WorkflowModelUseCase.ValueType  # 1
"""Classifier models without a detector parent (recursive check) in a workflow
are used for classification.
"""
DETECTION: WorkflowModelUseCase.ValueType  # 2
"""Detector models in a workflow are used for detection.
Classifier models that run after a detector model are also used for detection.
"""
global___WorkflowModelUseCase = WorkflowModelUseCase

class _DatasetVersionRequestOrigin:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DatasetVersionRequestOriginEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _DatasetVersionRequestOrigin.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DATASET_VERSION_REQUEST_ORIGIN_NOT_SET: _DatasetVersionRequestOrigin.ValueType  # 0
    MANUAL: _DatasetVersionRequestOrigin.ValueType  # 1
    TRAINING: _DatasetVersionRequestOrigin.ValueType  # 2
    EVAL_GROUND_TRUTH: _DatasetVersionRequestOrigin.ValueType  # 3
    EVAL_PREDICTIONS: _DatasetVersionRequestOrigin.ValueType  # 4

class DatasetVersionRequestOrigin(
    _DatasetVersionRequestOrigin, metaclass=_DatasetVersionRequestOriginEnumTypeWrapper
): ...

DATASET_VERSION_REQUEST_ORIGIN_NOT_SET: DatasetVersionRequestOrigin.ValueType  # 0
MANUAL: DatasetVersionRequestOrigin.ValueType  # 1
TRAINING: DatasetVersionRequestOrigin.ValueType  # 2
EVAL_GROUND_TRUTH: DatasetVersionRequestOrigin.ValueType  # 3
EVAL_PREDICTIONS: DatasetVersionRequestOrigin.ValueType  # 4
global___DatasetVersionRequestOrigin = DatasetVersionRequestOrigin

class _DatasetVersionMetricsGroupType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DatasetVersionMetricsGroupTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _DatasetVersionMetricsGroupType.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DATASET_VERSION_METRICS_GROUP_TYPE_NOT_SET: _DatasetVersionMetricsGroupType.ValueType  # 0
    INPUT_TYPE: _DatasetVersionMetricsGroupType.ValueType  # 2
    """Group data examples by input type.
    Examples: images, videos, text, audio.
    """
    CONCEPT_ID: _DatasetVersionMetricsGroupType.ValueType  # 10
    """Group data examples by concept ID.
    Examples: inputs with cat concept, inputs with dog concept.
    """
    CONCEPTS_COUNT: _DatasetVersionMetricsGroupType.ValueType  # 11
    """Group data examples by concepts count.
    Examples: inputs with 20 concepts, inputs with 21 concepts.
    """
    BOUNDING_BOXES_COUNT: _DatasetVersionMetricsGroupType.ValueType  # 20
    """Group data examples by bounding boxes count.
    Examples: inputs with 20 bounding boxes, inputs with 21 bounding boxes.
    """
    POLYGONS_COUNT: _DatasetVersionMetricsGroupType.ValueType  # 21
    """Group data examples by polygons count.
    Examples: inputs with 20 polygons, inputs with 21 polygons.
    """
    POINTS_COUNT: _DatasetVersionMetricsGroupType.ValueType  # 22
    """Group data examples by points count.
    Examples: inputs with 20 points, inputs with 21 points.
    """
    MASKS_COUNT: _DatasetVersionMetricsGroupType.ValueType  # 23
    """Group data examples by masks count.
    Examples: inputs with 20 masks, inputs with 21 masks.
    """
    PIXELS_COUNT: _DatasetVersionMetricsGroupType.ValueType  # 30
    """Group data examples by pixels count.
    In order to reduce the number of groups, we use bins.
    Examples for bin size = 400: inputs with [200000, 200400) pixels, inputs with [200400, 200800) pixels.
    """
    ASPECT_RATIO: _DatasetVersionMetricsGroupType.ValueType  # 31
    """Group data examples by aspect ratio.
    In order to reduce the number of groups, we use bins.
    Examples for bin size = 0.1: inputs with [0.5, 0.6) aspect ratio, inputs with [0.6, 0.7) aspect ratio.
    """

class DatasetVersionMetricsGroupType(
    _DatasetVersionMetricsGroupType, metaclass=_DatasetVersionMetricsGroupTypeEnumTypeWrapper
): ...

DATASET_VERSION_METRICS_GROUP_TYPE_NOT_SET: DatasetVersionMetricsGroupType.ValueType  # 0
INPUT_TYPE: DatasetVersionMetricsGroupType.ValueType  # 2
"""Group data examples by input type.
Examples: images, videos, text, audio.
"""
CONCEPT_ID: DatasetVersionMetricsGroupType.ValueType  # 10
"""Group data examples by concept ID.
Examples: inputs with cat concept, inputs with dog concept.
"""
CONCEPTS_COUNT: DatasetVersionMetricsGroupType.ValueType  # 11
"""Group data examples by concepts count.
Examples: inputs with 20 concepts, inputs with 21 concepts.
"""
BOUNDING_BOXES_COUNT: DatasetVersionMetricsGroupType.ValueType  # 20
"""Group data examples by bounding boxes count.
Examples: inputs with 20 bounding boxes, inputs with 21 bounding boxes.
"""
POLYGONS_COUNT: DatasetVersionMetricsGroupType.ValueType  # 21
"""Group data examples by polygons count.
Examples: inputs with 20 polygons, inputs with 21 polygons.
"""
POINTS_COUNT: DatasetVersionMetricsGroupType.ValueType  # 22
"""Group data examples by points count.
Examples: inputs with 20 points, inputs with 21 points.
"""
MASKS_COUNT: DatasetVersionMetricsGroupType.ValueType  # 23
"""Group data examples by masks count.
Examples: inputs with 20 masks, inputs with 21 masks.
"""
PIXELS_COUNT: DatasetVersionMetricsGroupType.ValueType  # 30
"""Group data examples by pixels count.
In order to reduce the number of groups, we use bins.
Examples for bin size = 400: inputs with [200000, 200400) pixels, inputs with [200400, 200800) pixels.
"""
ASPECT_RATIO: DatasetVersionMetricsGroupType.ValueType  # 31
"""Group data examples by aspect ratio.
In order to reduce the number of groups, we use bins.
Examples for bin size = 0.1: inputs with [0.5, 0.6) aspect ratio, inputs with [0.6, 0.7) aspect ratio.
"""
global___DatasetVersionMetricsGroupType = DatasetVersionMetricsGroupType

class _DatasetVersionExportFormat:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DatasetVersionExportFormatEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _DatasetVersionExportFormat.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DATASET_VERSION_EXPORT_FORMAT_NOT_SET: _DatasetVersionExportFormat.ValueType  # 0
    CLARIFAI_DATA_PROTOBUF: _DatasetVersionExportFormat.ValueType  # 1
    """CLARIFAI_DATA_PROTOBUF is the proprietary Clarifai API Data format. It
    is a ZIP-archive containing batches of serialized InputBatch protobuf messages.

    Note that only the "id" and "data" fields of exported inputs are set.
    """
    CLARIFAI_DATA_JSON: _DatasetVersionExportFormat.ValueType  # 3
    """CLARIFAI_DATA_JSON is the proprietary Clarifai API Data format in JSON. It
    is a ZIP-archive containing batches of serialized InputBatch JSON messages.

    Note that only the "id" and "data" fields of exported inputs are set.
    """
    COCO: _DatasetVersionExportFormat.ValueType  # 2
    """COCO is the data format used by Common Objects in Context. It is a
    ZIP-archive containing JSON files with the dataset version annotations.
    See https://cocodataset.org/#format-data.
    """

class DatasetVersionExportFormat(
    _DatasetVersionExportFormat, metaclass=_DatasetVersionExportFormatEnumTypeWrapper
): ...

DATASET_VERSION_EXPORT_FORMAT_NOT_SET: DatasetVersionExportFormat.ValueType  # 0
CLARIFAI_DATA_PROTOBUF: DatasetVersionExportFormat.ValueType  # 1
"""CLARIFAI_DATA_PROTOBUF is the proprietary Clarifai API Data format. It
is a ZIP-archive containing batches of serialized InputBatch protobuf messages.

Note that only the "id" and "data" fields of exported inputs are set.
"""
CLARIFAI_DATA_JSON: DatasetVersionExportFormat.ValueType  # 3
"""CLARIFAI_DATA_JSON is the proprietary Clarifai API Data format in JSON. It
is a ZIP-archive containing batches of serialized InputBatch JSON messages.

Note that only the "id" and "data" fields of exported inputs are set.
"""
COCO: DatasetVersionExportFormat.ValueType  # 2
"""COCO is the data format used by Common Objects in Context. It is a
ZIP-archive containing JSON files with the dataset version annotations.
See https://cocodataset.org/#format-data.
"""
global___DatasetVersionExportFormat = DatasetVersionExportFormat

class _ExpirationAction:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ExpirationActionEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ExpirationAction.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    EXPIRATION_ACTION_NOT_SET: _ExpirationAction.ValueType  # 0
    DELAY: _ExpirationAction.ValueType  # 1
    """Progressively delay the execution of operations"""
    EXPIRY: _ExpirationAction.ValueType  # 2
    """Cease functioning"""

class ExpirationAction(_ExpirationAction, metaclass=_ExpirationActionEnumTypeWrapper): ...

EXPIRATION_ACTION_NOT_SET: ExpirationAction.ValueType  # 0
DELAY: ExpirationAction.ValueType  # 1
"""Progressively delay the execution of operations"""
EXPIRY: ExpirationAction.ValueType  # 2
"""Cease functioning"""
global___ExpirationAction = ExpirationAction

class _LicenseScope:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LicenseScopeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LicenseScope.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    LICENSE_SCOPE_NOT_SET: _LicenseScope.ValueType  # 0
    PREDICT: _LicenseScope.ValueType  # 1
    TRAIN: _LicenseScope.ValueType  # 2
    SEARCH: _LicenseScope.ValueType  # 3

class LicenseScope(_LicenseScope, metaclass=_LicenseScopeEnumTypeWrapper): ...

LICENSE_SCOPE_NOT_SET: LicenseScope.ValueType  # 0
PREDICT: LicenseScope.ValueType  # 1
TRAIN: LicenseScope.ValueType  # 2
SEARCH: LicenseScope.ValueType  # 3
global___LicenseScope = LicenseScope

class _LicenseType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LicenseTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LicenseType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN_LICENSE_TYPE: _LicenseType.ValueType  # 0
    FIRST_PARTY: _LicenseType.ValueType  # 1
    OPEN_SOURCE: _LicenseType.ValueType  # 2
    CLOSED_SOURCE: _LicenseType.ValueType  # 3

class LicenseType(_LicenseType, metaclass=_LicenseTypeEnumTypeWrapper): ...

UNKNOWN_LICENSE_TYPE: LicenseType.ValueType  # 0
FIRST_PARTY: LicenseType.ValueType  # 1
OPEN_SOURCE: LicenseType.ValueType  # 2
CLOSED_SOURCE: LicenseType.ValueType  # 3
global___LicenseType = LicenseType

class _DeployRestriction:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DeployRestrictionEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DeployRestriction.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    USAGE_RESTRICTION_NOT_SET: _DeployRestriction.ValueType  # 0
    """Default uninitialized state."""
    NO_LIMITS: _DeployRestriction.ValueType  # 1
    """No restrictions on usage."""
    SHARED_COMPUTE_ONLY: _DeployRestriction.ValueType  # 2
    """Model can only be used on shared compute resources."""
    DEDICATED_COMPUTE_ONLY: _DeployRestriction.ValueType  # 3
    """Model can only be used on dedicated compute resources."""

class DeployRestriction(_DeployRestriction, metaclass=_DeployRestrictionEnumTypeWrapper): ...

USAGE_RESTRICTION_NOT_SET: DeployRestriction.ValueType  # 0
"""Default uninitialized state."""
NO_LIMITS: DeployRestriction.ValueType  # 1
"""No restrictions on usage."""
SHARED_COMPUTE_ONLY: DeployRestriction.ValueType  # 2
"""Model can only be used on shared compute resources."""
DEDICATED_COMPUTE_ONLY: DeployRestriction.ValueType  # 3
"""Model can only be used on dedicated compute resources."""
global___DeployRestriction = DeployRestriction

class _DataType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DataTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DataType.ValueType], builtins.type
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNDEFINED: _DataType.ValueType  # 0
    """Default value, should not be used"""
    STRING: _DataType.ValueType  # 1
    UINT8: _DataType.ValueType  # 2
    INT32: _DataType.ValueType  # 3
    INT64: _DataType.ValueType  # 4
    FP32: _DataType.ValueType  # 5

class DataType(_DataType, metaclass=_DataTypeEnumTypeWrapper): ...

UNDEFINED: DataType.ValueType  # 0
"""Default value, should not be used"""
STRING: DataType.ValueType  # 1
UINT8: DataType.ValueType  # 2
INT32: DataType.ValueType  # 3
INT64: DataType.ValueType  # 4
FP32: DataType.ValueType  # 5
global___DataType = DataType

class _ValueComparator:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ValueComparatorEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ValueComparator.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CONCEPT_THRESHOLD_NOT_SET: _ValueComparator.ValueType  # 0
    GREATER_THAN: _ValueComparator.ValueType  # 1
    """input > value"""
    GREATER_THAN_OR_EQUAL: _ValueComparator.ValueType  # 2
    """input >= value"""
    LESS_THAN: _ValueComparator.ValueType  # 3
    """input < value"""
    LESS_THAN_OR_EQUAL: _ValueComparator.ValueType  # 4
    """input <= value"""
    EQUAL: _ValueComparator.ValueType  # 5
    """input == value"""

class ValueComparator(_ValueComparator, metaclass=_ValueComparatorEnumTypeWrapper): ...

CONCEPT_THRESHOLD_NOT_SET: ValueComparator.ValueType  # 0
GREATER_THAN: ValueComparator.ValueType  # 1
"""input > value"""
GREATER_THAN_OR_EQUAL: ValueComparator.ValueType  # 2
"""input >= value"""
LESS_THAN: ValueComparator.ValueType  # 3
"""input < value"""
LESS_THAN_OR_EQUAL: ValueComparator.ValueType  # 4
"""input <= value"""
EQUAL: ValueComparator.ValueType  # 5
"""input == value"""
global___ValueComparator = ValueComparator

class _EvaluationType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _EvaluationTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_EvaluationType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    Undefined: _EvaluationType.ValueType  # 0
    Classification: _EvaluationType.ValueType  # 1
    """default"""
    Detection: _EvaluationType.ValueType  # 2
    Segmentation: _EvaluationType.ValueType  # 3
    Clustering: _EvaluationType.ValueType  # 4
    Tracker: _EvaluationType.ValueType  # 5
    Generation: _EvaluationType.ValueType  # 6

class EvaluationType(_EvaluationType, metaclass=_EvaluationTypeEnumTypeWrapper): ...

Undefined: EvaluationType.ValueType  # 0
Classification: EvaluationType.ValueType  # 1
"""default"""
Detection: EvaluationType.ValueType  # 2
Segmentation: EvaluationType.ValueType  # 3
Clustering: EvaluationType.ValueType  # 4
Tracker: EvaluationType.ValueType  # 5
Generation: EvaluationType.ValueType  # 6
global___EvaluationType = EvaluationType

class _APIEventType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _APIEventTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_APIEventType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    API_EVENT_TYPE_NOT_SET: _APIEventType.ValueType  # 0
    ON_PREM_PREDICT: _APIEventType.ValueType  # 1
    """On Prem event types"""
    ON_PREM_TRAIN: _APIEventType.ValueType  # 2
    ON_PREM_SEARCH: _APIEventType.ValueType  # 3

class APIEventType(_APIEventType, metaclass=_APIEventTypeEnumTypeWrapper): ...

API_EVENT_TYPE_NOT_SET: APIEventType.ValueType  # 0
ON_PREM_PREDICT: APIEventType.ValueType  # 1
"""On Prem event types"""
ON_PREM_TRAIN: APIEventType.ValueType  # 2
ON_PREM_SEARCH: APIEventType.ValueType  # 3
global___APIEventType = APIEventType

class _UsageIntervalType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _UsageIntervalTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_UsageIntervalType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    undef: _UsageIntervalType.ValueType  # 0
    """undef UsageIntervalType is so that the interval field can be forced to be included"""
    day: _UsageIntervalType.ValueType  # 1
    month: _UsageIntervalType.ValueType  # 2
    year: _UsageIntervalType.ValueType  # 3

class UsageIntervalType(_UsageIntervalType, metaclass=_UsageIntervalTypeEnumTypeWrapper): ...

undef: UsageIntervalType.ValueType  # 0
"""undef UsageIntervalType is so that the interval field can be forced to be included"""
day: UsageIntervalType.ValueType  # 1
month: UsageIntervalType.ValueType  # 2
year: UsageIntervalType.ValueType  # 3
global___UsageIntervalType = UsageIntervalType

class _AnnotationDataType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AnnotationDataTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AnnotationDataType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ANNOTATION_DATA_TYPE_NOT_SET: _AnnotationDataType.ValueType  # 0
    TAG: _AnnotationDataType.ValueType  # 1
    BOUNDING_BOX: _AnnotationDataType.ValueType  # 2
    POLYGON: _AnnotationDataType.ValueType  # 4
    POINT: _AnnotationDataType.ValueType  # 8
    SPAN: _AnnotationDataType.ValueType  # 16
    MASK: _AnnotationDataType.ValueType  # 32

class AnnotationDataType(_AnnotationDataType, metaclass=_AnnotationDataTypeEnumTypeWrapper): ...

ANNOTATION_DATA_TYPE_NOT_SET: AnnotationDataType.ValueType  # 0
TAG: AnnotationDataType.ValueType  # 1
BOUNDING_BOX: AnnotationDataType.ValueType  # 2
POLYGON: AnnotationDataType.ValueType  # 4
POINT: AnnotationDataType.ValueType  # 8
SPAN: AnnotationDataType.ValueType  # 16
MASK: AnnotationDataType.ValueType  # 32
global___AnnotationDataType = AnnotationDataType

class _RoleType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RoleTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_RoleType.ValueType], builtins.type
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TEAM: _RoleType.ValueType  # 0
    ORG: _RoleType.ValueType  # 1

class RoleType(_RoleType, metaclass=_RoleTypeEnumTypeWrapper): ...

TEAM: RoleType.ValueType  # 0
ORG: RoleType.ValueType  # 1
global___RoleType = RoleType

class _StatValueAggType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StatValueAggTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_StatValueAggType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SUM: _StatValueAggType.ValueType  # 0
    AVG: _StatValueAggType.ValueType  # 1

class StatValueAggType(_StatValueAggType, metaclass=_StatValueAggTypeEnumTypeWrapper): ...

SUM: StatValueAggType.ValueType  # 0
AVG: StatValueAggType.ValueType  # 1
global___StatValueAggType = StatValueAggType

class _StatTimeAggType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StatTimeAggTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_StatTimeAggType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NO_TIME_AGG: _StatTimeAggType.ValueType  # 0
    YEAR: _StatTimeAggType.ValueType  # 1
    MONTH: _StatTimeAggType.ValueType  # 2
    WEEK: _StatTimeAggType.ValueType  # 3
    DAY: _StatTimeAggType.ValueType  # 4
    HOUR: _StatTimeAggType.ValueType  # 5
    MINUTE: _StatTimeAggType.ValueType  # 6

class StatTimeAggType(_StatTimeAggType, metaclass=_StatTimeAggTypeEnumTypeWrapper): ...

NO_TIME_AGG: StatTimeAggType.ValueType  # 0
YEAR: StatTimeAggType.ValueType  # 1
MONTH: StatTimeAggType.ValueType  # 2
WEEK: StatTimeAggType.ValueType  # 3
DAY: StatTimeAggType.ValueType  # 4
HOUR: StatTimeAggType.ValueType  # 5
MINUTE: StatTimeAggType.ValueType  # 6
global___StatTimeAggType = StatTimeAggType

class _ValidationErrorType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ValidationErrorTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ValidationErrorType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    VALIDATION_ERROR_TYPE_NOT_SET: _ValidationErrorType.ValueType  # 0
    RESTRICTED: _ValidationErrorType.ValueType  # 1
    DATABASE: _ValidationErrorType.ValueType  # 2
    FORMAT: _ValidationErrorType.ValueType  # 3

class ValidationErrorType(_ValidationErrorType, metaclass=_ValidationErrorTypeEnumTypeWrapper): ...

VALIDATION_ERROR_TYPE_NOT_SET: ValidationErrorType.ValueType  # 0
RESTRICTED: ValidationErrorType.ValueType  # 1
DATABASE: ValidationErrorType.ValueType  # 2
FORMAT: ValidationErrorType.ValueType  # 3
global___ValidationErrorType = ValidationErrorType

class _InputIDConflictResolution:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _InputIDConflictResolutionEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _InputIDConflictResolution.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    INPUT_ID_CONFLICT_RESOLUTION_NOT_SET: _InputIDConflictResolution.ValueType  # 0
    """Defaults to SKIP"""
    SKIP: _InputIDConflictResolution.ValueType  # 1
    """Mark duplicate inputs as error and skip processing them."""
    SUFFIX: _InputIDConflictResolution.ValueType  # 2
    """Add a suffix to inputs with conflicting IDs. Attempts numeric suffixes "-1" to "-9" and then a randomized suffix. Identical ID's in the same request are still treated as errors."""

class InputIDConflictResolution(
    _InputIDConflictResolution, metaclass=_InputIDConflictResolutionEnumTypeWrapper
): ...

INPUT_ID_CONFLICT_RESOLUTION_NOT_SET: InputIDConflictResolution.ValueType  # 0
"""Defaults to SKIP"""
SKIP: InputIDConflictResolution.ValueType  # 1
"""Mark duplicate inputs as error and skip processing them."""
SUFFIX: InputIDConflictResolution.ValueType  # 2
"""Add a suffix to inputs with conflicting IDs. Attempts numeric suffixes "-1" to "-9" and then a randomized suffix. Identical ID's in the same request are still treated as errors."""
global___InputIDConflictResolution = InputIDConflictResolution

class _RunnerMethodType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RunnerMethodTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_RunnerMethodType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN: _RunnerMethodType.ValueType  # 0
    UNARY_UNARY: _RunnerMethodType.ValueType  # 1
    """single request, single response. predict() in code"""
    UNARY_STREAMING: _RunnerMethodType.ValueType  # 2
    """single request, streamed response. generate() in code"""
    STREAMING_UNARY: _RunnerMethodType.ValueType  # 3
    """stream of requests, single response."""
    STREAMING_STREAMING: _RunnerMethodType.ValueType  # 4
    """stream of requests, stream of responses. stream() in code"""

class RunnerMethodType(_RunnerMethodType, metaclass=_RunnerMethodTypeEnumTypeWrapper): ...

UNKNOWN: RunnerMethodType.ValueType  # 0
UNARY_UNARY: RunnerMethodType.ValueType  # 1
"""single request, single response. predict() in code"""
UNARY_STREAMING: RunnerMethodType.ValueType  # 2
"""single request, streamed response. generate() in code"""
STREAMING_UNARY: RunnerMethodType.ValueType  # 3
"""stream of requests, single response."""
STREAMING_STREAMING: RunnerMethodType.ValueType  # 4
"""stream of requests, stream of responses. stream() in code"""
global___RunnerMethodType = RunnerMethodType

class _EventType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _EventTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_EventType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    EVENT_TYPE_NOT_SET: _EventType.ValueType  # 0
    ORGANIZATION_MEMBER_ADD: _EventType.ValueType  # 100
    """Event types related to organization memberships and teams: 100 - 199"""
    ORGANIZATION_MEMBER_CHANGE: _EventType.ValueType  # 101
    ORGANIZATION_MEMBER_REMOVE: _EventType.ValueType  # 102
    ORGANIZATION_MEMBER_INVITATION_CREATE: _EventType.ValueType  # 103
    ORGANIZATION_MEMBER_INVITATION_CANCEL: _EventType.ValueType  # 104
    ORGANIZATION_MEMBER_INVITATION_ACCEPT: _EventType.ValueType  # 105
    ORGANIZATION_MEMBER_INVITATION_DECLINE: _EventType.ValueType  # 106
    ORGANIZATION_TEAM_CREATE: _EventType.ValueType  # 107
    ORGANIZATION_TEAM_UPDATE: _EventType.ValueType  # 108
    ORGANIZATION_TEAM_DELETE: _EventType.ValueType  # 109
    ORGANIZATION_TEAM_MEMBER_ADD: _EventType.ValueType  # 110
    ORGANIZATION_TEAM_MEMBER_REMOVE: _EventType.ValueType  # 111
    ORGANIZATION_TEAM_APP_ADD: _EventType.ValueType  # 112
    ORGANIZATION_TEAM_APP_REMOVE: _EventType.ValueType  # 113
    MODULE_CREATE: _EventType.ValueType  # 200
    """Event types related to modules: 200 - 299"""
    MODULE_UPDATE: _EventType.ValueType  # 201
    MODULE_DELETE: _EventType.ValueType  # 202
    MODULE_VERSION_CREATE: _EventType.ValueType  # 203
    MODULE_VERSION_UPDATE: _EventType.ValueType  # 204
    MODULE_VERSION_DELETE: _EventType.ValueType  # 205
    MODEL_CREATE: _EventType.ValueType  # 300
    """Event types related to models: 300 - 399"""
    MODEL_UPDATE: _EventType.ValueType  # 301
    MODEL_DELETE: _EventType.ValueType  # 302
    MODEL_VERSION_CREATE: _EventType.ValueType  # 303
    MODEL_VERSION_UPDATE: _EventType.ValueType  # 304
    MODEL_VERSION_DELETE: _EventType.ValueType  # 305
    WORKFLOW_CREATE: _EventType.ValueType  # 400
    """Event types related to workflows: 400 - 499"""
    WORKFLOW_UPDATE: _EventType.ValueType  # 401
    WORKFLOW_DELETE: _EventType.ValueType  # 402
    WORKFLOW_VERSION_CREATE: _EventType.ValueType  # 403
    WORKFLOW_VERSION_UPDATE: _EventType.ValueType  # 404
    WORKFLOW_VERSION_DELETE: _EventType.ValueType  # 405
    APPLICATION_CREATE: _EventType.ValueType  # 600
    """Event types related to datasets: 500 - 599

    Event types related to applications: 600 - 699
    """
    APPLICATION_UPDATE: _EventType.ValueType  # 601
    APPLICATION_DELETE: _EventType.ValueType  # 602
    COLLABORATOR_ADD: _EventType.ValueType  # 700
    """Event types related to collaborators: 700 - 799"""
    COLLABORATOR_UPDATE: _EventType.ValueType  # 701
    COLLABORATOR_REMOVE: _EventType.ValueType  # 702
    USER_UPDATE: _EventType.ValueType  # 800
    """Event types related to users: 800 - 899"""
    COMPUTE_CLUSTER_CREATE: _EventType.ValueType  # 900
    """Event types related to compute clusters: 900-999"""
    COMPUTE_CLUSTER_DELETE: _EventType.ValueType  # 901
    NODEPOOL_CREATE: _EventType.ValueType  # 1000
    """Event types related to nodepools: 1000-1099"""
    NODEPOOL_UPDATE: _EventType.ValueType  # 1001
    NODEPOOL_DELETE: _EventType.ValueType  # 1002
    DEPLOYMENT_CREATE: _EventType.ValueType  # 1100
    """Event types related to deployments: 1100-1199"""
    DEPLOYMENT_UPDATE: _EventType.ValueType  # 1101
    DEPLOYMENT_DELETE: _EventType.ValueType  # 1102

class EventType(_EventType, metaclass=_EventTypeEnumTypeWrapper): ...

EVENT_TYPE_NOT_SET: EventType.ValueType  # 0
ORGANIZATION_MEMBER_ADD: EventType.ValueType  # 100
"""Event types related to organization memberships and teams: 100 - 199"""
ORGANIZATION_MEMBER_CHANGE: EventType.ValueType  # 101
ORGANIZATION_MEMBER_REMOVE: EventType.ValueType  # 102
ORGANIZATION_MEMBER_INVITATION_CREATE: EventType.ValueType  # 103
ORGANIZATION_MEMBER_INVITATION_CANCEL: EventType.ValueType  # 104
ORGANIZATION_MEMBER_INVITATION_ACCEPT: EventType.ValueType  # 105
ORGANIZATION_MEMBER_INVITATION_DECLINE: EventType.ValueType  # 106
ORGANIZATION_TEAM_CREATE: EventType.ValueType  # 107
ORGANIZATION_TEAM_UPDATE: EventType.ValueType  # 108
ORGANIZATION_TEAM_DELETE: EventType.ValueType  # 109
ORGANIZATION_TEAM_MEMBER_ADD: EventType.ValueType  # 110
ORGANIZATION_TEAM_MEMBER_REMOVE: EventType.ValueType  # 111
ORGANIZATION_TEAM_APP_ADD: EventType.ValueType  # 112
ORGANIZATION_TEAM_APP_REMOVE: EventType.ValueType  # 113
MODULE_CREATE: EventType.ValueType  # 200
"""Event types related to modules: 200 - 299"""
MODULE_UPDATE: EventType.ValueType  # 201
MODULE_DELETE: EventType.ValueType  # 202
MODULE_VERSION_CREATE: EventType.ValueType  # 203
MODULE_VERSION_UPDATE: EventType.ValueType  # 204
MODULE_VERSION_DELETE: EventType.ValueType  # 205
MODEL_CREATE: EventType.ValueType  # 300
"""Event types related to models: 300 - 399"""
MODEL_UPDATE: EventType.ValueType  # 301
MODEL_DELETE: EventType.ValueType  # 302
MODEL_VERSION_CREATE: EventType.ValueType  # 303
MODEL_VERSION_UPDATE: EventType.ValueType  # 304
MODEL_VERSION_DELETE: EventType.ValueType  # 305
WORKFLOW_CREATE: EventType.ValueType  # 400
"""Event types related to workflows: 400 - 499"""
WORKFLOW_UPDATE: EventType.ValueType  # 401
WORKFLOW_DELETE: EventType.ValueType  # 402
WORKFLOW_VERSION_CREATE: EventType.ValueType  # 403
WORKFLOW_VERSION_UPDATE: EventType.ValueType  # 404
WORKFLOW_VERSION_DELETE: EventType.ValueType  # 405
APPLICATION_CREATE: EventType.ValueType  # 600
"""Event types related to datasets: 500 - 599

Event types related to applications: 600 - 699
"""
APPLICATION_UPDATE: EventType.ValueType  # 601
APPLICATION_DELETE: EventType.ValueType  # 602
COLLABORATOR_ADD: EventType.ValueType  # 700
"""Event types related to collaborators: 700 - 799"""
COLLABORATOR_UPDATE: EventType.ValueType  # 701
COLLABORATOR_REMOVE: EventType.ValueType  # 702
USER_UPDATE: EventType.ValueType  # 800
"""Event types related to users: 800 - 899"""
COMPUTE_CLUSTER_CREATE: EventType.ValueType  # 900
"""Event types related to compute clusters: 900-999"""
COMPUTE_CLUSTER_DELETE: EventType.ValueType  # 901
NODEPOOL_CREATE: EventType.ValueType  # 1000
"""Event types related to nodepools: 1000-1099"""
NODEPOOL_UPDATE: EventType.ValueType  # 1001
NODEPOOL_DELETE: EventType.ValueType  # 1002
DEPLOYMENT_CREATE: EventType.ValueType  # 1100
"""Event types related to deployments: 1100-1199"""
DEPLOYMENT_UPDATE: EventType.ValueType  # 1101
DEPLOYMENT_DELETE: EventType.ValueType  # 1102
global___EventType = EventType

class _MetricType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MetricTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MetricType.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    METRIC_TYPE_NOT_SET: _MetricType.ValueType  # 0
    MODEL_REQUEST_COUNT: _MetricType.ValueType  # 1
    MODEL_LATENCY: _MetricType.ValueType  # 2

class MetricType(_MetricType, metaclass=_MetricTypeEnumTypeWrapper): ...

METRIC_TYPE_NOT_SET: MetricType.ValueType  # 0
MODEL_REQUEST_COUNT: MetricType.ValueType  # 1
MODEL_LATENCY: MetricType.ValueType  # 2
global___MetricType = MetricType

class _MetricLabel:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MetricLabelEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MetricLabel.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    METRIC_LABEL_NOT_SET: _MetricLabel.ValueType  # 0
    APP_ID: _MetricLabel.ValueType  # 1
    MODEL_ID: _MetricLabel.ValueType  # 2
    MODEL_VERSION_ID: _MetricLabel.ValueType  # 3
    CALLER_USER_ID: _MetricLabel.ValueType  # 4
    WORKFLOW_ID: _MetricLabel.ValueType  # 5

class MetricLabel(_MetricLabel, metaclass=_MetricLabelEnumTypeWrapper): ...

METRIC_LABEL_NOT_SET: MetricLabel.ValueType  # 0
APP_ID: MetricLabel.ValueType  # 1
MODEL_ID: MetricLabel.ValueType  # 2
MODEL_VERSION_ID: MetricLabel.ValueType  # 3
CALLER_USER_ID: MetricLabel.ValueType  # 4
WORKFLOW_ID: MetricLabel.ValueType  # 5
global___MetricLabel = MetricLabel

@typing_extensions.final
class Annotation(google.protobuf.message.Message):
    """Annotation of an asset with metadata"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    INPUT_ID_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    ANNOTATION_INFO_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    MODEL_VERSION_ID_FIELD_NUMBER: builtins.int
    EMBED_MODEL_VERSION_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    TRUSTED_FIELD_NUMBER: builtins.int
    INPUT_LEVEL_FIELD_NUMBER: builtins.int
    CONSENSUS_INFO_FIELD_NUMBER: builtins.int
    TASK_ID_FIELD_NUMBER: builtins.int
    WORKER_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID for the annotation"""
    input_id: builtins.str
    """ID of the input this annotation is tied to"""
    @property
    def data(self) -> global___Data:
        """The data passed along in this annotation."""
    @property
    def annotation_info(self) -> google.protobuf.struct_pb2.Struct:
        """task_id is deprecated in annotation_info. Use task_id"""
    user_id: builtins.str
    """DEPRECATED: Use worker.user.id instead."""
    model_version_id: builtins.str
    """DEPRECATED: Use worker.model.model_version.id instead"""
    embed_model_version_id: builtins.str
    """DEPRECATED."""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """Annotation Status"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the annotation was created. We follow the XXXX timestamp
        format. We use https://www.ietf.org/rfc/rfc3339.txt format:
        "2006-01-02T15:04:05.999999Z" so you can expect results like
        the following from the API:
        "2017-04-11T21:50:50.223962Z"
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the annotation was modified."""
    trusted: builtins.bool
    """Whether or not this annotation is trusted
    Will be deprecated
    """
    input_level: builtins.bool
    """Is this the input level annotation."""
    @property
    def consensus_info(self) -> google.protobuf.struct_pb2.Struct:
        """Consensus review related information, e.g.
        * annotation group
        * id of annotation parent, in case the annotation was split from another annotation
        """
    task_id: builtins.str
    """The id of the task annotation belongs to"""
    @property
    def worker(self) -> global___Worker:
        """Worker is the worker that created the annotation."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        input_id: builtins.str = ...,
        data: global___Data | None = ...,
        annotation_info: google.protobuf.struct_pb2.Struct | None = ...,
        user_id: builtins.str = ...,
        model_version_id: builtins.str = ...,
        embed_model_version_id: builtins.str = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        trusted: builtins.bool = ...,
        input_level: builtins.bool = ...,
        consensus_info: google.protobuf.struct_pb2.Struct | None = ...,
        task_id: builtins.str = ...,
        worker: global___Worker | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "annotation_info",
            b"annotation_info",
            "consensus_info",
            b"consensus_info",
            "created_at",
            b"created_at",
            "data",
            b"data",
            "modified_at",
            b"modified_at",
            "status",
            b"status",
            "worker",
            b"worker",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "annotation_info",
            b"annotation_info",
            "consensus_info",
            b"consensus_info",
            "created_at",
            b"created_at",
            "data",
            b"data",
            "embed_model_version_id",
            b"embed_model_version_id",
            "id",
            b"id",
            "input_id",
            b"input_id",
            "input_level",
            b"input_level",
            "model_version_id",
            b"model_version_id",
            "modified_at",
            b"modified_at",
            "status",
            b"status",
            "task_id",
            b"task_id",
            "trusted",
            b"trusted",
            "user_id",
            b"user_id",
            "worker",
            b"worker",
        ],
    ) -> None: ...

global___Annotation = Annotation

@typing_extensions.final
class AnnotationTrack(google.protobuf.message.Message):
    """AnnotationTrack of an asset with metadata"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    INPUT_ID_FIELD_NUMBER: builtins.int
    CONCEPT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    START_FRAME_NR_FIELD_NUMBER: builtins.int
    END_FRAME_NR_FIELD_NUMBER: builtins.int
    START_FRAME_MS_FIELD_NUMBER: builtins.int
    END_FRAME_MS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    SAMPLE_RATE_MS_FIELD_NUMBER: builtins.int
    SAMPLE_RATE_FRAME_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID for the annotation track"""
    input_id: builtins.str
    """ID of the asset this annotation track is tied to"""
    @property
    def concept(self) -> global___Concept:
        """Concept this annotation track"""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """AnnotationTrack Status"""
    start_frame_nr: builtins.int
    """Start frame number (in original video) of the annotation track, inclusive."""
    end_frame_nr: builtins.int
    """End frame number (in original video) of the annotation track, inclusive."""
    start_frame_ms: builtins.int
    """Start time (in milliseconds of original video) of the annotation track, inclusive."""
    end_frame_ms: builtins.int
    """End time (in milliseconds of original video) of the annotation track, inclusive."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the annotation track was created."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the annotation track was modified."""
    sample_rate_ms: builtins.int
    """Sampling rate of the annotation track in milliseconds."""
    sample_rate_frame: builtins.int
    """Sampling frame rate of the video track in frame number increments
    increment of 1 means it matches the original video FPS
    increment of 2 means every second frame is sampled, etc.
    So if you have 30fps original video and frame_rate=3, your annotations in a track are stored at 30fps/3frame_rate=10 frames per second
    Useful if client relies on simple frame access.
    Useful if video has variable frame rate (VFR), then annotations are also sampled with VFR in mind
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        input_id: builtins.str = ...,
        concept: global___Concept | None = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        start_frame_nr: builtins.int = ...,
        end_frame_nr: builtins.int = ...,
        start_frame_ms: builtins.int = ...,
        end_frame_ms: builtins.int = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        sample_rate_ms: builtins.int = ...,
        sample_rate_frame: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "concept",
            b"concept",
            "created_at",
            b"created_at",
            "modified_at",
            b"modified_at",
            "status",
            b"status",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "concept",
            b"concept",
            "created_at",
            b"created_at",
            "end_frame_ms",
            b"end_frame_ms",
            "end_frame_nr",
            b"end_frame_nr",
            "id",
            b"id",
            "input_id",
            b"input_id",
            "modified_at",
            b"modified_at",
            "sample_rate_frame",
            b"sample_rate_frame",
            "sample_rate_ms",
            b"sample_rate_ms",
            "start_frame_ms",
            b"start_frame_ms",
            "start_frame_nr",
            b"start_frame_nr",
            "status",
            b"status",
        ],
    ) -> None: ...

global___AnnotationTrack = AnnotationTrack

@typing_extensions.final
class Worker(google.protobuf.message.Message):
    """Worker is the author of an annotation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    WORKFLOW_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___User:
        """User is the human that created the annotation.

        By default no real names of users are returned in responses. These can
        be requested with the 'names' additional field.
        """
    @property
    def model(self) -> global___Model:
        """Model is the model that created the annotation."""
    @property
    def workflow(self) -> global___Workflow:
        """Workflow is the workflow that created the annotation."""
    def __init__(
        self,
        *,
        user: global___User | None = ...,
        model: global___Model | None = ...,
        workflow: global___Workflow | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "model", b"model", "user", b"user", "worker", b"worker", "workflow", b"workflow"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "model", b"model", "user", b"user", "worker", b"worker", "workflow", b"workflow"
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["worker", b"worker"]
    ) -> typing_extensions.Literal["user", "model", "workflow"] | None: ...

global___Worker = Worker

@typing_extensions.final
class App(google.protobuf.message.Message):
    """Application with tasks and datasets"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _EmbeddingsStorage:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EmbeddingsStorageEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            App._EmbeddingsStorage.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        EMBEDDING_STORAGE_NOT_SET: App._EmbeddingsStorage.ValueType  # 0
        POSTGRES: App._EmbeddingsStorage.ValueType  # 1
        QDRANT: App._EmbeddingsStorage.ValueType  # 2

    class EmbeddingsStorage(_EmbeddingsStorage, metaclass=_EmbeddingsStorageEnumTypeWrapper): ...
    EMBEDDING_STORAGE_NOT_SET: App.EmbeddingsStorage.ValueType  # 0
    POSTGRES: App.EmbeddingsStorage.ValueType  # 1
    QDRANT: App.EmbeddingsStorage.ValueType  # 2

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DEFAULT_LANGUAGE_FIELD_NUMBER: builtins.int
    DEFAULT_WORKFLOW_ID_FIELD_NUMBER: builtins.int
    DEFAULT_WORKFLOW_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    LEGAL_CONSENT_STATUS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    SAMPLE_MS_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    DATA_TIER_ID_FIELD_NUMBER: builtins.int
    IS_STARRED_FIELD_NUMBER: builtins.int
    STAR_COUNT_FIELD_NUMBER: builtins.int
    NOTES_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    IS_TEMPLATE_FIELD_NUMBER: builtins.int
    EXTRA_INFO_FIELD_NUMBER: builtins.int
    EMBEDDINGS_STORAGE_FIELD_NUMBER: builtins.int
    id: builtins.str
    name: builtins.str
    default_language: builtins.str
    default_workflow_id: builtins.str
    """Deprecated, use default_workflow instead.
    @exclude TODO (EAGLE-4506): Remove this field and associated code
    """
    @property
    def default_workflow(self) -> global___Workflow: ...
    user_id: builtins.str
    """why is user_id present here when this message type is used in PostApps but completely ignored there? PostApp already
    specifies the userid in path but doesn't even actually use neither of userids, it instead used the id from auth context.
    This creates a lot of ambiguity, should always have different message types for Post/Get endpoints so that the minimum interface for each op can be described
    """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the app was created. We follow the XXXX timestamp
        format. We use https://www.ietf.org/rfc/rfc3339.txt format:
        "2006-01-02T15:04:05.999999Z" so you can expect results like
        the following from the API:
        "2017-04-11T21:50:50.223962Z"
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the app was last modified"""
    legal_consent_status: builtins.int
    """if user accept legal consent for face recognition"""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    description: builtins.str
    """short description about the app."""
    sample_ms: builtins.int
    """Default value for model predictions on video: Sample delay for video predicting (1 frame per N milliseconds)"""
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    data_tier_id: builtins.str
    """data tier id this app is using."""
    is_starred: builtins.bool
    """Is starred by the requesting user (only showed on get/list requests)
    Please use PostAppStars/DeleteAppStars endpoints to star/unstar an app
    """
    star_count: builtins.int
    """How many users have starred the app (only showed on get/list requests)
    Computed value, not editable
    """
    notes: builtins.str
    """Notes for the application
    This field should be used for in-depth notes and supports up to 64Kbs.
    """
    @property
    def image(self) -> global___Image:
        """Representative image for this app"""
    @property
    def is_template(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """An app marked as a template can be duplicated by any user that can see it,
        including all visible resources within it.
        """
    @property
    def extra_info(self) -> global___AppExtraInfo: ...
    embeddings_storage: global___App.EmbeddingsStorage.ValueType
    """Where app embeddings are stored
    postgres (default), qdrant
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        default_language: builtins.str = ...,
        default_workflow_id: builtins.str = ...,
        default_workflow: global___Workflow | None = ...,
        user_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        legal_consent_status: builtins.int = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        description: builtins.str = ...,
        sample_ms: builtins.int = ...,
        visibility: global___Visibility | None = ...,
        data_tier_id: builtins.str = ...,
        is_starred: builtins.bool = ...,
        star_count: builtins.int = ...,
        notes: builtins.str = ...,
        image: global___Image | None = ...,
        is_template: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        extra_info: global___AppExtraInfo | None = ...,
        embeddings_storage: global___App.EmbeddingsStorage.ValueType = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "default_workflow",
            b"default_workflow",
            "extra_info",
            b"extra_info",
            "image",
            b"image",
            "is_template",
            b"is_template",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "data_tier_id",
            b"data_tier_id",
            "default_language",
            b"default_language",
            "default_workflow",
            b"default_workflow",
            "default_workflow_id",
            b"default_workflow_id",
            "description",
            b"description",
            "embeddings_storage",
            b"embeddings_storage",
            "extra_info",
            b"extra_info",
            "id",
            b"id",
            "image",
            b"image",
            "is_starred",
            b"is_starred",
            "is_template",
            b"is_template",
            "legal_consent_status",
            b"legal_consent_status",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "name",
            b"name",
            "notes",
            b"notes",
            "sample_ms",
            b"sample_ms",
            "star_count",
            b"star_count",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___App = App

@typing_extensions.final
class AppExtraInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SEARCH_REVISION_MARKER_FIELD_NUMBER: builtins.int
    COUNTS_FIELD_NUMBER: builtins.int
    search_revision_marker: builtins.str
    """Revision marker for this application.
    The value of the revision changes when
    * inputs are added, updated or deleted
    * annotations are added, updated or deleted
    * inputs are added to or removed from datasets
    For example, this value can be used to detect if client side caches related to searching should be invalidated.
    Field not filled in for list endpoints, use GetApp
    """
    @property
    def counts(self) -> global___AppResourceCounts: ...
    def __init__(
        self,
        *,
        search_revision_marker: builtins.str = ...,
        counts: global___AppResourceCounts | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["counts", b"counts"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "counts", b"counts", "search_revision_marker", b"search_revision_marker"
        ],
    ) -> None: ...

global___AppExtraInfo = AppExtraInfo

@typing_extensions.final
class AppQuery(google.protobuf.message.Message):
    """App query"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Query by application name. This supports wildcard queries like "gen*" to match "general" as an example."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___AppQuery = AppQuery

@typing_extensions.final
class AppResourceCounts(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASETS_FIELD_NUMBER: builtins.int
    MODELS_FIELD_NUMBER: builtins.int
    WORKFLOWS_FIELD_NUMBER: builtins.int
    MODULES_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    datasets: builtins.int
    models: builtins.int
    workflows: builtins.int
    modules: builtins.int
    inputs: builtins.int
    def __init__(
        self,
        *,
        datasets: builtins.int = ...,
        models: builtins.int = ...,
        workflows: builtins.int = ...,
        modules: builtins.int = ...,
        inputs: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "datasets",
            b"datasets",
            "inputs",
            b"inputs",
            "models",
            b"models",
            "modules",
            b"modules",
            "workflows",
            b"workflows",
        ],
    ) -> None: ...

global___AppResourceCounts = AppResourceCounts

@typing_extensions.final
class Collaborator(google.protobuf.message.Message):
    """Collaborator - invited user, who shares an access to an application"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    APP_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    SCOPES_FIELD_NUMBER: builtins.int
    ENDPOINTS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    DELETED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id of this collaborator"""
    @property
    def app(self) -> global___App:
        """the app this collaborator has access to
        FIXME(zeiler): this should be in the user_app_id.app_id already from the endpoint.
        """
    @property
    def user(self) -> global___User:
        """who is this collaborator"""
    @property
    def scopes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """the permission this collaborator"""
    @property
    def endpoints(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the app was shared with. We follow the XXXX timestamp
        format. We use https://www.ietf.org/rfc/rfc3339.txt format:
        "2006-01-02T15:04:05.999999Z" so you can expect results like
        the following from the API:
        "2017-04-11T21:50:50.223962Z"
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the collaborator was updated."""
    @property
    def deleted_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the collaborator was removed from app."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        app: global___App | None = ...,
        user: global___User | None = ...,
        scopes: collections.abc.Iterable[builtins.str] | None = ...,
        endpoints: collections.abc.Iterable[builtins.str] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        deleted_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "app",
            b"app",
            "created_at",
            b"created_at",
            "deleted_at",
            b"deleted_at",
            "modified_at",
            b"modified_at",
            "user",
            b"user",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app",
            b"app",
            "created_at",
            b"created_at",
            "deleted_at",
            b"deleted_at",
            "endpoints",
            b"endpoints",
            "id",
            b"id",
            "modified_at",
            b"modified_at",
            "scopes",
            b"scopes",
            "user",
            b"user",
        ],
    ) -> None: ...

global___Collaborator = Collaborator

@typing_extensions.final
class Collaboration(google.protobuf.message.Message):
    """collaboration includes an app you're invited to work on."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APP_FIELD_NUMBER: builtins.int
    APP_OWNER_FIELD_NUMBER: builtins.int
    SCOPES_FIELD_NUMBER: builtins.int
    ENDPOINTS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    @property
    def app(self) -> global___App:
        """the application"""
    @property
    def app_owner(self) -> global___User:
        """the app owner's info(including user_unique_id, first_name, last_name, primary_email)"""
    @property
    def scopes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """the low-level scope users are shared with for this collaboration"""
    @property
    def endpoints(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """the endpoint-level scopes users are shared with for this collaboration"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """when is the collaboration created"""
    def __init__(
        self,
        *,
        app: global___App | None = ...,
        app_owner: global___User | None = ...,
        scopes: collections.abc.Iterable[builtins.str] | None = ...,
        endpoints: collections.abc.Iterable[builtins.str] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "app", b"app", "app_owner", b"app_owner", "created_at", b"created_at"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app",
            b"app",
            "app_owner",
            b"app_owner",
            "created_at",
            b"created_at",
            "endpoints",
            b"endpoints",
            "scopes",
            b"scopes",
        ],
    ) -> None: ...

global___Collaboration = Collaboration

@typing_extensions.final
class Audio(google.protobuf.message.Message):
    """Audio asset struct"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    BASE64_FIELD_NUMBER: builtins.int
    ALLOW_DUPLICATE_URL_FIELD_NUMBER: builtins.int
    HOSTED_FIELD_NUMBER: builtins.int
    AUDIO_INFO_FIELD_NUMBER: builtins.int
    url: builtins.str
    """This is a URL to a publicly accessible image file. The platform will download this file server
    side and then process.
    """
    base64: builtins.bytes
    """The base64 field is using image file bytes directly in the request.
    NOTE: if you're sending a json request, then this MUST be base64 encoded before sending (hence
    the name here).
    When using our grpc clients, you DO NOT need to base64 encode
    it yourself since the clients know how to do this for you automatically and will avoid the
    base64 encoding if they send a binary request.
    """
    allow_duplicate_url: builtins.bool
    """If True then you will be allowed to have multiple urls."""
    @property
    def hosted(self) -> global___HostedURL:
        """The hosted field lists original audio hosted in Clarifai storage. This field is currently used
        only in response.
        """
    @property
    def audio_info(self) -> global___AudioInfo:
        """audio info"""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
        base64: builtins.bytes = ...,
        allow_duplicate_url: builtins.bool = ...,
        hosted: global___HostedURL | None = ...,
        audio_info: global___AudioInfo | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal["audio_info", b"audio_info", "hosted", b"hosted"],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "allow_duplicate_url",
            b"allow_duplicate_url",
            "audio_info",
            b"audio_info",
            "base64",
            b"base64",
            "hosted",
            b"hosted",
            "url",
            b"url",
        ],
    ) -> None: ...

global___Audio = Audio

@typing_extensions.final
class AudioInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FORMAT_FIELD_NUMBER: builtins.int
    SAMPLE_RATE_FIELD_NUMBER: builtins.int
    DURATION_SECONDS_FIELD_NUMBER: builtins.int
    BIT_RATE_FIELD_NUMBER: builtins.int
    audio_format: builtins.str
    """audio format"""
    sample_rate: builtins.int
    """sample rate"""
    duration_seconds: builtins.float
    """audio track duration in seconds"""
    bit_rate: builtins.int
    """audio track bit rate"""
    def __init__(
        self,
        *,
        audio_format: builtins.str = ...,
        sample_rate: builtins.int = ...,
        duration_seconds: builtins.float = ...,
        bit_rate: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "audio_format",
            b"audio_format",
            "bit_rate",
            b"bit_rate",
            "duration_seconds",
            b"duration_seconds",
            "sample_rate",
            b"sample_rate",
        ],
    ) -> None: ...

global___AudioInfo = AudioInfo

@typing_extensions.final
class Track(google.protobuf.message.Message):
    """Track proto encodes information of a track over a number of frames"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    TIME_INFO_FIELD_NUMBER: builtins.int
    QUALITY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """track id"""
    @property
    def data(self) -> global___Data:
        """This is a recursive definition which can contain all the concepts,
        embeddings, etc. that are computed within this track.
        """
    @property
    def time_info(self) -> global___TimeInfo: ...
    quality: builtins.float
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        data: global___Data | None = ...,
        time_info: global___TimeInfo | None = ...,
        quality: builtins.float = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["data", b"data", "time_info", b"time_info"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "data", b"data", "id", b"id", "quality", b"quality", "time_info", b"time_info"
        ],
    ) -> None: ...

global___Track = Track

@typing_extensions.final
class Cluster(google.protobuf.message.Message):
    """Cluster data"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    SCORE_FIELD_NUMBER: builtins.int
    HITS_FIELD_NUMBER: builtins.int
    PROJECTION_FIELD_NUMBER: builtins.int
    id: builtins.str
    count: builtins.int
    """Number of annotations tied to the cluster in the app"""
    score: builtins.float
    """The score assigned to this cluster.
    For List Clusters endpoint, this represents percentage of inputs in the app assigned to this cluster.
    """
    @property
    def hits(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Hit]:
        """Representative hits for cluster (for now we only return 1)"""
    @property
    def projection(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        count: builtins.int = ...,
        score: builtins.float = ...,
        hits: collections.abc.Iterable[global___Hit] | None = ...,
        projection: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "count",
            b"count",
            "hits",
            b"hits",
            "id",
            b"id",
            "projection",
            b"projection",
            "score",
            b"score",
        ],
    ) -> None: ...

global___Cluster = Cluster

@typing_extensions.final
class Color(google.protobuf.message.Message):
    """Color data"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RAW_HEX_FIELD_NUMBER: builtins.int
    W3C_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    raw_hex: builtins.str
    @property
    def w3c(self) -> global___W3C: ...
    value: builtins.float
    def __init__(
        self,
        *,
        raw_hex: builtins.str = ...,
        w3c: global___W3C | None = ...,
        value: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["w3c", b"w3c"]) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "raw_hex", b"raw_hex", "value", b"value", "w3c", b"w3c"
        ],
    ) -> None: ...

global___Color = Color

@typing_extensions.final
class W3C(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEX_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    hex: builtins.str
    name: builtins.str
    def __init__(
        self,
        *,
        hex: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["hex", b"hex", "name", b"name"]
    ) -> None: ...

global___W3C = W3C

@typing_extensions.final
class UserAppIDSet(google.protobuf.message.Message):
    """Common message to identify the app in a url endpoint."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """Note user_id 'me' is reserved - it is the alias for the id of authorized user"""
    app_id: builtins.str
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        app_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["app_id", b"app_id", "user_id", b"user_id"]
    ) -> None: ...

global___UserAppIDSet = UserAppIDSet

@typing_extensions.final
class PatchAction(google.protobuf.message.Message):
    """PatchAction"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OP_FIELD_NUMBER: builtins.int
    MERGE_CONFLICT_RESOLUTION_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    op: builtins.str
    """The operation to perform on the patched metadata given a path
    For now only operations 'overwrite', 'delete, and 'merge' is supported
    """
    merge_conflict_resolution: builtins.str
    """If the action is 'merge' and there is a conflict, how to resolve it.
    The options are
    'overwrite_by_id', 'remove_by_id', 'merge_by_id','overwrite', 'append' and 'do_nothing'
    Note that for conflict resolutions '*_by_id' to work on a list, the list should contain
    objects with an 'id' field which will be used to uniquely identify each field. For example
    Patching existing json
    {
      "tag": [
        {
          "id": "1",
          "data": 1
        },
        {
          "id": "2",
          "data": 2
        }
      ]
    }
    with op 'merge' and merge_conflict_resolution 'overwrite_by_id'
    {
      "tag": [
        {
          "id": "2",
          "data": 3
        }
      ]
    }
    would produce
    {
      "tag": [
        {
          "id": "1",
          "data": 1
        },
        {
          "id": "2",
          "data": 3
        }
      ]
    }
    while with merge_conflict_resolution 'remove_by_id' it would produce
    {
      "tag": [
        {
          "id": "1",
          "data": 1
        }
      ]
    }

    Option 'append' will simply create a list on conflicts. For example in above example
    the final result would be
    {
      "tag": [
        {
          "id": "1",
          "data": 1
        },
        {
          "id": "2",
          "data": [2, 3]
        }
      ]
    }
    """
    path: builtins.str
    """Path for the change. For example 'tag[1].data' is a valid path in above example.
    Default path is root level i.e. ''.
    """
    def __init__(
        self,
        *,
        op: builtins.str = ...,
        merge_conflict_resolution: builtins.str = ...,
        path: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "merge_conflict_resolution", b"merge_conflict_resolution", "op", b"op", "path", b"path"
        ],
    ) -> None: ...

global___PatchAction = PatchAction

@typing_extensions.final
class Concept(google.protobuf.message.Message):
    """Concept or tag"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LANGUAGE_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    DEFINITION_FIELD_NUMBER: builtins.int
    VOCAB_ID_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    KEYPOINT_INFO_FIELD_NUMBER: builtins.int
    EXTRA_INFO_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The concept's unique id."""
    name: builtins.str
    """The name of the concept in the given language."""
    value: builtins.float
    """Used to indicate presence (1.0) or not (0.0) of this concept when making a request.
    This is also the prediction probability when returning predictions from our API.
    For convenience we use the default of 1.0 when making requests so the concept you provide is
    is treated as a positive (1.0) and not a negative (which would be value == 0.0).
    """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the concept was created. The format is https://www.ietf.org/rfc/rfc3339.txt .
        Example: "2006-01-02T15:04:05.999999Z". This field is used only in a response.
        """
    language: builtins.str
    """The language in which the concept name is in. This is *ONLY* used in the response and setting
    it in a request is ignored since the default language of your app is used when creating
    or patching a Concept. To set other languages for your concept use the ConceptLanguage object
    and its corresponding endpoints.
    """
    app_id: builtins.str
    """The application id that this concept is within. This can be ignored by most users."""
    definition: builtins.str
    """The definition for the concept. Similar to name. This can be ignored by most users."""
    vocab_id: builtins.str
    """The vocabulary that this concept belongs to. This is useful if you have different unique sets
    of concepts that you can separate out based on this field. For example "age_appearance" vs
    "gender_appearance" in a list of concept returned from the demographics model.
    """
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    user_id: builtins.str
    """The user the concept belongs to."""
    @property
    def keypoint_info(self) -> global___KeypointInfo:
        """Information about keypoints for this concept"""
    @property
    def extra_info(self) -> global___ConceptExtraInfo:
        """Optional extra info."""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    @property
    def image(self) -> global___Image:
        """Representative image for the concept"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        value: builtins.float = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        language: builtins.str = ...,
        app_id: builtins.str = ...,
        definition: builtins.str = ...,
        vocab_id: builtins.str = ...,
        visibility: global___Visibility | None = ...,
        user_id: builtins.str = ...,
        keypoint_info: global___KeypointInfo | None = ...,
        extra_info: global___ConceptExtraInfo | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        image: global___Image | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "extra_info",
            b"extra_info",
            "image",
            b"image",
            "keypoint_info",
            b"keypoint_info",
            "metadata",
            b"metadata",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "created_at",
            b"created_at",
            "definition",
            b"definition",
            "extra_info",
            b"extra_info",
            "id",
            b"id",
            "image",
            b"image",
            "keypoint_info",
            b"keypoint_info",
            "language",
            b"language",
            "metadata",
            b"metadata",
            "name",
            b"name",
            "user_id",
            b"user_id",
            "value",
            b"value",
            "visibility",
            b"visibility",
            "vocab_id",
            b"vocab_id",
        ],
    ) -> None: ...

global___Concept = Concept

@typing_extensions.final
class KeypointInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEYPOINT_NAMES_FIELD_NUMBER: builtins.int
    SKELETON_FIELD_NUMBER: builtins.int
    @property
    def keypoint_names(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of the keypoints"""
    @property
    def skeleton(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___KeypointEdge
    ]:
        """Defines the connections between keypoint_names. Each value represents the index in keypoint_names."""
    def __init__(
        self,
        *,
        keypoint_names: collections.abc.Iterable[builtins.str] | None = ...,
        skeleton: collections.abc.Iterable[global___KeypointEdge] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "keypoint_names", b"keypoint_names", "skeleton", b"skeleton"
        ],
    ) -> None: ...

global___KeypointInfo = KeypointInfo

@typing_extensions.final
class KeypointEdge(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    K1_FIELD_NUMBER: builtins.int
    K2_FIELD_NUMBER: builtins.int
    k1: builtins.int
    k2: builtins.int
    def __init__(
        self,
        *,
        k1: builtins.int = ...,
        k2: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["k1", b"k1", "k2", b"k2"]
    ) -> None: ...

global___KeypointEdge = KeypointEdge

@typing_extensions.final
class ConceptExtraInfo(google.protobuf.message.Message):
    """ConceptExtraInfo represents extra information related to a concept that is context-dependent.
    It is only set when requested in ConceptExtraInfoRequest.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_RANKABLE_FIELD_NUMBER: builtins.int
    is_rankable: builtins.bool
    """Whether this concept is rankable based on ConceptExtraInfoRequest configuration."""
    def __init__(
        self,
        *,
        is_rankable: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["is_rankable", b"is_rankable"]
    ) -> None: ...

global___ConceptExtraInfo = ConceptExtraInfo

@typing_extensions.final
class ConceptCount(google.protobuf.message.Message):
    """ConceptCount"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CONCEPT_TYPE_COUNT_FIELD_NUMBER: builtins.int
    DETAIL_CONCEPT_COUNT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The concept's unique id."""
    name: builtins.str
    """The name of the concept."""
    @property
    def concept_type_count(self) -> global___ConceptTypeCount:
        """The total count for concepts labeled for all asset statues (processing, to_process, processed, error)"""
    @property
    def detail_concept_count(self) -> global___DetailConceptCount:
        """The detail count for different assets status"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        concept_type_count: global___ConceptTypeCount | None = ...,
        detail_concept_count: global___DetailConceptCount | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "concept_type_count",
            b"concept_type_count",
            "detail_concept_count",
            b"detail_concept_count",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "concept_type_count",
            b"concept_type_count",
            "detail_concept_count",
            b"detail_concept_count",
            "id",
            b"id",
            "name",
            b"name",
        ],
    ) -> None: ...

global___ConceptCount = ConceptCount

@typing_extensions.final
class ConceptTypeCount(google.protobuf.message.Message):
    """ConceptTypeCount"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POSITIVE_FIELD_NUMBER: builtins.int
    NEGATIVE_FIELD_NUMBER: builtins.int
    positive: builtins.int
    """The number of inputs that have a concept with a value of 1.0 (indicating presence of the
    concept in an input).
    """
    negative: builtins.int
    """The number of inputs that have a concept with a value of 0.0 (indicating absence of the
    concept in an input).
    """
    def __init__(
        self,
        *,
        positive: builtins.int = ...,
        negative: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["negative", b"negative", "positive", b"positive"],
    ) -> None: ...

global___ConceptTypeCount = ConceptTypeCount

@typing_extensions.final
class DetailConceptCount(google.protobuf.message.Message):
    """DetailConceptCount"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROCESSED_FIELD_NUMBER: builtins.int
    TO_PROCESS_FIELD_NUMBER: builtins.int
    ERRORS_FIELD_NUMBER: builtins.int
    PROCESSING_FIELD_NUMBER: builtins.int
    @property
    def processed(self) -> global___ConceptTypeCount:
        """The concept count for processed assets"""
    @property
    def to_process(self) -> global___ConceptTypeCount:
        """The concept count for to process assets"""
    @property
    def errors(self) -> global___ConceptTypeCount:
        """The concept count for assets with status error"""
    @property
    def processing(self) -> global___ConceptTypeCount:
        """The concept count for processing assets"""
    def __init__(
        self,
        *,
        processed: global___ConceptTypeCount | None = ...,
        to_process: global___ConceptTypeCount | None = ...,
        errors: global___ConceptTypeCount | None = ...,
        processing: global___ConceptTypeCount | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "errors",
            b"errors",
            "processed",
            b"processed",
            "processing",
            b"processing",
            "to_process",
            b"to_process",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "errors",
            b"errors",
            "processed",
            b"processed",
            "processing",
            b"processing",
            "to_process",
            b"to_process",
        ],
    ) -> None: ...

global___DetailConceptCount = DetailConceptCount

@typing_extensions.final
class ConceptQuery(google.protobuf.message.Message):
    """ConceptQuery"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    LANGUAGE_FIELD_NUMBER: builtins.int
    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    USE_CASES_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    WORKFLOW_FIELD_NUMBER: builtins.int
    IGNORE_APP_CONCEPTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the concept to search."""
    language: builtins.str
    """The language of the concept name in a search. Defaults to English."""
    workflow_id: builtins.str
    """Deprecated: Use workflow.id instead.
    @exclude TODO (EAGLE-4506): Remove this field and associated code
    """
    @property
    def use_cases(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___WorkflowModelUseCase.ValueType
    ]:
        """The concepts must belong to models with specified use cases.
        Multiple values are joined using an OR condition.
        """
    @property
    def model(self) -> global___Model: ...
    @property
    def workflow(self) -> global___Workflow: ...
    ignore_app_concepts: builtins.bool
    """By default, we return app concepts combined with source (model or workflow) concepts.
    If source is not set, then we only return app concepts.
    If ignore_app_concepts is true, then we only return source concepts.
    When use_cases are set, then ignore_app_concepts is always true, because
    concept use cases can only be determined in relation to a model or a workflow.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        language: builtins.str = ...,
        workflow_id: builtins.str = ...,
        use_cases: collections.abc.Iterable[global___WorkflowModelUseCase.ValueType] | None = ...,
        model: global___Model | None = ...,
        workflow: global___Workflow | None = ...,
        ignore_app_concepts: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "model", b"model", "source", b"source", "workflow", b"workflow"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "ignore_app_concepts",
            b"ignore_app_concepts",
            "language",
            b"language",
            "model",
            b"model",
            "name",
            b"name",
            "source",
            b"source",
            "use_cases",
            b"use_cases",
            "workflow",
            b"workflow",
            "workflow_id",
            b"workflow_id",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["source", b"source"]
    ) -> typing_extensions.Literal["model", "workflow"] | None: ...

global___ConceptQuery = ConceptQuery

@typing_extensions.final
class ConceptRelation(google.protobuf.message.Message):
    """This represents a relation (i.e. edge) between the subject concept and the object concept"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    SUBJECT_CONCEPT_FIELD_NUMBER: builtins.int
    OBJECT_CONCEPT_FIELD_NUMBER: builtins.int
    PREDICATE_FIELD_NUMBER: builtins.int
    KNOWLEDGE_GRAPH_ID_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the concept relation"""
    @property
    def subject_concept(self) -> global___Concept:
        """The subject concept (i.e. source) of the concept relation"""
    @property
    def object_concept(self) -> global___Concept:
        """The subject concept (i.e. destination) of the concept relation"""
    predicate: builtins.str
    """The predicate (i.e. edge) linking the subject and the object
    Both subject_concept and object_concept are concepts.
    The predicate is the type of relationship.
    That predicate acts on the subject.

    There are three current types of predicates:
    1) "hyponym"
    2) "hypernym"
    3) "synonym"

    1) For example, 'hyponym' is a type of predicate which represents 'is_a_kind_of' relation so
    the following relationship:
    'honey' (subject), 'hyponym' (predicate), 'food' (object)
    Can more easily be read as:
    'honey' 'is a kind of' 'food'


    2) The 'hypernym' relation is the opposite of 'hyponym' and when you add one of the
    relationships the opposite will automatically appear for you in queries.

    The 'hypernym' can be read as 'is a parent of' so:
    'food' (subject), 'hypernym' (predicate), 'honey' (object)
    Can more easily be read as:
    'food' is a parent of 'honey'

    3) The 'synonym' relation defines two concepts that essential mean the same thing. This
    is more like a "is" relationship. So for example a 'synonym' relationship could be:
    "puppy" is "pup"
    The reverse is also true once the former is added so:
    "pup" is "puppy"
    will appear in queries as well.
    """
    knowledge_graph_id: builtins.str
    """The knowledge graph id that this edge belongs to. If using the app's global knowledge graph
    and not a specific one then this should be the empty string "".
    """
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        subject_concept: global___Concept | None = ...,
        object_concept: global___Concept | None = ...,
        predicate: builtins.str = ...,
        knowledge_graph_id: builtins.str = ...,
        visibility: global___Visibility | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "object_concept",
            b"object_concept",
            "subject_concept",
            b"subject_concept",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "id",
            b"id",
            "knowledge_graph_id",
            b"knowledge_graph_id",
            "object_concept",
            b"object_concept",
            "predicate",
            b"predicate",
            "subject_concept",
            b"subject_concept",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___ConceptRelation = ConceptRelation

@typing_extensions.final
class KnowledgeGraph(google.protobuf.message.Message):
    """A Knowledge Graph is a logical subsets of edges in the overall Concept Graph"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    EXAMPLES_APP_ID_FIELD_NUMBER: builtins.int
    SAMPLED_EXAMPLES_APP_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the knowledge graph"""
    name: builtins.str
    """Name of the knowledge graph"""
    description: builtins.str
    """Human readable description of the knowledge graph"""
    examples_app_id: builtins.str
    """The app that contains the images that correspond to the concepts in the knowledge graph"""
    sampled_examples_app_id: builtins.str
    """The app that contains the sample images that we want to show the customer for the concepts in the knowledge graph"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        examples_app_id: builtins.str = ...,
        sampled_examples_app_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "description",
            b"description",
            "examples_app_id",
            b"examples_app_id",
            "id",
            b"id",
            "name",
            b"name",
            "sampled_examples_app_id",
            b"sampled_examples_app_id",
        ],
    ) -> None: ...

global___KnowledgeGraph = KnowledgeGraph

@typing_extensions.final
class ConceptLanguage(google.protobuf.message.Message):
    """This represents a link to an outside source for the given concept.
    The values from here are sticked into Concept message into the name and definition fields when
    returning from the API in your default language. The "id" field here becomes the "language"
    field of the Concept message which is a little weird.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DEFINITION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """This is the language code for the language such as "en"."""
    name: builtins.str
    """The type of the outside source."""
    definition: builtins.str
    """The ID that is referenced in the source."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        definition: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "definition", b"definition", "id", b"id", "name", b"name"
        ],
    ) -> None: ...

global___ConceptLanguage = ConceptLanguage

@typing_extensions.final
class Data(google.protobuf.message.Message):
    """Data"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_FIELD_NUMBER: builtins.int
    VIDEO_FIELD_NUMBER: builtins.int
    CONCEPTS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    GEO_FIELD_NUMBER: builtins.int
    COLORS_FIELD_NUMBER: builtins.int
    CLUSTERS_FIELD_NUMBER: builtins.int
    EMBEDDINGS_FIELD_NUMBER: builtins.int
    REGIONS_FIELD_NUMBER: builtins.int
    FRAMES_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    AUDIO_FIELD_NUMBER: builtins.int
    TRACKS_FIELD_NUMBER: builtins.int
    TIME_SEGMENTS_FIELD_NUMBER: builtins.int
    HITS_FIELD_NUMBER: builtins.int
    HEATMAPS_FIELD_NUMBER: builtins.int
    PARTS_FIELD_NUMBER: builtins.int
    NDARRAY_FIELD_NUMBER: builtins.int
    INT_VALUE_FIELD_NUMBER: builtins.int
    FLOAT_VALUE_FIELD_NUMBER: builtins.int
    BYTES_VALUE_FIELD_NUMBER: builtins.int
    BOOL_VALUE_FIELD_NUMBER: builtins.int
    STRING_VALUE_FIELD_NUMBER: builtins.int
    @property
    def image(self) -> global___Image:
        """Input and output images."""
    @property
    def video(self) -> global___Video:
        """Input and output videos."""
    @property
    def concepts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Concept]:
        """A list of concepts."""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    @property
    def geo(self) -> global___Geo:
        """Geography information."""
    @property
    def colors(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Color]:
        """The dominant colors within an image."""
    @property
    def clusters(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Cluster]:
        """Clustering centroids for inputs."""
    @property
    def embeddings(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Embedding]:
        """Embedding vectors representing each input."""
    @property
    def regions(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Region]:
        """For recursing into localized regions of an input."""
    @property
    def frames(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Frame]:
        """For temporal content like video."""
    @property
    def text(self) -> global___Text:
        """Input, output or annotation text."""
    @property
    def audio(self) -> global___Audio:
        """Input and output audio."""
    @property
    def tracks(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Track]:
        """Track information."""
    @property
    def time_segments(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TimeSegment]:
        """Time segments information."""
    @property
    def hits(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Hit]:
        """Holds score, rank, and user, app, input IDs and search hit data"""
    @property
    def heatmaps(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Image]:
        """Heatmap as 2d image"""
    @property
    def parts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Part]:
        """For data messages that have multiple parts such as multi-modal
        requests, we allow you to specify those as a list of Data objects.
        """
    @property
    def ndarray(self) -> global___NDArray:
        """A proto representation for numpy arrays, useful to pass information from python SDK to a
        python based model implementation.
        """
    int_value: builtins.int
    """Input and output integer number"""
    float_value: builtins.float
    """Input and output floating number"""
    bytes_value: builtins.bytes
    """Input and output bytes data"""
    bool_value: builtins.bool
    """Input and output bool data"""
    string_value: builtins.str
    """Input and output string data"""
    def __init__(
        self,
        *,
        image: global___Image | None = ...,
        video: global___Video | None = ...,
        concepts: collections.abc.Iterable[global___Concept] | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        geo: global___Geo | None = ...,
        colors: collections.abc.Iterable[global___Color] | None = ...,
        clusters: collections.abc.Iterable[global___Cluster] | None = ...,
        embeddings: collections.abc.Iterable[global___Embedding] | None = ...,
        regions: collections.abc.Iterable[global___Region] | None = ...,
        frames: collections.abc.Iterable[global___Frame] | None = ...,
        text: global___Text | None = ...,
        audio: global___Audio | None = ...,
        tracks: collections.abc.Iterable[global___Track] | None = ...,
        time_segments: collections.abc.Iterable[global___TimeSegment] | None = ...,
        hits: collections.abc.Iterable[global___Hit] | None = ...,
        heatmaps: collections.abc.Iterable[global___Image] | None = ...,
        parts: collections.abc.Iterable[global___Part] | None = ...,
        ndarray: global___NDArray | None = ...,
        int_value: builtins.int = ...,
        float_value: builtins.float = ...,
        bytes_value: builtins.bytes = ...,
        bool_value: builtins.bool = ...,
        string_value: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "audio",
            b"audio",
            "geo",
            b"geo",
            "image",
            b"image",
            "metadata",
            b"metadata",
            "ndarray",
            b"ndarray",
            "text",
            b"text",
            "video",
            b"video",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "audio",
            b"audio",
            "bool_value",
            b"bool_value",
            "bytes_value",
            b"bytes_value",
            "clusters",
            b"clusters",
            "colors",
            b"colors",
            "concepts",
            b"concepts",
            "embeddings",
            b"embeddings",
            "float_value",
            b"float_value",
            "frames",
            b"frames",
            "geo",
            b"geo",
            "heatmaps",
            b"heatmaps",
            "hits",
            b"hits",
            "image",
            b"image",
            "int_value",
            b"int_value",
            "metadata",
            b"metadata",
            "ndarray",
            b"ndarray",
            "parts",
            b"parts",
            "regions",
            b"regions",
            "string_value",
            b"string_value",
            "text",
            b"text",
            "time_segments",
            b"time_segments",
            "tracks",
            b"tracks",
            "video",
            b"video",
        ],
    ) -> None: ...

global___Data = Data

@typing_extensions.final
class Part(google.protobuf.message.Message):
    """A part of data used for multi-modal processing."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    @property
    def data(self) -> global___Data:
        """The data for this part."""
    id: builtins.str
    """A unique id for the part."""
    def __init__(
        self,
        *,
        data: global___Data | None = ...,
        id: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["data", b"data"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["data", b"data", "id", b"id"]
    ) -> None: ...

global___Part = Part

@typing_extensions.final
class Region(google.protobuf.message.Message):
    """A region within the data."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    REGION_INFO_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    TRACK_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """A unique id for the region."""
    @property
    def region_info(self) -> global___RegionInfo:
        """The details about the location of the region."""
    @property
    def data(self) -> global___Data:
        """A recursive definition of the data within the Region. For example, this will contain
        data.concepts if the region also has annotations or predictions of concepts within it.
        """
    value: builtins.float
    """This is the confidence score of the overall Region."""
    track_id: builtins.str
    """For tracking algorithsm and annotations we tie regions together with this track id."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        region_info: global___RegionInfo | None = ...,
        data: global___Data | None = ...,
        value: builtins.float = ...,
        track_id: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["data", b"data", "region_info", b"region_info"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "data",
            b"data",
            "id",
            b"id",
            "region_info",
            b"region_info",
            "track_id",
            b"track_id",
            "value",
            b"value",
        ],
    ) -> None: ...

global___Region = Region

@typing_extensions.final
class RegionInfo(google.protobuf.message.Message):
    """The information of the location of the Region."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BOUNDING_BOX_FIELD_NUMBER: builtins.int
    MASK_FIELD_NUMBER: builtins.int
    POLYGON_FIELD_NUMBER: builtins.int
    POINT_FIELD_NUMBER: builtins.int
    SPAN_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    KEYPOINT_LOCATIONS_FIELD_NUMBER: builtins.int
    @property
    def bounding_box(self) -> global___BoundingBox:
        """Details of the region's rectangular bounding box."""
    @property
    def mask(self) -> global___Mask:
        """Details of the region's segmentation mask."""
    @property
    def polygon(self) -> global___Polygon:
        """A polygon of points."""
    @property
    def point(self) -> global___Point:
        """A landmark point location."""
    @property
    def span(self) -> global___Span:
        """Span char sequence for NLP."""
    @property
    def token(self) -> global___Token:
        """Token char sequence for NLP."""
    @property
    def keypoint_locations(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Point]:
        """The locations of detected keypoints, which are to be used in conjunction with the detected concept's skeleton to connect the keypoint locations.
        These will be in the same order as the respective keypoint_names inside the concept.
        """
    def __init__(
        self,
        *,
        bounding_box: global___BoundingBox | None = ...,
        mask: global___Mask | None = ...,
        polygon: global___Polygon | None = ...,
        point: global___Point | None = ...,
        span: global___Span | None = ...,
        token: global___Token | None = ...,
        keypoint_locations: collections.abc.Iterable[global___Point] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "bounding_box",
            b"bounding_box",
            "mask",
            b"mask",
            "point",
            b"point",
            "polygon",
            b"polygon",
            "span",
            b"span",
            "token",
            b"token",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "bounding_box",
            b"bounding_box",
            "keypoint_locations",
            b"keypoint_locations",
            "mask",
            b"mask",
            "point",
            b"point",
            "polygon",
            b"polygon",
            "span",
            b"span",
            "token",
            b"token",
        ],
    ) -> None: ...

global___RegionInfo = RegionInfo

@typing_extensions.final
class BoundingBox(google.protobuf.message.Message):
    """Rectangular bounding box for a region."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOP_ROW_FIELD_NUMBER: builtins.int
    LEFT_COL_FIELD_NUMBER: builtins.int
    BOTTOM_ROW_FIELD_NUMBER: builtins.int
    RIGHT_COL_FIELD_NUMBER: builtins.int
    top_row: builtins.float
    """The top left of the bounding box normalized to the data dimension to be within [0-1.0]"""
    left_col: builtins.float
    """The left column of the bounding box normalized to the data dimension to be within [0-1.0]"""
    bottom_row: builtins.float
    """The bottom row of the bounding box normalized to the data dimension to be within [0-1.0]"""
    right_col: builtins.float
    """The right col of the bounding box normalized to the data dimension to be within [0-1.0]"""
    def __init__(
        self,
        *,
        top_row: builtins.float = ...,
        left_col: builtins.float = ...,
        bottom_row: builtins.float = ...,
        right_col: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "bottom_row",
            b"bottom_row",
            "left_col",
            b"left_col",
            "right_col",
            b"right_col",
            "top_row",
            b"top_row",
        ],
    ) -> None: ...

global___BoundingBox = BoundingBox

@typing_extensions.final
class FrameInfo(google.protobuf.message.Message):
    """The information of the location of the Frame."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INDEX_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    index: builtins.int
    """Deprecated. Use Time instead.
    The index of the frame, informational and optional.
    Depends on the sampling rate used during processing
    May be 0 for interpolated frames that are generated for brief time (training) or if new frame is manually added
    """
    time: builtins.int
    """time in the video in milliseconds. This is independent of the sampling rates used during
    processing.
    """
    def __init__(
        self,
        *,
        index: builtins.int = ...,
        time: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["index", b"index", "time", b"time"]
    ) -> None: ...

global___FrameInfo = FrameInfo

@typing_extensions.final
class Frame(google.protobuf.message.Message):
    """A Frame of time-series Data such as a Video."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FRAME_INFO_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    @property
    def frame_info(self) -> global___FrameInfo:
        """Information aboue frame such as number and time."""
    @property
    def data(self) -> global___Data:
        """A recursive definition of the data within the Frame. For example, this will contain
        data.concepts if the Frame also has annotations or predictions of concepts within it.
        This can also have data.regions for annotation or predictions of detection regions, which can
        then recursively have their data field filled in as well.
        """
    id: builtins.str
    """An ID for the frame."""
    def __init__(
        self,
        *,
        frame_info: global___FrameInfo | None = ...,
        data: global___Data | None = ...,
        id: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["data", b"data", "frame_info", b"frame_info"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "data", b"data", "frame_info", b"frame_info", "id", b"id"
        ],
    ) -> None: ...

global___Frame = Frame

@typing_extensions.final
class NDArray(google.protobuf.message.Message):
    """A representation of a numpy array as a proto.
    To convert a numpy array 'ndarray' to this proto do:
    NDArray(buffer=ndarray.tobytes(), shape=ndarray.shape, dtype=str(ndarray.dtype))

    To convert this proto 'ndarray_proto' to a numpy array:
    array = np.frombuffer(ndarray_proto.buffer, dtype=ndarray_proto.dtype)
    array = array.reshape(tuple(ndarray_proto.shape))
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUFFER_FIELD_NUMBER: builtins.int
    SHAPE_FIELD_NUMBER: builtins.int
    DTYPE_FIELD_NUMBER: builtins.int
    buffer: builtins.bytes
    """The bytes of data from the array from array.tobytes()"""
    @property
    def shape(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Simply the shape of the numpy array. array.shape."""
    dtype: builtins.str
    """Dtype for numpy. You can get it back from this string format using:
    np.dtype('float32') for example.
    """
    def __init__(
        self,
        *,
        buffer: builtins.bytes = ...,
        shape: collections.abc.Iterable[builtins.int] | None = ...,
        dtype: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "buffer", b"buffer", "dtype", b"dtype", "shape", b"shape"
        ],
    ) -> None: ...

global___NDArray = NDArray

@typing_extensions.final
class Mask(google.protobuf.message.Message):
    """Segmentation mask."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_FIELD_NUMBER: builtins.int
    @property
    def image(self) -> global___Image:
        """The image of the mask in a non-raster format."""
    def __init__(
        self,
        *,
        image: global___Image | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["image", b"image"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["image", b"image"]) -> None: ...

global___Mask = Mask

@typing_extensions.final
class Polygon(google.protobuf.message.Message):
    """Polygon"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POINTS_FIELD_NUMBER: builtins.int
    @property
    def points(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Point]:
        """A list of points connected together to form the polygon."""
    def __init__(
        self,
        *,
        points: collections.abc.Iterable[global___Point] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["points", b"points"]) -> None: ...

global___Polygon = Polygon

@typing_extensions.final
class Point(google.protobuf.message.Message):
    """Point"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Visibility:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _VisibilityEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Point._Visibility.ValueType],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NOT_SET: Point._Visibility.ValueType  # 0
        """Visibility of the point is not set"""
        VISIBLE: Point._Visibility.ValueType  # 1
        """Point is visible"""
        NOT_VISIBLE: Point._Visibility.ValueType  # 2
        """Point is occluded"""
        NOT_PRESENT: Point._Visibility.ValueType  # 3
        """Point is not in the image"""

    class Visibility(_Visibility, metaclass=_VisibilityEnumTypeWrapper):
        """Whether this point is visible or occluded"""

    NOT_SET: Point.Visibility.ValueType  # 0
    """Visibility of the point is not set"""
    VISIBLE: Point.Visibility.ValueType  # 1
    """Point is visible"""
    NOT_VISIBLE: Point.Visibility.ValueType  # 2
    """Point is occluded"""
    NOT_PRESENT: Point.Visibility.ValueType  # 3
    """Point is not in the image"""

    ROW_FIELD_NUMBER: builtins.int
    COL_FIELD_NUMBER: builtins.int
    Z_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    row: builtins.float
    """The row location of the point. This has a [0.0-1.0] range with 0.0 being top row and 1.0
    being the bottom row.
    """
    col: builtins.float
    """The column location of the point. This has a [0.0-1.0] range with 0.0 being left col and 1.0
    being the right col.
    """
    z: builtins.float
    """Depth if applicable for the point."""
    visibility: global___Point.Visibility.ValueType
    def __init__(
        self,
        *,
        row: builtins.float = ...,
        col: builtins.float = ...,
        z: builtins.float = ...,
        visibility: global___Point.Visibility.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "col", b"col", "row", b"row", "visibility", b"visibility", "z", b"z"
        ],
    ) -> None: ...

global___Point = Point

@typing_extensions.final
class Span(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAR_START_FIELD_NUMBER: builtins.int
    CHAR_END_FIELD_NUMBER: builtins.int
    RAW_TEXT_FIELD_NUMBER: builtins.int
    char_start: builtins.int
    char_end: builtins.int
    raw_text: builtins.str
    def __init__(
        self,
        *,
        char_start: builtins.int = ...,
        char_end: builtins.int = ...,
        raw_text: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "char_end", b"char_end", "char_start", b"char_start", "raw_text", b"raw_text"
        ],
    ) -> None: ...

global___Span = Span

@typing_extensions.final
class Token(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAR_START_FIELD_NUMBER: builtins.int
    CHAR_END_FIELD_NUMBER: builtins.int
    RAW_TEXT_FIELD_NUMBER: builtins.int
    char_start: builtins.int
    char_end: builtins.int
    raw_text: builtins.str
    def __init__(
        self,
        *,
        char_start: builtins.int = ...,
        char_end: builtins.int = ...,
        raw_text: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "char_end", b"char_end", "char_start", b"char_start", "raw_text", b"raw_text"
        ],
    ) -> None: ...

global___Token = Token

@typing_extensions.final
class Embedding(google.protobuf.message.Message):
    """Embedding"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VECTOR_FIELD_NUMBER: builtins.int
    NUM_DIMENSIONS_FIELD_NUMBER: builtins.int
    @property
    def vector(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    num_dimensions: builtins.int
    def __init__(
        self,
        *,
        vector: collections.abc.Iterable[builtins.float] | None = ...,
        num_dimensions: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "num_dimensions", b"num_dimensions", "vector", b"vector"
        ],
    ) -> None: ...

global___Embedding = Embedding

@typing_extensions.final
class GeoPoint(google.protobuf.message.Message):
    """GeoPoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LONGITUDE_FIELD_NUMBER: builtins.int
    LATITUDE_FIELD_NUMBER: builtins.int
    longitude: builtins.float
    latitude: builtins.float
    def __init__(
        self,
        *,
        longitude: builtins.float = ...,
        latitude: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["latitude", b"latitude", "longitude", b"longitude"],
    ) -> None: ...

global___GeoPoint = GeoPoint

@typing_extensions.final
class GeoLimit(google.protobuf.message.Message):
    """GeoLimit"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    type: builtins.str
    value: builtins.float
    def __init__(
        self,
        *,
        type: builtins.str = ...,
        value: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["type", b"type", "value", b"value"]
    ) -> None: ...

global___GeoLimit = GeoLimit

@typing_extensions.final
class GeoBoxedPoint(google.protobuf.message.Message):
    """GeoBoxedPoint"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEO_POINT_FIELD_NUMBER: builtins.int
    @property
    def geo_point(self) -> global___GeoPoint: ...
    def __init__(
        self,
        *,
        geo_point: global___GeoPoint | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["geo_point", b"geo_point"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["geo_point", b"geo_point"]
    ) -> None: ...

global___GeoBoxedPoint = GeoBoxedPoint

@typing_extensions.final
class Geo(google.protobuf.message.Message):
    """Geo"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEO_POINT_FIELD_NUMBER: builtins.int
    GEO_LIMIT_FIELD_NUMBER: builtins.int
    GEO_BOX_FIELD_NUMBER: builtins.int
    @property
    def geo_point(self) -> global___GeoPoint: ...
    @property
    def geo_limit(self) -> global___GeoLimit: ...
    @property
    def geo_box(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___GeoBoxedPoint
    ]:
        """NOTE: inconsistency: should have been geo_boxed_points"""
    def __init__(
        self,
        *,
        geo_point: global___GeoPoint | None = ...,
        geo_limit: global___GeoLimit | None = ...,
        geo_box: collections.abc.Iterable[global___GeoBoxedPoint] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "geo_limit", b"geo_limit", "geo_point", b"geo_point"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "geo_box", b"geo_box", "geo_limit", b"geo_limit", "geo_point", b"geo_point"
        ],
    ) -> None: ...

global___Geo = Geo

@typing_extensions.final
class Image(google.protobuf.message.Message):
    """Image"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class HostedImageInfoEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ImageInfo: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ImageInfo | None = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    URL_FIELD_NUMBER: builtins.int
    BASE64_FIELD_NUMBER: builtins.int
    ALLOW_DUPLICATE_URL_FIELD_NUMBER: builtins.int
    HOSTED_FIELD_NUMBER: builtins.int
    IMAGE_INFO_FIELD_NUMBER: builtins.int
    HOSTED_IMAGE_INFO_FIELD_NUMBER: builtins.int
    DECODED_BYTES_FIELD_NUMBER: builtins.int
    url: builtins.str
    """This is a URL to a publicly accessible image file. The platform will download this file server
    side and then process.
    """
    base64: builtins.bytes
    """The base64 field is using image file bytes directly in the request.
    NOTE: if you're sending a json request, then this MUST be base64 encoded before sending (hence
    the name here).
    When using our grpc clients, you DO NOT need to base64 encode
    it yourself since the clients know how to do this for you automatically and will avoid the
    base64 encoding if they send a binary request.
    """
    allow_duplicate_url: builtins.bool
    @property
    def hosted(self) -> global___HostedURL:
        """The hosted field lists images in different sizes hosted in Clarifai storage."""
    @property
    def image_info(self) -> global___ImageInfo:
        """image info for original size. for image info for other sizes, use hosted_image_info"""
    @property
    def hosted_image_info(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ImageInfo]:
        """The map of hosted image info of different sizes (see hosted.sizes), excluding the original image.
        Note: keys(hosted_image_info) = hosted.sizes - "orig"
        """
    decoded_bytes: builtins.bytes
    """For internal processing of already decoded bytes."""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
        base64: builtins.bytes = ...,
        allow_duplicate_url: builtins.bool = ...,
        hosted: global___HostedURL | None = ...,
        image_info: global___ImageInfo | None = ...,
        hosted_image_info: collections.abc.Mapping[builtins.str, global___ImageInfo] | None = ...,
        decoded_bytes: builtins.bytes = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal["hosted", b"hosted", "image_info", b"image_info"],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "allow_duplicate_url",
            b"allow_duplicate_url",
            "base64",
            b"base64",
            "decoded_bytes",
            b"decoded_bytes",
            "hosted",
            b"hosted",
            "hosted_image_info",
            b"hosted_image_info",
            "image_info",
            b"image_info",
            "url",
            b"url",
        ],
    ) -> None: ...

global___Image = Image

@typing_extensions.final
class ImageInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WIDTH_FIELD_NUMBER: builtins.int
    HEIGHT_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    COLOR_MODE_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    width: builtins.int
    """width"""
    height: builtins.int
    """height"""
    format: builtins.str
    """image format"""
    color_mode: builtins.str
    """image color mode"""
    mode: builtins.str
    """mode (when used for decoded_bytes) (RGB, RGBA, P, L, etc.)"""
    def __init__(
        self,
        *,
        width: builtins.int = ...,
        height: builtins.int = ...,
        format: builtins.str = ...,
        color_mode: builtins.str = ...,
        mode: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "color_mode",
            b"color_mode",
            "format",
            b"format",
            "height",
            b"height",
            "mode",
            b"mode",
            "width",
            b"width",
        ],
    ) -> None: ...

global___ImageInfo = ImageInfo

@typing_extensions.final
class HostedURL(google.protobuf.message.Message):
    """HostedURL"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREFIX_FIELD_NUMBER: builtins.int
    SUFFIX_FIELD_NUMBER: builtins.int
    SIZES_FIELD_NUMBER: builtins.int
    CROSSORIGIN_FIELD_NUMBER: builtins.int
    prefix: builtins.str
    """Prefix of the URL of every hosted image."""
    suffix: builtins.str
    """Suffix of an image stored in different sizes."""
    @property
    def sizes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The sizes field lists which images of the different sizes are hosted in our storage. The URL
        of each hosted image can be obtained by joining the prefix, one of the sizes and suffix.
        """
    crossorigin: builtins.str
    """The crossorigin property of html media tag
    For Secure Data Hosting this needs to be set to 'use-credentials'
    """
    def __init__(
        self,
        *,
        prefix: builtins.str = ...,
        suffix: builtins.str = ...,
        sizes: collections.abc.Iterable[builtins.str] | None = ...,
        crossorigin: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "crossorigin",
            b"crossorigin",
            "prefix",
            b"prefix",
            "sizes",
            b"sizes",
            "suffix",
            b"suffix",
        ],
    ) -> None: ...

global___HostedURL = HostedURL

@typing_extensions.final
class Input(google.protobuf.message.Message):
    """Input"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    DATASET_IDS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID for the input"""
    @property
    def data(self) -> global___Data:
        """The data passed along in this input."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the input was created. We follow the XXXX timestamp
        format. We use https://www.ietf.org/rfc/rfc3339.txt format:
        "2006-01-02T15:04:05.999999Z" so you can expect results like
        the following from the API:
        "2017-04-11T21:50:50.223962Z"
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the input was modified."""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """This is the status at a per Input level which allows for
        partial failures.
        """
    @property
    def dataset_ids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of dataset IDs that this input is part of
        Currently, this field is ONLY used to
        * search inputs part of dataset(s), e.g. in `PostSearches`, `PostInputsSearches` and `PostAnnotationsSearches` endpoints, and
        * to add inputs to dataset(s) in `PostInputs` endpoint.
        Note that this field is ignored for other endpoints, e.g. `GetInput`, `ListInputs` and `PatchInputs`.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        data: global___Data | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        dataset_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "data",
            b"data",
            "modified_at",
            b"modified_at",
            "status",
            b"status",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "data",
            b"data",
            "dataset_ids",
            b"dataset_ids",
            "id",
            b"id",
            "modified_at",
            b"modified_at",
            "status",
            b"status",
        ],
    ) -> None: ...

global___Input = Input

@typing_extensions.final
class InputBatch(google.protobuf.message.Message):
    """InputBatch is a batch of Input resources. Large amounts of inputs are usually
    divided into multiple InputBatches.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUTS_FIELD_NUMBER: builtins.int
    @property
    def inputs(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Input]: ...
    def __init__(
        self,
        *,
        inputs: collections.abc.Iterable[global___Input] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputs", b"inputs"]) -> None: ...

global___InputBatch = InputBatch

@typing_extensions.final
class InputCount(google.protobuf.message.Message):
    """NOTE: inconsistency: this is weird mix of plural and singular words."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROCESSED_FIELD_NUMBER: builtins.int
    TO_PROCESS_FIELD_NUMBER: builtins.int
    ERRORS_FIELD_NUMBER: builtins.int
    PROCESSING_FIELD_NUMBER: builtins.int
    REINDEXED_FIELD_NUMBER: builtins.int
    TO_REINDEX_FIELD_NUMBER: builtins.int
    REINDEX_ERRORS_FIELD_NUMBER: builtins.int
    REINDEXING_FIELD_NUMBER: builtins.int
    processed: builtins.int
    to_process: builtins.int
    errors: builtins.int
    processing: builtins.int
    reindexed: builtins.int
    to_reindex: builtins.int
    reindex_errors: builtins.int
    reindexing: builtins.int
    def __init__(
        self,
        *,
        processed: builtins.int = ...,
        to_process: builtins.int = ...,
        errors: builtins.int = ...,
        processing: builtins.int = ...,
        reindexed: builtins.int = ...,
        to_reindex: builtins.int = ...,
        reindex_errors: builtins.int = ...,
        reindexing: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "errors",
            b"errors",
            "processed",
            b"processed",
            "processing",
            b"processing",
            "reindex_errors",
            b"reindex_errors",
            "reindexed",
            b"reindexed",
            "reindexing",
            b"reindexing",
            "to_process",
            b"to_process",
            "to_reindex",
            b"to_reindex",
        ],
    ) -> None: ...

global___InputCount = InputCount

@typing_extensions.final
class Dataset(google.protobuf.message.Message):
    """Dataset"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    DEFAULT_ANNOTATION_FILTER_FIELD_NUMBER: builtins.int
    DEFAULT_PROCESSING_INFO_FIELD_NUMBER: builtins.int
    NOTES_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    IS_STARRED_FIELD_NUMBER: builtins.int
    STAR_COUNT_FIELD_NUMBER: builtins.int
    BOOKMARK_ORIGIN_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID for the dataset"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the dataset was created.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the dataset was modified.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    app_id: builtins.str
    """The app the dataset belongs to."""
    user_id: builtins.str
    """The user the dataset belongs to."""
    description: builtins.str
    """Description of the dataset"""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    @property
    def default_annotation_filter(self) -> global___AnnotationFilter:
        """Default annotation filter used for this dataset."""
    @property
    def default_processing_info(self) -> global___DatasetVersionProcessingInfo:
        """Default processing info used for this dataset."""
    notes: builtins.str
    """Notes for the dataset
    This field should be used for in-depth notes and supports up to 64Kbs.
    """
    @property
    def version(self) -> global___DatasetVersion:
        """Dataset version associated with this dataset. This is used in listing Datasets
        and including the latest version.
        """
    is_starred: builtins.bool
    """Whether the dataset is starred by the requesting user."""
    star_count: builtins.int
    """Number of users that starred this dataset."""
    @property
    def bookmark_origin(self) -> global___BookmarkOrigin:
        """bookmark info. When set, this dataset is a bookmarked dataset of this app.
        Info in this field will allow you to find/access original dataset.
        """
    @property
    def image(self) -> global___Image:
        """Representative image for this dataset"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        app_id: builtins.str = ...,
        user_id: builtins.str = ...,
        description: builtins.str = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        visibility: global___Visibility | None = ...,
        default_annotation_filter: global___AnnotationFilter | None = ...,
        default_processing_info: global___DatasetVersionProcessingInfo | None = ...,
        notes: builtins.str = ...,
        version: global___DatasetVersion | None = ...,
        is_starred: builtins.bool = ...,
        star_count: builtins.int = ...,
        bookmark_origin: global___BookmarkOrigin | None = ...,
        image: global___Image | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "bookmark_origin",
            b"bookmark_origin",
            "created_at",
            b"created_at",
            "default_annotation_filter",
            b"default_annotation_filter",
            "default_processing_info",
            b"default_processing_info",
            "image",
            b"image",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "version",
            b"version",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "bookmark_origin",
            b"bookmark_origin",
            "created_at",
            b"created_at",
            "default_annotation_filter",
            b"default_annotation_filter",
            "default_processing_info",
            b"default_processing_info",
            "description",
            b"description",
            "id",
            b"id",
            "image",
            b"image",
            "is_starred",
            b"is_starred",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "notes",
            b"notes",
            "star_count",
            b"star_count",
            "user_id",
            b"user_id",
            "version",
            b"version",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___Dataset = Dataset

@typing_extensions.final
class AnnotationFilter(google.protobuf.message.Message):
    """AnnotationFilter is used to create a new dataset version.
    For now, the filter is simply a wrapper over a Search.
    In the future, we may add extra fields to customize the filtering.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    SEARCH_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID for the annotation filter"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the annotation filter was created.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the annotation filter was modified.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    user_id: builtins.str
    """The user the annotation filter belongs to."""
    app_id: builtins.str
    """The app the annotation filter belongs to."""
    @property
    def search(self) -> global___Search:
        """The search that this filter uses."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        user_id: builtins.str = ...,
        app_id: builtins.str = ...,
        search: global___Search | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at", b"created_at", "modified_at", b"modified_at", "search", b"search"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "created_at",
            b"created_at",
            "id",
            b"id",
            "modified_at",
            b"modified_at",
            "search",
            b"search",
            "user_id",
            b"user_id",
        ],
    ) -> None: ...

global___AnnotationFilter = AnnotationFilter

@typing_extensions.final
class DatasetInput(google.protobuf.message.Message):
    """DatasetInput"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATED_AT_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the input was added to the dataset.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def input(self) -> global___Input:
        """The input data."""
    def __init__(
        self,
        *,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        input: global___Input | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["created_at", b"created_at", "input", b"input"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["created_at", b"created_at", "input", b"input"]
    ) -> None: ...

global___DatasetInput = DatasetInput

@typing_extensions.final
class DatasetVersion(google.protobuf.message.Message):
    """DatasetVersion"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class MetricsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___DatasetVersionMetrics: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___DatasetVersionMetrics | None = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    DATASET_ID_FIELD_NUMBER: builtins.int
    ANNOTATION_FILTER_CONFIG_FIELD_NUMBER: builtins.int
    MODEL_PREDICT_CONFIG_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PROCESSING_INFO_FIELD_NUMBER: builtins.int
    METRICS_FIELD_NUMBER: builtins.int
    EXPORT_INFO_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    EMBED_MODEL_VERSION_IDS_FIELD_NUMBER: builtins.int
    REQUEST_ORIGIN_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID for the dataset version"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the dataset version was created.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the dataset version was modified.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    app_id: builtins.str
    """The app the dataset version belongs to."""
    user_id: builtins.str
    """The user the dataset version belongs to."""
    dataset_id: builtins.str
    """The dataset the dataset version belongs to."""
    @property
    def annotation_filter_config(self) -> global___AnnotationFilterConfig:
        """The dataset version will be generated based on a single annotation filter."""
    @property
    def model_predict_config(self) -> global___ModelPredictConfig:
        """The dataset version will be generated based on model version inferences."""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """Status for this dataset version."""
    description: builtins.str
    """Description of the dataset version"""
    @property
    def processing_info(self) -> global___DatasetVersionProcessingInfo:
        """Dataset version processing. If this is not set when the dataset version is
        created, then the dataset default_processing_info is copied instead. Later
        updates to default_processing_info will not apply to existing versions.
        """
    @property
    def metrics(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[
        builtins.str, global___DatasetVersionMetrics
    ]:
        """Dataset version metrics"""
    @property
    def export_info(self) -> global___DatasetVersionExportInfo:
        """Dataset version exports"""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    @property
    def embed_model_version_ids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The embedding models to return embeddings for. If empty, no embeddings are returned."""
    request_origin: global___DatasetVersionRequestOrigin.ValueType
    """Read Only. Cannot be Set
    Origin of request for new dataset version
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        app_id: builtins.str = ...,
        user_id: builtins.str = ...,
        dataset_id: builtins.str = ...,
        annotation_filter_config: global___AnnotationFilterConfig | None = ...,
        model_predict_config: global___ModelPredictConfig | None = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        description: builtins.str = ...,
        processing_info: global___DatasetVersionProcessingInfo | None = ...,
        metrics: collections.abc.Mapping[builtins.str, global___DatasetVersionMetrics]
        | None = ...,
        export_info: global___DatasetVersionExportInfo | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        visibility: global___Visibility | None = ...,
        embed_model_version_ids: collections.abc.Iterable[builtins.str] | None = ...,
        request_origin: global___DatasetVersionRequestOrigin.ValueType = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "annotation_filter_config",
            b"annotation_filter_config",
            "created_at",
            b"created_at",
            "data_config",
            b"data_config",
            "export_info",
            b"export_info",
            "metadata",
            b"metadata",
            "model_predict_config",
            b"model_predict_config",
            "modified_at",
            b"modified_at",
            "processing_info",
            b"processing_info",
            "status",
            b"status",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "annotation_filter_config",
            b"annotation_filter_config",
            "app_id",
            b"app_id",
            "created_at",
            b"created_at",
            "data_config",
            b"data_config",
            "dataset_id",
            b"dataset_id",
            "description",
            b"description",
            "embed_model_version_ids",
            b"embed_model_version_ids",
            "export_info",
            b"export_info",
            "id",
            b"id",
            "metadata",
            b"metadata",
            "metrics",
            b"metrics",
            "model_predict_config",
            b"model_predict_config",
            "modified_at",
            b"modified_at",
            "processing_info",
            b"processing_info",
            "request_origin",
            b"request_origin",
            "status",
            b"status",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["data_config", b"data_config"]
    ) -> typing_extensions.Literal["annotation_filter_config", "model_predict_config"] | None: ...

global___DatasetVersion = DatasetVersion

@typing_extensions.final
class AnnotationFilterConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ANNOTATION_FILTER_FIELD_NUMBER: builtins.int
    IGNORE_EMPTY_INPUTS_FIELD_NUMBER: builtins.int
    @property
    def annotation_filter(self) -> global___AnnotationFilter:
        """The annotation filter that is used."""
    ignore_empty_inputs: builtins.bool
    """If true, empty inputs are not included in the dataset version.
    If false, empty inputs are included in the dataset version.
    We define an empty input as an input without any annotations after annotation filter is applied.
    """
    def __init__(
        self,
        *,
        annotation_filter: global___AnnotationFilter | None = ...,
        ignore_empty_inputs: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["annotation_filter", b"annotation_filter"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "annotation_filter",
            b"annotation_filter",
            "ignore_empty_inputs",
            b"ignore_empty_inputs",
        ],
    ) -> None: ...

global___AnnotationFilterConfig = AnnotationFilterConfig

@typing_extensions.final
class ModelPredictConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    @property
    def model(self) -> global___Model:
        """Assumed to be owned by the calling users app unless user_id and app_id are filled out."""
    def __init__(
        self,
        *,
        model: global___Model | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["model", b"model"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model"]) -> None: ...

global___ModelPredictConfig = ModelPredictConfig

@typing_extensions.final
class DatasetVersionMetrics(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUTS_COUNT_FIELD_NUMBER: builtins.int
    UNLABELED_INPUTS_COUNT_FIELD_NUMBER: builtins.int
    INPUTS_WITH_METADATA_COUNT_FIELD_NUMBER: builtins.int
    INPUTS_WITH_GEO_COUNT_FIELD_NUMBER: builtins.int
    REGIONS_COUNT_FIELD_NUMBER: builtins.int
    REGION_LOCATION_MATRIX_FIELD_NUMBER: builtins.int
    BOUNDING_BOXES_COUNT_FIELD_NUMBER: builtins.int
    POLYGONS_COUNT_FIELD_NUMBER: builtins.int
    POINTS_COUNT_FIELD_NUMBER: builtins.int
    MASKS_COUNT_FIELD_NUMBER: builtins.int
    REGION_INPUTS_COUNT_FIELD_NUMBER: builtins.int
    REGION_FRAMES_COUNT_FIELD_NUMBER: builtins.int
    FRAMES_COUNT_FIELD_NUMBER: builtins.int
    FRAME_INPUTS_COUNT_FIELD_NUMBER: builtins.int
    EMBEDDINGS_COUNT_FIELD_NUMBER: builtins.int
    POSITIVE_INPUT_TAGS_COUNT_FIELD_NUMBER: builtins.int
    POSITIVE_REGION_TAGS_COUNT_FIELD_NUMBER: builtins.int
    POSITIVE_FRAME_TAGS_COUNT_FIELD_NUMBER: builtins.int
    @property
    def inputs_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of inputs"""
    @property
    def unlabeled_inputs_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of unlabeled inputs
        An input is considered unlabeled if it there are no annotations with positive labels for that input.
        """
    @property
    def inputs_with_metadata_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of inputs that have metadata"""
    @property
    def inputs_with_geo_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of inputs that have geo information"""
    @property
    def regions_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of regions"""
    @property
    def region_location_matrix(self) -> proto.clarifai.api.utils.matrix_pb2.MatrixUint64:
        """The matrix shows where the regions are located.
        Example: If the matrix has 2x2 dimensions, then
        * region_location_matrix[0][0] = the number of regions that appear in the top left corner, i.e. [0,0]..(0.5,0.5)
        * region_location_matrix[0][1] = the number of regions that appear in the top right corner, i.e. [0,0.5]..[0.5,1]
        * region_location_matrix[1][0] = the number of regions that appear in the bottom left corner, i.e. [0.5,0]..[1,0.5)
        * region_location_matrix[1][1] = the number of regions that appear in the bottom right corner, i.e. [0.5,0.5]..[1,1]
        """
    @property
    def bounding_boxes_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of bounding boxes"""
    @property
    def polygons_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of polygons"""
    @property
    def points_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of points"""
    @property
    def masks_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of masks"""
    @property
    def region_inputs_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of inputs that have regions attached
        Note that this is not a recursive count: if an input contains frames that contains regions, then the region_frames_count is increased, but region_inputs_count is not increased.
        """
    @property
    def region_frames_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of frames that have regions attached"""
    @property
    def frames_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of frames"""
    @property
    def frame_inputs_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of inputs that have frames attached"""
    @property
    def embeddings_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of embeddings"""
    @property
    def positive_input_tags_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of positive tags added at input-level"""
    @property
    def positive_region_tags_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of positive tags added at region-level"""
    @property
    def positive_frame_tags_count(self) -> google.protobuf.wrappers_pb2.UInt64Value:
        """Number of positive tags added at frame-level"""
    def __init__(
        self,
        *,
        inputs_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        unlabeled_inputs_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        inputs_with_metadata_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        inputs_with_geo_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        regions_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        region_location_matrix: proto.clarifai.api.utils.matrix_pb2.MatrixUint64 | None = ...,
        bounding_boxes_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        polygons_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        points_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        masks_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        region_inputs_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        region_frames_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        frames_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        frame_inputs_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        embeddings_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        positive_input_tags_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        positive_region_tags_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
        positive_frame_tags_count: google.protobuf.wrappers_pb2.UInt64Value | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "bounding_boxes_count",
            b"bounding_boxes_count",
            "embeddings_count",
            b"embeddings_count",
            "frame_inputs_count",
            b"frame_inputs_count",
            "frames_count",
            b"frames_count",
            "inputs_count",
            b"inputs_count",
            "inputs_with_geo_count",
            b"inputs_with_geo_count",
            "inputs_with_metadata_count",
            b"inputs_with_metadata_count",
            "masks_count",
            b"masks_count",
            "points_count",
            b"points_count",
            "polygons_count",
            b"polygons_count",
            "positive_frame_tags_count",
            b"positive_frame_tags_count",
            "positive_input_tags_count",
            b"positive_input_tags_count",
            "positive_region_tags_count",
            b"positive_region_tags_count",
            "region_frames_count",
            b"region_frames_count",
            "region_inputs_count",
            b"region_inputs_count",
            "region_location_matrix",
            b"region_location_matrix",
            "regions_count",
            b"regions_count",
            "unlabeled_inputs_count",
            b"unlabeled_inputs_count",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "bounding_boxes_count",
            b"bounding_boxes_count",
            "embeddings_count",
            b"embeddings_count",
            "frame_inputs_count",
            b"frame_inputs_count",
            "frames_count",
            b"frames_count",
            "inputs_count",
            b"inputs_count",
            "inputs_with_geo_count",
            b"inputs_with_geo_count",
            "inputs_with_metadata_count",
            b"inputs_with_metadata_count",
            "masks_count",
            b"masks_count",
            "points_count",
            b"points_count",
            "polygons_count",
            b"polygons_count",
            "positive_frame_tags_count",
            b"positive_frame_tags_count",
            "positive_input_tags_count",
            b"positive_input_tags_count",
            "positive_region_tags_count",
            b"positive_region_tags_count",
            "region_frames_count",
            b"region_frames_count",
            "region_inputs_count",
            b"region_inputs_count",
            "region_location_matrix",
            b"region_location_matrix",
            "regions_count",
            b"regions_count",
            "unlabeled_inputs_count",
            b"unlabeled_inputs_count",
        ],
    ) -> None: ...

global___DatasetVersionMetrics = DatasetVersionMetrics

@typing_extensions.final
class DatasetVersionMetricsGroup(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_PATH_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    METRICS_FIELD_NUMBER: builtins.int
    parent_path: builtins.str
    type: global___DatasetVersionMetricsGroupType.ValueType
    @property
    def value(self) -> google.protobuf.struct_pb2.Value: ...
    @property
    def metrics(self) -> global___DatasetVersionMetrics: ...
    def __init__(
        self,
        *,
        parent_path: builtins.str = ...,
        type: global___DatasetVersionMetricsGroupType.ValueType = ...,
        value: google.protobuf.struct_pb2.Value | None = ...,
        metrics: global___DatasetVersionMetrics | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["metrics", b"metrics", "value", b"value"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "metrics",
            b"metrics",
            "parent_path",
            b"parent_path",
            "type",
            b"type",
            "value",
            b"value",
        ],
    ) -> None: ...

global___DatasetVersionMetricsGroup = DatasetVersionMetricsGroup

@typing_extensions.final
class DatasetVersionExportInfo(google.protobuf.message.Message):
    """DatasetVersionExportInfo contains information about all exports of a dataset version.

    If the dataset version has not been exported in a format, then the DatasetVersionExport
    field for that format is empty instead of having a "not exported" status.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLARIFAI_DATA_PROTOBUF_FIELD_NUMBER: builtins.int
    CLARIFAI_DATA_JSON_FIELD_NUMBER: builtins.int
    COCO_FIELD_NUMBER: builtins.int
    @property
    def clarifai_data_protobuf(self) -> global___DatasetVersionExport:
        """clarifai_data_protobuf is a CLARIFAI_DATA_PROTOBUF export of the dataset version."""
    @property
    def clarifai_data_json(self) -> global___DatasetVersionExport:
        """clarifai_data_json is a CLARIFAI_DATA_JSON export of the dataset version."""
    @property
    def coco(self) -> global___DatasetVersionExport:
        """coco is a COCO export of the dataset version."""
    def __init__(
        self,
        *,
        clarifai_data_protobuf: global___DatasetVersionExport | None = ...,
        clarifai_data_json: global___DatasetVersionExport | None = ...,
        coco: global___DatasetVersionExport | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "clarifai_data_json",
            b"clarifai_data_json",
            "clarifai_data_protobuf",
            b"clarifai_data_protobuf",
            "coco",
            b"coco",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "clarifai_data_json",
            b"clarifai_data_json",
            "clarifai_data_protobuf",
            b"clarifai_data_protobuf",
            "coco",
            b"coco",
        ],
    ) -> None: ...

global___DatasetVersionExportInfo = DatasetVersionExportInfo

@typing_extensions.final
class DatasetVersionExport(google.protobuf.message.Message):
    """DatasetVersionExport contains metadata for a single dataset version export."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FORMAT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    INCLUDE_EMBEDDINGS_FIELD_NUMBER: builtins.int
    format: global___DatasetVersionExportFormat.ValueType
    """format is the format of the dataset version export."""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """status is the current status of the dataset version export."""
    url: builtins.str
    """url is the URL from where the dataset version export can be downloaded."""
    size: builtins.int
    """size is the size of the dataset version export in number of bytes."""
    include_embeddings: builtins.bool
    """whether to include embeddings in the export or not."""
    def __init__(
        self,
        *,
        format: global___DatasetVersionExportFormat.ValueType = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        url: builtins.str = ...,
        size: builtins.int = ...,
        include_embeddings: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["status", b"status"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "format",
            b"format",
            "include_embeddings",
            b"include_embeddings",
            "size",
            b"size",
            "status",
            b"status",
            "url",
            b"url",
        ],
    ) -> None: ...

global___DatasetVersionExport = DatasetVersionExport

@typing_extensions.final
class DatasetVersionProcessingInfo(google.protobuf.message.Message):
    """DatasetVersionProcessingInfo contains information about processing applied
    to a dataset version.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FRAME_INTERPOLATION_INFO_FIELD_NUMBER: builtins.int
    @property
    def frame_interpolation_info(self) -> global___FrameInterpolationInfo:
        """If frame_interpolation_info is set, then these settings are used to
        interpolate new frame annotation from other video annotations.

        If frame_interpolation_info is set in the dataset default_processing_info,
        then it can be disabled for a single dataset version by setting
        processing_info but not setting processing_info.frame_interpolation_info.
        """
    def __init__(
        self,
        *,
        frame_interpolation_info: global___FrameInterpolationInfo | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "frame_interpolation_info", b"frame_interpolation_info"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "frame_interpolation_info", b"frame_interpolation_info"
        ],
    ) -> None: ...

global___DatasetVersionProcessingInfo = DatasetVersionProcessingInfo

@typing_extensions.final
class FrameInterpolationInfo(google.protobuf.message.Message):
    """FrameInterpolationInfo contains information about frame annotations
    interpolated from other video annotations, such as image object-detection
    regions generated from video object-tracking regions.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SAMPLE_MS_FIELD_NUMBER: builtins.int
    sample_ms: builtins.int
    """sample_ms is the sampling rate at which frame annotations are interpolated.
    If sample_ms is zero, then the dataset default_processing_info value is used.
    If the dataset default is zero or not set, then the input frame prediction
    sampling rate is used.
    """
    def __init__(
        self,
        *,
        sample_ms: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["sample_ms", b"sample_ms"]
    ) -> None: ...

global___FrameInterpolationInfo = FrameInterpolationInfo

@typing_extensions.final
class Key(google.protobuf.message.Message):
    """Key"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    SCOPES_FIELD_NUMBER: builtins.int
    ENDPOINTS_FIELD_NUMBER: builtins.int
    APPS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    AUTHORIZED_IDP_IDS_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The id of this key, it is used for authorization."""
    type: builtins.str
    """The type of key, it can be app_specific_key (default) or personal_access_token"""
    description: builtins.str
    """The description"""
    @property
    def scopes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The low-level scopes this key has"""
    @property
    def endpoints(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The endpoint-level scopes this key has"""
    @property
    def apps(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___App]:
        """The apps that this key give you access to, it is empty if this key is personal_access_token
        API key can only give you access to a single app.
        """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the key was created. We follow the XXXX timestamp
        format. We use https://www.ietf.org/rfc/rfc3339.txt format:
        "2006-01-02T15:04:05.999999Z" so you can expect results like
        the following from the API:
        "2017-04-11T21:50:50.223962Z"
        """
    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When does the key expires, the key won't expire if this is empty"""
    @property
    def authorized_idp_ids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """list of idp ids at which key is currently authorized"""
    organization_id: builtins.str
    """The organization associated with the key, if any. This is applicable only for PAT keys."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        type: builtins.str = ...,
        description: builtins.str = ...,
        scopes: collections.abc.Iterable[builtins.str] | None = ...,
        endpoints: collections.abc.Iterable[builtins.str] | None = ...,
        apps: collections.abc.Iterable[global___App] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        authorized_idp_ids: collections.abc.Iterable[builtins.str] | None = ...,
        organization_id: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at", b"created_at", "expires_at", b"expires_at"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "apps",
            b"apps",
            "authorized_idp_ids",
            b"authorized_idp_ids",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "endpoints",
            b"endpoints",
            "expires_at",
            b"expires_at",
            "id",
            b"id",
            "organization_id",
            b"organization_id",
            "scopes",
            b"scopes",
            "type",
            b"type",
        ],
    ) -> None: ...

global___Key = Key

@typing_extensions.final
class Model(google.protobuf.message.Message):
    """This is the Model object which represents a created model in the platform.
    Each model has a particular type denoted by the model_type_id.
    When creating a Model with PostModels the following happens:
     - if the ModelType is trainable, then a new ModelVersion is created that is
       - UNTRAINED status by default
       - TRAINED status if a ModelVersion was included with PretrainedModelConfig in PostModels
     - if the ModelType is not trainable, then a new ModelVersion is created with TRAINED status.
    To modify config settings like OutputInfo for the Model you an use PatchModels. This will
    also create a new ModelVersion, potentially UNTRAINED following the same rules as above.
    The fields that are patchable include Model.name, Model.display_name and Model.output_info
    (except the Model.output_info.type and Model.output_info.type_ext).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Source:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SourceEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Model._Source.ValueType],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN_SOURCE: Model._Source.ValueType  # 0
        HOSTED: Model._Source.ValueType  # 1
        WRAPPED: Model._Source.ValueType  # 2

    class Source(_Source, metaclass=_SourceEnumTypeWrapper):
        """Source of Model"""

    UNKNOWN_SOURCE: Model.Source.ValueType  # 0
    HOSTED: Model.Source.ValueType  # 1
    WRAPPED: Model.Source.ValueType  # 2

    class _BillingType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _BillingTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Model._BillingType.ValueType],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        Unknown: Model._BillingType.ValueType  # 0
        Tokens: Model._BillingType.ValueType  # 1
        Ops: Model._BillingType.ValueType  # 2

    class BillingType(_BillingType, metaclass=_BillingTypeEnumTypeWrapper): ...
    Unknown: Model.BillingType.ValueType  # 0
    Tokens: Model.BillingType.ValueType  # 1
    Ops: Model.BillingType.ValueType  # 2

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    OUTPUT_INFO_FIELD_NUMBER: builtins.int
    MODEL_VERSION_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    DEFAULT_EVAL_INFO_FIELD_NUMBER: builtins.int
    MODEL_TYPE_ID_FIELD_NUMBER: builtins.int
    TASK_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    PRESETS_FIELD_NUMBER: builtins.int
    NOTES_FIELD_NUMBER: builtins.int
    TOOLKITS_FIELD_NUMBER: builtins.int
    USE_CASES_FIELD_NUMBER: builtins.int
    LANGUAGES_FIELD_NUMBER: builtins.int
    LANGUAGES_FULL_FIELD_NUMBER: builtins.int
    CHECK_CONSENTS_FIELD_NUMBER: builtins.int
    IS_STARRED_FIELD_NUMBER: builtins.int
    STAR_COUNT_FIELD_NUMBER: builtins.int
    WORKFLOW_RECOMMENDED_FIELD_NUMBER: builtins.int
    BOOKMARK_ORIGIN_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    LICENSE_TYPE_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    CREATOR_FIELD_NUMBER: builtins.int
    VERSION_COUNT_FIELD_NUMBER: builtins.int
    BILLING_TYPE_FIELD_NUMBER: builtins.int
    FEATURED_ORDER_FIELD_NUMBER: builtins.int
    DEPLOY_RESTRICTION_FIELD_NUMBER: builtins.int
    REPLICA_COUNT_FIELD_NUMBER: builtins.int
    OPEN_ROUTER_INFO_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The model's ID. Must be unique within a particular app and URL-friendly."""
    name: builtins.str
    """DEPRECATED: Please use the model id to name the model."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the model was created. We follow the XXXX timestamp
        format. We use https://www.ietf.org/rfc/rfc3339.txt format:
        "2006-01-02T15:04:05.999999Z" so you can expect results like
         the following from the API:
         "2017-04-11T21:50:50.223962Z"
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When was the most recent model version created at"""
    app_id: builtins.str
    """The app the model belongs to."""
    @property
    def output_info(self) -> global___OutputInfo:
        """Info about the model's output and configuration.
        DEPRECATED: Will be moved to model version
        """
    @property
    def model_version(self) -> global___ModelVersion:
        """A particular version of the model, e.g., to specify the version when creating a workflow or
        when listing Models to include the latest ModelVersion of the model in the response.
        """
    display_name: builtins.str
    """DEPRECATED: Please use the model id to name the model."""
    user_id: builtins.str
    """The user id that the model belongs to."""
    @property
    def default_eval_info(self) -> global___EvalInfo:
        """The default evaluation info. Can be overwritten by eval request."""
    model_type_id: builtins.str
    """The ModelType.Id that is used for this model. This is used for all versions and you cannot
    change model_type_id between versions of the same model.
    """
    task: builtins.str
    """The task the model was trained to do"""
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    description: builtins.str
    """Short description about this model"""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    @property
    def presets(self) -> google.protobuf.struct_pb2.Struct: ...
    notes: builtins.str
    """Notes for the model
    This field should be used for in-depth notes and supports up to 64Kbs.
    """
    @property
    def toolkits(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Tags from toolkits category"""
    @property
    def use_cases(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Tags from use_cases category"""
    @property
    def languages(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Tags from languages category."""
    @property
    def languages_full(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FullTag]:
        """Tags from languages category with names, only used in responses."""
    @property
    def check_consents(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    is_starred: builtins.bool
    """Is starred by the requesting user (only showed on get/list requests)
    Please use PostModelStars/DeleteModelStars endpoints to star/unstar a model
    """
    star_count: builtins.int
    """How many users have starred the model (only showed on get/list requests)
    Computed value, not editable
    """
    @property
    def workflow_recommended(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Whether it's recommended that this model is used within a workflow"""
    @property
    def bookmark_origin(self) -> global___BookmarkOrigin:
        """bookmark info. When set, this model is a bookmarked model of this app.
        Info in this field will allow you to find/access original model.
        """
    @property
    def image(self) -> global___Image:
        """Representative image for this model"""
    license_type: global___LicenseType.ValueType
    """License Type"""
    source: global___Model.Source.ValueType
    creator: builtins.str
    """Creator of Model"""
    version_count: builtins.int
    billing_type: global___Model.BillingType.ValueType
    @property
    def featured_order(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Whether the model should be featured, and if so, the order in which it should be featured.
        The order is relative to other models that are also featured.
        Models with a higher order will be featured first.
        """
    deploy_restriction: global___DeployRestriction.ValueType
    """Deploy restriction for the model."""
    replica_count: builtins.int
    """replica_count indicates the number of deployed model replicas.
    This field is populated when `show_replicas` is true in ListModelsRequest.
    """
    @property
    def open_router_info(self) -> global___OpenRouterInfo:
        """OpenRouter Info for the model"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        app_id: builtins.str = ...,
        output_info: global___OutputInfo | None = ...,
        model_version: global___ModelVersion | None = ...,
        display_name: builtins.str = ...,
        user_id: builtins.str = ...,
        default_eval_info: global___EvalInfo | None = ...,
        model_type_id: builtins.str = ...,
        task: builtins.str = ...,
        visibility: global___Visibility | None = ...,
        description: builtins.str = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        presets: google.protobuf.struct_pb2.Struct | None = ...,
        notes: builtins.str = ...,
        toolkits: collections.abc.Iterable[builtins.str] | None = ...,
        use_cases: collections.abc.Iterable[builtins.str] | None = ...,
        languages: collections.abc.Iterable[builtins.str] | None = ...,
        languages_full: collections.abc.Iterable[global___FullTag] | None = ...,
        check_consents: collections.abc.Iterable[builtins.str] | None = ...,
        is_starred: builtins.bool = ...,
        star_count: builtins.int = ...,
        workflow_recommended: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        bookmark_origin: global___BookmarkOrigin | None = ...,
        image: global___Image | None = ...,
        license_type: global___LicenseType.ValueType = ...,
        source: global___Model.Source.ValueType = ...,
        creator: builtins.str = ...,
        version_count: builtins.int = ...,
        billing_type: global___Model.BillingType.ValueType = ...,
        featured_order: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        deploy_restriction: global___DeployRestriction.ValueType = ...,
        replica_count: builtins.int = ...,
        open_router_info: global___OpenRouterInfo | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "bookmark_origin",
            b"bookmark_origin",
            "created_at",
            b"created_at",
            "default_eval_info",
            b"default_eval_info",
            "featured_order",
            b"featured_order",
            "image",
            b"image",
            "metadata",
            b"metadata",
            "model_version",
            b"model_version",
            "modified_at",
            b"modified_at",
            "open_router_info",
            b"open_router_info",
            "output_info",
            b"output_info",
            "presets",
            b"presets",
            "visibility",
            b"visibility",
            "workflow_recommended",
            b"workflow_recommended",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "billing_type",
            b"billing_type",
            "bookmark_origin",
            b"bookmark_origin",
            "check_consents",
            b"check_consents",
            "created_at",
            b"created_at",
            "creator",
            b"creator",
            "default_eval_info",
            b"default_eval_info",
            "deploy_restriction",
            b"deploy_restriction",
            "description",
            b"description",
            "display_name",
            b"display_name",
            "featured_order",
            b"featured_order",
            "id",
            b"id",
            "image",
            b"image",
            "is_starred",
            b"is_starred",
            "languages",
            b"languages",
            "languages_full",
            b"languages_full",
            "license_type",
            b"license_type",
            "metadata",
            b"metadata",
            "model_type_id",
            b"model_type_id",
            "model_version",
            b"model_version",
            "modified_at",
            b"modified_at",
            "name",
            b"name",
            "notes",
            b"notes",
            "open_router_info",
            b"open_router_info",
            "output_info",
            b"output_info",
            "presets",
            b"presets",
            "replica_count",
            b"replica_count",
            "source",
            b"source",
            "star_count",
            b"star_count",
            "task",
            b"task",
            "toolkits",
            b"toolkits",
            "use_cases",
            b"use_cases",
            "user_id",
            b"user_id",
            "version_count",
            b"version_count",
            "visibility",
            b"visibility",
            "workflow_recommended",
            b"workflow_recommended",
        ],
    ) -> None: ...

global___Model = Model

@typing_extensions.final
class SpecialHandling(google.protobuf.message.Message):
    """Tracks special handling reason and whether it's been done."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Reason:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ReasonEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            SpecialHandling._Reason.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        REASON_NOT_SET: SpecialHandling._Reason.ValueType  # 0
        CONTACT_SALES: SpecialHandling._Reason.ValueType  # 1

    class Reason(_Reason, metaclass=_ReasonEnumTypeWrapper): ...
    REASON_NOT_SET: SpecialHandling.Reason.ValueType  # 0
    CONTACT_SALES: SpecialHandling.Reason.ValueType  # 1

    ID_FIELD_NUMBER: builtins.int
    REASON_FIELD_NUMBER: builtins.int
    DONE_FIELD_NUMBER: builtins.int
    id: builtins.str
    reason: global___SpecialHandling.Reason.ValueType
    done: builtins.bool
    """Whether special handling is done."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        reason: global___SpecialHandling.Reason.ValueType = ...,
        done: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["done", b"done", "id", b"id", "reason", b"reason"],
    ) -> None: ...

global___SpecialHandling = SpecialHandling

@typing_extensions.final
class OpenRouterInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARAMS_FIELD_NUMBER: builtins.int
    @property
    def params(self) -> google.protobuf.struct_pb2.Struct: ...
    def __init__(
        self,
        *,
        params: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["params", b"params"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["params", b"params"]) -> None: ...

global___OpenRouterInfo = OpenRouterInfo

@typing_extensions.final
class ModelReference(google.protobuf.message.Message):
    """A link to a html/markdown/text file that stores reference material tied to a model."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Id of the reference"""
    model_id: builtins.str
    """The id of the model this Model reference is tied to."""
    url: builtins.str
    """address of resource"""
    name: builtins.str
    """name of link"""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        model_id: builtins.str = ...,
        url: builtins.str = ...,
        name: builtins.str = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["metadata", b"metadata"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "id",
            b"id",
            "metadata",
            b"metadata",
            "model_id",
            b"model_id",
            "name",
            b"name",
            "url",
            b"url",
        ],
    ) -> None: ...

global___ModelReference = ModelReference

@typing_extensions.final
class ModelVersionInputExample(google.protobuf.message.Message):
    """ModelVersionInputExample"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    MODEL_VERSION_ID_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """user unique id"""
    model_id: builtins.str
    """external id of model"""
    model_version_id: builtins.str
    """external id of model version"""
    @property
    def data(self) -> global___Data:
        """data to store as example input for model"""
    name: builtins.str
    """name of link for display"""
    description: builtins.str
    """description of link contents"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        model_id: builtins.str = ...,
        model_version_id: builtins.str = ...,
        data: global___Data | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["data", b"data"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "data",
            b"data",
            "description",
            b"description",
            "id",
            b"id",
            "model_id",
            b"model_id",
            "model_version_id",
            b"model_version_id",
            "name",
            b"name",
        ],
    ) -> None: ...

global___ModelVersionInputExample = ModelVersionInputExample

@typing_extensions.final
class OutputInfo(google.protobuf.message.Message):
    """OutputInfo defines some of the settings for each model version that PatchModels can effect. These
    parameters control some of the training or inference operations that this model can do.
    As the number of parameters continued to grow when we launched more ModelTypes we decided to move
    to using the OutputInfo.params field which is a Struct (or JSON object if you're using
    our JSON REST APIs). This allows each ModelType to define the set of fields, their default values
    and description of each field so that we can display those in Portal and make the creation of
    Model's very extensible. The OutputConfig object will eventually go away in favor of
    output_info.params struct.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    OUTPUT_CONFIG_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    FIELDS_MAP_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    PARAMS_SPECS_FIELD_NUMBER: builtins.int
    @property
    def data(self) -> global___Data:
        """List of concepts or other output related data for the model."""
    @property
    def output_config(self) -> global___OutputConfig:
        """Model configuration...going away in favor of output_info.params and train_params over time.
        TO BE DEPRECATED
        """
    message: builtins.str
    """For returning where to look for the Output info if not returning it."""
    @property
    def fields_map(self) -> google.protobuf.struct_pb2.Struct:
        """Map from the api.Data field names to the underlying model graph's outputs. When using a
        PretrainedModelConfig the values in this map need to match the Triton config.pbtxt output names.
        """
    @property
    def params(self) -> google.protobuf.struct_pb2.Struct:
        """For predicting with the various ModelType's we accept a Struct (JSON object) worth of args
        that the ModelTypeField defines. During inference, the settings contained within are sent
        to the model predictor to alter predictions from this Model.
        """
    @property
    def params_specs(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ModelTypeField
    ]:
        """These allow you to specifcy addition fields that a specific model supports beyond those defined
        in it's ModelType. This field is to be deprecated and will be replaced by MethodSignature
        proto.
        """
    def __init__(
        self,
        *,
        data: global___Data | None = ...,
        output_config: global___OutputConfig | None = ...,
        message: builtins.str = ...,
        fields_map: google.protobuf.struct_pb2.Struct | None = ...,
        params: google.protobuf.struct_pb2.Struct | None = ...,
        params_specs: collections.abc.Iterable[global___ModelTypeField] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "data",
            b"data",
            "fields_map",
            b"fields_map",
            "output_config",
            b"output_config",
            "params",
            b"params",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "data",
            b"data",
            "fields_map",
            b"fields_map",
            "message",
            b"message",
            "output_config",
            b"output_config",
            "params",
            b"params",
            "params_specs",
            b"params_specs",
        ],
    ) -> None: ...

global___OutputInfo = OutputInfo

@typing_extensions.final
class InputInfo(google.protobuf.message.Message):
    """InputInfo"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELDS_MAP_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    BASE_EMBED_MODEL_FIELD_NUMBER: builtins.int
    @property
    def fields_map(self) -> google.protobuf.struct_pb2.Struct:
        """Map from the api.Data field names to the underlying model graph's inputs. When using a
        PretrainedModelConfig the values in this map need to match the Triton config.pbtxt input names.
        """
    @property
    def params(self) -> google.protobuf.struct_pb2.Struct:
        """To control the inputs to the given model we allow a list of parameters
        defined for each ModelType as a Struct (JSON object) here. During training or inference, the
        settings contained within are sent to the training processor to alter the training process.
        """
    @property
    def base_embed_model(self) -> global___Model:
        """For base model to get embeddings from for transfer learned models."""
    def __init__(
        self,
        *,
        fields_map: google.protobuf.struct_pb2.Struct | None = ...,
        params: google.protobuf.struct_pb2.Struct | None = ...,
        base_embed_model: global___Model | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "base_embed_model",
            b"base_embed_model",
            "fields_map",
            b"fields_map",
            "params",
            b"params",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "base_embed_model",
            b"base_embed_model",
            "fields_map",
            b"fields_map",
            "params",
            b"params",
        ],
    ) -> None: ...

global___InputInfo = InputInfo

@typing_extensions.final
class TrainInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARAMS_FIELD_NUMBER: builtins.int
    DATASET_FIELD_NUMBER: builtins.int
    RESUME_FROM_MODEL_FIELD_NUMBER: builtins.int
    @property
    def params(self) -> google.protobuf.struct_pb2.Struct:
        """To control the training process when PostModelVersions is used we allow a list of parameters
        defined for each ModelType as a Struct (JSON object) here. During training, the settings
        contained within are sent to the training processor to alter the training process.
        """
    @property
    def dataset(self) -> global___Dataset:
        """The dataset and dataset version this model version was or will be trained on"""
    @property
    def resume_from_model(self) -> global___Model:
        """The model to resume training from."""
    def __init__(
        self,
        *,
        params: google.protobuf.struct_pb2.Struct | None = ...,
        dataset: global___Dataset | None = ...,
        resume_from_model: global___Model | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "dataset", b"dataset", "params", b"params", "resume_from_model", b"resume_from_model"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "dataset", b"dataset", "params", b"params", "resume_from_model", b"resume_from_model"
        ],
    ) -> None: ...

global___TrainInfo = TrainInfo

@typing_extensions.final
class EvalInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARAMS_FIELD_NUMBER: builtins.int
    @property
    def params(self) -> google.protobuf.struct_pb2.Struct:
        """To control the evaluation process.
        Allow a list of parameters.
        """
    def __init__(
        self,
        *,
        params: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["params", b"params"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["params", b"params"]) -> None: ...

global___EvalInfo = EvalInfo

@typing_extensions.final
class ImportInfo(google.protobuf.message.Message):
    """DEPRECATED: no longer support importing models from third party toolkits"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARAMS_FIELD_NUMBER: builtins.int
    @property
    def params(self) -> google.protobuf.struct_pb2.Struct:
        """Used to configure model imports from third-party toolkits.
        DEPRECATED: no longer support importing models from third party toolkits
        """
    def __init__(
        self,
        *,
        params: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["params", b"params"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["params", b"params"]) -> None: ...

global___ImportInfo = ImportInfo

@typing_extensions.final
class OutputConfig(google.protobuf.message.Message):
    """OutputConfig is a collection of parameters controlling either inference or training settings for
    the given Model. This message will be deprecated over time in favor or output_info.params and
    train_params in OutputInfo which are cleaner and more extensible for many ModelTypes.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONCEPTS_MUTUALLY_EXCLUSIVE_FIELD_NUMBER: builtins.int
    EXISTING_MODEL_ID_FIELD_NUMBER: builtins.int
    LANGUAGE_FIELD_NUMBER: builtins.int
    HYPER_PARAMETERS_FIELD_NUMBER: builtins.int
    MAX_CONCEPTS_FIELD_NUMBER: builtins.int
    MIN_VALUE_FIELD_NUMBER: builtins.int
    SELECT_CONCEPTS_FIELD_NUMBER: builtins.int
    TRAINING_TIMEOUT_FIELD_NUMBER: builtins.int
    SAMPLE_MS_FIELD_NUMBER: builtins.int
    HYPER_PARAMS_FIELD_NUMBER: builtins.int
    EMBED_MODEL_VERSION_ID_FIELD_NUMBER: builtins.int
    FAIL_ON_MISSING_POSITIVE_EXAMPLES_FIELD_NUMBER: builtins.int
    MODEL_METADATA_FIELD_NUMBER: builtins.int
    concepts_mutually_exclusive: builtins.bool
    """For custom concept model training: whether the concept predictions must sum to 1."""
    existing_model_id: builtins.str
    """DEPRECATED: For custom models, this is the base model to use for image embeddings.
    Default is general model.
    """
    language: builtins.str
    """For concept model predictions: Overrides the default_language for the app in a predict call."""
    hyper_parameters: builtins.str
    """DEPRECATED: Hyper-parameters for custom training.
    Use new hyper_params field instead.
    """
    max_concepts: builtins.int
    """For concept model predictions:  Maximum number of concepts in result. Defaults to 0 which under
    the hood will return default of 20. We do a server side default in order to control this
    feature in the future.
    """
    min_value: builtins.float
    """For concept model predictions: Minimum value of concept's probability score in result.
    Defaults to 0.0 which means we won't do any thresholding as all probabilities will
    likely be > 0.0.
    """
    @property
    def select_concepts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Concept]:
        """For concept model predictions: Select concepts in result by name or by id"""
    training_timeout: builtins.int
    """For custom concept model training: Training timeout of the model (in seconds)"""
    sample_ms: builtins.int
    """For model predictions on video: Sample delay for video predicting (1 frame per N milliseconds)"""
    @property
    def hyper_params(self) -> google.protobuf.struct_pb2.Struct:
        """For custom model training: Hyperparameters for custom training"""
    embed_model_version_id: builtins.str
    """For custom model training: this is the base model version to use for image embeddings.
    This has to be one of the embed models in the app workflow.
    Use input_info.base_embed_model instead.
    """
    fail_on_missing_positive_examples: builtins.bool
    """For custom model training: Use this flag to fail on missing positive examples
    By default we fill in the missing with random examples
    """
    @property
    def model_metadata(self) -> google.protobuf.struct_pb2.Struct:
        """For custom model training: This is any additional metadata as a JSON object that we want
        want to persist in the model's output config. This is a useful quick way to set fields for
        introducing fields for new model types so we don't have to add a new proto field and DB field
        each time. Please refer to the documentation or model implementation internally for more
        details on what fields are supported for which models.
        TODO(zeiler): remove this field after Portal is updated.
        """
    def __init__(
        self,
        *,
        concepts_mutually_exclusive: builtins.bool = ...,
        existing_model_id: builtins.str = ...,
        language: builtins.str = ...,
        hyper_parameters: builtins.str = ...,
        max_concepts: builtins.int = ...,
        min_value: builtins.float = ...,
        select_concepts: collections.abc.Iterable[global___Concept] | None = ...,
        training_timeout: builtins.int = ...,
        sample_ms: builtins.int = ...,
        hyper_params: google.protobuf.struct_pb2.Struct | None = ...,
        embed_model_version_id: builtins.str = ...,
        fail_on_missing_positive_examples: builtins.bool = ...,
        model_metadata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "hyper_params", b"hyper_params", "model_metadata", b"model_metadata"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "concepts_mutually_exclusive",
            b"concepts_mutually_exclusive",
            "embed_model_version_id",
            b"embed_model_version_id",
            "existing_model_id",
            b"existing_model_id",
            "fail_on_missing_positive_examples",
            b"fail_on_missing_positive_examples",
            "hyper_parameters",
            b"hyper_parameters",
            "hyper_params",
            b"hyper_params",
            "language",
            b"language",
            "max_concepts",
            b"max_concepts",
            "min_value",
            b"min_value",
            "model_metadata",
            b"model_metadata",
            "sample_ms",
            b"sample_ms",
            "select_concepts",
            b"select_concepts",
            "training_timeout",
            b"training_timeout",
        ],
    ) -> None: ...

global___OutputConfig = OutputConfig

@typing_extensions.final
class ModelType(google.protobuf.message.Message):
    """ModelType is a definition of a set of models that generally have the same input and output fields.
    This is used to understand more about the possible models in our platform.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    INPUT_FIELDS_FIELD_NUMBER: builtins.int
    OUTPUT_FIELDS_FIELD_NUMBER: builtins.int
    TRAINABLE_FIELD_NUMBER: builtins.int
    CREATABLE_FIELD_NUMBER: builtins.int
    INTERNAL_ONLY_FIELD_NUMBER: builtins.int
    MODEL_TYPE_FIELDS_FIELD_NUMBER: builtins.int
    REQUIRES_SEQUENTIAL_FRAMES_FIELD_NUMBER: builtins.int
    EXPECTED_INPUT_LAYERS_FIELD_NUMBER: builtins.int
    EXPECTED_OUTPUT_LAYERS_FIELD_NUMBER: builtins.int
    EVALUATION_TYPE_FIELD_NUMBER: builtins.int
    METHOD_SIGNATURES_FIELD_NUMBER: builtins.int
    id: builtins.str
    """A unique identifier for this model type."""
    title: builtins.str
    """A display title for this model."""
    description: builtins.str
    """Description of this model type."""
    @property
    def input_fields(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """For both input_fields and output_fields below, the following hold true:
        - They are both lists of strings that name the fields from the Data proto
        - Individual entries in the list can be comma-separated lists. Each element of it is expected to be present in an incoming data example.
        - There is not currently a notion of fields that can be "OR separated". "OR separated" meaning any combination of the fields can be present.
        - Multiple entries in the list imply that inputs come from different input sources.
        - Both are used to validate which models can be chained before and after each other inside a workflow.

        The list of input fields that this model expects as inputs.
        Used to validate that request input data has the expected fields.
        """
    @property
    def output_fields(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The list of output fields that this model accepts."""
    trainable: builtins.bool
    """Is this model trainable in our platform."""
    creatable: builtins.bool
    """Is this model creatable. We have some pre-trained model types that users cannot create yet in
    model mode.
    """
    internal_only: builtins.bool
    """Is this model type only for internal users at this time."""
    @property
    def model_type_fields(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ModelTypeField
    ]:
        """The remaining fields are definitions of the configurable fields that exist."""
    requires_sequential_frames: builtins.bool
    """For sequence models we need to know when processing that they require temporal time frames
    in sequential order. This will be true for model types like trackers as an example.
    """
    @property
    def expected_input_layers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ModelLayerInfo
    ]:
        """Expected input layers of an uploaded model."""
    @property
    def expected_output_layers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ModelLayerInfo
    ]:
        """Expected output layers of an uploaded model"""
    evaluation_type: global___EvaluationType.ValueType
    """What type of evaluation is supported for this model type."""
    @property
    def method_signatures(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___MethodSignature
    ]:
        """method signature for this model type
        This will be used in the future to replace input_fields, output_fields, and model_type_fields
        as it can define any python function call.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        input_fields: collections.abc.Iterable[builtins.str] | None = ...,
        output_fields: collections.abc.Iterable[builtins.str] | None = ...,
        trainable: builtins.bool = ...,
        creatable: builtins.bool = ...,
        internal_only: builtins.bool = ...,
        model_type_fields: collections.abc.Iterable[global___ModelTypeField] | None = ...,
        requires_sequential_frames: builtins.bool = ...,
        expected_input_layers: collections.abc.Iterable[global___ModelLayerInfo] | None = ...,
        expected_output_layers: collections.abc.Iterable[global___ModelLayerInfo] | None = ...,
        evaluation_type: global___EvaluationType.ValueType = ...,
        method_signatures: collections.abc.Iterable[global___MethodSignature] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "creatable",
            b"creatable",
            "description",
            b"description",
            "evaluation_type",
            b"evaluation_type",
            "expected_input_layers",
            b"expected_input_layers",
            "expected_output_layers",
            b"expected_output_layers",
            "id",
            b"id",
            "input_fields",
            b"input_fields",
            "internal_only",
            b"internal_only",
            "method_signatures",
            b"method_signatures",
            "model_type_fields",
            b"model_type_fields",
            "output_fields",
            b"output_fields",
            "requires_sequential_frames",
            b"requires_sequential_frames",
            "title",
            b"title",
            "trainable",
            b"trainable",
        ],
    ) -> None: ...

global___ModelType = ModelType

@typing_extensions.final
class ModelLayerInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NAME_FIELD_NUMBER: builtins.int
    SHAPES_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    REQUIRES_LABEL_FILENAME_FIELD_NUMBER: builtins.int
    data_field_name: builtins.str
    """The api.Data field this layer will be parsed into"""
    @property
    def shapes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LayerShape]:
        """Description of the expected shape. Can support multiple support layer shapes."""
    description: builtins.str
    """Brief description about the layer if needed"""
    requires_label_filename: builtins.bool
    """Whether this layer should have a label_filename specified and provided"""
    def __init__(
        self,
        *,
        data_field_name: builtins.str = ...,
        shapes: collections.abc.Iterable[global___LayerShape] | None = ...,
        description: builtins.str = ...,
        requires_label_filename: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "data_field_name",
            b"data_field_name",
            "description",
            b"description",
            "requires_label_filename",
            b"requires_label_filename",
            "shapes",
            b"shapes",
        ],
    ) -> None: ...

global___ModelLayerInfo = ModelLayerInfo

@typing_extensions.final
class TritonCondaEnvInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONDA_PACK_URL_FIELD_NUMBER: builtins.int
    CONDA_YAML_URL_FIELD_NUMBER: builtins.int
    conda_pack_url: builtins.str
    conda_yaml_url: builtins.str
    def __init__(
        self,
        *,
        conda_pack_url: builtins.str = ...,
        conda_yaml_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "conda_pack_url", b"conda_pack_url", "conda_yaml_url", b"conda_yaml_url"
        ],
    ) -> None: ...

global___TritonCondaEnvInfo = TritonCondaEnvInfo

@typing_extensions.final
class LayerShape(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIMS_FIELD_NUMBER: builtins.int
    MAX_DIMS_FIELD_NUMBER: builtins.int
    DATA_TYPE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    @property
    def dims(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Supported dimensions
        Example: [-1,4] is a 2-dimensional array with the first dimension of variablesize, but second dimension with a static size: [[1,2,3,4],[4,5,6,7],...]
        """
    @property
    def max_dims(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Max dimension size, applicable to layers that can have flexible sizes."""
    data_type: global___DataType.ValueType
    """The triton data type"""
    description: builtins.str
    """Description about the dimensions"""
    def __init__(
        self,
        *,
        dims: collections.abc.Iterable[builtins.int] | None = ...,
        max_dims: collections.abc.Iterable[builtins.int] | None = ...,
        data_type: global___DataType.ValueType = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "data_type",
            b"data_type",
            "description",
            b"description",
            "dims",
            b"dims",
            "max_dims",
            b"max_dims",
        ],
    ) -> None: ...

global___LayerShape = LayerShape

@typing_extensions.final
class ModelTypeField(google.protobuf.message.Message):
    """ModelTypeField stores a field value of a configurable type."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ModelTypeFieldType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModelTypeFieldTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            ModelTypeField._ModelTypeFieldType.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INVALID_MODEL_TYPE_FIELD_TYPE: ModelTypeField._ModelTypeFieldType.ValueType  # 0
        BOOLEAN: ModelTypeField._ModelTypeFieldType.ValueType  # 1
        STRING: ModelTypeField._ModelTypeFieldType.ValueType  # 2
        NUMBER: ModelTypeField._ModelTypeFieldType.ValueType  # 3
        ARRAY_OF_CONCEPTS: ModelTypeField._ModelTypeFieldType.ValueType  # 4
        """For auto-completing to concepts in the app. This goes into an data.concepts field."""
        ARRAY_OF_CONCEPTS_WITH_THRESHOLD: ModelTypeField._ModelTypeFieldType.ValueType  # 5
        """For auto-completing to concepts in the app. This goes into an data.concepts field."""
        RANGE: ModelTypeField._ModelTypeFieldType.ValueType  # 7
        """A range for a float value."""
        ENUM: ModelTypeField._ModelTypeFieldType.ValueType  # 8
        """If ENUM is used then the "enum_options" field should also be filled in with the respective ID and description
        for the different ENUM options.
        """
        COLLABORATORS: ModelTypeField._ModelTypeFieldType.ValueType  # 9
        """For listing collaborators of the app. The field is a string of the collaborator's user_id."""
        JSON: ModelTypeField._ModelTypeFieldType.ValueType  # 10
        """For arbitrary json object: "{...}" """
        ARRAY_OF_NUMBERS: ModelTypeField._ModelTypeFieldType.ValueType  # 11
        """Such as [1.0, 2.0, 3.5]"""
        WORKFLOW_EMBED_MODELS: ModelTypeField._ModelTypeFieldType.ValueType  # 12
        """For selecting the embed_model_version_id for context based models."""
        ARRAY_OF_STRINGS: ModelTypeField._ModelTypeFieldType.ValueType  # 13
        """Such as ['a', 'b', 'cantaloupe']"""
        RECURSIVE_ENUM: ModelTypeField._ModelTypeFieldType.ValueType  # 14
        """If RECURSIVE_ENUM is used then the "enum_options" field should also be filled in with the respective ID and
        description for the different RECURSIVE_ENUM options, as well as model_type_fields for each enum choice.
        """
        PYTHON_CODE: ModelTypeField._ModelTypeFieldType.ValueType  # 15
        """For blocks of code that need to be specified by the user for setup or execution during workflow runs."""
        DATASET_ID: ModelTypeField._ModelTypeFieldType.ValueType  # 16
        """For selecting a dataset id in model parameters. String in API request."""
        DATASET_VERSION_ID: ModelTypeField._ModelTypeFieldType.ValueType  # 17
        """For selecting a dataset version id. String."""
        ARRAY_OF_MODEL_CONCEPTS: ModelTypeField._ModelTypeFieldType.ValueType  # 18
        """For auto-completing to concepts in the model."""
        DATASET: ModelTypeField._ModelTypeFieldType.ValueType  # 19
        """For selecting a dataset"""
        DATASET_VERSION: ModelTypeField._ModelTypeFieldType.ValueType  # 20
        """For selecting a dataset version"""
        ENCRYPTED_STRING: ModelTypeField._ModelTypeFieldType.ValueType  # 21
        """To pass a string downstream, that is encrypted in the DB and API."""
        CHECKPOINT_MODEL: ModelTypeField._ModelTypeFieldType.ValueType  # 22
        """For selecting a model version of the same model type to resume training from."""
        ARRAY_OF_SECRETS: ModelTypeField._ModelTypeFieldType.ValueType  # 23
        """For model secrets"""

    class ModelTypeFieldType(_ModelTypeFieldType, metaclass=_ModelTypeFieldTypeEnumTypeWrapper):
        """These are various types of fields that we have UIs for."""

    INVALID_MODEL_TYPE_FIELD_TYPE: ModelTypeField.ModelTypeFieldType.ValueType  # 0
    BOOLEAN: ModelTypeField.ModelTypeFieldType.ValueType  # 1
    STRING: ModelTypeField.ModelTypeFieldType.ValueType  # 2
    NUMBER: ModelTypeField.ModelTypeFieldType.ValueType  # 3
    ARRAY_OF_CONCEPTS: ModelTypeField.ModelTypeFieldType.ValueType  # 4
    """For auto-completing to concepts in the app. This goes into an data.concepts field."""
    ARRAY_OF_CONCEPTS_WITH_THRESHOLD: ModelTypeField.ModelTypeFieldType.ValueType  # 5
    """For auto-completing to concepts in the app. This goes into an data.concepts field."""
    RANGE: ModelTypeField.ModelTypeFieldType.ValueType  # 7
    """A range for a float value."""
    ENUM: ModelTypeField.ModelTypeFieldType.ValueType  # 8
    """If ENUM is used then the "enum_options" field should also be filled in with the respective ID and description
    for the different ENUM options.
    """
    COLLABORATORS: ModelTypeField.ModelTypeFieldType.ValueType  # 9
    """For listing collaborators of the app. The field is a string of the collaborator's user_id."""
    JSON: ModelTypeField.ModelTypeFieldType.ValueType  # 10
    """For arbitrary json object: "{...}" """
    ARRAY_OF_NUMBERS: ModelTypeField.ModelTypeFieldType.ValueType  # 11
    """Such as [1.0, 2.0, 3.5]"""
    WORKFLOW_EMBED_MODELS: ModelTypeField.ModelTypeFieldType.ValueType  # 12
    """For selecting the embed_model_version_id for context based models."""
    ARRAY_OF_STRINGS: ModelTypeField.ModelTypeFieldType.ValueType  # 13
    """Such as ['a', 'b', 'cantaloupe']"""
    RECURSIVE_ENUM: ModelTypeField.ModelTypeFieldType.ValueType  # 14
    """If RECURSIVE_ENUM is used then the "enum_options" field should also be filled in with the respective ID and
    description for the different RECURSIVE_ENUM options, as well as model_type_fields for each enum choice.
    """
    PYTHON_CODE: ModelTypeField.ModelTypeFieldType.ValueType  # 15
    """For blocks of code that need to be specified by the user for setup or execution during workflow runs."""
    DATASET_ID: ModelTypeField.ModelTypeFieldType.ValueType  # 16
    """For selecting a dataset id in model parameters. String in API request."""
    DATASET_VERSION_ID: ModelTypeField.ModelTypeFieldType.ValueType  # 17
    """For selecting a dataset version id. String."""
    ARRAY_OF_MODEL_CONCEPTS: ModelTypeField.ModelTypeFieldType.ValueType  # 18
    """For auto-completing to concepts in the model."""
    DATASET: ModelTypeField.ModelTypeFieldType.ValueType  # 19
    """For selecting a dataset"""
    DATASET_VERSION: ModelTypeField.ModelTypeFieldType.ValueType  # 20
    """For selecting a dataset version"""
    ENCRYPTED_STRING: ModelTypeField.ModelTypeFieldType.ValueType  # 21
    """To pass a string downstream, that is encrypted in the DB and API."""
    CHECKPOINT_MODEL: ModelTypeField.ModelTypeFieldType.ValueType  # 22
    """For selecting a model version of the same model type to resume training from."""
    ARRAY_OF_SECRETS: ModelTypeField.ModelTypeFieldType.ValueType  # 23
    """For model secrets"""

    class _DataType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DataTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            ModelTypeField._DataType.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NOT_SET: ModelTypeField._DataType.ValueType  # 0
        STR: ModelTypeField._DataType.ValueType  # 1
        """A string value."""
        BYTES: ModelTypeField._DataType.ValueType  # 2
        """A byte string. This is used for binary data."""
        INT: ModelTypeField._DataType.ValueType  # 3
        """An integer value."""
        FLOAT: ModelTypeField._DataType.ValueType  # 4
        """A float value."""
        BOOL: ModelTypeField._DataType.ValueType  # 5
        """A boolean value."""
        NDARRAY: ModelTypeField._DataType.ValueType  # 6
        """A proto representation for numpy arrays."""
        JSON_DATA: ModelTypeField._DataType.ValueType  # 7
        """For arbitrary json object: "{...}" """
        TEXT: ModelTypeField._DataType.ValueType  # 8
        """For text data"""
        IMAGE: ModelTypeField._DataType.ValueType  # 9
        """A image is a image proto for url or bytes."""
        CONCEPT: ModelTypeField._DataType.ValueType  # 10
        """A concept is a concept proto that represents a concept in the app."""
        REGION: ModelTypeField._DataType.ValueType  # 11
        """A region is a bounding box in an image or video frame."""
        FRAME: ModelTypeField._DataType.ValueType  # 12
        """A frame is a single image in a video stream"""
        AUDIO: ModelTypeField._DataType.ValueType  # 13
        """A audio is a audio proto for url or bytes."""
        VIDEO: ModelTypeField._DataType.ValueType  # 14
        """A video is a video proto for url or bytes."""
        NAMED_FIELDS: ModelTypeField._DataType.ValueType  # 15
        """this can be used to store named fields with values similar to Dict"""
        TUPLE: ModelTypeField._DataType.ValueType  # 16
        """An arg that is a tuple."""
        LIST: ModelTypeField._DataType.ValueType  # 17
        """An arg that is a list."""

    class DataType(_DataType, metaclass=_DataTypeEnumTypeWrapper):
        """DataType is used in MethodSignature to define all the possible types that a python function
        may have that we want to support. These include built-ins like int, float, str, bool, and
        more complex types like JSON, numpy arrays, List, Tuple, Dict (as Named Fields), as well as Clarifai provided
        unstructured types like Image, Video, Text, etc.
        """

    NOT_SET: ModelTypeField.DataType.ValueType  # 0
    STR: ModelTypeField.DataType.ValueType  # 1
    """A string value."""
    BYTES: ModelTypeField.DataType.ValueType  # 2
    """A byte string. This is used for binary data."""
    INT: ModelTypeField.DataType.ValueType  # 3
    """An integer value."""
    FLOAT: ModelTypeField.DataType.ValueType  # 4
    """A float value."""
    BOOL: ModelTypeField.DataType.ValueType  # 5
    """A boolean value."""
    NDARRAY: ModelTypeField.DataType.ValueType  # 6
    """A proto representation for numpy arrays."""
    JSON_DATA: ModelTypeField.DataType.ValueType  # 7
    """For arbitrary json object: "{...}" """
    TEXT: ModelTypeField.DataType.ValueType  # 8
    """For text data"""
    IMAGE: ModelTypeField.DataType.ValueType  # 9
    """A image is a image proto for url or bytes."""
    CONCEPT: ModelTypeField.DataType.ValueType  # 10
    """A concept is a concept proto that represents a concept in the app."""
    REGION: ModelTypeField.DataType.ValueType  # 11
    """A region is a bounding box in an image or video frame."""
    FRAME: ModelTypeField.DataType.ValueType  # 12
    """A frame is a single image in a video stream"""
    AUDIO: ModelTypeField.DataType.ValueType  # 13
    """A audio is a audio proto for url or bytes."""
    VIDEO: ModelTypeField.DataType.ValueType  # 14
    """A video is a video proto for url or bytes."""
    NAMED_FIELDS: ModelTypeField.DataType.ValueType  # 15
    """this can be used to store named fields with values similar to Dict"""
    TUPLE: ModelTypeField.DataType.ValueType  # 16
    """An arg that is a tuple."""
    LIST: ModelTypeField.DataType.ValueType  # 17
    """An arg that is a list."""

    PATH_FIELD_NUMBER: builtins.int
    FIELD_TYPE_FIELD_NUMBER: builtins.int
    DEFAULT_VALUE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PLACEHOLDER_FIELD_NUMBER: builtins.int
    MODEL_TYPE_ENUM_OPTIONS_FIELD_NUMBER: builtins.int
    INTERNAL_ONLY_FIELD_NUMBER: builtins.int
    REQUIRED_FIELD_NUMBER: builtins.int
    MODEL_TYPE_RANGE_INFO_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    TYPE_ARGS_FIELD_NUMBER: builtins.int
    ITERATOR_FIELD_NUMBER: builtins.int
    DEFAULT_FIELD_NUMBER: builtins.int
    IS_PARAM_FIELD_NUMBER: builtins.int
    path: builtins.str
    """The path where the value of the field will be stored in the model version object.
    Example:
    "output_info.data" would be the Data message in the OutputInfo message.
    "output_info.output_config.language" is in the OutputConfig message within OutputInfo
    "input_info.params" is in the params struct within InputInfo.
    "output_info.params" is in the params struct within OutputInfo.
    "train_info.params" is in the params struct within TrainInfo.
    and so on.
    """
    field_type: global___ModelTypeField.ModelTypeFieldType.ValueType
    """The field for this field. This is often used for displaying the field in the UI whereas
    the DataType enum below defines the specific type of datain the Python function.
    """
    @property
    def default_value(self) -> google.protobuf.struct_pb2.Value:
        """A default value. We use the Value field because we want to have structured data (just like
        google.protobuf.Struct but this is just a single value).
        """
    description: builtins.str
    """Description for this field."""
    placeholder: builtins.str
    """Placeholder text for the UI element."""
    @property
    def model_type_enum_options(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ModelTypeEnumOption
    ]:
        """List of options of the ENUM type and potentially additional fields they bring with them."""
    internal_only: builtins.bool
    """If this field should appear for internal users only."""
    required: builtins.bool
    """If this field is a required field. If True then during validation you won't be able to create
    a model of this type with providing a value for this field. When False, the ModelType's
    default_value will be used for this field.
    """
    @property
    def model_type_range_info(self) -> global___ModelTypeRangeInfo:
        """If the field_type is RANGE, this must be filled in."""
    name: builtins.str
    """///////////////////////////////////
    New fields for MethodSignature
    ///////////////////////////////////
    The fields below were added when we introduced ability to call an arbitrary python function
    from the client side. This is used to define the method signature of the python function
    that we want to call. The above fields are still relevant to decide what a UI should display.
    Some of the above fields above will be relevant like definition, required, etc.

    name of method signature argument
    """
    type: global___ModelTypeField.DataType.ValueType
    """The type of the argument."""
    @property
    def type_args(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ModelTypeField
    ]:
        """type enum, and recursively set type_args with
        the inner type argumets in complex objects (e.g. List[Tuple[int, str]])
        """
    iterator: builtins.bool
    """this will be use to define whether the method argument supports streaming as an iterator."""
    default: builtins.str
    """This specify the default value of the method argument
    If this argument is not passed, the input is required. If it is explicitly set to None, the input is optional
    We define this as a string
    because the default value can be a string, int, float, bool, or a complex object like a JSON
    The default_value field above should not also be used.
    """
    is_param: builtins.bool
    """wheather it's a inference param or a modeltype field"""
    def __init__(
        self,
        *,
        path: builtins.str = ...,
        field_type: global___ModelTypeField.ModelTypeFieldType.ValueType = ...,
        default_value: google.protobuf.struct_pb2.Value | None = ...,
        description: builtins.str = ...,
        placeholder: builtins.str = ...,
        model_type_enum_options: collections.abc.Iterable[global___ModelTypeEnumOption]
        | None = ...,
        internal_only: builtins.bool = ...,
        required: builtins.bool = ...,
        model_type_range_info: global___ModelTypeRangeInfo | None = ...,
        name: builtins.str = ...,
        type: global___ModelTypeField.DataType.ValueType = ...,
        type_args: collections.abc.Iterable[global___ModelTypeField] | None = ...,
        iterator: builtins.bool = ...,
        default: builtins.str = ...,
        is_param: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "default_value", b"default_value", "model_type_range_info", b"model_type_range_info"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "default",
            b"default",
            "default_value",
            b"default_value",
            "description",
            b"description",
            "field_type",
            b"field_type",
            "internal_only",
            b"internal_only",
            "is_param",
            b"is_param",
            "iterator",
            b"iterator",
            "model_type_enum_options",
            b"model_type_enum_options",
            "model_type_range_info",
            b"model_type_range_info",
            "name",
            b"name",
            "path",
            b"path",
            "placeholder",
            b"placeholder",
            "required",
            b"required",
            "type",
            b"type",
            "type_args",
            b"type_args",
        ],
    ) -> None: ...

global___ModelTypeField = ModelTypeField

@typing_extensions.final
class ModelTypeRangeInfo(google.protobuf.message.Message):
    """ModelTypeRangeInfo"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_FIELD_NUMBER: builtins.int
    MAX_FIELD_NUMBER: builtins.int
    STEP_FIELD_NUMBER: builtins.int
    min: builtins.float
    """The start of the range as a float."""
    max: builtins.float
    """The end of the range as a float."""
    step: builtins.float
    """An optional step size for the range. If provided then only values at that step size will be
    rounded to. For example if step is 0.02 then 0.0245 will round to 0.02.
    """
    def __init__(
        self,
        *,
        min: builtins.float = ...,
        max: builtins.float = ...,
        step: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["max", b"max", "min", b"min", "step", b"step"]
    ) -> None: ...

global___ModelTypeRangeInfo = ModelTypeRangeInfo

@typing_extensions.final
class ModelTypeEnumOption(google.protobuf.message.Message):
    """ModelTypeEnumOption"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    ALIASES_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    MODEL_TYPE_FIELDS_FIELD_NUMBER: builtins.int
    INTERNAL_ONLY_FIELD_NUMBER: builtins.int
    RECOMMENDED_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The unique value of the enum option."""
    @property
    def aliases(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ModelTypeEnumOptionAlias
    ]:
        """List of other ID values that are equivalent with this ID.
        This allows the user to choose this option by multiple IDs.
        Example: if enum is "Phone Number Prefix", you could add an option that is selectable by two values:
        1. ID: "Estonia"
        2. Alias: 37
        """
    description: builtins.str
    """Optional description for this enum option."""
    @property
    def model_type_fields(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ModelTypeField
    ]:
        """These are additional fields that are specific to this enum choice. This allows
        us to use enums to control configuration settings as well.
        """
    internal_only: builtins.bool
    """If this enum option should be internal only."""
    recommended: builtins.bool
    """Whether this is the recommended enum option. Set to `true` when there
    are multiple options, and one is shown to be better than the others.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        aliases: collections.abc.Iterable[global___ModelTypeEnumOptionAlias] | None = ...,
        description: builtins.str = ...,
        model_type_fields: collections.abc.Iterable[global___ModelTypeField] | None = ...,
        internal_only: builtins.bool = ...,
        recommended: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "aliases",
            b"aliases",
            "description",
            b"description",
            "id",
            b"id",
            "internal_only",
            b"internal_only",
            "model_type_fields",
            b"model_type_fields",
            "recommended",
            b"recommended",
        ],
    ) -> None: ...

global___ModelTypeEnumOption = ModelTypeEnumOption

@typing_extensions.final
class ModelTypeEnumOptionAlias(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_INT_FIELD_NUMBER: builtins.int
    WILDCARD_STRING_FIELD_NUMBER: builtins.int
    id_int: builtins.int
    """Integer alias for id."""
    wildcard_string: builtins.str
    """String that can contain wild cards and the regex needs to match."""
    def __init__(
        self,
        *,
        id_int: builtins.int = ...,
        wildcard_string: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "id_int", b"id_int", "wildcard_string", b"wildcard_string"
        ],
    ) -> None: ...

global___ModelTypeEnumOptionAlias = ModelTypeEnumOptionAlias

@typing_extensions.final
class ModelQuery(google.protobuf.message.Message):
    """ModelQuery"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    MODEL_TYPE_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name ofthe field. This supports wilcard queries like "gen*" to match "general" as an example."""
    model_type_id: builtins.str
    """Filter models by the specific model_type_id. See ListModelTypes for the list of ModelType.Id's
    supported.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        model_type_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["model_type_id", b"model_type_id", "name", b"name"],
    ) -> None: ...

global___ModelQuery = ModelQuery

@typing_extensions.final
class ModelVersion(google.protobuf.message.Message):
    """ModelVersion"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ACTIVE_CONCEPT_COUNT_FIELD_NUMBER: builtins.int
    METRICS_FIELD_NUMBER: builtins.int
    TOTAL_INPUT_COUNT_FIELD_NUMBER: builtins.int
    PRETRAINED_MODEL_CONFIG_FIELD_NUMBER: builtins.int
    COMPLETED_AT_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    LICENSE_FIELD_NUMBER: builtins.int
    OUTPUT_INFO_FIELD_NUMBER: builtins.int
    INPUT_INFO_FIELD_NUMBER: builtins.int
    TRAIN_INFO_FIELD_NUMBER: builtins.int
    IMPORT_INFO_FIELD_NUMBER: builtins.int
    TRAIN_LOG_FIELD_NUMBER: builtins.int
    INFERENCE_COMPUTE_INFO_FIELD_NUMBER: builtins.int
    BUILD_INFO_FIELD_NUMBER: builtins.int
    METHOD_SIGNATURES_FIELD_NUMBER: builtins.int
    SPECIAL_HANDLING_FIELD_NUMBER: builtins.int
    id: builtins.str
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the version was created."""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """The status of the version (whether it's untrained, training, trained, etc.)."""
    active_concept_count: builtins.int
    @property
    def metrics(self) -> global___EvalMetrics: ...
    total_input_count: builtins.int
    """number of inputs in the model version"""
    @property
    def pretrained_model_config(self) -> global___PretrainedModelConfig:
        """When a model has already been trained externally, you can upload
        it directly to the platform as a model version directly by
        setting the PretrainedModelConfig
        """
    @property
    def completed_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Detailed training stats.

        When training of this version was completed.
        """
    description: builtins.str
    """Description about this version"""
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    app_id: builtins.str
    """The app the model version belongs to."""
    user_id: builtins.str
    """The user the model version belongs to."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When this model version was last modified"""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    license: builtins.str
    @property
    def output_info(self) -> global___OutputInfo:
        """Info about the model's output. Besides `output_info.data`, these fields should
        be reserved for parameters that affect the models outputs when inferencing.
        `output_info.data` is used to specify the training concepts for this model version.
        """
    @property
    def input_info(self) -> global___InputInfo:
        """Info about preprocessing the models inputs, before they are sent to this model for training or inferencing.
        E.g.: `input_info.base_embed_model` lets us know inputs should be ran through a base model before being sent to an embedding-classifier.
        """
    @property
    def train_info(self) -> global___TrainInfo:
        """Configuration for the training process of this model version."""
    @property
    def import_info(self) -> global___ImportInfo:
        """Configuration used to import model from third-party toolkits
        DEPRECATED: no longer support importing models from third party toolkits
        """
    train_log: builtins.str
    """Contains the training logs if available"""
    @property
    def inference_compute_info(self) -> global___ComputeInfo:
        """The minimum required compute resource for this model for inference."""
    @property
    def build_info(self) -> global___BuildInfo:
        """Build information for the model version"""
    @property
    def method_signatures(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___MethodSignature
    ]:
        """Model signature information for the model version"""
    @property
    def special_handling(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___SpecialHandling
    ]:
        """List of special handling instructions for this model version."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        active_concept_count: builtins.int = ...,
        metrics: global___EvalMetrics | None = ...,
        total_input_count: builtins.int = ...,
        pretrained_model_config: global___PretrainedModelConfig | None = ...,
        completed_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        description: builtins.str = ...,
        visibility: global___Visibility | None = ...,
        app_id: builtins.str = ...,
        user_id: builtins.str = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        license: builtins.str = ...,
        output_info: global___OutputInfo | None = ...,
        input_info: global___InputInfo | None = ...,
        train_info: global___TrainInfo | None = ...,
        import_info: global___ImportInfo | None = ...,
        train_log: builtins.str = ...,
        inference_compute_info: global___ComputeInfo | None = ...,
        build_info: global___BuildInfo | None = ...,
        method_signatures: collections.abc.Iterable[global___MethodSignature] | None = ...,
        special_handling: collections.abc.Iterable[global___SpecialHandling] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "build_info",
            b"build_info",
            "completed_at",
            b"completed_at",
            "created_at",
            b"created_at",
            "import_info",
            b"import_info",
            "inference_compute_info",
            b"inference_compute_info",
            "input_info",
            b"input_info",
            "metadata",
            b"metadata",
            "metrics",
            b"metrics",
            "modified_at",
            b"modified_at",
            "output_info",
            b"output_info",
            "pretrained_model_config",
            b"pretrained_model_config",
            "status",
            b"status",
            "train_info",
            b"train_info",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "active_concept_count",
            b"active_concept_count",
            "app_id",
            b"app_id",
            "build_info",
            b"build_info",
            "completed_at",
            b"completed_at",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "id",
            b"id",
            "import_info",
            b"import_info",
            "inference_compute_info",
            b"inference_compute_info",
            "input_info",
            b"input_info",
            "license",
            b"license",
            "metadata",
            b"metadata",
            "method_signatures",
            b"method_signatures",
            "metrics",
            b"metrics",
            "modified_at",
            b"modified_at",
            "output_info",
            b"output_info",
            "pretrained_model_config",
            b"pretrained_model_config",
            "special_handling",
            b"special_handling",
            "status",
            b"status",
            "total_input_count",
            b"total_input_count",
            "train_info",
            b"train_info",
            "train_log",
            b"train_log",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___ModelVersion = ModelVersion

@typing_extensions.final
class MethodSignature(google.protobuf.message.Message):
    """MethodSignature is a definition of a method that a model can have.
    This is used to communicate between a python method definition of any arbitrary function
    to the client or UI on how to call that function from the client side.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    METHOD_TYPE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    INPUT_FIELDS_FIELD_NUMBER: builtins.int
    OUTPUT_FIELDS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the method on the server."""
    method_type: global___RunnerMethodType.ValueType
    """whether the method is for predict(unary-unary), generate(unary-stream), stream(stream-stream)"""
    description: builtins.str
    """description from the docstring of the method on the server."""
    @property
    def input_fields(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ModelTypeField
    ]:
        """input fields and signature of every method arguments"""
    @property
    def output_fields(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ModelTypeField
    ]:
        """output signature of method"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        method_type: global___RunnerMethodType.ValueType = ...,
        description: builtins.str = ...,
        input_fields: collections.abc.Iterable[global___ModelTypeField] | None = ...,
        output_fields: collections.abc.Iterable[global___ModelTypeField] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "description",
            b"description",
            "input_fields",
            b"input_fields",
            "method_type",
            b"method_type",
            "name",
            b"name",
            "output_fields",
            b"output_fields",
        ],
    ) -> None: ...

global___MethodSignature = MethodSignature

@typing_extensions.final
class BuildInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DOCKER_IMAGE_NAME_FIELD_NUMBER: builtins.int
    DOCKER_IMAGE_TAG_FIELD_NUMBER: builtins.int
    DOCKER_IMAGE_DIGEST_FIELD_NUMBER: builtins.int
    docker_image_name: builtins.str
    """Docker image name"""
    docker_image_tag: builtins.str
    """Docker image tag"""
    docker_image_digest: builtins.str
    """Docker image digest"""
    def __init__(
        self,
        *,
        docker_image_name: builtins.str = ...,
        docker_image_tag: builtins.str = ...,
        docker_image_digest: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "docker_image_digest",
            b"docker_image_digest",
            "docker_image_name",
            b"docker_image_name",
            "docker_image_tag",
            b"docker_image_tag",
        ],
    ) -> None: ...

global___BuildInfo = BuildInfo

@typing_extensions.final
class ModelVersionExport(google.protobuf.message.Message):
    """ModelVersionExport contains metadata for a single Model version export."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """status is the current status of the dataset version export."""
    url: builtins.str
    """url is the URL from where the model version export can be downloaded."""
    size: builtins.int
    """size of model file"""
    def __init__(
        self,
        *,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        url: builtins.str = ...,
        size: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["status", b"status"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["size", b"size", "status", b"status", "url", b"url"],
    ) -> None: ...

global___ModelVersionExport = ModelVersionExport

@typing_extensions.final
class PretrainedModelConfig(google.protobuf.message.Message):
    """PretrainedModelConfig"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUT_FIELDS_MAP_FIELD_NUMBER: builtins.int
    OUTPUT_FIELDS_MAP_FIELD_NUMBER: builtins.int
    MODEL_ZIP_URL_FIELD_NUMBER: builtins.int
    LOCAL_DEV_FIELD_NUMBER: builtins.int
    @property
    def input_fields_map(self) -> google.protobuf.struct_pb2.Struct:
        """This is the internal id of the pretrained model.
        Map from the api.Data field names to the Triton config.pbtxt input.
        """
    @property
    def output_fields_map(self) -> google.protobuf.struct_pb2.Struct:
        """Map from the api.Data field names to the Triton config.pbtxt output."""
    model_zip_url: builtins.str
    """Url to a zipped up model in triton format with the following files and folders at the root:
     config.pbtxt
     version 1 folder that contains model files (onnx graph, torch script, python BE model, and etc.)
    """
    local_dev: builtins.bool
    """Whether to overwrite the model for the existing internal id
    If this is a local dev model that runs external to the platform, set this to true.
    This helps during development of models before uploading them to the platform.
    These models MUST run in an associated compute cluster with cluster_type = "local-dev"
    """
    def __init__(
        self,
        *,
        input_fields_map: google.protobuf.struct_pb2.Struct | None = ...,
        output_fields_map: google.protobuf.struct_pb2.Struct | None = ...,
        model_zip_url: builtins.str = ...,
        local_dev: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "input_fields_map", b"input_fields_map", "output_fields_map", b"output_fields_map"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "input_fields_map",
            b"input_fields_map",
            "local_dev",
            b"local_dev",
            "model_zip_url",
            b"model_zip_url",
            "output_fields_map",
            b"output_fields_map",
        ],
    ) -> None: ...

global___PretrainedModelConfig = PretrainedModelConfig

@typing_extensions.final
class TrainStats(google.protobuf.message.Message):
    """TrainStats"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOSS_CURVE_FIELD_NUMBER: builtins.int
    @property
    def loss_curve(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___LossCurveEntry
    ]: ...
    def __init__(
        self,
        *,
        loss_curve: collections.abc.Iterable[global___LossCurveEntry] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["loss_curve", b"loss_curve"]
    ) -> None: ...

global___TrainStats = TrainStats

@typing_extensions.final
class LossCurveEntry(google.protobuf.message.Message):
    """LossCurveEntry"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EPOCH_FIELD_NUMBER: builtins.int
    GLOBAL_STEP_FIELD_NUMBER: builtins.int
    COST_FIELD_NUMBER: builtins.int
    epoch: builtins.int
    """current epoch"""
    global_step: builtins.int
    """current global step"""
    cost: builtins.float
    """current cost
    FIXME(rigel): this should be loss instead of cost.
    """
    def __init__(
        self,
        *,
        epoch: builtins.int = ...,
        global_step: builtins.int = ...,
        cost: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cost", b"cost", "epoch", b"epoch", "global_step", b"global_step"
        ],
    ) -> None: ...

global___LossCurveEntry = LossCurveEntry

@typing_extensions.final
class LabelCount(google.protobuf.message.Message):
    """LabelCount"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONCEPT_NAME_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    CONCEPT_FIELD_NUMBER: builtins.int
    concept_name: builtins.str
    count: builtins.int
    @property
    def concept(self) -> global___Concept: ...
    def __init__(
        self,
        *,
        concept_name: builtins.str = ...,
        count: builtins.int = ...,
        concept: global___Concept | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["concept", b"concept"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "concept", b"concept", "concept_name", b"concept_name", "count", b"count"
        ],
    ) -> None: ...

global___LabelCount = LabelCount

@typing_extensions.final
class LabelDistribution(google.protobuf.message.Message):
    """LabelDistribution"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POSITIVE_LABEL_COUNTS_FIELD_NUMBER: builtins.int
    @property
    def positive_label_counts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___LabelCount
    ]: ...
    def __init__(
        self,
        *,
        positive_label_counts: collections.abc.Iterable[global___LabelCount] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["positive_label_counts", b"positive_label_counts"],
    ) -> None: ...

global___LabelDistribution = LabelDistribution

@typing_extensions.final
class CooccurrenceMatrixEntry(google.protobuf.message.Message):
    """NOTE: this is inefficient, should just have the order of the rows/cols"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROW_FIELD_NUMBER: builtins.int
    COL_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    row: builtins.str
    """concept_id for the row"""
    col: builtins.str
    """concept_id for the col"""
    count: builtins.int
    def __init__(
        self,
        *,
        row: builtins.str = ...,
        col: builtins.str = ...,
        count: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["col", b"col", "count", b"count", "row", b"row"],
    ) -> None: ...

global___CooccurrenceMatrixEntry = CooccurrenceMatrixEntry

@typing_extensions.final
class CooccurrenceMatrix(google.protobuf.message.Message):
    """CooccurrenceMatrix"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MATRIX_FIELD_NUMBER: builtins.int
    CONCEPT_IDS_FIELD_NUMBER: builtins.int
    @property
    def matrix(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___CooccurrenceMatrixEntry
    ]: ...
    @property
    def concept_ids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """These concept_ids are ordered by the strength of the diagonal in the ConfusionMatrix."""
    def __init__(
        self,
        *,
        matrix: collections.abc.Iterable[global___CooccurrenceMatrixEntry] | None = ...,
        concept_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["concept_ids", b"concept_ids", "matrix", b"matrix"],
    ) -> None: ...

global___CooccurrenceMatrix = CooccurrenceMatrix

@typing_extensions.final
class ConfusionMatrixEntry(google.protobuf.message.Message):
    """ConfusionMatrixEntry"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREDICTED_FIELD_NUMBER: builtins.int
    ACTUAL_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    PREDICTED_CONCEPT_FIELD_NUMBER: builtins.int
    ACTUAL_CONCEPT_FIELD_NUMBER: builtins.int
    predicted: builtins.str
    actual: builtins.str
    value: builtins.float
    @property
    def predicted_concept(self) -> global___Concept: ...
    @property
    def actual_concept(self) -> global___Concept: ...
    def __init__(
        self,
        *,
        predicted: builtins.str = ...,
        actual: builtins.str = ...,
        value: builtins.float = ...,
        predicted_concept: global___Concept | None = ...,
        actual_concept: global___Concept | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "actual_concept", b"actual_concept", "predicted_concept", b"predicted_concept"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "actual",
            b"actual",
            "actual_concept",
            b"actual_concept",
            "predicted",
            b"predicted",
            "predicted_concept",
            b"predicted_concept",
            "value",
            b"value",
        ],
    ) -> None: ...

global___ConfusionMatrixEntry = ConfusionMatrixEntry

@typing_extensions.final
class ConfusionMatrix(google.protobuf.message.Message):
    """ConfusionMatrix"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MATRIX_FIELD_NUMBER: builtins.int
    CONCEPT_IDS_FIELD_NUMBER: builtins.int
    @property
    def matrix(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ConfusionMatrixEntry
    ]: ...
    @property
    def concept_ids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """These concept_ids are ordered by the strength of the diagonal in the ConfusionMatrix."""
    def __init__(
        self,
        *,
        matrix: collections.abc.Iterable[global___ConfusionMatrixEntry] | None = ...,
        concept_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["concept_ids", b"concept_ids", "matrix", b"matrix"],
    ) -> None: ...

global___ConfusionMatrix = ConfusionMatrix

@typing_extensions.final
class ROC(google.protobuf.message.Message):
    """ROC"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FPR_FIELD_NUMBER: builtins.int
    TPR_FIELD_NUMBER: builtins.int
    THRESHOLDS_FIELD_NUMBER: builtins.int
    FPR_PER_IMAGE_FIELD_NUMBER: builtins.int
    FPR_PER_OBJECT_FIELD_NUMBER: builtins.int
    @property
    def fpr(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def tpr(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def thresholds(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def fpr_per_image(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def fpr_per_object(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        fpr: collections.abc.Iterable[builtins.float] | None = ...,
        tpr: collections.abc.Iterable[builtins.float] | None = ...,
        thresholds: collections.abc.Iterable[builtins.float] | None = ...,
        fpr_per_image: collections.abc.Iterable[builtins.float] | None = ...,
        fpr_per_object: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "fpr",
            b"fpr",
            "fpr_per_image",
            b"fpr_per_image",
            "fpr_per_object",
            b"fpr_per_object",
            "thresholds",
            b"thresholds",
            "tpr",
            b"tpr",
        ],
    ) -> None: ...

global___ROC = ROC

@typing_extensions.final
class PrecisionRecallCurve(google.protobuf.message.Message):
    """PrecisionRecallCurve"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECALL_FIELD_NUMBER: builtins.int
    PRECISION_FIELD_NUMBER: builtins.int
    THRESHOLDS_FIELD_NUMBER: builtins.int
    @property
    def recall(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def precision(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    @property
    def thresholds(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]: ...
    def __init__(
        self,
        *,
        recall: collections.abc.Iterable[builtins.float] | None = ...,
        precision: collections.abc.Iterable[builtins.float] | None = ...,
        thresholds: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "precision", b"precision", "recall", b"recall", "thresholds", b"thresholds"
        ],
    ) -> None: ...

global___PrecisionRecallCurve = PrecisionRecallCurve

@typing_extensions.final
class BinaryMetrics(google.protobuf.message.Message):
    """BinaryMetrics"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NUM_POS_FIELD_NUMBER: builtins.int
    NUM_NEG_FIELD_NUMBER: builtins.int
    NUM_TOT_FIELD_NUMBER: builtins.int
    ROC_AUC_FIELD_NUMBER: builtins.int
    F1_FIELD_NUMBER: builtins.int
    CONCEPT_FIELD_NUMBER: builtins.int
    ROC_CURVE_FIELD_NUMBER: builtins.int
    PRECISION_RECALL_CURVE_FIELD_NUMBER: builtins.int
    AVG_PRECISION_FIELD_NUMBER: builtins.int
    AREA_NAME_FIELD_NUMBER: builtins.int
    AREA_MIN_FIELD_NUMBER: builtins.int
    AREA_MAX_FIELD_NUMBER: builtins.int
    IOU_FIELD_NUMBER: builtins.int
    num_pos: builtins.int
    num_neg: builtins.int
    num_tot: builtins.int
    roc_auc: builtins.float
    f1: builtins.float
    @property
    def concept(self) -> global___Concept: ...
    @property
    def roc_curve(self) -> global___ROC: ...
    @property
    def precision_recall_curve(self) -> global___PrecisionRecallCurve: ...
    avg_precision: builtins.float
    area_name: builtins.str
    area_min: builtins.float
    area_max: builtins.float
    iou: builtins.float
    def __init__(
        self,
        *,
        num_pos: builtins.int = ...,
        num_neg: builtins.int = ...,
        num_tot: builtins.int = ...,
        roc_auc: builtins.float = ...,
        f1: builtins.float = ...,
        concept: global___Concept | None = ...,
        roc_curve: global___ROC | None = ...,
        precision_recall_curve: global___PrecisionRecallCurve | None = ...,
        avg_precision: builtins.float = ...,
        area_name: builtins.str = ...,
        area_min: builtins.float = ...,
        area_max: builtins.float = ...,
        iou: builtins.float = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "concept",
            b"concept",
            "precision_recall_curve",
            b"precision_recall_curve",
            "roc_curve",
            b"roc_curve",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "area_max",
            b"area_max",
            "area_min",
            b"area_min",
            "area_name",
            b"area_name",
            "avg_precision",
            b"avg_precision",
            "concept",
            b"concept",
            "f1",
            b"f1",
            "iou",
            b"iou",
            "num_neg",
            b"num_neg",
            "num_pos",
            b"num_pos",
            "num_tot",
            b"num_tot",
            "precision_recall_curve",
            b"precision_recall_curve",
            "roc_auc",
            b"roc_auc",
            "roc_curve",
            b"roc_curve",
        ],
    ) -> None: ...

global___BinaryMetrics = BinaryMetrics

@typing_extensions.final
class TrackerMetrics(google.protobuf.message.Message):
    """TrackerMetrics"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MOT_MOTA_FIELD_NUMBER: builtins.int
    MOT_NUM_SWITCHES_FIELD_NUMBER: builtins.int
    MORSE_FRAG_FIELD_NUMBER: builtins.int
    AVG_PRECISION_FIELD_NUMBER: builtins.int
    AIID_FIELD_NUMBER: builtins.int
    UNIQUE_SWITCH_RATE_FIELD_NUMBER: builtins.int
    mot_mota: builtins.float
    """Multiple object tracking accuracy"""
    mot_num_switches: builtins.int
    """Number of switches between tracks"""
    morse_frag: builtins.float
    """MORSE fragmentation rate (a.k.a unique switch rate, only calculated in public sector)"""
    avg_precision: builtins.float
    """Average precision calculated from all processed frames"""
    aiid: builtins.str
    """The concept that we are evaluating the tracker"""
    unique_switch_rate: builtins.float
    """Same as morse_frag but calculated using MOT mapping/metrics"""
    def __init__(
        self,
        *,
        mot_mota: builtins.float = ...,
        mot_num_switches: builtins.int = ...,
        morse_frag: builtins.float = ...,
        avg_precision: builtins.float = ...,
        aiid: builtins.str = ...,
        unique_switch_rate: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "aiid",
            b"aiid",
            "avg_precision",
            b"avg_precision",
            "morse_frag",
            b"morse_frag",
            "mot_mota",
            b"mot_mota",
            "mot_num_switches",
            b"mot_num_switches",
            "unique_switch_rate",
            b"unique_switch_rate",
        ],
    ) -> None: ...

global___TrackerMetrics = TrackerMetrics

@typing_extensions.final
class EvalTestSetEntry(google.protobuf.message.Message):
    """EvalTestSetEntry"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUT_FIELD_NUMBER: builtins.int
    PREDICTED_CONCEPTS_FIELD_NUMBER: builtins.int
    GROUND_TRUTH_CONCEPTS_FIELD_NUMBER: builtins.int
    ANNOTATION_FIELD_NUMBER: builtins.int
    PREDICTED_ANNOTATION_FIELD_NUMBER: builtins.int
    GROUND_TRUTH_ANNOTATION_FIELD_NUMBER: builtins.int
    @property
    def input(self) -> global___Input:
        """the input information"""
    @property
    def predicted_concepts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Concept]: ...
    @property
    def ground_truth_concepts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Concept]:
        """All the ground truth concepts will be show on the top level"""
    @property
    def annotation(self) -> global___Annotation:
        """Only region-based/frame-based app contains this annotation
        Each annotation only contains one region
        And the concepts is in ground_truth_concepts instead of this annotation
        """
    @property
    def predicted_annotation(self) -> global___Annotation:
        """For region based models, region and associated concepts are stored together."""
    @property
    def ground_truth_annotation(self) -> global___Annotation: ...
    def __init__(
        self,
        *,
        input: global___Input | None = ...,
        predicted_concepts: collections.abc.Iterable[global___Concept] | None = ...,
        ground_truth_concepts: collections.abc.Iterable[global___Concept] | None = ...,
        annotation: global___Annotation | None = ...,
        predicted_annotation: global___Annotation | None = ...,
        ground_truth_annotation: global___Annotation | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "annotation",
            b"annotation",
            "ground_truth_annotation",
            b"ground_truth_annotation",
            "input",
            b"input",
            "predicted_annotation",
            b"predicted_annotation",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "annotation",
            b"annotation",
            "ground_truth_annotation",
            b"ground_truth_annotation",
            "ground_truth_concepts",
            b"ground_truth_concepts",
            "input",
            b"input",
            "predicted_annotation",
            b"predicted_annotation",
            "predicted_concepts",
            b"predicted_concepts",
        ],
    ) -> None: ...

global___EvalTestSetEntry = EvalTestSetEntry

@typing_extensions.final
class LOPQEvalResult(google.protobuf.message.Message):
    """LOPQEvalResult"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    K_FIELD_NUMBER: builtins.int
    RECALL_VS_BRUTE_FORCE_FIELD_NUMBER: builtins.int
    KENDALL_TAU_VS_BRUTE_FORCE_FIELD_NUMBER: builtins.int
    MOST_FREQUENT_CODE_PERCENT_FIELD_NUMBER: builtins.int
    LOPQ_NDCG_FIELD_NUMBER: builtins.int
    BRUTE_FORCE_NDCG_FIELD_NUMBER: builtins.int
    k: builtins.int
    """Rank k for which all metrics are reported."""
    recall_vs_brute_force: builtins.float
    """Recall @ k assuming the brute force search is the ground truth."""
    kendall_tau_vs_brute_force: builtins.float
    """Kendall's tau correlation @ k assuming the brute force search is the ground truth."""
    most_frequent_code_percent: builtins.float
    """The percentage of the most frequent code in the indexed part of evaluation data."""
    lopq_ndcg: builtins.float
    """Normalized Discounted Cumulative Gain (NDCG) @ k with a ground truth inferred from annotations
    and/or prediction for this evaluation LOPQ model.
    NDCG uses individual relevance scores of each returned image to evaluate the usefulness, or
    gain, of a document based on its position in the result list. The premise of DCG is that
    highly relevant documents appearing lower in a search result list should be penalized as the
    graded relevance value is reduced logarithmically proportional to the position of the result.
    See: https://en.wikipedia.org/wiki/Information_retrieval#Discounted_cumulative_gain

    To compute the relevance score between two images we consider two cases:
    1) Only one label for each image
    An image is relevant to an image query iff they are labeled the same (score 1), and
    not relevant otherwise (score 0)
    2) Multiple labels for each image
    Here an image relevancy with respect to a single image query is measured by f-beta score
    assuming the query image list of labels as ground truth and comparing them with that of
    the search result. These labels can come from image annotations or if substitute_annotation_misses
    is set, predictions of base classifier where any prediction with prob < prob_threshold are
    discarded. To quantify the relevancy score of a single search result we opt to compute precision
    and recall @ k for simplicity, and combine them with f-beta score to obtain a single number.
    """
    brute_force_ndcg: builtins.float
    """Brute force NDCG which gives a baseline to compare to and is a measure of how good
    the embeddings are.
    """
    def __init__(
        self,
        *,
        k: builtins.int = ...,
        recall_vs_brute_force: builtins.float = ...,
        kendall_tau_vs_brute_force: builtins.float = ...,
        most_frequent_code_percent: builtins.float = ...,
        lopq_ndcg: builtins.float = ...,
        brute_force_ndcg: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "brute_force_ndcg",
            b"brute_force_ndcg",
            "k",
            b"k",
            "kendall_tau_vs_brute_force",
            b"kendall_tau_vs_brute_force",
            "lopq_ndcg",
            b"lopq_ndcg",
            "most_frequent_code_percent",
            b"most_frequent_code_percent",
            "recall_vs_brute_force",
            b"recall_vs_brute_force",
        ],
    ) -> None: ...

global___LOPQEvalResult = LOPQEvalResult

@typing_extensions.final
class MetricsSummary(google.protobuf.message.Message):
    """MetricsSummary"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOP1_ACCURACY_FIELD_NUMBER: builtins.int
    TOP5_ACCURACY_FIELD_NUMBER: builtins.int
    MACRO_AVG_ROC_AUC_FIELD_NUMBER: builtins.int
    MACRO_STD_ROC_AUC_FIELD_NUMBER: builtins.int
    MACRO_AVG_F1_SCORE_FIELD_NUMBER: builtins.int
    MACRO_STD_F1_SCORE_FIELD_NUMBER: builtins.int
    MACRO_AVG_PRECISION_FIELD_NUMBER: builtins.int
    MACRO_AVG_RECALL_FIELD_NUMBER: builtins.int
    MEAN_AVG_PRECISION_IOU_50_FIELD_NUMBER: builtins.int
    MEAN_AVG_PRECISION_IOU_RANGE_FIELD_NUMBER: builtins.int
    LOPQ_METRICS_FIELD_NUMBER: builtins.int
    top1_accuracy: builtins.float
    top5_accuracy: builtins.float
    macro_avg_roc_auc: builtins.float
    macro_std_roc_auc: builtins.float
    macro_avg_f1_score: builtins.float
    macro_std_f1_score: builtins.float
    macro_avg_precision: builtins.float
    macro_avg_recall: builtins.float
    mean_avg_precision_iou_50: builtins.float
    mean_avg_precision_iou_range: builtins.float
    @property
    def lopq_metrics(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___LOPQEvalResult
    ]: ...
    def __init__(
        self,
        *,
        top1_accuracy: builtins.float = ...,
        top5_accuracy: builtins.float = ...,
        macro_avg_roc_auc: builtins.float = ...,
        macro_std_roc_auc: builtins.float = ...,
        macro_avg_f1_score: builtins.float = ...,
        macro_std_f1_score: builtins.float = ...,
        macro_avg_precision: builtins.float = ...,
        macro_avg_recall: builtins.float = ...,
        mean_avg_precision_iou_50: builtins.float = ...,
        mean_avg_precision_iou_range: builtins.float = ...,
        lopq_metrics: collections.abc.Iterable[global___LOPQEvalResult] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "lopq_metrics",
            b"lopq_metrics",
            "macro_avg_f1_score",
            b"macro_avg_f1_score",
            "macro_avg_precision",
            b"macro_avg_precision",
            "macro_avg_recall",
            b"macro_avg_recall",
            "macro_avg_roc_auc",
            b"macro_avg_roc_auc",
            "macro_std_f1_score",
            b"macro_std_f1_score",
            "macro_std_roc_auc",
            b"macro_std_roc_auc",
            "mean_avg_precision_iou_50",
            b"mean_avg_precision_iou_50",
            "mean_avg_precision_iou_range",
            b"mean_avg_precision_iou_range",
            "top1_accuracy",
            b"top1_accuracy",
            "top5_accuracy",
            b"top5_accuracy",
        ],
    ) -> None: ...

global___MetricsSummary = MetricsSummary

@typing_extensions.final
class EvalMetrics(google.protobuf.message.Message):
    """EvalMetrics"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    GROUND_TRUTH_DATASET_FIELD_NUMBER: builtins.int
    PREDICTIONS_DATASET_FIELD_NUMBER: builtins.int
    SUMMARY_FIELD_NUMBER: builtins.int
    CONFUSION_MATRIX_FIELD_NUMBER: builtins.int
    COOCCURRENCE_MATRIX_FIELD_NUMBER: builtins.int
    LABEL_COUNTS_FIELD_NUMBER: builtins.int
    BINARY_METRICS_FIELD_NUMBER: builtins.int
    TEST_SET_FIELD_NUMBER: builtins.int
    METRICS_BY_AREA_FIELD_NUMBER: builtins.int
    METRICS_BY_CLASS_FIELD_NUMBER: builtins.int
    TRACKER_METRICS_FIELD_NUMBER: builtins.int
    EVAL_INFO_FIELD_NUMBER: builtins.int
    EXTENDED_METRICS_FIELD_NUMBER: builtins.int
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status: ...
    user_id: builtins.str
    """user id that owns this evaluation"""
    app_id: builtins.str
    """app id that owns this evaluation"""
    id: builtins.str
    """Id of this evaluation"""
    @property
    def model(self) -> global___Model:
        """Model to evaluate"""
    @property
    def ground_truth_dataset(self) -> global___Dataset:
        """The ground truth dataset"""
    @property
    def predictions_dataset(self) -> global___Dataset:
        """The dataset with predictions"""
    @property
    def summary(self) -> global___MetricsSummary: ...
    @property
    def confusion_matrix(self) -> global___ConfusionMatrix: ...
    @property
    def cooccurrence_matrix(self) -> global___CooccurrenceMatrix: ...
    @property
    def label_counts(self) -> global___LabelDistribution: ...
    @property
    def binary_metrics(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___BinaryMetrics
    ]: ...
    @property
    def test_set(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___EvalTestSetEntry
    ]: ...
    @property
    def metrics_by_area(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___BinaryMetrics
    ]: ...
    @property
    def metrics_by_class(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___BinaryMetrics
    ]: ...
    @property
    def tracker_metrics(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___TrackerMetrics
    ]: ...
    @property
    def eval_info(self) -> global___EvalInfo:
        """Evaluation parameters to pass. Expected to match what
        is defined in the model type for the respective model.
        """
    @property
    def extended_metrics(self) -> global___ExtendedMetrics: ...
    def __init__(
        self,
        *,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        user_id: builtins.str = ...,
        app_id: builtins.str = ...,
        id: builtins.str = ...,
        model: global___Model | None = ...,
        ground_truth_dataset: global___Dataset | None = ...,
        predictions_dataset: global___Dataset | None = ...,
        summary: global___MetricsSummary | None = ...,
        confusion_matrix: global___ConfusionMatrix | None = ...,
        cooccurrence_matrix: global___CooccurrenceMatrix | None = ...,
        label_counts: global___LabelDistribution | None = ...,
        binary_metrics: collections.abc.Iterable[global___BinaryMetrics] | None = ...,
        test_set: collections.abc.Iterable[global___EvalTestSetEntry] | None = ...,
        metrics_by_area: collections.abc.Iterable[global___BinaryMetrics] | None = ...,
        metrics_by_class: collections.abc.Iterable[global___BinaryMetrics] | None = ...,
        tracker_metrics: collections.abc.Iterable[global___TrackerMetrics] | None = ...,
        eval_info: global___EvalInfo | None = ...,
        extended_metrics: global___ExtendedMetrics | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "confusion_matrix",
            b"confusion_matrix",
            "cooccurrence_matrix",
            b"cooccurrence_matrix",
            "eval_info",
            b"eval_info",
            "extended_metrics",
            b"extended_metrics",
            "ground_truth_dataset",
            b"ground_truth_dataset",
            "label_counts",
            b"label_counts",
            "model",
            b"model",
            "predictions_dataset",
            b"predictions_dataset",
            "status",
            b"status",
            "summary",
            b"summary",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "binary_metrics",
            b"binary_metrics",
            "confusion_matrix",
            b"confusion_matrix",
            "cooccurrence_matrix",
            b"cooccurrence_matrix",
            "eval_info",
            b"eval_info",
            "extended_metrics",
            b"extended_metrics",
            "ground_truth_dataset",
            b"ground_truth_dataset",
            "id",
            b"id",
            "label_counts",
            b"label_counts",
            "metrics_by_area",
            b"metrics_by_area",
            "metrics_by_class",
            b"metrics_by_class",
            "model",
            b"model",
            "predictions_dataset",
            b"predictions_dataset",
            "status",
            b"status",
            "summary",
            b"summary",
            "test_set",
            b"test_set",
            "tracker_metrics",
            b"tracker_metrics",
            "user_id",
            b"user_id",
        ],
    ) -> None: ...

global___EvalMetrics = EvalMetrics

@typing_extensions.final
class ExtendedMetrics(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_METRICS_FIELD_NUMBER: builtins.int
    @property
    def user_metrics(self) -> google.protobuf.struct_pb2.Struct: ...
    def __init__(
        self,
        *,
        user_metrics: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["user_metrics", b"user_metrics"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["user_metrics", b"user_metrics"]
    ) -> None: ...

global___ExtendedMetrics = ExtendedMetrics

@typing_extensions.final
class FieldsValue(google.protobuf.message.Message):
    """FieldsValue"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFUSION_MATRIX_FIELD_NUMBER: builtins.int
    COOCCURRENCE_MATRIX_FIELD_NUMBER: builtins.int
    LABEL_COUNTS_FIELD_NUMBER: builtins.int
    BINARY_METRICS_FIELD_NUMBER: builtins.int
    TEST_SET_FIELD_NUMBER: builtins.int
    METRICS_BY_AREA_FIELD_NUMBER: builtins.int
    METRICS_BY_CLASS_FIELD_NUMBER: builtins.int
    confusion_matrix: builtins.bool
    cooccurrence_matrix: builtins.bool
    label_counts: builtins.bool
    binary_metrics: builtins.bool
    test_set: builtins.bool
    metrics_by_area: builtins.bool
    metrics_by_class: builtins.bool
    def __init__(
        self,
        *,
        confusion_matrix: builtins.bool = ...,
        cooccurrence_matrix: builtins.bool = ...,
        label_counts: builtins.bool = ...,
        binary_metrics: builtins.bool = ...,
        test_set: builtins.bool = ...,
        metrics_by_area: builtins.bool = ...,
        metrics_by_class: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "binary_metrics",
            b"binary_metrics",
            "confusion_matrix",
            b"confusion_matrix",
            "cooccurrence_matrix",
            b"cooccurrence_matrix",
            "label_counts",
            b"label_counts",
            "metrics_by_area",
            b"metrics_by_area",
            "metrics_by_class",
            b"metrics_by_class",
            "test_set",
            b"test_set",
        ],
    ) -> None: ...

global___FieldsValue = FieldsValue

@typing_extensions.final
class Output(google.protobuf.message.Message):
    """Output"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    PROMPT_TOKENS_FIELD_NUMBER: builtins.int
    COMPLETION_TOKENS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """One of these outputs per Input"""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status: ...
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the object was created. We follow the XXXX timestamp
        format. We use https://www.ietf.org/rfc/rfc3339.txt format:
        "2006-01-02T15:04:05.999999Z" so you can expect results like
        the following from the API:
        "2017-04-11T21:50:50.223962Z"
        """
    @property
    def model(self) -> global___Model:
        """The model that created this Output."""
    @property
    def input(self) -> global___Input:
        """The input that was passed to the model to create this Output. For example if we have an image
        model then it will take as input here an Input object with Image filled in.
        """
    @property
    def data(self) -> global___Data:
        """The output data for this Output. For example if we have a concept model then the predicted
        concepts will appear here.
        """
    prompt_tokens: builtins.int
    """Number of prompt tokens as reported by the model or third-party API."""
    completion_tokens: builtins.int
    """Number of completion tokens as reported by the model or third-party API."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        model: global___Model | None = ...,
        input: global___Input | None = ...,
        data: global___Data | None = ...,
        prompt_tokens: builtins.int = ...,
        completion_tokens: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "data",
            b"data",
            "input",
            b"input",
            "model",
            b"model",
            "status",
            b"status",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "completion_tokens",
            b"completion_tokens",
            "created_at",
            b"created_at",
            "data",
            b"data",
            "id",
            b"id",
            "input",
            b"input",
            "model",
            b"model",
            "prompt_tokens",
            b"prompt_tokens",
            "status",
            b"status",
        ],
    ) -> None: ...

global___Output = Output

@typing_extensions.final
class ScopeDeps(google.protobuf.message.Message):
    """ScopeDeps"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCOPE_FIELD_NUMBER: builtins.int
    DEPENDING_SCOPES_FIELD_NUMBER: builtins.int
    scope: builtins.str
    """The scope"""
    @property
    def depending_scopes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Other scopes that are required."""
    def __init__(
        self,
        *,
        scope: builtins.str = ...,
        depending_scopes: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "depending_scopes", b"depending_scopes", "scope", b"scope"
        ],
    ) -> None: ...

global___ScopeDeps = ScopeDeps

@typing_extensions.final
class EndpointDeps(google.protobuf.message.Message):
    """EndpointDeps"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENDPOINT_FIELD_NUMBER: builtins.int
    DEPENDING_SCOPES_FIELD_NUMBER: builtins.int
    endpoint: builtins.str
    """The fully qualified endpoint to"""
    @property
    def depending_scopes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Other scopes that are required."""
    def __init__(
        self,
        *,
        endpoint: builtins.str = ...,
        depending_scopes: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "depending_scopes", b"depending_scopes", "endpoint", b"endpoint"
        ],
    ) -> None: ...

global___EndpointDeps = EndpointDeps

@typing_extensions.final
class Hit(google.protobuf.message.Message):
    """Hit"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCORE_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    ANNOTATION_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    score: builtins.float
    """This is the score for the ranked Hit results of the search query. This score is a number
    between 0.0 and 1.0 as it represents a confidence in the search Hit. For example, if you search
    for "car" and get a close matching Hit, the score should be close to 1.0. If you get a score
    of close to 0.0 that means it's very disimilar to your query, in this case NOT a "car". There
    is a special intermediate score of 0.5 that means that the Hit is not really correlated with
    your search query (ie. not similar or dissimlar to the query) which is a common occurrence
    when using negate queries.
    Note: some queries that are just filtering down your app of inputs may just return a score of
    1.0 for all Hits.
    """
    @property
    def input(self) -> global___Input:
        """This is the matched input returned from the search query. This will contain information about
        the Input such as the url, created_at time and trusted annotation information (for backwards
        compatibility with apps that existed before Annotations were introduced.
        """
    @property
    def annotation(self) -> global___Annotation:
        """We also provide back the specific matched annotation for the above input. We do this in order
        to support more complex Annotation queries in the And message below. For example if we match
        the search results to a region in your input, or a frame in a video input, this annotation
        field will be that matched annotation info and the input will be the image/video that the user
        originally added which contains those regions / frames.
        """
    user_id: builtins.str
    """The customer-facing id of the user who owns the app the asset came from."""
    app_id: builtins.str
    """The cfid of the app the asset came from."""
    def __init__(
        self,
        *,
        score: builtins.float = ...,
        input: global___Input | None = ...,
        annotation: global___Annotation | None = ...,
        user_id: builtins.str = ...,
        app_id: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["annotation", b"annotation", "input", b"input"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "annotation",
            b"annotation",
            "app_id",
            b"app_id",
            "input",
            b"input",
            "score",
            b"score",
            "user_id",
            b"user_id",
        ],
    ) -> None: ...

global___Hit = Hit

@typing_extensions.final
class HitCount(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ESTIMATED_TOTAL_FIELD_NUMBER: builtins.int
    estimated_total: builtins.int
    """The estimated total number of hits for the search query, not just the current page."""
    def __init__(
        self,
        *,
        estimated_total: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["estimated_total", b"estimated_total"]
    ) -> None: ...

global___HitCount = HitCount

@typing_extensions.final
class And(google.protobuf.message.Message):
    """This is the common building block of a query which is a sequence of And messages ANDed together.
    Note that some fields are used too RANK results (affect the scores) and some are used to FILTER
    results (unordered subset of your app's contents). In general, FILTER operations are more
    efficient queries at scale and when combined with RANK operations can speed up search performance
    as you effectively operate on a smaller sub-set of your entire app.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUT_FIELD_NUMBER: builtins.int
    OUTPUT_FIELD_NUMBER: builtins.int
    NEGATE_FIELD_NUMBER: builtins.int
    ANNOTATION_FIELD_NUMBER: builtins.int
    @property
    def input(self) -> global___Input:
        """FILTER by input.data... information.
        This can include human provided concepts, geo location info, metadata, etc.
        This is effectively searching over only the trusted annotation attached to an input in your
        app. To search by more specific annotation fields use the Annotation object here.
        ########## Supported fields ##########
         - data.concepts[].id
         - data.concepts[].name
         - data.concepts[].value
         - data.geo.geo_box[].geo_point.latitude
         - data.geo.geo_box[].geo_point.longitude
         - data.geo.geo_limit.type
         - data.geo.geo_limit.value
         - data.geo.geo_point.latitude
         - data.geo.geo_point.longitude
         - data.image.url
         - data.metadata.fields - filter by metadata. metadata key&value fields are OR-ed.
         - dataset_ids[] - filter by dataset IDs
         - id - filter by input ID
         - status.code - filter by input status
        """
    @property
    def output(self) -> global___Output:
        """RANK based predicted outputs from models such as custom trained models, pre-trained models,
        etc. This is also where you enter the image url for a visual search because what we're asking
        the system to do is find output embedding most visually similar to the provided input (that
        input being in And.output.input.data.image.url for example). This will return the Hits
        sorted by visual similarity (1.0 being very similar or exact match and 0.0 being very
        dissimlar). For a search by Output concept, this means we're asking the system to rank
        the Hits by confidence of our model's predicted Outputs. So for example if the model
        predicts an image is 0.95 likely there is a "dog" present, that should related directly
        to the score returned if you search for Output concept "dog" in your query. This provides
        a natural ranking to search results based on confidence of predictions from the models and
        is used when ANDing multiple of these types of RANK by Output queries together as well.

        ########## Supported fields ##########
         - data.clusters[].id
         - data.concepts[].id
         - data.concepts[].name
         - data.concepts[].value
         - input.data.image.base64[]
         - input.data.image.url
         - input.id
        """
    negate: builtins.bool
    """If True then this will flip the meaning of this part of the
    query. This allow for queries such as dog AND ! metadata=={"blah":"value"}
    """
    @property
    def annotation(self) -> global___Annotation:
        """FILTER by annotation information. This is more flexible than just filtering by
        Input information because in the general case each input can have several annotations.
        Some example use cases for filtering by annotations:
        1) find all the inputs annotated "dog" by worker_id = "XYZ"
        2) find all the annotations associated with embed_model_version_id = "123"
        3) find all the annotations that are trusted, etc.

        Since all the annotations under the hood are joined to the embedding model's annotation
        using worker_id's of other models like cluster models or concept models should be
        combinable with queries like visual search (a query with Output filled in).

        ########## Supported fields ##########
         - annotation_info.fields - filter by annotation info
         - data.concepts[].id
         - data.concepts[].name
         - data.concepts[].value
         - data.geo.geo_box[].geo_point.latitude
         - data.geo.geo_box[].geo_point.longitude
         - data.geo.geo_limit.type
         - data.geo.geo_limit.value
         - data.geo.geo_point.latitude
         - data.geo.geo_point.longitude
         - data.image.url
         - data.metadata.fields - filter by metadata. metadata key&value fields are OR-ed.
         - input_id
         - input_level
         - model_version_id
         - status.code
         - task_id
         - trusted
         - user_id
        """
    def __init__(
        self,
        *,
        input: global___Input | None = ...,
        output: global___Output | None = ...,
        negate: builtins.bool = ...,
        annotation: global___Annotation | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "annotation", b"annotation", "input", b"input", "output", b"output"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "annotation",
            b"annotation",
            "input",
            b"input",
            "negate",
            b"negate",
            "output",
            b"output",
        ],
    ) -> None: ...

global___And = And

@typing_extensions.final
class Query(google.protobuf.message.Message):
    """This is the search query used in /searches, model training requests, bulk data exports, etc."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ANDS_FIELD_NUMBER: builtins.int
    LANGUAGE_FIELD_NUMBER: builtins.int
    FILTERS_FIELD_NUMBER: builtins.int
    RANKS_FIELD_NUMBER: builtins.int
    @property
    def ands(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___And]:
        """The query syntax is simply a list of And operatiosn that will be ANDed together to fetch
        results which are returned to the user as Hit messages.

        Deprecated: Only used by the deprecated PostSearches endpoint. Use filters
        and ranks instead with PostInputsSearches or PostAnnotationsSearches.
        """
    language: builtins.str
    """This allows the query to override any default language the app was setup in when doing Concept
    based searches. This currently only affects public Models Output searches when those public
    Models have translations for their Concepts.
    """
    @property
    def filters(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Filter]:
        """filters in this query
        e.q. only fetch annotations that have certain metadata
        """
    @property
    def ranks(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Rank]:
        """rankings in this query
        e.g. visual search by a url
        """
    def __init__(
        self,
        *,
        ands: collections.abc.Iterable[global___And] | None = ...,
        language: builtins.str = ...,
        filters: collections.abc.Iterable[global___Filter] | None = ...,
        ranks: collections.abc.Iterable[global___Rank] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "ands", b"ands", "filters", b"filters", "language", b"language", "ranks", b"ranks"
        ],
    ) -> None: ...

global___Query = Query

@typing_extensions.final
class Search(google.protobuf.message.Message):
    """This is the new Search object used in saved searches."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Metric:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MetricEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Search._Metric.ValueType],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        METRIC_NOT_SET: Search._Metric.ValueType  # 0
        EUCLIDEAN_DISTANCE: Search._Metric.ValueType  # 1
        COSINE_DISTANCE: Search._Metric.ValueType  # 2

    class Metric(_Metric, metaclass=_MetricEnumTypeWrapper):
        """Metric used for search. Can be EUCLIDEAN_DISTANCE (default) or COSINE_DISTANCE.
        Currently only brute force search supports non-eudlicean metrics.
        """

    METRIC_NOT_SET: Search.Metric.ValueType  # 0
    EUCLIDEAN_DISTANCE: Search.Metric.ValueType  # 1
    COSINE_DISTANCE: Search.Metric.ValueType  # 2

    QUERY_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    APPLICATION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    AS_OF_FIELD_NUMBER: builtins.int
    GIT_HASH_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    SAVE_FIELD_NUMBER: builtins.int
    MIN_VALUE_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    METRIC_FIELD_NUMBER: builtins.int
    @property
    def query(self) -> global___Query:
        """Search query."""
    id: builtins.str
    """Customer facing, external ID for search to be saved. Provided by the user, e.g. "saved-search-1.
    It is unique per application.
    """
    application_id: builtins.str
    """Application that owns this saved search."""
    name: builtins.str
    """Human readable display name of the saved search."""
    @property
    def as_of(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """ "As of" timestamp, indicating a time in the past as of which we want to
        retrieve the annotations satisfying the query.
        """
    git_hash: builtins.str
    """Git hash of the code that ran the filter."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the saved search was created."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the saved search was updated."""
    algorithm: builtins.str
    """The search algorithm to be used.
    Options are are 'nearest_neighbor', 'brute_force', and 'avg_concept_brute_force'
    The last two perform a brute force search visual search instead of a more scalable distributed
    nearest neighbor search and should be used by advanced users only.
    If not specified we default to nearest neighbor
    """
    save: builtins.bool
    """If true, save this search, and exit without executing the search.
    If false execute the query
    """
    min_value: builtins.float
    """Minimum value of confidence threshold score in result.
    Defaults to 0.0 which means we won't do any thresholding as all probabilities will
    likely be > 0.0.
    """
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    metric: global___Search.Metric.ValueType
    def __init__(
        self,
        *,
        query: global___Query | None = ...,
        id: builtins.str = ...,
        application_id: builtins.str = ...,
        name: builtins.str = ...,
        as_of: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        git_hash: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        algorithm: builtins.str = ...,
        save: builtins.bool = ...,
        min_value: builtins.float = ...,
        visibility: global___Visibility | None = ...,
        metric: global___Search.Metric.ValueType = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "as_of",
            b"as_of",
            "created_at",
            b"created_at",
            "modified_at",
            b"modified_at",
            "query",
            b"query",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "algorithm",
            b"algorithm",
            "application_id",
            b"application_id",
            "as_of",
            b"as_of",
            "created_at",
            b"created_at",
            "git_hash",
            b"git_hash",
            "id",
            b"id",
            "metric",
            b"metric",
            "min_value",
            b"min_value",
            "modified_at",
            b"modified_at",
            "name",
            b"name",
            "query",
            b"query",
            "save",
            b"save",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___Search = Search

@typing_extensions.final
class Filter(google.protobuf.message.Message):
    """Filter"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NEGATE_FIELD_NUMBER: builtins.int
    ANNOTATION_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    LAST_UPDATED_TIME_RANGE_FIELD_NUMBER: builtins.int
    negate: builtins.bool
    """If True then this will flip the meaning of this part of the
    query. This allow for queries such as dog AND ! metadata=={"blah":"value"}
    """
    @property
    def annotation(self) -> global___Annotation:
        """FILTER by annotation information.
        ########## Supported fields ##########
         # Filter by ID fields
         - id                                      - example: `{"id": "xyz"}`
         - input_id
         - model_version_id
         - task_id
         - user_id

         # Filter by worker fields such as model, workflow and user IDs
         - worker.model.model_version.id
         - worker.user.id
         - worker.workflow.version.id

         # Filter by other top-level fields
         - annotation_info.fields                  - filter by annotation info
         - input_level                             - filter only input-level annotations
         - status.code                             - filter by annotation status code
         - trusted                                 - filter only trusted annotations

         # Filter by space-time info fields, i.e. region, frames and time-segments
         - data                                    - filter only annotations without space-time info, e.g. classifications
                                                   - in order to enable this, you need to set the field to an empty object, i.e. `{"data": {}}`
         - data.frames[].frame_info                - filter only frame annotations
                                                   - in order to enable this, you need to set the field to an empty object, i.e. `{"data": {"frames": [{"frame_info": {}}]}}`
         - data.regions[].region_info.bounding_box - filter only bounding box annotations
                                                   - in order to enable this, you need to set the field to an empty object, i.e. `{"data": {"regions": [{"region_info": {"bounding_box":{}}}]}}`
         - data.regions[].region_info.mask         - filter only mask annotations
                                                   - in order to enable this, you need to set the field to an empty object, i.e. `{"data": {"regions": [{"region_info": {"mask":{}}}]}}`
         - data.regions[].region_info.point        - filter only point annotations
                                                   - in order to enable this, you need to set the field to an empty object, i.e. `{"data": {"regions": [{"region_info": {"point":{}}}]}}`
         - data.regions[].region_info.polygon      - filter only polygon annotations
                                                   - in order to enable this, you need to set the field to an empty object, i.e. `{"data": {"regions": [{"region_info": {"polygon":{}}}]}}`
         - data.regions[].region_info.span         - filter only span annotations
                                                   - in order to enable this, you need to set the field to an empty object, i.e. `{"data": {"regions": [{"region_info": {"span":{}}}]}}`
         - data.regions[].track_id                 - filter annotations by track_id
                                                   - in order to enable this, you need to provide "track_id_value" i.e. `{"data": {"regions": [{"track_id" : "track_id_value"}]}}`
         - data.time_segments[].time_info          - filter only time-segment annotations
                                                   - in order to enable this, you need to set the field to an empty object, i.e. `{"data": {"time_segments": [{"time_info": {}}]}}`

         # Filter by other data fields
         - data.clusters[].id
         - data.concepts[].id
         - data.concepts[].name
         - data.concepts[].value
         - data.geo.geo_box[].geo_point.latitude
         - data.geo.geo_box[].geo_point.longitude
         - data.geo.geo_limit.type
         - data.geo.geo_limit.value
         - data.geo.geo_point.latitude
         - data.geo.geo_point.longitude
         - data.metadata.fields                    - filter by metadata
                                                   - Important to note: metadata key&value fields are OR-ed.
                                                   - example with 1 metadata key: searching by
                                                             `{
                                                             `  "data": {
                                                             `    "metadata": {
                                                             `      "fields": {
                                                             `        "foo": {
                                                             `          "string_value": "bar"
                                                             `        },
                                                             `      }
                                                             `    }
                                                             `  }
                                                             `}
                                                             will result in a search condition like `metadata includes {"foo": "bar}`;
                                                   - example with 2 metadata keys: searching by
                                                             `{
                                                             `  "data": {
                                                             `    "metadata": {
                                                             `      "fields": {
                                                             `        "foo1": {
                                                             `          "string_value": "bar2"
                                                             `        },
                                                             `        "foo2": {
                                                             `          "string_value": "bar2"
                                                             `        }
                                                             `      }
                                                             `    }
                                                             `  }
                                                             `}
                                                             will result in a search condition like `(metadata includes {"foo1": "bar1"}) OR (metadata includes {"foo2": "bar2"})`.
         - data.text                               - filter only text annotations
                                                   - in order to enable this, you need to set the field to an empty object, i.e. `{"data": {"text": {}}}`
        """
    @property
    def input(self) -> global___Input:
        """FILTER by input information.
        ########## Supported fields ##########
         - data.audio                              - filter only audio inputs
                                                   - in order to enable this, you need to set the field to an empty object, i.e. `{"audio": {}}`
         - data.image                              - filter only image inputs
                                                   - enable using `{"image": {}}`
         - data.text                               - filter only text inputs
                                                   - enable using `{"text": {}}`
         - data.video                              - filter only video inputs
                                                   - enable using `{"video": {}}`
         - dataset_ids[]                           - filter by dataset IDs
                                                   - example: `{"dataset_ids": ["d1", "d2"]}` will filter for inputs in d1 OR d2
         - status.code                             - filter by input status
                                                   - example: `{"status": {"code": 30000}}` to filter only for SUCCESS inputs
        """
    @property
    def last_updated_time_range(self) -> global___TimeRange:
        """Filter by annotation last updated time range."""
    def __init__(
        self,
        *,
        negate: builtins.bool = ...,
        annotation: global___Annotation | None = ...,
        input: global___Input | None = ...,
        last_updated_time_range: global___TimeRange | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "annotation",
            b"annotation",
            "input",
            b"input",
            "last_updated_time_range",
            b"last_updated_time_range",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "annotation",
            b"annotation",
            "input",
            b"input",
            "last_updated_time_range",
            b"last_updated_time_range",
            "negate",
            b"negate",
        ],
    ) -> None: ...

global___Filter = Filter

@typing_extensions.final
class TimeRange(google.protobuf.message.Message):
    """TimeRange"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Begin of the time range, optional, inclusive."""
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End of the time range, optional, inclusive."""
    def __init__(
        self,
        *,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "end_time", b"end_time", "start_time", b"start_time"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "end_time", b"end_time", "start_time", b"start_time"
        ],
    ) -> None: ...

global___TimeRange = TimeRange

@typing_extensions.final
class Rank(google.protobuf.message.Message):
    """Rank"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NEGATE_FIELD_NUMBER: builtins.int
    ANNOTATION_FIELD_NUMBER: builtins.int
    negate: builtins.bool
    """If True then this will flip the meaning of this part of the
    query. This allow for queries such as !dog
    """
    @property
    def annotation(self) -> global___Annotation:
        """RANK by annotation information.
        ########## Supported fields ##########
         - data.concepts[].id
         - data.concepts[].name
         - data.concepts[].value
         - data.embeddings[].num_dimensions
         - data.embeddings[].vector[]
         - data.image.base64[]
         - data.image.url
         - data.text.raw
         - input_id
         - model_version_id
        """
    def __init__(
        self,
        *,
        negate: builtins.bool = ...,
        annotation: global___Annotation | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["annotation", b"annotation"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["annotation", b"annotation", "negate", b"negate"],
    ) -> None: ...

global___Rank = Rank

@typing_extensions.final
class AnnotationSearchMetrics(google.protobuf.message.Message):
    """AnnotationSearchMetrics"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUND_TRUTH_FIELD_NUMBER: builtins.int
    SEARCH_TO_EVAL_FIELD_NUMBER: builtins.int
    METRICS_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    ACTIVE_CONCEPT_COUNT_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    @property
    def ground_truth(self) -> global___Search:
        """The ground truth we are evaluating against"""
    @property
    def search_to_eval(self) -> global___Search:
        """The set we are evaluating"""
    @property
    def metrics(self) -> global___EvalMetrics:
        """The metric result"""
    @property
    def data(self) -> global___Data:
        """data is filled out with the concepts used for this evaluation"""
    active_concept_count: builtins.int
    """active_concept_count is the number of concepts for this evaluation"""
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    def __init__(
        self,
        *,
        ground_truth: global___Search | None = ...,
        search_to_eval: global___Search | None = ...,
        metrics: global___EvalMetrics | None = ...,
        data: global___Data | None = ...,
        active_concept_count: builtins.int = ...,
        visibility: global___Visibility | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "data",
            b"data",
            "ground_truth",
            b"ground_truth",
            "metrics",
            b"metrics",
            "search_to_eval",
            b"search_to_eval",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "active_concept_count",
            b"active_concept_count",
            "data",
            b"data",
            "ground_truth",
            b"ground_truth",
            "metrics",
            b"metrics",
            "search_to_eval",
            b"search_to_eval",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___AnnotationSearchMetrics = AnnotationSearchMetrics

@typing_extensions.final
class Text(google.protobuf.message.Message):
    """Text"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RAW_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    ALLOW_DUPLICATE_URL_FIELD_NUMBER: builtins.int
    HOSTED_FIELD_NUMBER: builtins.int
    TEXT_INFO_FIELD_NUMBER: builtins.int
    raw: builtins.str
    """This is a raw text string."""
    url: builtins.str
    """Url to a text file"""
    allow_duplicate_url: builtins.bool
    @property
    def hosted(self) -> global___HostedURL:
        """The hosted field lists original text hosted in Clarifai storage. This field is currently used
        only in response.
        """
    @property
    def text_info(self) -> global___TextInfo:
        """text info"""
    def __init__(
        self,
        *,
        raw: builtins.str = ...,
        url: builtins.str = ...,
        allow_duplicate_url: builtins.bool = ...,
        hosted: global___HostedURL | None = ...,
        text_info: global___TextInfo | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["hosted", b"hosted", "text_info", b"text_info"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "allow_duplicate_url",
            b"allow_duplicate_url",
            "hosted",
            b"hosted",
            "raw",
            b"raw",
            "text_info",
            b"text_info",
            "url",
            b"url",
        ],
    ) -> None: ...

global___Text = Text

@typing_extensions.final
class TextInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAR_COUNT_FIELD_NUMBER: builtins.int
    ENCODING_FIELD_NUMBER: builtins.int
    char_count: builtins.int
    """count of characters in text"""
    encoding: builtins.str
    """text encoding"""
    def __init__(
        self,
        *,
        char_count: builtins.int = ...,
        encoding: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "char_count", b"char_count", "encoding", b"encoding"
        ],
    ) -> None: ...

global___TextInfo = TextInfo

@typing_extensions.final
class User(google.protobuf.message.Message):
    """User"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    PRIMARY_EMAIL_FIELD_NUMBER: builtins.int
    FIRST_NAME_FIELD_NUMBER: builtins.int
    LAST_NAME_FIELD_NUMBER: builtins.int
    COMPANY_NAME_FIELD_NUMBER: builtins.int
    JOB_TITLE_FIELD_NUMBER: builtins.int
    JOB_ROLE_FIELD_NUMBER: builtins.int
    INTENTION_FIELD_NUMBER: builtins.int
    REFERRAL_SOURCE_FIELD_NUMBER: builtins.int
    BILL_TYPE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    DATE_GDPR_CONSENT_FIELD_NUMBER: builtins.int
    DATE_TOS_CONSENT_FIELD_NUMBER: builtins.int
    DATE_MARKETING_CONSENT_FIELD_NUMBER: builtins.int
    DATE_PII_CONSENT_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    EMAIL_ADDRESSES_FIELD_NUMBER: builtins.int
    TWO_FACTOR_AUTH_ENABLED_FIELD_NUMBER: builtins.int
    TEAMS_COUNT_FIELD_NUMBER: builtins.int
    IS_STARRED_FIELD_NUMBER: builtins.int
    STAR_COUNT_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    USER_DETAIL_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    id: builtins.str
    primary_email: builtins.str
    first_name: builtins.str
    last_name: builtins.str
    company_name: builtins.str
    job_title: builtins.str
    job_role: builtins.str
    intention: builtins.str
    """This specifies user intent when registering on clarifai"""
    referral_source: builtins.str
    """This specifies how one got to know about clarifai"""
    bill_type: builtins.str
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the user was created. We follow the XXXX timestamp
        format. We use https://www.ietf.org/rfc/rfc3339.txt format:
        "2006-01-02T15:04:05.999999Z" so you can expect results like
        the following from the API:
        "2017-04-11T21:50:50.223962Z"
        """
    @property
    def date_gdpr_consent(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def date_tos_consent(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def date_marketing_consent(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def date_pii_consent(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    @property
    def email_addresses(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___EmailAddress
    ]: ...
    two_factor_auth_enabled: builtins.bool
    teams_count: builtins.int
    is_starred: builtins.bool
    """Is starred by the requesting user (only showed on get/list requests)
    Please use PostUserStars/DeleteUserStars endpoints to star/unstar an user
    """
    star_count: builtins.int
    """How many users have starred the user (only showed on get/list requests)
    Computed value, not editable
    """
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    @property
    def user_detail(self) -> global___UserDetail:
        """This is all the personal information of a user. GetUser/ListUsers will not return this
        information unless the caller has the UserAccounts_Get scope on their key or is the user
        themselves.
        """
    @property
    def image(self) -> global___Image:
        """Representative image for this User (a.k.a. Profile or cover photo)"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        primary_email: builtins.str = ...,
        first_name: builtins.str = ...,
        last_name: builtins.str = ...,
        company_name: builtins.str = ...,
        job_title: builtins.str = ...,
        job_role: builtins.str = ...,
        intention: builtins.str = ...,
        referral_source: builtins.str = ...,
        bill_type: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        date_gdpr_consent: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        date_tos_consent: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        date_marketing_consent: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        date_pii_consent: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        email_addresses: collections.abc.Iterable[global___EmailAddress] | None = ...,
        two_factor_auth_enabled: builtins.bool = ...,
        teams_count: builtins.int = ...,
        is_starred: builtins.bool = ...,
        star_count: builtins.int = ...,
        visibility: global___Visibility | None = ...,
        user_detail: global___UserDetail | None = ...,
        image: global___Image | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "date_gdpr_consent",
            b"date_gdpr_consent",
            "date_marketing_consent",
            b"date_marketing_consent",
            "date_pii_consent",
            b"date_pii_consent",
            "date_tos_consent",
            b"date_tos_consent",
            "image",
            b"image",
            "metadata",
            b"metadata",
            "user_detail",
            b"user_detail",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "bill_type",
            b"bill_type",
            "company_name",
            b"company_name",
            "created_at",
            b"created_at",
            "date_gdpr_consent",
            b"date_gdpr_consent",
            "date_marketing_consent",
            b"date_marketing_consent",
            "date_pii_consent",
            b"date_pii_consent",
            "date_tos_consent",
            b"date_tos_consent",
            "email_addresses",
            b"email_addresses",
            "first_name",
            b"first_name",
            "id",
            b"id",
            "image",
            b"image",
            "intention",
            b"intention",
            "is_starred",
            b"is_starred",
            "job_role",
            b"job_role",
            "job_title",
            b"job_title",
            "last_name",
            b"last_name",
            "metadata",
            b"metadata",
            "primary_email",
            b"primary_email",
            "referral_source",
            b"referral_source",
            "star_count",
            b"star_count",
            "teams_count",
            b"teams_count",
            "two_factor_auth_enabled",
            b"two_factor_auth_enabled",
            "user_detail",
            b"user_detail",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___User = User

@typing_extensions.final
class UserDetail(google.protobuf.message.Message):
    """This message holds the confidential information from the User object that we don't want to expose
    to other users. It will be accessible only from /users/{user_id}/account and with the User scopes.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRIMARY_EMAIL_FIELD_NUMBER: builtins.int
    BILL_TYPE_FIELD_NUMBER: builtins.int
    DATE_GDPR_CONSENT_FIELD_NUMBER: builtins.int
    DATE_TOS_CONSENT_FIELD_NUMBER: builtins.int
    DATE_MARKETING_CONSENT_FIELD_NUMBER: builtins.int
    DATE_PII_CONSENT_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    EMAIL_ADDRESSES_FIELD_NUMBER: builtins.int
    TWO_FACTOR_AUTH_ENABLED_FIELD_NUMBER: builtins.int
    TEAMS_COUNT_FIELD_NUMBER: builtins.int
    COUNTRY_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    COMMITMENT_VALUE_FIELD_NUMBER: builtins.int
    primary_email: builtins.str
    bill_type: builtins.str
    @property
    def date_gdpr_consent(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def date_tos_consent(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def date_marketing_consent(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def date_pii_consent(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    @property
    def email_addresses(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___EmailAddress
    ]: ...
    two_factor_auth_enabled: builtins.bool
    teams_count: builtins.int
    country: builtins.str
    state: builtins.str
    @property
    def commitment_value(self) -> global___CommitmentValue: ...
    def __init__(
        self,
        *,
        primary_email: builtins.str = ...,
        bill_type: builtins.str = ...,
        date_gdpr_consent: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        date_tos_consent: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        date_marketing_consent: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        date_pii_consent: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        email_addresses: collections.abc.Iterable[global___EmailAddress] | None = ...,
        two_factor_auth_enabled: builtins.bool = ...,
        teams_count: builtins.int = ...,
        country: builtins.str = ...,
        state: builtins.str = ...,
        commitment_value: global___CommitmentValue | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "commitment_value",
            b"commitment_value",
            "date_gdpr_consent",
            b"date_gdpr_consent",
            "date_marketing_consent",
            b"date_marketing_consent",
            "date_pii_consent",
            b"date_pii_consent",
            "date_tos_consent",
            b"date_tos_consent",
            "metadata",
            b"metadata",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "bill_type",
            b"bill_type",
            "commitment_value",
            b"commitment_value",
            "country",
            b"country",
            "date_gdpr_consent",
            b"date_gdpr_consent",
            "date_marketing_consent",
            b"date_marketing_consent",
            "date_pii_consent",
            b"date_pii_consent",
            "date_tos_consent",
            b"date_tos_consent",
            "email_addresses",
            b"email_addresses",
            "metadata",
            b"metadata",
            "primary_email",
            b"primary_email",
            "state",
            b"state",
            "teams_count",
            b"teams_count",
            "two_factor_auth_enabled",
            b"two_factor_auth_enabled",
        ],
    ) -> None: ...

global___UserDetail = UserDetail

@typing_extensions.final
class EmailAddress(google.protobuf.message.Message):
    """EmailAddress"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EMAIL_FIELD_NUMBER: builtins.int
    PRIMARY_FIELD_NUMBER: builtins.int
    VERIFIED_FIELD_NUMBER: builtins.int
    email: builtins.str
    primary: builtins.bool
    verified: builtins.bool
    def __init__(
        self,
        *,
        email: builtins.str = ...,
        primary: builtins.bool = ...,
        verified: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "email", b"email", "primary", b"primary", "verified", b"verified"
        ],
    ) -> None: ...

global___EmailAddress = EmailAddress

@typing_extensions.final
class Password(google.protobuf.message.Message):
    """Password"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAINTEXT_FIELD_NUMBER: builtins.int
    plaintext: builtins.str
    """unencrypted password string"""
    def __init__(
        self,
        *,
        plaintext: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["plaintext", b"plaintext"]
    ) -> None: ...

global___Password = Password

@typing_extensions.final
class PasswordViolations(google.protobuf.message.Message):
    """PasswordViolations"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MINIMUM_LENGTH_FIELD_NUMBER: builtins.int
    MAXIMUM_LENGTH_FIELD_NUMBER: builtins.int
    UPPER_CASE_NEEDED_FIELD_NUMBER: builtins.int
    LOWER_CASE_NEEDED_FIELD_NUMBER: builtins.int
    NUMERIC_NEEDED_FIELD_NUMBER: builtins.int
    NON_ALPHANUMERIC_NEEDED_FIELD_NUMBER: builtins.int
    PASSWORD_REUSE_FIELD_NUMBER: builtins.int
    EXCLUDE_NAMES_FIELD_NUMBER: builtins.int
    EXCLUDE_EMAIL_FIELD_NUMBER: builtins.int
    NO_CONFUSING_LETTERS_FIELD_NUMBER: builtins.int
    NO_SIMPLE_PASSWORDS_FIELD_NUMBER: builtins.int
    NO_COMMON_VOCABS_FIELD_NUMBER: builtins.int
    NO_OVERLAP_WITH_OLD_FIELD_NUMBER: builtins.int
    PASSWORD_LIFESPAN_FIELD_NUMBER: builtins.int
    minimum_length: builtins.bool
    """when new password length is shorter than minimum length set"""
    maximum_length: builtins.bool
    """when new password length is longer than maximum length set"""
    upper_case_needed: builtins.bool
    """there is no upper case letter in the new password when there should be at least one"""
    lower_case_needed: builtins.bool
    """there is no lower case letter in the new password when there should be at least one"""
    numeric_needed: builtins.bool
    """there is no numerics in the new password when there should be at least one"""
    non_alphanumeric_needed: builtins.bool
    """there is no special character in the new password when there should be at least one"""
    password_reuse: builtins.bool
    """when one of the N most recent old password is reused, N is specified by password_reuse_epoch in db.password_policies"""
    exclude_names: builtins.bool
    """when either user's first, middle or last name is used in the new password"""
    exclude_email: builtins.bool
    """when first part of user's email (exact string or after removing special characters) is used in the new password"""
    no_confusing_letters: builtins.bool
    """when there are confusing letters in the new password, such as o (first character of 'omega') vs 0 (zero)"""
    no_simple_passwords: builtins.bool
    """when there are simple password patterns used, such as 12345678 or aaaaaaa1"""
    no_common_vocabs: builtins.bool
    """when there are common vocabs from the common vocab list used"""
    no_overlap_with_old: builtins.bool
    """when the current password is contained in the new password or vice versa"""
    password_lifespan: builtins.bool
    """when password has to be changed becauase it's too old"""
    def __init__(
        self,
        *,
        minimum_length: builtins.bool = ...,
        maximum_length: builtins.bool = ...,
        upper_case_needed: builtins.bool = ...,
        lower_case_needed: builtins.bool = ...,
        numeric_needed: builtins.bool = ...,
        non_alphanumeric_needed: builtins.bool = ...,
        password_reuse: builtins.bool = ...,
        exclude_names: builtins.bool = ...,
        exclude_email: builtins.bool = ...,
        no_confusing_letters: builtins.bool = ...,
        no_simple_passwords: builtins.bool = ...,
        no_common_vocabs: builtins.bool = ...,
        no_overlap_with_old: builtins.bool = ...,
        password_lifespan: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "exclude_email",
            b"exclude_email",
            "exclude_names",
            b"exclude_names",
            "lower_case_needed",
            b"lower_case_needed",
            "maximum_length",
            b"maximum_length",
            "minimum_length",
            b"minimum_length",
            "no_common_vocabs",
            b"no_common_vocabs",
            "no_confusing_letters",
            b"no_confusing_letters",
            "no_overlap_with_old",
            b"no_overlap_with_old",
            "no_simple_passwords",
            b"no_simple_passwords",
            "non_alphanumeric_needed",
            b"non_alphanumeric_needed",
            "numeric_needed",
            b"numeric_needed",
            "password_lifespan",
            b"password_lifespan",
            "password_reuse",
            b"password_reuse",
            "upper_case_needed",
            b"upper_case_needed",
        ],
    ) -> None: ...

global___PasswordViolations = PasswordViolations

@typing_extensions.final
class CommitmentValue(google.protobuf.message.Message):
    """Commitment Value - used to track users' commitment amount and type"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _CommitmentType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CommitmentTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            CommitmentValue._CommitmentType.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_NOT_SET: CommitmentValue._CommitmentType.ValueType  # 0
        MONTHLY: CommitmentValue._CommitmentType.ValueType  # 1
        ANNUAL: CommitmentValue._CommitmentType.ValueType  # 2

    class CommitmentType(_CommitmentType, metaclass=_CommitmentTypeEnumTypeWrapper): ...
    TYPE_NOT_SET: CommitmentValue.CommitmentType.ValueType  # 0
    MONTHLY: CommitmentValue.CommitmentType.ValueType  # 1
    ANNUAL: CommitmentValue.CommitmentType.ValueType  # 2

    VALUE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    value: builtins.int
    """The commitment value, in cents"""
    type: global___CommitmentValue.CommitmentType.ValueType
    """The commitment type, can be either 'monthly' or 'annual'"""
    def __init__(
        self,
        *,
        value: builtins.int = ...,
        type: global___CommitmentValue.CommitmentType.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["type", b"type", "value", b"value"]
    ) -> None: ...

global___CommitmentValue = CommitmentValue

@typing_extensions.final
class Video(google.protobuf.message.Message):
    """Video"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    BASE64_FIELD_NUMBER: builtins.int
    ALLOW_DUPLICATE_URL_FIELD_NUMBER: builtins.int
    THUMBNAIL_URL_FIELD_NUMBER: builtins.int
    HOSTED_FIELD_NUMBER: builtins.int
    HOSTED_THUMBNAIL_FIELD_NUMBER: builtins.int
    VIDEO_INFO_FIELD_NUMBER: builtins.int
    url: builtins.str
    """This is a URL to a publicly accessible video file. The platform will download this file server
    side and then process.
    """
    base64: builtins.bytes
    """The base64 field is using video file bytes directly in the request.
    NOTE: if you're sending a json request, then this MUST be base64 encoded before sending (hence
    the name here).
    When using our grpc clients, you DO NOT need to base64 encode
    it yourself since the clients know how to do this for you automatically and will avoid the
    base64 encoding if they send a binary request.
    """
    allow_duplicate_url: builtins.bool
    thumbnail_url: builtins.str
    """URL of thumbnail image, which is currently frame at position of 1s. This field is currently
    used only in response.
    Deprecated in favour of thumbnail_hosted, which also contains alternate sizes of thumbnail
    """
    @property
    def hosted(self) -> global___HostedURL:
        """The hosted field lists original video hosted in Clarifai storage. This field is currently used
        only in response.
        """
    @property
    def hosted_thumbnail(self) -> global___HostedURL:
        """The hosted field lists various sizes of the vide thumbnail hosted in Clarifai storage, with 'thumbnail' as the full size
        This field is currently used only in response.
        """
    @property
    def video_info(self) -> global___VideoInfo:
        """video info"""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
        base64: builtins.bytes = ...,
        allow_duplicate_url: builtins.bool = ...,
        thumbnail_url: builtins.str = ...,
        hosted: global___HostedURL | None = ...,
        hosted_thumbnail: global___HostedURL | None = ...,
        video_info: global___VideoInfo | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "hosted",
            b"hosted",
            "hosted_thumbnail",
            b"hosted_thumbnail",
            "video_info",
            b"video_info",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "allow_duplicate_url",
            b"allow_duplicate_url",
            "base64",
            b"base64",
            "hosted",
            b"hosted",
            "hosted_thumbnail",
            b"hosted_thumbnail",
            "thumbnail_url",
            b"thumbnail_url",
            "url",
            b"url",
            "video_info",
            b"video_info",
        ],
    ) -> None: ...

global___Video = Video

@typing_extensions.final
class VideoInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WIDTH_FIELD_NUMBER: builtins.int
    HEIGHT_FIELD_NUMBER: builtins.int
    FPS_FIELD_NUMBER: builtins.int
    VIDEO_FORMAT_FIELD_NUMBER: builtins.int
    BIT_RATE_FIELD_NUMBER: builtins.int
    FRAME_COUNT_FIELD_NUMBER: builtins.int
    DURATION_SECONDS_FIELD_NUMBER: builtins.int
    width: builtins.int
    """width"""
    height: builtins.int
    """height"""
    fps: builtins.float
    """Frames per second of the video."""
    video_format: builtins.str
    """video format"""
    bit_rate: builtins.int
    """video track bit rate"""
    frame_count: builtins.int
    """video frame count"""
    duration_seconds: builtins.float
    """video duration in seconds"""
    def __init__(
        self,
        *,
        width: builtins.int = ...,
        height: builtins.int = ...,
        fps: builtins.float = ...,
        video_format: builtins.str = ...,
        bit_rate: builtins.int = ...,
        frame_count: builtins.int = ...,
        duration_seconds: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "bit_rate",
            b"bit_rate",
            "duration_seconds",
            b"duration_seconds",
            "fps",
            b"fps",
            "frame_count",
            b"frame_count",
            "height",
            b"height",
            "video_format",
            b"video_format",
            "width",
            b"width",
        ],
    ) -> None: ...

global___VideoInfo = VideoInfo

@typing_extensions.final
class Workflow(google.protobuf.message.Message):
    """Workflow"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NODES_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    IS_STARRED_FIELD_NUMBER: builtins.int
    STAR_COUNT_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    NOTES_FIELD_NUMBER: builtins.int
    USE_CASES_FIELD_NUMBER: builtins.int
    CHECK_CONSENTS_FIELD_NUMBER: builtins.int
    BOOKMARK_ORIGIN_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The workflows's unique id."""
    app_id: builtins.str
    """The app the workflow belongs to"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the workflow was created. We follow the XXXX timestamp
        format. We use https://www.ietf.org/rfc/rfc3339.txt format:
        "2006-01-02T15:04:05.999999Z" so you can expect results like
        the following from the API:
        "2017-04-11T21:50:50.223962Z"
        """
    @property
    def nodes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___WorkflowNode
    ]:
        """The list of nodes retrieved from latest workflow version.
        Each node can specify an input node that it connects to in order to define the graph.
        """
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    user_id: builtins.str
    """The user the workflow belongs to"""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the workflow was last modified"""
    @property
    def version(self) -> global___WorkflowVersion:
        """Info about the workflow version used to return the latest version when listing Workflows."""
    is_starred: builtins.bool
    """Is starred by the requesting user (only showed on get/list requests)
    Please use PostWorkflowStars/DeleteWorkflowStars endpoints to star/unstar a workflow
    """
    star_count: builtins.int
    """How many users have starred the workflow (only showed on get/list requests)
    Computed value, not editable
    """
    description: builtins.str
    """Short description about this workflow"""
    notes: builtins.str
    """Notes for the workflow
    This field should be used for in-depth notes and supports up to 64Kbs.
    """
    @property
    def use_cases(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Tags from use_cases category"""
    @property
    def check_consents(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Tags for check consents"""
    @property
    def bookmark_origin(self) -> global___BookmarkOrigin:
        """bookmark info. When set, this workflow is a bookmarked workflow of this app.
        Info in this field will allow you to find/access original workflow.
        """
    @property
    def image(self) -> global___Image:
        """Representative image for this workflow"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        app_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        nodes: collections.abc.Iterable[global___WorkflowNode] | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        visibility: global___Visibility | None = ...,
        user_id: builtins.str = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        version: global___WorkflowVersion | None = ...,
        is_starred: builtins.bool = ...,
        star_count: builtins.int = ...,
        description: builtins.str = ...,
        notes: builtins.str = ...,
        use_cases: collections.abc.Iterable[builtins.str] | None = ...,
        check_consents: collections.abc.Iterable[builtins.str] | None = ...,
        bookmark_origin: global___BookmarkOrigin | None = ...,
        image: global___Image | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "bookmark_origin",
            b"bookmark_origin",
            "created_at",
            b"created_at",
            "image",
            b"image",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "version",
            b"version",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "bookmark_origin",
            b"bookmark_origin",
            "check_consents",
            b"check_consents",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "id",
            b"id",
            "image",
            b"image",
            "is_starred",
            b"is_starred",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "nodes",
            b"nodes",
            "notes",
            b"notes",
            "star_count",
            b"star_count",
            "use_cases",
            b"use_cases",
            "user_id",
            b"user_id",
            "version",
            b"version",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___Workflow = Workflow

@typing_extensions.final
class WorkflowVersion(google.protobuf.message.Message):
    """WorkflowVersion"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    NODES_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LICENSE_FIELD_NUMBER: builtins.int
    IS_DEPRECATED_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Id of this version."""
    workflow_id: builtins.str
    """Workflow id for this version."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the version was created.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Most recent time when the version was updated.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    @property
    def nodes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___WorkflowNode
    ]:
        """The list of nodes that make up the workflow version. Each node can specify an input node
        that it connects to in order to define the graph.
        """
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    app_id: builtins.str
    """The app the workflow version belongs to."""
    user_id: builtins.str
    """The user the workflow version belongs to."""
    description: builtins.str
    """Short description about this workflow version"""
    license: builtins.str
    """License associated to this workflow version"""
    is_deprecated: builtins.bool
    """If a model version associated with the workflow version is deleted, the workflow version
    will be marked as deprecated.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        workflow_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        visibility: global___Visibility | None = ...,
        nodes: collections.abc.Iterable[global___WorkflowNode] | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        app_id: builtins.str = ...,
        user_id: builtins.str = ...,
        description: builtins.str = ...,
        license: builtins.str = ...,
        is_deprecated: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "id",
            b"id",
            "is_deprecated",
            b"is_deprecated",
            "license",
            b"license",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "nodes",
            b"nodes",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
            "workflow_id",
            b"workflow_id",
        ],
    ) -> None: ...

global___WorkflowVersion = WorkflowVersion

@typing_extensions.final
class WorkflowNode(google.protobuf.message.Message):
    """WorkflowNode"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    NODE_INPUTS_FIELD_NUMBER: builtins.int
    SUPPRESS_OUTPUT_FIELD_NUMBER: builtins.int
    OUTPUT_INFO_OVERRIDE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """An identifier for this node in the graph. This is used when connecting NodeInputs
    together.
    """
    @property
    def model(self) -> global___Model:
        """The model that will do the processing at this node. We only vlidate the model.id and
        model.model_version.id fields.
        """
    @property
    def node_inputs(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NodeInput]:
        """Each WorkflowNode can connect to multiple input nodes so that we can handle multi-model data
        and more complex workflow operations.
        """
    suppress_output: builtins.bool
    """suppress the output for workflow prediction"""
    @property
    def output_info_override(self) -> global___OutputInfo:
        """Used to override the output_info.data and output_info.params of the model specified by the node.
        Values for fields_map, message, and output_config are ignored.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        model: global___Model | None = ...,
        node_inputs: collections.abc.Iterable[global___NodeInput] | None = ...,
        suppress_output: builtins.bool = ...,
        output_info_override: global___OutputInfo | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "model", b"model", "output_info_override", b"output_info_override"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "id",
            b"id",
            "model",
            b"model",
            "node_inputs",
            b"node_inputs",
            "output_info_override",
            b"output_info_override",
            "suppress_output",
            b"suppress_output",
        ],
    ) -> None: ...

global___WorkflowNode = WorkflowNode

@typing_extensions.final
class NodeInput(google.protobuf.message.Message):
    """NodeInput represents inputs to a node of the graph."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODE_ID_FIELD_NUMBER: builtins.int
    node_id: builtins.str
    """The id to a connected WorkflowNode which will be used as an input for current WorkflowNode."""
    def __init__(
        self,
        *,
        node_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["node_id", b"node_id"]) -> None: ...

global___NodeInput = NodeInput

@typing_extensions.final
class WorkflowResult(google.protobuf.message.Message):
    """WorkflowResult
    One result per input in the workflow.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    SUPPRESS_OUTPUT_FIELD_NUMBER: builtins.int
    id: builtins.str
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status: ...
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the object was created. We follow the XXXX timestamp
        format. We use https://www.ietf.org/rfc/rfc3339.txt format:
        "2006-01-02T15:04:05.999999Z" so you can expect results like
        the following from the API:
        "2017-04-11T21:50:50.223962Z"
        """
    @property
    def input(self) -> global___Input:
        """The input that ran through the workflow to generate the outputs in this WorkflowResult."""
    @property
    def outputs(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Output]:
        """For each model in the workflow we return an Output."""
    suppress_output: builtins.bool
    """Indicate if the output of this model is suppressed."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        input: global___Input | None = ...,
        outputs: collections.abc.Iterable[global___Output] | None = ...,
        suppress_output: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at", b"created_at", "input", b"input", "status", b"status"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "id",
            b"id",
            "input",
            b"input",
            "outputs",
            b"outputs",
            "status",
            b"status",
            "suppress_output",
            b"suppress_output",
        ],
    ) -> None: ...

global___WorkflowResult = WorkflowResult

@typing_extensions.final
class WorkflowState(google.protobuf.message.Message):
    """WorkflowState"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """A unique ID for the workflow state.
    To start saving a state in a PostWorkflowResults request set this ID to "init"
    and it will return a newly generated unique state id that you can then pass in subsequent
    PostWorkflowResults calls. These state expire after 5 minutes between calls.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___WorkflowState = WorkflowState

@typing_extensions.final
class AppDuplication(google.protobuf.message.Message):
    """AppDuplication"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    DESTINATION_APP_FIELD_NUMBER: builtins.int
    EXISTING_APP_ID_FIELD_NUMBER: builtins.int
    NEW_APP_ID_FIELD_NUMBER: builtins.int
    NEW_APP_NAME_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_AT_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    PROGRESS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The unique identifier of an app duplication job."""
    @property
    def destination_app(self) -> global___App:
        """The destination application where resources are written.

        If the destination does not exist, then the fields from the request are
        used to create the application. If a field is not set or not supported,
        then it will be copied from the source app, unless otherwise noted.

        Note: this field can be empty when reading app duplication jobs in cases
        where the app has been deleted or is just not visible to the caller.

        ########## Supported fields ##########
         - description
         - id      - if not set, then generated automatically
         - user_id - if not set, then the calling user is used as the app owner
        """
    existing_app_id: builtins.str
    """The ID of an existing app you want to copy data into.

    If not provided, then we will create a new application as the destination instead.
    The various new_app_* fields can be used to set fields of this new application.

    Deprecated: Use destination_app.id with an existing ID instead.
    """
    new_app_id: builtins.str
    """The ID to use when creating a new application.
    You cannot set this field when copying into an existing app, i.e., when existing_app_is is set.

    If not provided, then it will be generated automatically.

    Deprecated: Use destination_app.id with a new ID instead.
    """
    new_app_name: builtins.str
    """The name to use when creating a new application.
    You cannot set this field when copying into an existing app, i.e., when existing_app_is is set.

    If not provided, then the ID of the new application is also used as the name.

    Deprecated: Application names are deprecated, use application IDs instead.
    """
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """The status of the app duplication job."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when the app duplication job was created."""
    @property
    def last_modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The last time when the app duplication job status was updated."""
    @property
    def filter(self) -> global___AppDuplicationFilters:
        """The filter specifies which resources are copied by the app duplication job."""
    @property
    def progress(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___AppCopyProgress
    ]:
        """Copy progress for each resource type requested by the filter. Possible fields:
        - inputs
        - concepts
        - annotations
        - models
        - workflows
        - installed_module_versions
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        destination_app: global___App | None = ...,
        existing_app_id: builtins.str = ...,
        new_app_id: builtins.str = ...,
        new_app_name: builtins.str = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        filter: global___AppDuplicationFilters | None = ...,
        progress: collections.abc.Iterable[global___AppCopyProgress] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "destination_app",
            b"destination_app",
            "filter",
            b"filter",
            "last_modified_at",
            b"last_modified_at",
            "status",
            b"status",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "destination_app",
            b"destination_app",
            "existing_app_id",
            b"existing_app_id",
            "filter",
            b"filter",
            "id",
            b"id",
            "last_modified_at",
            b"last_modified_at",
            "new_app_id",
            b"new_app_id",
            "new_app_name",
            b"new_app_name",
            "progress",
            b"progress",
            "status",
            b"status",
        ],
    ) -> None: ...

global___AppDuplication = AppDuplication

@typing_extensions.final
class AppCopyProgress(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELD_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    field: builtins.str
    value: builtins.int
    def __init__(
        self,
        *,
        field: builtins.str = ...,
        value: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["field", b"field", "value", b"value"]
    ) -> None: ...

global___AppCopyProgress = AppCopyProgress

@typing_extensions.final
class AppDuplicationFilters(google.protobuf.message.Message):
    """AppDuplicationFilters"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COPY_INPUTS_FIELD_NUMBER: builtins.int
    COPY_CONCEPTS_FIELD_NUMBER: builtins.int
    COPY_ANNOTATIONS_FIELD_NUMBER: builtins.int
    COPY_MODELS_FIELD_NUMBER: builtins.int
    COPY_WORKFLOWS_FIELD_NUMBER: builtins.int
    COPY_INSTALLED_MODULE_VERSIONS_FIELD_NUMBER: builtins.int
    copy_inputs: builtins.bool
    """Copy inputs. Requires that copy_concepts is also set.
    Note that this will still copy input-level annotations even if copy_annotations is not set.
    """
    copy_concepts: builtins.bool
    """Copy concepts."""
    copy_annotations: builtins.bool
    """Copy annotations. Requires that copy_inputs and copy_concepts are also set."""
    copy_models: builtins.bool
    """Copy models. Requires that copy_concepts is also set."""
    copy_workflows: builtins.bool
    """Copy workflows."""
    copy_installed_module_versions: builtins.bool
    """Copy installed module versions."""
    def __init__(
        self,
        *,
        copy_inputs: builtins.bool = ...,
        copy_concepts: builtins.bool = ...,
        copy_annotations: builtins.bool = ...,
        copy_models: builtins.bool = ...,
        copy_workflows: builtins.bool = ...,
        copy_installed_module_versions: builtins.bool = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "copy_annotations",
            b"copy_annotations",
            "copy_concepts",
            b"copy_concepts",
            "copy_inputs",
            b"copy_inputs",
            "copy_installed_module_versions",
            b"copy_installed_module_versions",
            "copy_models",
            b"copy_models",
            "copy_workflows",
            b"copy_workflows",
        ],
    ) -> None: ...

global___AppDuplicationFilters = AppDuplicationFilters

@typing_extensions.final
class LabelOrder(google.protobuf.message.Message):
    """LabelOrder"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    AUTO_RELEASE_FIELD_NUMBER: builtins.int
    ALLOW_EMPTY_TAG_FIELD_NUMBER: builtins.int
    DESIRED_FULFILL_TIME_FIELD_NUMBER: builtins.int
    ESTIMATE_FULFILL_TIME_FIELD_NUMBER: builtins.int
    TASK_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id of the order"""
    name: builtins.str
    """name of the order"""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """status of the order.
        pending (QA lead review the order),
        in progress (labeling in progress),
        ready for release (passed clarifai QA and client can review)
        success (released)
        """
    auto_release: builtins.bool
    """if set to true, automatically release the labels once passed clarifai review."""
    allow_empty_tag: builtins.bool
    """allow input without any tag."""
    @property
    def desired_fulfill_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """User desired estimation when the task should be done"""
    @property
    def estimate_fulfill_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Clarifai estimation when the task should be done ."""
    @property
    def task(self) -> global___Task:
        """task for this label order"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the label order was created.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Most recent time when the label order was updated.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        auto_release: builtins.bool = ...,
        allow_empty_tag: builtins.bool = ...,
        desired_fulfill_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        estimate_fulfill_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        task: global___Task | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "desired_fulfill_time",
            b"desired_fulfill_time",
            "estimate_fulfill_time",
            b"estimate_fulfill_time",
            "modified_at",
            b"modified_at",
            "status",
            b"status",
            "task",
            b"task",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "allow_empty_tag",
            b"allow_empty_tag",
            "auto_release",
            b"auto_release",
            "created_at",
            b"created_at",
            "desired_fulfill_time",
            b"desired_fulfill_time",
            "estimate_fulfill_time",
            b"estimate_fulfill_time",
            "id",
            b"id",
            "modified_at",
            b"modified_at",
            "name",
            b"name",
            "status",
            b"status",
            "task",
            b"task",
        ],
    ) -> None: ...

global___LabelOrder = LabelOrder

@typing_extensions.final
class Task(google.protobuf.message.Message):
    """Task is the work that needs to be done for labeling the inputs in an app."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _TaskType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TaskTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Task._TaskType.ValueType],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_NOT_SET: Task._TaskType.ValueType  # 0
        CONCEPTS_CLASSIFICATION: Task._TaskType.ValueType  # 1
        """Concepts classification tasks annotate concepts for the overall image, frame of video or section of text."""
        BOUNDING_BOX_DETECTION: Task._TaskType.ValueType  # 2
        """Bounding box detection tasks annotate rectangular bounding box regions around each concept in an image, frame of video or section of text."""
        POLYGON_DETECTION: Task._TaskType.ValueType  # 3
        """Polygon detection tasks annotate free-form regions around concepts in an image, frame of video or section of text."""

    class TaskType(_TaskType, metaclass=_TaskTypeEnumTypeWrapper): ...
    TYPE_NOT_SET: Task.TaskType.ValueType  # 0
    CONCEPTS_CLASSIFICATION: Task.TaskType.ValueType  # 1
    """Concepts classification tasks annotate concepts for the overall image, frame of video or section of text."""
    BOUNDING_BOX_DETECTION: Task.TaskType.ValueType  # 2
    """Bounding box detection tasks annotate rectangular bounding box regions around each concept in an image, frame of video or section of text."""
    POLYGON_DETECTION: Task.TaskType.ValueType  # 3
    """Polygon detection tasks annotate free-form regions around concepts in an image, frame of video or section of text."""

    class _TaskPriority:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TaskPriorityEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Task._TaskPriority.ValueType],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TASK_PRIORITY_NOT_SET: Task._TaskPriority.ValueType  # 0
        LOW: Task._TaskPriority.ValueType  # 1
        MEDIUM: Task._TaskPriority.ValueType  # 2
        HIGH: Task._TaskPriority.ValueType  # 3

    class TaskPriority(_TaskPriority, metaclass=_TaskPriorityEnumTypeWrapper): ...
    TASK_PRIORITY_NOT_SET: Task.TaskPriority.ValueType  # 0
    LOW: Task.TaskPriority.ValueType  # 1
    MEDIUM: Task.TaskPriority.ValueType  # 2
    HIGH: Task.TaskPriority.ValueType  # 3

    ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    WORKER_FIELD_NUMBER: builtins.int
    CONCEPT_IDS_FIELD_NUMBER: builtins.int
    INPUT_SOURCE_FIELD_NUMBER: builtins.int
    SAMPLE_MS_FIELD_NUMBER: builtins.int
    AI_ASSISTANT_FIELD_NUMBER: builtins.int
    REVIEW_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    AI_ASSIST_PARAMS_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    LABEL_ORDER_ID_FIELD_NUMBER: builtins.int
    CONCEPTS_FIELD_NUMBER: builtins.int
    DELETE_PREVIOUS_ANNOTATIONS_FIELD_NUMBER: builtins.int
    METRICS_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique ID for the task."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the task was created.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Most recent time when the task was updated.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    type: global___Task.TaskType.ValueType
    """Task type."""
    description: builtins.str
    """Description of the task."""
    @property
    def worker(self) -> global___TaskWorker:
        """Worker details."""
    @property
    def concept_ids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of concept ids used in the work of this task.
        DEPRECATED: Use task.concepts instead.
        """
    @property
    def input_source(self) -> global___TaskInputSource:
        """List of inputs used in this task will be taken from this source."""
    sample_ms: builtins.int
    """For model predictions on video: Sample delay for video predicting (1 frame per N milliseconds)"""
    @property
    def ai_assistant(self) -> global___TaskAIAssistant:
        """AI assistant details."""
    @property
    def review(self) -> global___TaskReview:
        """Review details."""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """Status of this task."""
    name: builtins.str
    """Add a title for this task to quickly recognise it in a list of tasks."""
    @property
    def ai_assist_params(self) -> global___AiAssistParameters: ...
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    app_id: builtins.str
    """The app the task belongs to."""
    user_id: builtins.str
    """The user the task belongs to."""
    label_order_id: builtins.str
    """The label order the task belongs to."""
    @property
    def concepts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TaskConcept]:
        """Ignore Task.concept_ids field if Task.TaskConcept are supplied."""
    delete_previous_annotations: builtins.bool
    """Specify whether existing Annotations within the same app that are generated by other auto annotation tasks
    with the specified Concept from the selected Model or Workflow should deleted before executing the Task
    """
    @property
    def metrics(self) -> global___TaskMetrics:
        """Tasks metrics are filled in upon user-request."""
    priority: global___Task.TaskPriority.ValueType
    """Priority of the task"""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        type: global___Task.TaskType.ValueType = ...,
        description: builtins.str = ...,
        worker: global___TaskWorker | None = ...,
        concept_ids: collections.abc.Iterable[builtins.str] | None = ...,
        input_source: global___TaskInputSource | None = ...,
        sample_ms: builtins.int = ...,
        ai_assistant: global___TaskAIAssistant | None = ...,
        review: global___TaskReview | None = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        name: builtins.str = ...,
        ai_assist_params: global___AiAssistParameters | None = ...,
        visibility: global___Visibility | None = ...,
        app_id: builtins.str = ...,
        user_id: builtins.str = ...,
        label_order_id: builtins.str = ...,
        concepts: collections.abc.Iterable[global___TaskConcept] | None = ...,
        delete_previous_annotations: builtins.bool = ...,
        metrics: global___TaskMetrics | None = ...,
        priority: global___Task.TaskPriority.ValueType = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "ai_assist_params",
            b"ai_assist_params",
            "ai_assistant",
            b"ai_assistant",
            "created_at",
            b"created_at",
            "input_source",
            b"input_source",
            "metadata",
            b"metadata",
            "metrics",
            b"metrics",
            "modified_at",
            b"modified_at",
            "review",
            b"review",
            "status",
            b"status",
            "visibility",
            b"visibility",
            "worker",
            b"worker",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "ai_assist_params",
            b"ai_assist_params",
            "ai_assistant",
            b"ai_assistant",
            "app_id",
            b"app_id",
            "concept_ids",
            b"concept_ids",
            "concepts",
            b"concepts",
            "created_at",
            b"created_at",
            "delete_previous_annotations",
            b"delete_previous_annotations",
            "description",
            b"description",
            "id",
            b"id",
            "input_source",
            b"input_source",
            "label_order_id",
            b"label_order_id",
            "metadata",
            b"metadata",
            "metrics",
            b"metrics",
            "modified_at",
            b"modified_at",
            "name",
            b"name",
            "priority",
            b"priority",
            "review",
            b"review",
            "sample_ms",
            b"sample_ms",
            "status",
            b"status",
            "type",
            b"type",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
            "worker",
            b"worker",
        ],
    ) -> None: ...

global___Task = Task

@typing_extensions.final
class AiAssistParameters(google.protobuf.message.Message):
    """AiAssistParameters"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_THRESHOLD_FIELD_NUMBER: builtins.int
    MAX_THRESHOLD_FIELD_NUMBER: builtins.int
    CONCEPT_RELATION_IDS_FIELD_NUMBER: builtins.int
    min_threshold: builtins.float
    """Min and max threshold values for approving annotations by default based on prediction score"""
    max_threshold: builtins.float
    @property
    def concept_relation_ids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """ids of concept relations. Used in AI assist workflow"""
    def __init__(
        self,
        *,
        min_threshold: builtins.float = ...,
        max_threshold: builtins.float = ...,
        concept_relation_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "concept_relation_ids",
            b"concept_relation_ids",
            "max_threshold",
            b"max_threshold",
            "min_threshold",
            b"min_threshold",
        ],
    ) -> None: ...

global___AiAssistParameters = AiAssistParameters

@typing_extensions.final
class TaskWorker(google.protobuf.message.Message):
    """TaskWorker includes information about the workers that will work on this task."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _TaskWorkerStrategy:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TaskWorkerStrategyEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            TaskWorker._TaskWorkerStrategy.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        WORKER_STRATEGY_NOT_SET: TaskWorker._TaskWorkerStrategy.ValueType  # 0
        PARTITIONED: TaskWorker._TaskWorkerStrategy.ValueType  # 2
        """The inputs will be partitioned in several partitions.
        Each worker will label one or more input partitions.
        All inputs are assigned at task creation.
        """
        FULL: TaskWorker._TaskWorkerStrategy.ValueType  # 3
        """Each worker will label all inputs from input source.
        All inputs are assigned at task creation.
        """
        DYNAMIC: TaskWorker._TaskWorkerStrategy.ValueType  # 4
        """Each worker will dynamically get 10 inputs assigned at a time.
        No inputs are assigned at task creation.
        """

    class TaskWorkerStrategy(
        _TaskWorkerStrategy, metaclass=_TaskWorkerStrategyEnumTypeWrapper
    ): ...
    WORKER_STRATEGY_NOT_SET: TaskWorker.TaskWorkerStrategy.ValueType  # 0
    PARTITIONED: TaskWorker.TaskWorkerStrategy.ValueType  # 2
    """The inputs will be partitioned in several partitions.
    Each worker will label one or more input partitions.
    All inputs are assigned at task creation.
    """
    FULL: TaskWorker.TaskWorkerStrategy.ValueType  # 3
    """Each worker will label all inputs from input source.
    All inputs are assigned at task creation.
    """
    DYNAMIC: TaskWorker.TaskWorkerStrategy.ValueType  # 4
    """Each worker will dynamically get 10 inputs assigned at a time.
    No inputs are assigned at task creation.
    """

    class _WorkerType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _WorkerTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            TaskWorker._WorkerType.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        WORKER_TYPE_NOT_SET: TaskWorker._WorkerType.ValueType  # 0
        """for backward compatibility when task is not setting any type and only sets workers"""
        WORKER_HUMAN: TaskWorker._WorkerType.ValueType  # 1
        """only human workers"""
        WORKER_AUTO: TaskWorker._WorkerType.ValueType  # 2
        """auto-annotation tasks. Task must set worker as model or workflow"""

    class WorkerType(_WorkerType, metaclass=_WorkerTypeEnumTypeWrapper): ...
    WORKER_TYPE_NOT_SET: TaskWorker.WorkerType.ValueType  # 0
    """for backward compatibility when task is not setting any type and only sets workers"""
    WORKER_HUMAN: TaskWorker.WorkerType.ValueType  # 1
    """only human workers"""
    WORKER_AUTO: TaskWorker.WorkerType.ValueType  # 2
    """auto-annotation tasks. Task must set worker as model or workflow"""

    STRATEGY_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    USERS_FIELD_NUMBER: builtins.int
    PARTITIONED_STRATEGY_INFO_FIELD_NUMBER: builtins.int
    WORKERS_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    strategy: global___TaskWorker.TaskWorkerStrategy.ValueType
    """Worker strategy."""
    @property
    def user_ids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Who will work on this task.
        DEPRECATED: Use workers.user.id instead.
        """
    @property
    def users(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___User]:
        """Users who will work on this task.
        When the 'worker.users' field is additionally requested, then all user
        info is filled for the workers. Otherwise, only the user 'id' is filled.
        DEPRECATED: Use workers.user instead.
        """
    @property
    def partitioned_strategy_info(self) -> global___TaskWorkerPartitionedStrategyInfo: ...
    @property
    def workers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Worker]:
        """Workers that will work on this task.

        For Auto Annotation Tasks:
          the worker can be either a model or a workflow;
          currently only supports 1 worker.
        For manual labeling Tasks:
          the workers can only be users;
          no limitation on number of workers.
        """
    type: global___TaskWorker.WorkerType.ValueType
    """Who is doing annotations - human Worker or auto-annotation via Model/Workflow.
    If set, worker must have be set accordingly to either human worker or model/workflow worker
    """
    def __init__(
        self,
        *,
        strategy: global___TaskWorker.TaskWorkerStrategy.ValueType = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        users: collections.abc.Iterable[global___User] | None = ...,
        partitioned_strategy_info: global___TaskWorkerPartitionedStrategyInfo | None = ...,
        workers: collections.abc.Iterable[global___Worker] | None = ...,
        type: global___TaskWorker.WorkerType.ValueType = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "partitioned_strategy_info",
            b"partitioned_strategy_info",
            "strategy_info",
            b"strategy_info",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "partitioned_strategy_info",
            b"partitioned_strategy_info",
            "strategy",
            b"strategy",
            "strategy_info",
            b"strategy_info",
            "type",
            b"type",
            "user_ids",
            b"user_ids",
            "users",
            b"users",
            "workers",
            b"workers",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["strategy_info", b"strategy_info"]
    ) -> typing_extensions.Literal["partitioned_strategy_info"] | None: ...

global___TaskWorker = TaskWorker

@typing_extensions.final
class TaskWorkerPartitionedStrategyInfo(google.protobuf.message.Message):
    """TaskWorkerPartitionedStrategyInfo"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _TaskWorkerPartitionedStrategy:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TaskWorkerPartitionedStrategyEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            TaskWorkerPartitionedStrategyInfo._TaskWorkerPartitionedStrategy.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PARTITIONED_WORKER_STRATEGY_NOT_SET: (
            TaskWorkerPartitionedStrategyInfo._TaskWorkerPartitionedStrategy.ValueType
        )  # 0
        EVENLY: TaskWorkerPartitionedStrategyInfo._TaskWorkerPartitionedStrategy.ValueType  # 1
        """Each worker will label (approximately) the same number of inputs."""
        WEIGHTED: TaskWorkerPartitionedStrategyInfo._TaskWorkerPartitionedStrategy.ValueType  # 2
        """Each worker will have an assigned weight.
        See weights field for more details.
        """

    class TaskWorkerPartitionedStrategy(
        _TaskWorkerPartitionedStrategy, metaclass=_TaskWorkerPartitionedStrategyEnumTypeWrapper
    ): ...
    PARTITIONED_WORKER_STRATEGY_NOT_SET: (
        TaskWorkerPartitionedStrategyInfo.TaskWorkerPartitionedStrategy.ValueType
    )  # 0
    EVENLY: TaskWorkerPartitionedStrategyInfo.TaskWorkerPartitionedStrategy.ValueType  # 1
    """Each worker will label (approximately) the same number of inputs."""
    WEIGHTED: TaskWorkerPartitionedStrategyInfo.TaskWorkerPartitionedStrategy.ValueType  # 2
    """Each worker will have an assigned weight.
    See weights field for more details.
    """

    TYPE_FIELD_NUMBER: builtins.int
    WORKERS_PER_INPUT_FIELD_NUMBER: builtins.int
    WEIGHTS_FIELD_NUMBER: builtins.int
    type: global___TaskWorkerPartitionedStrategyInfo.TaskWorkerPartitionedStrategy.ValueType
    """Define how the partitioning should work."""
    workers_per_input: builtins.int
    """How many workers will label each input."""
    @property
    def weights(self) -> google.protobuf.struct_pb2.Struct:
        """In case of weighted partitioning, map user ids to weights.
        Each labeler will be assigned work proportional to its own weight as compared to the sum of total weight.

        EXAMPLE:
        If we have 3 workers, and weights = {1: 30, 2: 30, 3: 40},
        then first worker will have assigned 30% of the work,
        second worker will have assigned 30% of the work,
        and third worker will have assigned 40% of the work.
        You may use weights which add up to 100, but it's not necessary.
        For example, weights {1: 30, 2: 30, 3: 40} are equivalent with {1: 3, 2: 3, 3: 4}
        because they represent the same percentages: {1: 30%, 2: 30%, 3: 40%}.

        NOTE:
        Note that no worker should be assigned a weight percentage greater than 1/workers_per_input.
        It is mathematically impossible to partition the work in such a case.
        Why? Say, we have 3 workers. And workers_per_input = 2, i.e. each input must be labeled by 2 workers.
        Let's assign weights {1: 51%, 2: 25%, 3: 24%}.
        Note that first worker has a weight percentage higher than 1/workers_per_input = 1/2 = 50%.
        If we have 100 inputs, then a total of 100 * workers_per_input = 200 cumulative inputs will be labeled by these 3 workers.
        Worker 1 should label 102 cumulative inputs, while worker 2 and worker 3 will label 98 cumulative inputs together.
        No matter how we assign the 98 cumulative inputs, the 2 workers will be able to label up to 98 actual inputs.
        This means the remaining 2 inputs will be labeled only by worker 1. This contradicts the worker_per_input = 2 requirement.
        """
    def __init__(
        self,
        *,
        type: global___TaskWorkerPartitionedStrategyInfo.TaskWorkerPartitionedStrategy.ValueType = ...,
        workers_per_input: builtins.int = ...,
        weights: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["weights", b"weights"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "type", b"type", "weights", b"weights", "workers_per_input", b"workers_per_input"
        ],
    ) -> None: ...

global___TaskWorkerPartitionedStrategyInfo = TaskWorkerPartitionedStrategyInfo

@typing_extensions.final
class TaskInputSource(google.protobuf.message.Message):
    """TaskInputSource"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _TaskInputSourceType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TaskInputSourceTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            TaskInputSource._TaskInputSourceType.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INPUT_SOURCE_TYPE_NOT_SET: TaskInputSource._TaskInputSourceType.ValueType  # 0
        ALL_INPUTS: TaskInputSource._TaskInputSourceType.ValueType  # 1
        """Use all inputs in the app."""
        SAVED_SEARCH: TaskInputSource._TaskInputSourceType.ValueType  # 2
        """Use the inputs from a saved search."""
        DATASET: TaskInputSource._TaskInputSourceType.ValueType  # 3
        """Inputs from a dataset."""

    class TaskInputSourceType(
        _TaskInputSourceType, metaclass=_TaskInputSourceTypeEnumTypeWrapper
    ): ...
    INPUT_SOURCE_TYPE_NOT_SET: TaskInputSource.TaskInputSourceType.ValueType  # 0
    ALL_INPUTS: TaskInputSource.TaskInputSourceType.ValueType  # 1
    """Use all inputs in the app."""
    SAVED_SEARCH: TaskInputSource.TaskInputSourceType.ValueType  # 2
    """Use the inputs from a saved search."""
    DATASET: TaskInputSource.TaskInputSourceType.ValueType  # 3
    """Inputs from a dataset."""

    TYPE_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    type: global___TaskInputSource.TaskInputSourceType.ValueType
    """Type of input source."""
    id: builtins.str
    """If type is SAVED_SEARCH, then this is the saved search id."""
    def __init__(
        self,
        *,
        type: global___TaskInputSource.TaskInputSourceType.ValueType = ...,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["id", b"id", "type", b"type"]
    ) -> None: ...

global___TaskInputSource = TaskInputSource

@typing_extensions.final
class TaskReview(google.protobuf.message.Message):
    """TaskReview"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _TaskReviewStrategy:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TaskReviewStrategyEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            TaskReview._TaskReviewStrategy.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TASK_REVIEW_STRATEGY_NOT_SET: TaskReview._TaskReviewStrategy.ValueType  # 0
        NONE: TaskReview._TaskReviewStrategy.ValueType  # 1
        """No review is needed.
        When a labeler labels an input, the annotations are immediately approved.
        """
        MANUAL: TaskReview._TaskReviewStrategy.ValueType  # 2
        """Human reviewers will review the work done by labelers."""
        CONSENSUS: TaskReview._TaskReviewStrategy.ValueType  # 3
        """Automatically approve inputs when labelers reach consensus.
        If consensus is not reached, then it will fallback to human reviewers.
        """

    class TaskReviewStrategy(
        _TaskReviewStrategy, metaclass=_TaskReviewStrategyEnumTypeWrapper
    ): ...
    TASK_REVIEW_STRATEGY_NOT_SET: TaskReview.TaskReviewStrategy.ValueType  # 0
    NONE: TaskReview.TaskReviewStrategy.ValueType  # 1
    """No review is needed.
    When a labeler labels an input, the annotations are immediately approved.
    """
    MANUAL: TaskReview.TaskReviewStrategy.ValueType  # 2
    """Human reviewers will review the work done by labelers."""
    CONSENSUS: TaskReview.TaskReviewStrategy.ValueType  # 3
    """Automatically approve inputs when labelers reach consensus.
    If consensus is not reached, then it will fallback to human reviewers.
    """

    STRATEGY_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    USERS_FIELD_NUMBER: builtins.int
    MANUAL_STRATEGY_INFO_FIELD_NUMBER: builtins.int
    CONSENSUS_STRATEGY_INFO_FIELD_NUMBER: builtins.int
    strategy: global___TaskReview.TaskReviewStrategy.ValueType
    """Task review strategy."""
    @property
    def user_ids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Who will review this task.
        DEPRECATED: Use users.id instead.
        """
    @property
    def users(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___User]:
        """Users who will review this task.
        When the 'review.users' field is additionally requested, then all user
        info is filled for the reviewers. Otherwise, only the user 'id' is filled.
        """
    @property
    def manual_strategy_info(self) -> global___TaskReviewManualStrategyInfo: ...
    @property
    def consensus_strategy_info(self) -> global___TaskReviewConsensusStrategyInfo: ...
    def __init__(
        self,
        *,
        strategy: global___TaskReview.TaskReviewStrategy.ValueType = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        users: collections.abc.Iterable[global___User] | None = ...,
        manual_strategy_info: global___TaskReviewManualStrategyInfo | None = ...,
        consensus_strategy_info: global___TaskReviewConsensusStrategyInfo | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "consensus_strategy_info",
            b"consensus_strategy_info",
            "manual_strategy_info",
            b"manual_strategy_info",
            "strategy_info",
            b"strategy_info",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "consensus_strategy_info",
            b"consensus_strategy_info",
            "manual_strategy_info",
            b"manual_strategy_info",
            "strategy",
            b"strategy",
            "strategy_info",
            b"strategy_info",
            "user_ids",
            b"user_ids",
            "users",
            b"users",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["strategy_info", b"strategy_info"]
    ) -> typing_extensions.Literal["manual_strategy_info", "consensus_strategy_info"] | None: ...

global___TaskReview = TaskReview

@typing_extensions.final
class TaskReviewManualStrategyInfo(google.protobuf.message.Message):
    """TaskReviewManualStrategyInfo"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SAMPLE_PERCENTAGE_FIELD_NUMBER: builtins.int
    APPROVAL_THRESHOLD_FIELD_NUMBER: builtins.int
    sample_percentage: builtins.float
    """This field represents the percentage of inputs that will be reviewed by reviewers. It is a value between 0 and 1."""
    approval_threshold: builtins.int
    """Deprecated: Use consensus_strategy_info.approval_threshold_reviewers."""
    def __init__(
        self,
        *,
        sample_percentage: builtins.float = ...,
        approval_threshold: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "approval_threshold", b"approval_threshold", "sample_percentage", b"sample_percentage"
        ],
    ) -> None: ...

global___TaskReviewManualStrategyInfo = TaskReviewManualStrategyInfo

@typing_extensions.final
class TaskReviewConsensusStrategyInfo(google.protobuf.message.Message):
    """TaskReviewConsensusStrategyInfo"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPROVAL_THRESHOLD_FIELD_NUMBER: builtins.int
    APPROVAL_THRESHOLD_LABELERS_FIELD_NUMBER: builtins.int
    APPROVAL_THRESHOLD_REVIEWERS_FIELD_NUMBER: builtins.int
    approval_threshold: builtins.int
    """Deprecated: Use approval_threshold_labelers."""
    approval_threshold_labelers: builtins.int
    """The number of labelers that need to agree in order to automatically approve an annotation.
    When 0, labelers consensus is disabled.
    When 1, the labels are automatically approved once a single labeler labels the input.
    When greater than 1, the labels are automatically approved when the specified number of labelers agree.
    If the number of labelers that agree is less than the specified number, then the input will reviewed by reviewers.
    """
    approval_threshold_reviewers: builtins.int
    """The number of reviewers that need to agree in order to approve an input.
    Currently, the only allowed values are:
    0  - when not set, it defaults to 1
    1  - only a single reviewer needs to approve each labeled input
    -1 - an input will be approved when all reviewers approve it
    """
    def __init__(
        self,
        *,
        approval_threshold: builtins.int = ...,
        approval_threshold_labelers: builtins.int = ...,
        approval_threshold_reviewers: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "approval_threshold",
            b"approval_threshold",
            "approval_threshold_labelers",
            b"approval_threshold_labelers",
            "approval_threshold_reviewers",
            b"approval_threshold_reviewers",
        ],
    ) -> None: ...

global___TaskReviewConsensusStrategyInfo = TaskReviewConsensusStrategyInfo

@typing_extensions.final
class TaskAIAssistant(google.protobuf.message.Message):
    """TaskAIAssistant"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_FIELD_NUMBER: builtins.int
    workflow_id: builtins.str
    """The worker is helped by an AI assistant.
    This field is the workflow id which is used to assist the worker with predictions.
    If empty, then AI assistant is disabled.
    """
    @property
    def workflow(self) -> global___Workflow: ...
    def __init__(
        self,
        *,
        workflow_id: builtins.str = ...,
        workflow: global___Workflow | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["workflow", b"workflow"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "workflow", b"workflow", "workflow_id", b"workflow_id"
        ],
    ) -> None: ...

global___TaskAIAssistant = TaskAIAssistant

@typing_extensions.final
class TaskAssignment(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    WORKER_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    id: builtins.str
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation time.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Most recent modification time.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def worker(self) -> global___Worker:
        """Assigned worker."""
    @property
    def input(self) -> global___Input:
        """Assigned input."""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """Assignment status.
        Read as: This is the status of the work assigned to worker W, on input I in task T.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        worker: global___Worker | None = ...,
        input: global___Input | None = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "input",
            b"input",
            "modified_at",
            b"modified_at",
            "status",
            b"status",
            "worker",
            b"worker",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "id",
            b"id",
            "input",
            b"input",
            "modified_at",
            b"modified_at",
            "status",
            b"status",
            "worker",
            b"worker",
        ],
    ) -> None: ...

global___TaskAssignment = TaskAssignment

@typing_extensions.final
class TaskStatusCountPerUser(google.protobuf.message.Message):
    """TaskStatusCountPerUser can represent one of the following:
    * count of task annotations created by a worker for each valid status,
    * count of task inputs assigned to a worker  (i.e. task assignments) for each valid status
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_ID_FIELD_NUMBER: builtins.int
    PENDING_FIELD_NUMBER: builtins.int
    AWAITING_REVIEW_FIELD_NUMBER: builtins.int
    SUCCESS_FIELD_NUMBER: builtins.int
    REVIEW_DENIED_FIELD_NUMBER: builtins.int
    AWAITING_CONSENSUS_REVIEW_FIELD_NUMBER: builtins.int
    WORKER_FIELD_NUMBER: builtins.int
    user_id: builtins.str
    """Deprecated: Use worker instead."""
    pending: builtins.int
    awaiting_review: builtins.int
    success: builtins.int
    review_denied: builtins.int
    awaiting_consensus_review: builtins.int
    @property
    def worker(self) -> global___Worker: ...
    def __init__(
        self,
        *,
        user_id: builtins.str = ...,
        pending: builtins.int = ...,
        awaiting_review: builtins.int = ...,
        success: builtins.int = ...,
        review_denied: builtins.int = ...,
        awaiting_consensus_review: builtins.int = ...,
        worker: global___Worker | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["worker", b"worker"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "awaiting_consensus_review",
            b"awaiting_consensus_review",
            "awaiting_review",
            b"awaiting_review",
            "pending",
            b"pending",
            "review_denied",
            b"review_denied",
            "success",
            b"success",
            "user_id",
            b"user_id",
            "worker",
            b"worker",
        ],
    ) -> None: ...

global___TaskStatusCountPerUser = TaskStatusCountPerUser

@typing_extensions.final
class ThresholdRange(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IS_LOWER_INCLUSIVE_FIELD_NUMBER: builtins.int
    IS_UPPER_INCLUSIVE_FIELD_NUMBER: builtins.int
    LOWER_FIELD_NUMBER: builtins.int
    UPPER_FIELD_NUMBER: builtins.int
    is_lower_inclusive: builtins.bool
    """The range used to filter over concept values.
    e.g. GREATER_THAN_OR_EQUAL_TO 0.7 -> is_lower_inclusive = true, lower = 0.7, is_upper_inclusive = true, upper = 1.0
    e.g. (0.3, 0.75] -> is_lower_inclusive = false, lower = 0.3, is_upper_inclusive = true, upper = 0.75
    """
    is_upper_inclusive: builtins.bool
    lower: builtins.float
    upper: builtins.float
    def __init__(
        self,
        *,
        is_lower_inclusive: builtins.bool = ...,
        is_upper_inclusive: builtins.bool = ...,
        lower: builtins.float = ...,
        upper: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "is_lower_inclusive",
            b"is_lower_inclusive",
            "is_upper_inclusive",
            b"is_upper_inclusive",
            "lower",
            b"lower",
            "upper",
            b"upper",
        ],
    ) -> None: ...

global___ThresholdRange = ThresholdRange

@typing_extensions.final
class TaskConceptAutoAnnotationConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ANNOTATION_DATA_TYPES_FIELD_NUMBER: builtins.int
    THRESHOLD_RANGE_FIELD_NUMBER: builtins.int
    STATUS_CODE_FIELD_NUMBER: builtins.int
    annotation_data_types: builtins.int
    """Filter annotations by their annotation data type.
    This is a bit-mask field that holds multiple AnnotationDataType values that are combined in an OR fashion.
    Example: if annotation_data_types = 34, then we filter annotations that appear as a mask or a bounding box,
    because MASK = 32 and BOUNDING_BOX = 2.
    """
    @property
    def threshold_range(self) -> global___ThresholdRange:
        """Filter annotations by concept value.
        Only concepts that fit in the threshold will be used to generate annotations.
        """
    status_code: proto.clarifai.api.status.status_code_pb2.StatusCode.ValueType
    """The output annotations will be created using this status code."""
    def __init__(
        self,
        *,
        annotation_data_types: builtins.int = ...,
        threshold_range: global___ThresholdRange | None = ...,
        status_code: proto.clarifai.api.status.status_code_pb2.StatusCode.ValueType = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["threshold_range", b"threshold_range"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "annotation_data_types",
            b"annotation_data_types",
            "status_code",
            b"status_code",
            "threshold_range",
            b"threshold_range",
        ],
    ) -> None: ...

global___TaskConceptAutoAnnotationConfig = TaskConceptAutoAnnotationConfig

@typing_extensions.final
class TaskConcept(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONCEPT_FIELD_NUMBER: builtins.int
    AUTO_ANNOTATION_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def concept(self) -> global___Concept:
        """For auto annotation, id/name and value, user + app id must be specified. For other tasks, only the id field is required."""
    @property
    def auto_annotation_config(self) -> global___TaskConceptAutoAnnotationConfig: ...
    def __init__(
        self,
        *,
        concept: global___Concept | None = ...,
        auto_annotation_config: global___TaskConceptAutoAnnotationConfig | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "auto_annotation_config", b"auto_annotation_config", "concept", b"concept"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "auto_annotation_config", b"auto_annotation_config", "concept", b"concept"
        ],
    ) -> None: ...

global___TaskConcept = TaskConcept

@typing_extensions.final
class TaskMetrics(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORK_FIELD_NUMBER: builtins.int
    REVIEW_FIELD_NUMBER: builtins.int
    INPUT_SOURCE_FIELD_NUMBER: builtins.int
    @property
    def work(self) -> global___TaskWorkMetrics: ...
    @property
    def review(self) -> global___TaskReviewMetrics: ...
    @property
    def input_source(self) -> global___TaskInputSourceMetrics: ...
    def __init__(
        self,
        *,
        work: global___TaskWorkMetrics | None = ...,
        review: global___TaskReviewMetrics | None = ...,
        input_source: global___TaskInputSourceMetrics | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "input_source", b"input_source", "review", b"review", "work", b"work"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "input_source", b"input_source", "review", b"review", "work", b"work"
        ],
    ) -> None: ...

global___TaskMetrics = TaskMetrics

@typing_extensions.final
class TaskWorkMetrics(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUTS_COUNT_ESTIMATED_FIELD_NUMBER: builtins.int
    INPUTS_PERCENT_ESTIMATED_FIELD_NUMBER: builtins.int
    inputs_count_estimated: builtins.int
    """Estimated number of inputs that workers have worked on."""
    inputs_percent_estimated: builtins.int
    """Estimated percent of inputs that workers have worked on.
    This is a value between 0 and 100, where 0 = 0% and 100 = 100%.
    """
    def __init__(
        self,
        *,
        inputs_count_estimated: builtins.int = ...,
        inputs_percent_estimated: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "inputs_count_estimated",
            b"inputs_count_estimated",
            "inputs_percent_estimated",
            b"inputs_percent_estimated",
        ],
    ) -> None: ...

global___TaskWorkMetrics = TaskWorkMetrics

@typing_extensions.final
class TaskReviewMetrics(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUTS_COUNT_ESTIMATED_FIELD_NUMBER: builtins.int
    INPUTS_PERCENT_ESTIMATED_FIELD_NUMBER: builtins.int
    INPUTS_COUNT_ESTIMATED_PER_REVIEWER_FIELD_NUMBER: builtins.int
    INPUTS_REVIEWABLE_COUNT_ESTIMATED_PER_REVIEWER_FIELD_NUMBER: builtins.int
    INPUTS_PERCENT_ESTIMATED_PER_REVIEWER_FIELD_NUMBER: builtins.int
    inputs_count_estimated: builtins.int
    """Estimated number of fully reviewed inputs.
    An input is considered fully reviewed if it has been reviewed by all necessary reviewers.
    Example: if task has no review, then an input is considered fully reviewed right after it's labeled (as review is skipped).
    Example: if task has manual review with single-reviewer per input, then an input is considered fully reviewed when 1 reviewer has approved/rejected it.
    Example: if task has consensus review with 3 reviewers per input, then an input is considered fully reviewed when 3 reviewers have approved it or 1 reviewer has rejected it.
    """
    inputs_percent_estimated: builtins.int
    """Estimated percent of review work that was finished.
    This is a value between 0 and 100, where 0 = 0% and 100 = 100%.
    Calculated as inputs_count_estimated/task.metrics.input_source.inputs_count_estimated.
    As the counts are estimated, the percentage is also estimated.
    However, additional checks are made to ensure that 100% percentage is only returned when all inputs are reviewed - giving a guarantee that the 100% percentage is always accurate.
    """
    @property
    def inputs_count_estimated_per_reviewer(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Estimated number of reviewed inputs per reviewer index.
        The reviewer indexes are based on task.review.users.
        An input is considered reviewed by a reviewer if:
        * the reviewer approved the input
        * the reviewer rejected the input
        Note that when a reviewer requests changes for an input, the input is sent to back to work again, so the whole work & review process is restarted.
        The reviewer will have to review the input again after work has been completed.
        As such, the review that requests changes for an input is immediately dis-regarded and not counted in this metric.
        """
    @property
    def inputs_reviewable_count_estimated_per_reviewer(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """The number of inputs actually available for review for each reviewer.
        Most times, this equals task.metrics.input_source.inputs_count_estimated.
        Several situations may result in different values:
        * When task has no review, then this is 0 for each reviewer.
        * When task has auto-annotation, then this number equals the inputs that have been auto-annotated with AWAITING_REVIEW status. All other inputs are considered completed by the auto-annotation process.
        * When task has consensus review with approval_threshold_labelers > 0, then it's possible that labelers will approve inputs through consensus, which skips review. In this case, the number of inputs available for review is less than task.metrics.input_source.inputs_count_estimated.
        * When task has consensus review with approval_threshold_reviewers = 1, then all inputs are assigned only to one reviewer, so each reviewer will get only a part of the inputs to review. It's expected that the sum(inputs_reviewable_count_estimated) = task.metrics.input_source.inputs_count_estimated.
        * When task has consensus review with approval_threshold_reviewers = -1, then all inputs are assigned to all reviewers. However, if an input is rejected, then rejection is final and all other reviewers will not review it. In this case, the number of inputs available for review for other reviewers will be less than task.metrics.input_source.inputs_count_estimated.
        """
    @property
    def inputs_percent_estimated_per_reviewer(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Estimated percent of review work that was finished per reviewer.
        This is a value between 0 and 100, where 0 = 0% and 100 = 100%.
        Calculated as inputs_count_estimated_per_reviewer/inputs_reviewable_count_estimated_per_reviewer.
        As the counts are estimated, the percentage is also estimated.
        However, additional checks are made to ensure that 100% percentage is only returned when all inputs are reviewed - giving a guarantee that the 100% percentage is always accurate.
        """
    def __init__(
        self,
        *,
        inputs_count_estimated: builtins.int = ...,
        inputs_percent_estimated: builtins.int = ...,
        inputs_count_estimated_per_reviewer: collections.abc.Iterable[builtins.int] | None = ...,
        inputs_reviewable_count_estimated_per_reviewer: collections.abc.Iterable[builtins.int]
        | None = ...,
        inputs_percent_estimated_per_reviewer: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "inputs_count_estimated",
            b"inputs_count_estimated",
            "inputs_count_estimated_per_reviewer",
            b"inputs_count_estimated_per_reviewer",
            "inputs_percent_estimated",
            b"inputs_percent_estimated",
            "inputs_percent_estimated_per_reviewer",
            b"inputs_percent_estimated_per_reviewer",
            "inputs_reviewable_count_estimated_per_reviewer",
            b"inputs_reviewable_count_estimated_per_reviewer",
        ],
    ) -> None: ...

global___TaskReviewMetrics = TaskReviewMetrics

@typing_extensions.final
class TaskInputSourceMetrics(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUTS_COUNT_ESTIMATED_FIELD_NUMBER: builtins.int
    inputs_count_estimated: builtins.int
    """Estimated number of inputs that are in the source of data"""
    def __init__(
        self,
        *,
        inputs_count_estimated: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["inputs_count_estimated", b"inputs_count_estimated"],
    ) -> None: ...

global___TaskInputSourceMetrics = TaskInputSourceMetrics

@typing_extensions.final
class Role(google.protobuf.message.Message):
    """Role represents a list of permissions"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    SCOPES_FIELD_NUMBER: builtins.int
    ENDPOINTS_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    id: builtins.str
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the role was created.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Most recent time when the role was updated.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    name: builtins.str
    description: builtins.str
    @property
    def scopes(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The low-level scopes this role has"""
    @property
    def endpoints(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The endpoint-level scopes this role has"""
    type: global___RoleType.ValueType
    """Type of the role 'team' or 'org'"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        scopes: collections.abc.Iterable[builtins.str] | None = ...,
        endpoints: collections.abc.Iterable[builtins.str] | None = ...,
        type: global___RoleType.ValueType = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at", b"created_at", "modified_at", b"modified_at"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "description",
            b"description",
            "endpoints",
            b"endpoints",
            "id",
            b"id",
            "modified_at",
            b"modified_at",
            "name",
            b"name",
            "scopes",
            b"scopes",
            "type",
            b"type",
        ],
    ) -> None: ...

global___Role = Role

@typing_extensions.final
class Team(google.protobuf.message.Message):
    """Represents a group of users."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DEFAULT_ROLE_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Identify the team (unique)."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the team was created.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Most recent time when the team was updated.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    name: builtins.str
    """Name the team."""
    default_role_id: builtins.str
    """When a new application is assigned to the team without an explicit role, then the default role will be used"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        default_role_id: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at", b"created_at", "modified_at", b"modified_at"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "default_role_id",
            b"default_role_id",
            "id",
            b"id",
            "modified_at",
            b"modified_at",
            "name",
            b"name",
        ],
    ) -> None: ...

global___Team = Team

@typing_extensions.final
class Collector(google.protobuf.message.Message):
    """Collector is a data pathway from a CollectorSource to an app to collect data automatically.
    For example, a CollectorSource
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    PRE_QUEUE_WORKFLOW_ID_FIELD_NUMBER: builtins.int
    PRE_QUEUE_RANDOM_SAMPLE_FIELD_NUMBER: builtins.int
    POST_QUEUE_WORKFLOW_ID_FIELD_NUMBER: builtins.int
    COLLECTOR_SOURCE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    COLLECT_OUTPUTS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique ID for the collector."""
    description: builtins.str
    """Human readable description for the collector."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the collector is created. We follow the XXXX timestamp
        format. We use https://www.ietf.org/rfc/rfc3339.txt format:
        "2006-01-02T15:04:05.999999Z" so you can expect results like
        the following from the API:
        "2017-04-11T21:50:50.223962Z"
        """
    pre_queue_workflow_id: builtins.str
    """This is a workflow to run inline in model predict calls. It should ONLY have very fast and
    light-weight models in it as it will effect the speed of the predictions being made.
    This workflow's purpose is to filter down the inputs to queue for the collector to process.
    The input to this workflow is going to be the OUTPUT of the model, not the input to the model
    since we want to encourage having fast workflows that can also take advantage of the model
    outputs to make deciions (for example: thresholding based on concepts). If the workflow
    output has any field that is non-empty then the input will be queued for the collector
    to process with the post_queue_workflow_id.

    As a simpler alternative, pre_queue_random_sample can be set to just use random sampling instead.
    """
    pre_queue_random_sample: builtins.float
    """Instead of needing to create a new workflow for pre_queue_workflow_id, if just random sampling
    of the model inputs is required, then pre_queue_random_sample can be set to a value from (0-1]
    to denote the fraction of inputs to collect.
    """
    post_queue_workflow_id: builtins.str
    """A workflow to run to after the collector is processing the queued input. This workflow
    uses the original input to the model as input to the workflow so that you can run additional
    models as well on that input to decide whether to queue the model or not. If the workflow
    output has any field that is non-empty then it will be passed on to POST /inputs to
    the destination app.
    """
    @property
    def collector_source(self) -> global___CollectorSource:
        """The source of the collector to feed data into this app.
        Note(zeiler): if we wanted more than one source per collector we could make this it's own
        object and introduce /collectors/{collector_id}/sources
        We will keep it simple for now and have just one source per collector since a user can make
        more than one collector in the same app anyways.
        """
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """This is the workflow ID to do POST /inputs with the collected data using.
        This needs to be present at all times in this app for the collector to work.
        If this is not specified then it will use the default_workflow_id of the app.
        Note(zeiler): not yet available, uses only the default workflow that POST /inputs uses.
        string workflow_id = 7;

        Status for the collector. This allows you to pause a collector without having to delete it as
        an example.
        """
    collect_outputs: builtins.bool
    """Whether to collect outputs or not. Default is false. If selected, outputs from the
    original model predict call will be posted as annotations along with the input with success status.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        description: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        pre_queue_workflow_id: builtins.str = ...,
        pre_queue_random_sample: builtins.float = ...,
        post_queue_workflow_id: builtins.str = ...,
        collector_source: global___CollectorSource | None = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        collect_outputs: builtins.bool = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "collector_source",
            b"collector_source",
            "created_at",
            b"created_at",
            "status",
            b"status",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "collect_outputs",
            b"collect_outputs",
            "collector_source",
            b"collector_source",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "id",
            b"id",
            "post_queue_workflow_id",
            b"post_queue_workflow_id",
            "pre_queue_random_sample",
            b"pre_queue_random_sample",
            "pre_queue_workflow_id",
            b"pre_queue_workflow_id",
            "status",
            b"status",
        ],
    ) -> None: ...

global___Collector = Collector

@typing_extensions.final
class CollectorSource(google.protobuf.message.Message):
    """Configuration for the source to collect data from.
    Only one of the fields can be present at a time.
    The ID of the source in case we want to implment /collectors/{collector_id}/sources
    string id = 1;
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_POST_MODEL_OUTPUTS_COLLECTOR_SOURCE_FIELD_NUMBER: builtins.int
    @property
    def api_post_model_outputs_collector_source(
        self,
    ) -> global___APIPostModelOutputsCollectorSource:
        """Collect from the inputs passed in for PostModelOutputs predictions of a specific model.
        This does not apply to models used within workflows, only PostModelOutputs calls.
        """
    def __init__(
        self,
        *,
        api_post_model_outputs_collector_source: global___APIPostModelOutputsCollectorSource
        | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "api_post_model_outputs_collector_source", b"api_post_model_outputs_collector_source"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "api_post_model_outputs_collector_source", b"api_post_model_outputs_collector_source"
        ],
    ) -> None: ...

global___CollectorSource = CollectorSource

@typing_extensions.final
class APIPostModelOutputsCollectorSource(google.protobuf.message.Message):
    """This is configuration for using the inputs send for model prediction in our API as
    as the source for data.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_USER_ID_FIELD_NUMBER: builtins.int
    MODEL_APP_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    MODEL_VERSION_ID_FIELD_NUMBER: builtins.int
    POST_INPUTS_KEY_ID_FIELD_NUMBER: builtins.int
    CALLER_USER_ID_FIELD_NUMBER: builtins.int
    model_user_id: builtins.str
    """To define the model that we should collect from we need to specify the following 4 IDs:
    The User ID of the model we want to collect from.
    This is User B in the example.
    """
    model_app_id: builtins.str
    """The App ID of the model we want to collect from."""
    model_id: builtins.str
    """The Model ID of the model we want to collect from."""
    model_version_id: builtins.str
    """The Version ID of the model we want to collect from."""
    post_inputs_key_id: builtins.str
    """This key is used to POST /inputs into your app by the collector. It can be an API key or a
    PAT. This needs the permissions that are needed for POST /inputs for the app_id this
    Collector is defined in.
    """
    caller_user_id: builtins.str
    """The User ID of the caller of the model we want to collect from.
    This is needed because the below Model's ids could be used by multiple users like the
    clarifai/main models are or any model that has been shared with a collaborator. Therefore we
    need to know which caller of the model to collect inputs from.
    This is User A in the example.

    This is a private field that defaults to the app owner for public users.
    If this is left blank then this collector will collect from ALL users calling the given model.
    """
    def __init__(
        self,
        *,
        model_user_id: builtins.str = ...,
        model_app_id: builtins.str = ...,
        model_id: builtins.str = ...,
        model_version_id: builtins.str = ...,
        post_inputs_key_id: builtins.str = ...,
        caller_user_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "caller_user_id",
            b"caller_user_id",
            "model_app_id",
            b"model_app_id",
            "model_id",
            b"model_id",
            "model_user_id",
            b"model_user_id",
            "model_version_id",
            b"model_version_id",
            "post_inputs_key_id",
            b"post_inputs_key_id",
        ],
    ) -> None: ...

global___APIPostModelOutputsCollectorSource = APIPostModelOutputsCollectorSource

@typing_extensions.final
class StatValue(google.protobuf.message.Message):
    """StatValue"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIME_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time of the event. Defaults to now()."""
    value: builtins.float
    """A value for the metric you're recording."""
    @property
    def tags(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of tags to attach to this stat. Each should contain one colon so that the first part will
        be used as a tag group while the second being the tag itself. For example: ["task_id:a",
        "worker_id:1"]. These tag groups like "task_id" or "worker_id" are important for aggregating
        values in the StatValueAggregateQuery.
        """
    def __init__(
        self,
        *,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        value: builtins.float = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["time", b"time"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["tags", b"tags", "time", b"time", "value", b"value"],
    ) -> None: ...

global___StatValue = StatValue

@typing_extensions.final
class StatValueAggregateResult(google.protobuf.message.Message):
    """StatValueAggregateResult"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STAT_VALUE_AGGREGATES_FIELD_NUMBER: builtins.int
    STAT_VALUE_AGGREGATE_QUERY_FIELD_NUMBER: builtins.int
    @property
    def stat_value_aggregates(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___StatValueAggregate
    ]:
        """The list of repeated aggregate values and their counts."""
    @property
    def stat_value_aggregate_query(self) -> global___StatValueAggregateQuery:
        """The query that created these results."""
    def __init__(
        self,
        *,
        stat_value_aggregates: collections.abc.Iterable[global___StatValueAggregate] | None = ...,
        stat_value_aggregate_query: global___StatValueAggregateQuery | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "stat_value_aggregate_query", b"stat_value_aggregate_query"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "stat_value_aggregate_query",
            b"stat_value_aggregate_query",
            "stat_value_aggregates",
            b"stat_value_aggregates",
        ],
    ) -> None: ...

global___StatValueAggregateResult = StatValueAggregateResult

@typing_extensions.final
class StatValueAggregate(google.protobuf.message.Message):
    """StatValueAggregate"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIME_FIELD_NUMBER: builtins.int
    AGGREGATE_VALUE_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time of the aggregation. For example, if you aggregate over "HOUR" buckets then you can
        expect each hour that has atleast one value (matching the rest of your query fields) will have
        a StatValueAggregate with the time filled into that hour.
        """
    aggregate_value: builtins.float
    """The value aggregated according to the stat_value_agg_type"""
    count: builtins.int
    """The count of the stat values that were used in this aggregation."""
    @property
    def tags(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The tags for this aggregated_value and count. This will be filled in if tag groups were used in
        the query to group aggregations.
        """
    def __init__(
        self,
        *,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        aggregate_value: builtins.float = ...,
        count: builtins.int = ...,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["time", b"time"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "aggregate_value",
            b"aggregate_value",
            "count",
            b"count",
            "tags",
            b"tags",
            "time",
            b"time",
        ],
    ) -> None: ...

global___StatValueAggregate = StatValueAggregate

@typing_extensions.final
class StatValueAggregateQuery(google.protobuf.message.Message):
    """StatValueAggregateQuery"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAGS_FIELD_NUMBER: builtins.int
    TAG_GROUPS_FIELD_NUMBER: builtins.int
    STAT_VALUE_AGG_TYPE_FIELD_NUMBER: builtins.int
    STAT_TIME_AGG_TYPE_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    @property
    def tags(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """These tags are used to filter down the values before they are aggregated. For example,
        if you want to aggregate values for "task_id:a" you could specify that as a tag here.
        """
    @property
    def tag_groups(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """These are tag groups to aggregate over. So for example if you added stat values with tags
        "task_id:a" and others with "task_id:b", then added ["task_id"] to the task group, it the
        aggregation would return StatValueAggregate values for each task_id. If you provide more than
        one tag_group the response will return all rolled up combinations of them. For example
        ["task_id", "something"] where "something:1" and "something:2" were used as tags for some
        values then you'd get StatValueAggregate values back for:
        task_id | something
        a       | 1
        a       | 2
        b       | 1
        b       | 1
        """
    stat_value_agg_type: global___StatValueAggType.ValueType
    """Aggregation function to use over the values. Count(value) is also always returns.
    Defaults to 'sum' if not provided.
    """
    stat_time_agg_type: global___StatTimeAggType.ValueType
    """Aggregation bins for time where the values will be aggregated at this bin granualarity.
    And the "time" field will be returned in StatValueAggregate object.
    If not provided then bins are not used, and all time is aggregated over.
    """
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """If provided the time range over which values will be >= this time. If not provided then
        all values will be used back to start of time.
        """
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """If provided the time range over which values will be <= this time. If not provided then all
        values will be used up until now().
        """
    def __init__(
        self,
        *,
        tags: collections.abc.Iterable[builtins.str] | None = ...,
        tag_groups: collections.abc.Iterable[builtins.str] | None = ...,
        stat_value_agg_type: global___StatValueAggType.ValueType = ...,
        stat_time_agg_type: global___StatTimeAggType.ValueType = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "end_time", b"end_time", "start_time", b"start_time"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "end_time",
            b"end_time",
            "start_time",
            b"start_time",
            "stat_time_agg_type",
            b"stat_time_agg_type",
            "stat_value_agg_type",
            b"stat_value_agg_type",
            "tag_groups",
            b"tag_groups",
            "tags",
            b"tags",
        ],
    ) -> None: ...

global___StatValueAggregateQuery = StatValueAggregateQuery

@typing_extensions.final
class PCAProjectionComparator(google.protobuf.message.Message):
    """PCAProjectionComparator"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISTANCE_THRESHOLD_FIELD_NUMBER: builtins.int
    MODEL_VERSION_ID_FIELD_NUMBER: builtins.int
    distance_threshold: builtins.float
    """Within what distance do we consider two annotations duplicates"""
    model_version_id: builtins.str
    """What cluster model version generated these"""
    def __init__(
        self,
        *,
        distance_threshold: builtins.float = ...,
        model_version_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "distance_threshold", b"distance_threshold", "model_version_id", b"model_version_id"
        ],
    ) -> None: ...

global___PCAProjectionComparator = PCAProjectionComparator

@typing_extensions.final
class DuplicateAnnotationsResults(google.protobuf.message.Message):
    """DuplicateAnnotationsResults"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DUPLICATE_CFID_FIELD_NUMBER: builtins.int
    UNIQUE_COUNT_FIELD_NUMBER: builtins.int
    @property
    def duplicate_cfid(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    unique_count: builtins.int
    def __init__(
        self,
        *,
        duplicate_cfid: collections.abc.Iterable[builtins.str] | None = ...,
        unique_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "duplicate_cfid", b"duplicate_cfid", "unique_count", b"unique_count"
        ],
    ) -> None: ...

global___DuplicateAnnotationsResults = DuplicateAnnotationsResults

@typing_extensions.final
class Visibility(google.protobuf.message.Message):
    """Visibility represents how visible the given resource is to other users.
    When authenticating a request we can tell if a user is a collaborator or a teammate for the
    the app that contains the resource and set their allowed visibility. We use that to restrict
    what they are allowed to see:
    If AllowedVisibility is PRIVATE then we allow PRIVATE (10), ORG (30), PUBLIC (50)
    If AllowedVisibility is ORG then we allow ORG (30), PUBLIC (50)
    If AllowedVisibility is PUBLIC then we allow PUBLIC (50) only.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Gettable:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _GettableEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            Visibility._Gettable.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN_VISIBILITY: Visibility._Gettable.ValueType  # 0
        """Default value not allowed."""
        PRIVATE: Visibility._Gettable.ValueType  # 10
        """PRIVATE requires collaborator or team permissions in order to GET this resource."""
        ORG: Visibility._Gettable.ValueType  # 30
        """ORG requires you to be in the same org in order to GET this resource, but don't have to be a
        teammate or collaborator.
        """
        PUBLIC: Visibility._Gettable.ValueType  # 50
        """PUBLIC opens up GET access to the resource to any user on the platform even if they are not
        a teammate or collaborator.
        """

    class Gettable(_Gettable, metaclass=_GettableEnumTypeWrapper):
        """Gettable defined the level of access for GET operations for this resource."""

    UNKNOWN_VISIBILITY: Visibility.Gettable.ValueType  # 0
    """Default value not allowed."""
    PRIVATE: Visibility.Gettable.ValueType  # 10
    """PRIVATE requires collaborator or team permissions in order to GET this resource."""
    ORG: Visibility.Gettable.ValueType  # 30
    """ORG requires you to be in the same org in order to GET this resource, but don't have to be a
    teammate or collaborator.
    """
    PUBLIC: Visibility.Gettable.ValueType  # 50
    """PUBLIC opens up GET access to the resource to any user on the platform even if they are not
    a teammate or collaborator.
    """

    GETTABLE_FIELD_NUMBER: builtins.int
    gettable: global___Visibility.Gettable.ValueType
    def __init__(
        self,
        *,
        gettable: global___Visibility.Gettable.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["gettable", b"gettable"]
    ) -> None: ...

global___Visibility = Visibility

@typing_extensions.final
class FullTag(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Display name of the tag. Ex. "English" """
    id: builtins.str
    """Id value for referencing. Ex. "en" """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["id", b"id", "name", b"name"]
    ) -> None: ...

global___FullTag = FullTag

@typing_extensions.final
class TimeSegment(google.protobuf.message.Message):
    """TimeSegment"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    TIME_INFO_FIELD_NUMBER: builtins.int
    id: builtins.str
    """A unique id for the time segment."""
    @property
    def data(self) -> global___Data: ...
    @property
    def time_info(self) -> global___TimeInfo: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        data: global___Data | None = ...,
        time_info: global___TimeInfo | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["data", b"data", "time_info", b"time_info"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "data", b"data", "id", b"id", "time_info", b"time_info"
        ],
    ) -> None: ...

global___TimeSegment = TimeSegment

@typing_extensions.final
class TimeInfo(google.protobuf.message.Message):
    """TimeInfo"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NUM_FRAMES_FIELD_NUMBER: builtins.int
    BEGIN_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    num_frames: builtins.int
    """Number of frames"""
    begin_time: builtins.float
    """Timestamp where track begins."""
    end_time: builtins.float
    """Timestamp where track ends."""
    def __init__(
        self,
        *,
        num_frames: builtins.int = ...,
        begin_time: builtins.float = ...,
        end_time: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "begin_time", b"begin_time", "end_time", b"end_time", "num_frames", b"num_frames"
        ],
    ) -> None: ...

global___TimeInfo = TimeInfo

@typing_extensions.final
class DatasetStar(google.protobuf.message.Message):
    """DatasetStar"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["dataset_id", b"dataset_id"]
    ) -> None: ...

global___DatasetStar = DatasetStar

@typing_extensions.final
class ModuleStar(google.protobuf.message.Message):
    """ModuleStar"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODULE_ID_FIELD_NUMBER: builtins.int
    module_id: builtins.str
    """Module id of the star"""
    def __init__(
        self,
        *,
        module_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["module_id", b"module_id"]
    ) -> None: ...

global___ModuleStar = ModuleStar

@typing_extensions.final
class Module(google.protobuf.message.Message):
    """An app module that a user created in our app module marketplace."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    MODULE_VERSION_FIELD_NUMBER: builtins.int
    IS_STARRED_FIELD_NUMBER: builtins.int
    STAR_COUNT_FIELD_NUMBER: builtins.int
    BOOKMARK_ORIGIN_FIELD_NUMBER: builtins.int
    IMAGE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """A unique ID for this app module."""
    description: builtins.str
    """A short description for this app module to be used in grids of modules."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the app module was created."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the app module was last modified."""
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        Defaults to PRIVATE if not provided.
        """
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        This is an optional arg.
        """
    user_id: builtins.str
    """The creator of the app module."""
    app_id: builtins.str
    """The app_id this module was created in."""
    @property
    def module_version(self) -> global___ModuleVersion:
        """A ModuleVersion which is used when listing modules to include the latest module version
        in the response.
        """
    is_starred: builtins.bool
    """Is starred by the requesting user (only showed on get/list requests)
    Please use PostModuleStars/DeleteModuleStars endpoints to star/unstar a module
    """
    star_count: builtins.int
    """How many users have starred the module (only showed on get/list requests)
    Computed value, not editable
    """
    @property
    def bookmark_origin(self) -> global___BookmarkOrigin:
        """bookmark info. When set, this module is a bookmarked module of this app.
        Info in this field will allow you to find/access original module.
        """
    @property
    def image(self) -> global___Image:
        """Representative image for this module"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        description: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        visibility: global___Visibility | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        user_id: builtins.str = ...,
        app_id: builtins.str = ...,
        module_version: global___ModuleVersion | None = ...,
        is_starred: builtins.bool = ...,
        star_count: builtins.int = ...,
        bookmark_origin: global___BookmarkOrigin | None = ...,
        image: global___Image | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "bookmark_origin",
            b"bookmark_origin",
            "created_at",
            b"created_at",
            "image",
            b"image",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "module_version",
            b"module_version",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "bookmark_origin",
            b"bookmark_origin",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "id",
            b"id",
            "image",
            b"image",
            "is_starred",
            b"is_starred",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "module_version",
            b"module_version",
            "star_count",
            b"star_count",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___Module = Module

@typing_extensions.final
class ModuleVersion(google.protobuf.message.Message):
    """A specific version of an app module that is available for assigning to apps."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ModuleSubNav(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TITLE_FIELD_NUMBER: builtins.int
        QUERY_KEY_FIELD_NUMBER: builtins.int
        QUERY_VALUE_FIELD_NUMBER: builtins.int
        title: builtins.str
        """This is the display title for a navbar element to link to a specific page.
        The name for this subnav element to show in the sidebar.
        """
        query_key: builtins.str
        """The query param name"""
        query_value: builtins.str
        """The query param value"""
        def __init__(
            self,
            *,
            title: builtins.str = ...,
            query_key: builtins.str = ...,
            query_value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "query_key", b"query_key", "query_value", b"query_value", "title", b"title"
            ],
        ) -> None: ...

    @typing_extensions.final
    class ModuleNav(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TITLE_FIELD_NUMBER: builtins.int
        MODULE_SUB_NAVS_FIELD_NUMBER: builtins.int
        title: builtins.str
        """This is the left side title for this module and for browser tab title of the module.
        We have this in the version so that users can change those settings
        when releasing a new version of their module.
        """
        @property
        def module_sub_navs(
            self,
        ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
            global___ModuleVersion.ModuleSubNav
        ]:
            """A list of subnav elements to put under the module title."""
        def __init__(
            self,
            *,
            title: builtins.str = ...,
            module_sub_navs: collections.abc.Iterable[global___ModuleVersion.ModuleSubNav]
            | None = ...,
        ) -> None: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "module_sub_navs", b"module_sub_navs", "title", b"title"
            ],
        ) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    MODULE_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    NOTES_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    GIT_COMMIT_URL_FIELD_NUMBER: builtins.int
    MODULE_NAV_FIELD_NUMBER: builtins.int
    APPROVED_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    id: builtins.str
    """A name for this version like 1_0, 1_1_0, etc."""
    module_id: builtins.str
    """The module this version belongs to."""
    app_id: builtins.str
    """The app_id this module version belongs to."""
    user_id: builtins.str
    """The user_id this module version belongs to."""
    description: builtins.str
    """A short description for this version."""
    notes: builtins.str
    """A markdown formatted string to detailed description of the app module.
    This is within each version so that it can be change version to version.
    """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the app module version was created."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the app module version was last modified."""
    git_commit_url: builtins.str
    """The code repo of the streamlit app.
    If you are still developing your Module you should create a ModuleVersion
    with an empty git_commit_url and then create an InstalledModuleVersion
    with a pre-deployed deploy_url (such as localhost or streamlit cloud).
    Once you are ready to create a production, create a new ModuleVersion with
    the ready git url to a specific commit that you would like to be reviewed by the
    Clarifai team for approval within our community. You cannot publish a ModuleVersion
    is reviewed and approved. Please only provide the git_commit_url when you're
    ready for a review. This url needs to include a specific commit, for example:
    https://github.com/user/repo/commit/767ff9c08ba3429c8e7b8825da148555
    """
    @property
    def module_nav(self) -> global___ModuleVersion.ModuleNav: ...
    approved: builtins.bool
    """A boolean to mark if Clarifai has approved this app version.
    This cannot be set in the request to True.
    """
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        Defaults to PRIVATE if not provided.
        """
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        This is an optional arg.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        module_id: builtins.str = ...,
        app_id: builtins.str = ...,
        user_id: builtins.str = ...,
        description: builtins.str = ...,
        notes: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        git_commit_url: builtins.str = ...,
        module_nav: global___ModuleVersion.ModuleNav | None = ...,
        approved: builtins.bool = ...,
        visibility: global___Visibility | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "module_nav",
            b"module_nav",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "approved",
            b"approved",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "git_commit_url",
            b"git_commit_url",
            "id",
            b"id",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "module_id",
            b"module_id",
            "module_nav",
            b"module_nav",
            "notes",
            b"notes",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___ModuleVersion = ModuleVersion

@typing_extensions.final
class InstalledModuleVersion(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    MODULE_VERSION_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    DEPLOY_URL_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    KEY_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """A unique id for this install. This will be used in the browser url."""
    @property
    def module_version(self) -> global___ModuleVersion:
        """The installed module version provided here so that we users don't need to do an additional
        fetch. When creating a new InstalledModuleVersion you should provide the:
        module_version.user_id
        module_version.app_id
        module_version.module_id
        module_version.id
        in order to uniquely define which module version.
        """
    app_id: builtins.str
    """The app_id the ModuleVersion is installed into (not necessary where the ModuleVersion was
    created). This doesn't have to be provided in requests to install, but will be returned in
    responses.
    """
    user_id: builtins.str
    """The user that the app belongs to where the ModuleVersion is installed into (not necessary where
    the ModuleVersion was created). This doesn't have to be provided in requests to install, but
    will be returned in responses.
    """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the install was created."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the install was last modified."""
    deploy_url: builtins.str
    """The URL of where this app module version is deployed.
    If you provide this deploy_url when creating the install then it will
    be treated as a pre-deployed module. You can only use a pre-deployed module
    in when installing to an app_id that you own as the creator of the module.
    If you want to install someone elses module or to rely on Clarifai deploying
    your module for you, leave deploy_url empty when creating the install.
    If it is left empty, then deployment will occur when this module version is
    installed into an app using the git_commit_url of the ModuleVersion.
    """
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible. For the InstalledModuleVersion this allows the app owner who
        installed the module version to decide if they want other users of their app to have
        the added functionality that the modules version provides to their app.
        Defaults to PRIVATE if not provided.
        """
    key_id: builtins.str
    """The key ID to use for making requests to the API for this module.
    This key is associated to this installed module version by PostInstalledModuleVersionsKey
    request. The key is associated with the CALLER not the App Owner where this module is installed
    nor the author of the module. This allows the module to act on behalf of the caller at all
    times so we get proper permissions the caller has (such as if they are stranger, teammate or
    collaborator). This key should be a personal access token to enable modules to work across apps
    and have necessary abilities beyond what app-specific keys offer.
    """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        module_version: global___ModuleVersion | None = ...,
        app_id: builtins.str = ...,
        user_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        deploy_url: builtins.str = ...,
        visibility: global___Visibility | None = ...,
        key_id: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "modified_at",
            b"modified_at",
            "module_version",
            b"module_version",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "created_at",
            b"created_at",
            "deploy_url",
            b"deploy_url",
            "id",
            b"id",
            "key_id",
            b"key_id",
            "modified_at",
            b"modified_at",
            "module_version",
            b"module_version",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___InstalledModuleVersion = InstalledModuleVersion

@typing_extensions.final
class BulkOperation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    INPUT_IDS_FIELD_NUMBER: builtins.int
    SEARCH_FIELD_NUMBER: builtins.int
    DATASET_FIELD_NUMBER: builtins.int
    ANNOTATION_SEARCH_FIELD_NUMBER: builtins.int
    OPERATION_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    PROGRESS_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LAST_MODIFIED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id of the Bulk Operation task"""
    @property
    def input_ids(self) -> global___InputIDs: ...
    @property
    def search(self) -> global___Search: ...
    @property
    def dataset(self) -> global___Dataset: ...
    @property
    def annotation_search(self) -> global___Search: ...
    @property
    def operation(self) -> global___Operation:
        """Operation to perform"""
    app_id: builtins.str
    """Application ID that this Operation was created from"""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """Status (pending, in-progress, completed, failed) of the operation"""
    @property
    def progress(self) -> global___Progress:
        """Progress of an on-going Bulk Operation task"""
    created_by: builtins.str
    """User id that created this operation"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the operation was created. We follow the XXXX timestamp
        format. We use https://www.ietf.org/rfc/rfc3339.txt format:
        "2006-01-02T15:04:05.999999Z" so you can expect results like
        the following from the API:
        "2017-04-11T21:50:50.223962Z"
        """
    @property
    def last_modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Last time the status got updated"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        input_ids: global___InputIDs | None = ...,
        search: global___Search | None = ...,
        dataset: global___Dataset | None = ...,
        annotation_search: global___Search | None = ...,
        operation: global___Operation | None = ...,
        app_id: builtins.str = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        progress: global___Progress | None = ...,
        created_by: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "annotation_search",
            b"annotation_search",
            "annotation_source",
            b"annotation_source",
            "created_at",
            b"created_at",
            "dataset",
            b"dataset",
            "input_ids",
            b"input_ids",
            "input_source",
            b"input_source",
            "last_modified_at",
            b"last_modified_at",
            "operation",
            b"operation",
            "progress",
            b"progress",
            "search",
            b"search",
            "status",
            b"status",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "annotation_search",
            b"annotation_search",
            "annotation_source",
            b"annotation_source",
            "app_id",
            b"app_id",
            "created_at",
            b"created_at",
            "created_by",
            b"created_by",
            "dataset",
            b"dataset",
            "id",
            b"id",
            "input_ids",
            b"input_ids",
            "input_source",
            b"input_source",
            "last_modified_at",
            b"last_modified_at",
            "operation",
            b"operation",
            "progress",
            b"progress",
            "search",
            b"search",
            "status",
            b"status",
        ],
    ) -> None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["annotation_source", b"annotation_source"]
    ) -> typing_extensions.Literal["annotation_search"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["input_source", b"input_source"]
    ) -> typing_extensions.Literal["input_ids", "search", "dataset"] | None: ...

global___BulkOperation = BulkOperation

@typing_extensions.final
class InputIDs(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUT_IDS_FIELD_NUMBER: builtins.int
    @property
    def input_ids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        input_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["input_ids", b"input_ids"]
    ) -> None: ...

global___InputIDs = InputIDs

@typing_extensions.final
class Progress(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROCESSED_FIELD_NUMBER: builtins.int
    LAST_PROCESSED_ID_FIELD_NUMBER: builtins.int
    processed: builtins.int
    last_processed_id: builtins.str
    def __init__(
        self,
        *,
        processed: builtins.int = ...,
        last_processed_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "last_processed_id", b"last_processed_id", "processed", b"processed"
        ],
    ) -> None: ...

global___Progress = Progress

@typing_extensions.final
class Operation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADD_CONCEPTS_FIELD_NUMBER: builtins.int
    DELETE_CONCEPTS_FIELD_NUMBER: builtins.int
    ADD_METADATA_FIELD_NUMBER: builtins.int
    DELETE_METADATA_FIELD_NUMBER: builtins.int
    OVERWRITE_GEO_FIELD_NUMBER: builtins.int
    DELETE_GEO_FIELD_NUMBER: builtins.int
    DELETE_FROM_DATASET_FIELD_NUMBER: builtins.int
    ADD_TO_DATASET_FIELD_NUMBER: builtins.int
    SPLIT_INTO_DATASETS_FIELD_NUMBER: builtins.int
    DELETE_ANNOTATIONS_FIELD_NUMBER: builtins.int
    @property
    def add_concepts(self) -> global___AddConcepts: ...
    @property
    def delete_concepts(self) -> global___DeleteConcepts: ...
    @property
    def add_metadata(self) -> global___AddMetadata: ...
    @property
    def delete_metadata(self) -> global___DeleteMetadata: ...
    @property
    def overwrite_geo(self) -> global___OverwriteGeo: ...
    @property
    def delete_geo(self) -> global___DeleteGeo: ...
    @property
    def delete_from_dataset(self) -> global___DeleteFromDataset: ...
    @property
    def add_to_dataset(self) -> global___AddToDataset: ...
    @property
    def split_into_datasets(self) -> global___SplitIntoDatasets: ...
    @property
    def delete_annotations(self) -> global___DeleteAnnotations: ...
    def __init__(
        self,
        *,
        add_concepts: global___AddConcepts | None = ...,
        delete_concepts: global___DeleteConcepts | None = ...,
        add_metadata: global___AddMetadata | None = ...,
        delete_metadata: global___DeleteMetadata | None = ...,
        overwrite_geo: global___OverwriteGeo | None = ...,
        delete_geo: global___DeleteGeo | None = ...,
        delete_from_dataset: global___DeleteFromDataset | None = ...,
        add_to_dataset: global___AddToDataset | None = ...,
        split_into_datasets: global___SplitIntoDatasets | None = ...,
        delete_annotations: global___DeleteAnnotations | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "add_concepts",
            b"add_concepts",
            "add_metadata",
            b"add_metadata",
            "add_to_dataset",
            b"add_to_dataset",
            "annotation_operation",
            b"annotation_operation",
            "delete_annotations",
            b"delete_annotations",
            "delete_concepts",
            b"delete_concepts",
            "delete_from_dataset",
            b"delete_from_dataset",
            "delete_geo",
            b"delete_geo",
            "delete_metadata",
            b"delete_metadata",
            "operation",
            b"operation",
            "overwrite_geo",
            b"overwrite_geo",
            "split_into_datasets",
            b"split_into_datasets",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "add_concepts",
            b"add_concepts",
            "add_metadata",
            b"add_metadata",
            "add_to_dataset",
            b"add_to_dataset",
            "annotation_operation",
            b"annotation_operation",
            "delete_annotations",
            b"delete_annotations",
            "delete_concepts",
            b"delete_concepts",
            "delete_from_dataset",
            b"delete_from_dataset",
            "delete_geo",
            b"delete_geo",
            "delete_metadata",
            b"delete_metadata",
            "operation",
            b"operation",
            "overwrite_geo",
            b"overwrite_geo",
            "split_into_datasets",
            b"split_into_datasets",
        ],
    ) -> None: ...
    @typing.overload
    def WhichOneof(
        self,
        oneof_group: typing_extensions.Literal["annotation_operation", b"annotation_operation"],
    ) -> typing_extensions.Literal["delete_annotations"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["operation", b"operation"]
    ) -> (
        typing_extensions.Literal[
            "add_concepts",
            "delete_concepts",
            "add_metadata",
            "delete_metadata",
            "overwrite_geo",
            "delete_geo",
            "delete_from_dataset",
            "add_to_dataset",
            "split_into_datasets",
        ]
        | None
    ): ...

global___Operation = Operation

@typing_extensions.final
class AddConcepts(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONCEPTS_FIELD_NUMBER: builtins.int
    @property
    def concepts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Concept]: ...
    def __init__(
        self,
        *,
        concepts: collections.abc.Iterable[global___Concept] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["concepts", b"concepts"]
    ) -> None: ...

global___AddConcepts = AddConcepts

@typing_extensions.final
class DeleteConcepts(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONCEPTS_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    @property
    def concepts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Concept]: ...
    @property
    def user_ids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        concepts: collections.abc.Iterable[global___Concept] | None = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["concepts", b"concepts", "user_ids", b"user_ids"],
    ) -> None: ...

global___DeleteConcepts = DeleteConcepts

@typing_extensions.final
class AddMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METADATA_FIELD_NUMBER: builtins.int
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    def __init__(
        self,
        *,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["metadata", b"metadata"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["metadata", b"metadata"]
    ) -> None: ...

global___AddMetadata = AddMetadata

@typing_extensions.final
class DeleteMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METADATA_FIELD_NUMBER: builtins.int
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    def __init__(
        self,
        *,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["metadata", b"metadata"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["metadata", b"metadata"]
    ) -> None: ...

global___DeleteMetadata = DeleteMetadata

@typing_extensions.final
class OverwriteGeo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GEO_FIELD_NUMBER: builtins.int
    @property
    def geo(self) -> global___Geo:
        """Geo info"""
    def __init__(
        self,
        *,
        geo: global___Geo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["geo", b"geo"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["geo", b"geo"]) -> None: ...

global___OverwriteGeo = OverwriteGeo

@typing_extensions.final
class DeleteGeo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteGeo = DeleteGeo

@typing_extensions.final
class AddToDataset(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["dataset_id", b"dataset_id"]
    ) -> None: ...

global___AddToDataset = AddToDataset

@typing_extensions.final
class DeleteFromDataset(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_ID_FIELD_NUMBER: builtins.int
    dataset_id: builtins.str
    def __init__(
        self,
        *,
        dataset_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["dataset_id", b"dataset_id"]
    ) -> None: ...

global___DeleteFromDataset = DeleteFromDataset

@typing_extensions.final
class SplitIntoDatasets(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _DatasetSplitMethod:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DatasetSplitMethodEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            SplitIntoDatasets._DatasetSplitMethod.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NOT_SET: SplitIntoDatasets._DatasetSplitMethod.ValueType  # 0
        RANDOM_PERCENTAGE_SPLIT: SplitIntoDatasets._DatasetSplitMethod.ValueType  # 1
        """We will randomly split inputs into the datasets"""

    class DatasetSplitMethod(
        _DatasetSplitMethod, metaclass=_DatasetSplitMethodEnumTypeWrapper
    ): ...
    NOT_SET: SplitIntoDatasets.DatasetSplitMethod.ValueType  # 0
    RANDOM_PERCENTAGE_SPLIT: SplitIntoDatasets.DatasetSplitMethod.ValueType  # 1
    """We will randomly split inputs into the datasets"""

    DATASET_SPLITS_FIELD_NUMBER: builtins.int
    METHOD_FIELD_NUMBER: builtins.int
    @property
    def dataset_splits(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___DatasetSplit
    ]: ...
    method: global___SplitIntoDatasets.DatasetSplitMethod.ValueType
    def __init__(
        self,
        *,
        dataset_splits: collections.abc.Iterable[global___DatasetSplit] | None = ...,
        method: global___SplitIntoDatasets.DatasetSplitMethod.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "dataset_splits", b"dataset_splits", "method", b"method"
        ],
    ) -> None: ...

global___SplitIntoDatasets = SplitIntoDatasets

@typing_extensions.final
class DatasetSplit(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATASET_FIELD_NUMBER: builtins.int
    PERCENTAGE_FIELD_NUMBER: builtins.int
    @property
    def dataset(self) -> global___Dataset:
        """Expected to have ID"""
    percentage: builtins.int
    """For RANDOM_PERCENTAGE_SPLIT.
    Values from (0,100]
    """
    def __init__(
        self,
        *,
        dataset: global___Dataset | None = ...,
        percentage: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "dataset", b"dataset", "method_info", b"method_info", "percentage", b"percentage"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "dataset", b"dataset", "method_info", b"method_info", "percentage", b"percentage"
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["method_info", b"method_info"]
    ) -> typing_extensions.Literal["percentage"] | None: ...

global___DatasetSplit = DatasetSplit

@typing_extensions.final
class DeleteAnnotations(google.protobuf.message.Message):
    """This operation takes no data (payload)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteAnnotations = DeleteAnnotations

@typing_extensions.final
class InputsAddJob(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CALL_BACK_URL_FIELD_NUMBER: builtins.int
    APP_PAT_FIELD_NUMBER: builtins.int
    PROGRESS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    EXTRACTION_JOBS_FIELD_NUMBER: builtins.int
    UPLOADS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id of the job"""
    call_back_url: builtins.str
    """If call back url is set, we will send a Post request to this endpoint with job status."""
    app_pat: builtins.str
    """Personal Access Token to the application to which inputs are added"""
    @property
    def progress(self) -> global___InputsAddJobProgress:
        """Progress of an on-going Input Ingestion task"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the job was created.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Most recent time when the job was updated.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def extraction_jobs(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___InputsExtractionJob
    ]:
        """Sub-jobs that extract inputs from the cloud and/or archives"""
    @property
    def uploads(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Upload]:
        """Archive uploads"""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """Status of the job"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        call_back_url: builtins.str = ...,
        app_pat: builtins.str = ...,
        progress: global___InputsAddJobProgress | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        extraction_jobs: collections.abc.Iterable[global___InputsExtractionJob] | None = ...,
        uploads: collections.abc.Iterable[global___Upload] | None = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "modified_at",
            b"modified_at",
            "progress",
            b"progress",
            "status",
            b"status",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_pat",
            b"app_pat",
            "call_back_url",
            b"call_back_url",
            "created_at",
            b"created_at",
            "extraction_jobs",
            b"extraction_jobs",
            "id",
            b"id",
            "modified_at",
            b"modified_at",
            "progress",
            b"progress",
            "status",
            b"status",
            "uploads",
            b"uploads",
        ],
    ) -> None: ...

global___InputsAddJob = InputsAddJob

@typing_extensions.final
class InputsAddJobProgress(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PENDING_COUNT_FIELD_NUMBER: builtins.int
    IN_PROGRESS_COUNT_FIELD_NUMBER: builtins.int
    SUCCESS_COUNT_FIELD_NUMBER: builtins.int
    FAILED_COUNT_FIELD_NUMBER: builtins.int
    pending_count: builtins.int
    in_progress_count: builtins.int
    success_count: builtins.int
    failed_count: builtins.int
    def __init__(
        self,
        *,
        pending_count: builtins.int = ...,
        in_progress_count: builtins.int = ...,
        success_count: builtins.int = ...,
        failed_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "failed_count",
            b"failed_count",
            "in_progress_count",
            b"in_progress_count",
            "pending_count",
            b"pending_count",
            "success_count",
            b"success_count",
        ],
    ) -> None: ...

global___InputsAddJobProgress = InputsAddJobProgress

@typing_extensions.final
class Upload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CONTENT_NAME_FIELD_NUMBER: builtins.int
    CONTENT_LENGTH_FIELD_NUMBER: builtins.int
    CONTENT_URL_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of upload"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the upload was started.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Most recent time when the upload was updated.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the upload will expire and be deleted
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """Status of the upload"""
    content_name: builtins.str
    """name of uploaded content (e.g. filename)"""
    content_length: builtins.int
    """Total size of the upload content"""
    content_url: builtins.str
    """Url of uploaded content"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        content_name: builtins.str = ...,
        content_length: builtins.int = ...,
        content_url: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "expires_at",
            b"expires_at",
            "modified_at",
            b"modified_at",
            "status",
            b"status",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "content_length",
            b"content_length",
            "content_name",
            b"content_name",
            "content_url",
            b"content_url",
            "created_at",
            b"created_at",
            "expires_at",
            b"expires_at",
            "id",
            b"id",
            "modified_at",
            b"modified_at",
            "status",
            b"status",
        ],
    ) -> None: ...

global___Upload = Upload

@typing_extensions.final
class UploadContentPart(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RANGE_START_FIELD_NUMBER: builtins.int
    PART_NUMBER_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    range_start: builtins.int
    part_number: builtins.int
    data: builtins.bytes
    def __init__(
        self,
        *,
        range_start: builtins.int = ...,
        part_number: builtins.int = ...,
        data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "data", b"data", "part_number", b"part_number", "range_start", b"range_start"
        ],
    ) -> None: ...

global___UploadContentPart = UploadContentPart

@typing_extensions.final
class InputsExtractionJob(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    PROGRESS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    INPUT_ID_CONFLICT_RESOLUTION_FIELD_NUMBER: builtins.int
    INPUT_TEMPLATE_FIELD_NUMBER: builtins.int
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status: ...
    id: builtins.str
    """ID of extraction job"""
    url: builtins.str
    """Url of archive or bucket"""
    @property
    def progress(self) -> global___InputsExtractionJobProgress:
        """Progress counts of the job"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the extraction job was started.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Most recent time when the extraction job was updated.
        The format is https://www.ietf.org/rfc/rfc3339.txt.
        Example: "2006-01-02T15:04:05.999999Z".
        """
    input_id_conflict_resolution: global___InputIDConflictResolution.ValueType
    """How to handle input ID conflicts."""
    @property
    def input_template(self) -> global___Input:
        """Fields set in the template are added to all generated inputs"""
    def __init__(
        self,
        *,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        id: builtins.str = ...,
        url: builtins.str = ...,
        progress: global___InputsExtractionJobProgress | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        input_id_conflict_resolution: global___InputIDConflictResolution.ValueType = ...,
        input_template: global___Input | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "input_template",
            b"input_template",
            "modified_at",
            b"modified_at",
            "progress",
            b"progress",
            "status",
            b"status",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "id",
            b"id",
            "input_id_conflict_resolution",
            b"input_id_conflict_resolution",
            "input_template",
            b"input_template",
            "modified_at",
            b"modified_at",
            "progress",
            b"progress",
            "status",
            b"status",
            "url",
            b"url",
        ],
    ) -> None: ...

global___InputsExtractionJob = InputsExtractionJob

@typing_extensions.final
class InputsExtractionJobProgress(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_INPUTS_COUNT_FIELD_NUMBER: builtins.int
    IMAGE_INPUTS_COUNT_FIELD_NUMBER: builtins.int
    VIDEO_INPUTS_COUNT_FIELD_NUMBER: builtins.int
    TEXT_INPUTS_COUNT_FIELD_NUMBER: builtins.int
    PENDING_ARCHIVES_COUNT_FIELD_NUMBER: builtins.int
    IN_PROGRESS_ARCHIVES_COUNT_FIELD_NUMBER: builtins.int
    COMPLETED_ARCHIVES_COUNT_FIELD_NUMBER: builtins.int
    FAILED_ARCHIVES_COUNT_FIELD_NUMBER: builtins.int
    audio_inputs_count: builtins.int
    image_inputs_count: builtins.int
    video_inputs_count: builtins.int
    text_inputs_count: builtins.int
    pending_archives_count: builtins.int
    in_progress_archives_count: builtins.int
    completed_archives_count: builtins.int
    failed_archives_count: builtins.int
    def __init__(
        self,
        *,
        audio_inputs_count: builtins.int = ...,
        image_inputs_count: builtins.int = ...,
        video_inputs_count: builtins.int = ...,
        text_inputs_count: builtins.int = ...,
        pending_archives_count: builtins.int = ...,
        in_progress_archives_count: builtins.int = ...,
        completed_archives_count: builtins.int = ...,
        failed_archives_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "audio_inputs_count",
            b"audio_inputs_count",
            "completed_archives_count",
            b"completed_archives_count",
            "failed_archives_count",
            b"failed_archives_count",
            "image_inputs_count",
            b"image_inputs_count",
            "in_progress_archives_count",
            b"in_progress_archives_count",
            "pending_archives_count",
            b"pending_archives_count",
            "text_inputs_count",
            b"text_inputs_count",
            "video_inputs_count",
            b"video_inputs_count",
        ],
    ) -> None: ...

global___InputsExtractionJobProgress = InputsExtractionJobProgress

@typing_extensions.final
class InputsDataSource(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUTS_ADD_JOB_ID_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    INPUT_ID_CONFLICT_RESOLUTION_FIELD_NUMBER: builtins.int
    INPUT_TEMPLATE_FIELD_NUMBER: builtins.int
    inputs_add_job_id: builtins.str
    """Collect statistics about created inputs in job with given ID.
    On Post call:
    * If job ID is empty, then job is automatically created with random ID.
    * If job ID is non-empty, then a new job will be created with given ID.
    """
    @property
    def url(self) -> global___DataSourceURL: ...
    input_id_conflict_resolution: global___InputIDConflictResolution.ValueType
    """How to handle input ID conflicts."""
    @property
    def input_template(self) -> global___Input:
        """Fields set in the template will also be added to all generated inputs"""
    def __init__(
        self,
        *,
        inputs_add_job_id: builtins.str = ...,
        url: global___DataSourceURL | None = ...,
        input_id_conflict_resolution: global___InputIDConflictResolution.ValueType = ...,
        input_template: global___Input | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal["input_template", b"input_template", "url", b"url"],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "input_id_conflict_resolution",
            b"input_id_conflict_resolution",
            "input_template",
            b"input_template",
            "inputs_add_job_id",
            b"inputs_add_job_id",
            "url",
            b"url",
        ],
    ) -> None: ...

global___InputsDataSource = InputsDataSource

@typing_extensions.final
class DataSourceURL(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    CREDENTIALS_FIELD_NUMBER: builtins.int
    url: builtins.str
    """Supported providers are AWS S3, Azure blob, GCP cloud storage."""
    @property
    def credentials(self) -> global___DataSourceCredentials:
        """Credentials that would allow access to the provided url"""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
        credentials: global___DataSourceCredentials | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["credentials", b"credentials"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["credentials", b"credentials", "url", b"url"]
    ) -> None: ...

global___DataSourceURL = DataSourceURL

@typing_extensions.final
class DataSourceCredentials(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    S3_CREDS_FIELD_NUMBER: builtins.int
    GCP_CREDS_FIELD_NUMBER: builtins.int
    AZURE_BLOB_CREDS_FIELD_NUMBER: builtins.int
    @property
    def s3_creds(self) -> global___AWSCreds:
        """AWS S3 credentials for authentication."""
    gcp_creds: builtins.bytes
    """GCP Cloud Storage uses service account key data(creds.json) as Byte array for authentication."""
    @property
    def azure_blob_creds(self) -> global___AzureBlobCreds:
        """Azure Blob credentials for authentication."""
    def __init__(
        self,
        *,
        s3_creds: global___AWSCreds | None = ...,
        gcp_creds: builtins.bytes = ...,
        azure_blob_creds: global___AzureBlobCreds | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "azure_blob_creds",
            b"azure_blob_creds",
            "credentials",
            b"credentials",
            "gcp_creds",
            b"gcp_creds",
            "s3_creds",
            b"s3_creds",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "azure_blob_creds",
            b"azure_blob_creds",
            "credentials",
            b"credentials",
            "gcp_creds",
            b"gcp_creds",
            "s3_creds",
            b"s3_creds",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["credentials", b"credentials"]
    ) -> typing_extensions.Literal["s3_creds", "gcp_creds", "azure_blob_creds"] | None: ...

global___DataSourceCredentials = DataSourceCredentials

@typing_extensions.final
class AWSCreds(google.protobuf.message.Message):
    """AWS S3 storage credentials."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REGION_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    SECRET_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    region: builtins.str
    id: builtins.str
    secret: builtins.str
    token: builtins.str
    def __init__(
        self,
        *,
        region: builtins.str = ...,
        id: builtins.str = ...,
        secret: builtins.str = ...,
        token: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "id", b"id", "region", b"region", "secret", b"secret", "token", b"token"
        ],
    ) -> None: ...

global___AWSCreds = AWSCreds

@typing_extensions.final
class AzureBlobCreds(google.protobuf.message.Message):
    """Azure Blob storage credentials."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCOUNT_NAME_FIELD_NUMBER: builtins.int
    ACCOUNT_KEY_FIELD_NUMBER: builtins.int
    account_name: builtins.str
    account_key: builtins.str
    def __init__(
        self,
        *,
        account_name: builtins.str = ...,
        account_key: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "account_key", b"account_key", "account_name", b"account_name"
        ],
    ) -> None: ...

global___AzureBlobCreds = AzureBlobCreds

@typing_extensions.final
class InputsUpload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUTS_ADD_JOB_ID_FIELD_NUMBER: builtins.int
    APP_PAT_FIELD_NUMBER: builtins.int
    UPLOAD_FIELD_NUMBER: builtins.int
    INPUT_ID_CONFLICT_RESOLUTION_FIELD_NUMBER: builtins.int
    INPUT_TEMPLATE_FIELD_NUMBER: builtins.int
    inputs_add_job_id: builtins.str
    """Collect statistics about created inputs in job with given ID.
    * If job ID is empty, then job is automatically created with random ID.
    * If job ID is non-empty, then a new job will be created with given ID.
    """
    app_pat: builtins.str
    """Personal Access Token to the application to which inputs are added
    Deprecated: No need to send app_pat, it will be generated internally if not present
    """
    @property
    def upload(self) -> global___Upload: ...
    input_id_conflict_resolution: global___InputIDConflictResolution.ValueType
    """How to handle input ID conflicts."""
    @property
    def input_template(self) -> global___Input:
        """Fields set in the template will also be added to all generated inputs"""
    def __init__(
        self,
        *,
        inputs_add_job_id: builtins.str = ...,
        app_pat: builtins.str = ...,
        upload: global___Upload | None = ...,
        input_id_conflict_resolution: global___InputIDConflictResolution.ValueType = ...,
        input_template: global___Input | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "input_template", b"input_template", "upload", b"upload"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_pat",
            b"app_pat",
            "input_id_conflict_resolution",
            b"input_id_conflict_resolution",
            "input_template",
            b"input_template",
            "inputs_add_job_id",
            b"inputs_add_job_id",
            "upload",
            b"upload",
        ],
    ) -> None: ...

global___InputsUpload = InputsUpload

@typing_extensions.final
class BookmarkOrigin(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _BookmarkType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _BookmarkTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            BookmarkOrigin._BookmarkType.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        unknown: BookmarkOrigin._BookmarkType.ValueType  # 0
        model: BookmarkOrigin._BookmarkType.ValueType  # 1
        workflow: BookmarkOrigin._BookmarkType.ValueType  # 2
        dataset: BookmarkOrigin._BookmarkType.ValueType  # 3
        module: BookmarkOrigin._BookmarkType.ValueType  # 4

    class BookmarkType(_BookmarkType, metaclass=_BookmarkTypeEnumTypeWrapper): ...
    unknown: BookmarkOrigin.BookmarkType.ValueType  # 0
    model: BookmarkOrigin.BookmarkType.ValueType  # 1
    workflow: BookmarkOrigin.BookmarkType.ValueType  # 2
    dataset: BookmarkOrigin.BookmarkType.ValueType  # 3
    module: BookmarkOrigin.BookmarkType.ValueType  # 4

    ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    RESOURCE_TYPE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """original resource id"""
    app_id: builtins.str
    """original resource app id"""
    user_id: builtins.str
    """original resource user id"""
    resource_type: global___BookmarkOrigin.BookmarkType.ValueType
    """resource type."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        app_id: builtins.str = ...,
        user_id: builtins.str = ...,
        resource_type: global___BookmarkOrigin.BookmarkType.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "id",
            b"id",
            "resource_type",
            b"resource_type",
            "user_id",
            b"user_id",
        ],
    ) -> None: ...

global___BookmarkOrigin = BookmarkOrigin

@typing_extensions.final
class Runner(google.protobuf.message.Message):
    """Moving the runner label matching into it's own object so that it can be used
    next to other resource types that a Runner might match work on.
    message RunnerLabels { // FUTURE
      repeated string labels = 1;
    }

    A worker for compute within a nodepool of instances.
    This asks the API for work
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    WORKER_FIELD_NUMBER: builtins.int
    NODEPOOL_FIELD_NUMBER: builtins.int
    COMPUTE_INFO_FIELD_NUMBER: builtins.int
    NUM_REPLICAS_FIELD_NUMBER: builtins.int
    SPECIAL_HANDLING_FIELD_NUMBER: builtins.int
    id: builtins.str
    """A unique ID for this runner.
    This is a UUID since runners can be automatically orchestrated.
    """
    description: builtins.str
    """short description about the runner."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the runner was created."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the runner was last modified."""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata you can use a struct field:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        This is an optional arg.
        """
    @property
    def labels(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Labels to match in order to find work."""
    @property
    def worker(self) -> global___Worker:
        """Instead of just matching on labels we might want to have more explicit matching of what
        work this runner is looking for.
        The thing that the autoscaling config applies to for this nodepool.
        """
    @property
    def nodepool(self) -> global___Nodepool:
        """Runners are defined within nodepools so this field needs the id and user_id of the nodepool
        to be provided when creating a Runner.
        This nodepool must be accessible to you or an org you are part of.
        """
    @property
    def compute_info(self) -> global___ComputeInfo:
        """//////////////////////////
        Need resources on the runner so we can schedule this Runner into the Nodepool.
        If this runner is being orchestrated for a model then the orchestrator will set this to the
        model resource requirements. If a workflow then it'll compute those requirements and set
        populate this resource field.
        Having this on the underlying object like Model and Workflow allows us to represent the minimum
        requirements on those object, which may be less than what the Runner allocates (as a safety
        margin for the runner to for sure run the resource).
        """
    num_replicas: builtins.int
    """Number of replicas that this runner should have up.
    We keep it separate from ComputeInfo which defines how many resources each replica needs.
    """
    @property
    def special_handling(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___SpecialHandling
    ]:
        """List of special handling instructions for this runner."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        description: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        labels: collections.abc.Iterable[builtins.str] | None = ...,
        worker: global___Worker | None = ...,
        nodepool: global___Nodepool | None = ...,
        compute_info: global___ComputeInfo | None = ...,
        num_replicas: builtins.int = ...,
        special_handling: collections.abc.Iterable[global___SpecialHandling] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "compute_info",
            b"compute_info",
            "created_at",
            b"created_at",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "nodepool",
            b"nodepool",
            "worker",
            b"worker",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "compute_info",
            b"compute_info",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "id",
            b"id",
            "labels",
            b"labels",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "nodepool",
            b"nodepool",
            "num_replicas",
            b"num_replicas",
            "special_handling",
            b"special_handling",
            "worker",
            b"worker",
        ],
    ) -> None: ...

global___Runner = Runner

@typing_extensions.final
class Nodepool(google.protobuf.message.Message):
    """A nodepool is a set of nodes dedicated for a given user's compute needs.
    This compute will typically be consumed by runners and in the future other objects
    like UI modules may be assigned to node pools.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    COMPUTE_CLUSTER_FIELD_NUMBER: builtins.int
    NODE_CAPACITY_TYPE_FIELD_NUMBER: builtins.int
    INSTANCE_TYPES_FIELD_NUMBER: builtins.int
    MIN_INSTANCES_FIELD_NUMBER: builtins.int
    MAX_INSTANCES_FIELD_NUMBER: builtins.int
    ENFORCED_MIN_INSTANCES_FIELD_NUMBER: builtins.int
    ENFORCED_MAX_INSTANCES_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    SPECIAL_HANDLING_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The user defined ID of the nodepool."""
    description: builtins.str
    """Short description about the nodepool."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the nodepool was created."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the nodepool was last modified."""
    @property
    def compute_cluster(self) -> global___ComputeCluster:
        """Which cluster this nodepool is within."""
    @property
    def node_capacity_type(self) -> global___NodeCapacityType: ...
    @property
    def instance_types(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___InstanceType
    ]: ...
    min_instances: builtins.int
    """Minimum number of instances in this nodepool. This allows the nodepool to scale down to this
    amount. This is the user desired minimum.
    """
    max_instances: builtins.int
    """An upper limit on the number of instances in this nodepool. This allows the nodepool to scale
    up to this amount. This is the user desired maximum.
    """
    enforced_min_instances: builtins.int
    """The actual minimum number of instances. Enforced by the user's plan limits."""
    enforced_max_instances: builtins.int
    """The actual maximum number of instances. Enforced by the user's plan limits."""
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    @property
    def special_handling(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___SpecialHandling
    ]:
        """List of special handling instructions for this nodepool."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        description: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        compute_cluster: global___ComputeCluster | None = ...,
        node_capacity_type: global___NodeCapacityType | None = ...,
        instance_types: collections.abc.Iterable[global___InstanceType] | None = ...,
        min_instances: builtins.int = ...,
        max_instances: builtins.int = ...,
        enforced_min_instances: builtins.int = ...,
        enforced_max_instances: builtins.int = ...,
        visibility: global___Visibility | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        special_handling: collections.abc.Iterable[global___SpecialHandling] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "compute_cluster",
            b"compute_cluster",
            "created_at",
            b"created_at",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "node_capacity_type",
            b"node_capacity_type",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "compute_cluster",
            b"compute_cluster",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "enforced_max_instances",
            b"enforced_max_instances",
            "enforced_min_instances",
            b"enforced_min_instances",
            "id",
            b"id",
            "instance_types",
            b"instance_types",
            "max_instances",
            b"max_instances",
            "metadata",
            b"metadata",
            "min_instances",
            b"min_instances",
            "modified_at",
            b"modified_at",
            "node_capacity_type",
            b"node_capacity_type",
            "special_handling",
            b"special_handling",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___Nodepool = Nodepool

@typing_extensions.final
class NodeCapacityType(google.protobuf.message.Message):
    """Type of nodes that are ok for instances in this pool.
    If both spot and on-demand are provided then the runner will be able to run on either
    with a preference for spot until they are not available.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _CapacityType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CapacityTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            NodeCapacityType._CapacityType.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UKNOWN_CAPACITY_TYPE: NodeCapacityType._CapacityType.ValueType  # 0
        ON_DEMAND_TYPE: NodeCapacityType._CapacityType.ValueType  # 1
        SPOT_TYPE: NodeCapacityType._CapacityType.ValueType  # 2

    class CapacityType(_CapacityType, metaclass=_CapacityTypeEnumTypeWrapper): ...
    UKNOWN_CAPACITY_TYPE: NodeCapacityType.CapacityType.ValueType  # 0
    ON_DEMAND_TYPE: NodeCapacityType.CapacityType.ValueType  # 1
    SPOT_TYPE: NodeCapacityType.CapacityType.ValueType  # 2

    CAPACITY_TYPES_FIELD_NUMBER: builtins.int
    @property
    def capacity_types(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___NodeCapacityType.CapacityType.ValueType
    ]: ...
    def __init__(
        self,
        *,
        capacity_types: collections.abc.Iterable[global___NodeCapacityType.CapacityType.ValueType]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["capacity_types", b"capacity_types"]
    ) -> None: ...

global___NodeCapacityType = NodeCapacityType

@typing_extensions.final
class InstanceType(google.protobuf.message.Message):
    """The instance types that will be available in this pool of nodes.
    Clarifai offers multiple different choices that combine cpu cores, memory and accelerator.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    COMPUTE_INFO_FIELD_NUMBER: builtins.int
    PRICE_FIELD_NUMBER: builtins.int
    CLOUD_PROVIDER_FIELD_NUMBER: builtins.int
    REGION_FIELD_NUMBER: builtins.int
    ALLOWED_CAPACITY_TYPES_FIELD_NUMBER: builtins.int
    FEATURE_FLAG_GROUP_FIELD_NUMBER: builtins.int
    SPECIAL_HANDLING_FIELD_NUMBER: builtins.int
    id: builtins.str
    description: builtins.str
    """Short description of instance type."""
    @property
    def compute_info(self) -> global___ComputeInfo: ...
    price: builtins.str
    @property
    def cloud_provider(self) -> global___CloudProvider:
        """The cloud provider where this instance type is available, if any."""
    region: builtins.str
    """The region where this instance type is available, if any."""
    @property
    def allowed_capacity_types(self) -> global___NodeCapacityType:
        """The capacity types allowed for this instance type. If empty - all capacity types are allowed."""
    feature_flag_group: builtins.str
    """The feature flag group associated with this instance type."""
    @property
    def special_handling(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___SpecialHandling
    ]:
        """List of special handling instructions for this instance type."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        description: builtins.str = ...,
        compute_info: global___ComputeInfo | None = ...,
        price: builtins.str = ...,
        cloud_provider: global___CloudProvider | None = ...,
        region: builtins.str = ...,
        allowed_capacity_types: global___NodeCapacityType | None = ...,
        feature_flag_group: builtins.str = ...,
        special_handling: collections.abc.Iterable[global___SpecialHandling] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "allowed_capacity_types",
            b"allowed_capacity_types",
            "cloud_provider",
            b"cloud_provider",
            "compute_info",
            b"compute_info",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "allowed_capacity_types",
            b"allowed_capacity_types",
            "cloud_provider",
            b"cloud_provider",
            "compute_info",
            b"compute_info",
            "description",
            b"description",
            "feature_flag_group",
            b"feature_flag_group",
            "id",
            b"id",
            "price",
            b"price",
            "region",
            b"region",
            "special_handling",
            b"special_handling",
        ],
    ) -> None: ...

global___InstanceType = InstanceType

@typing_extensions.final
class CloudProvider(google.protobuf.message.Message):
    """CloudProvider represents the entity that provides the infrastructure where the Nodepools are deployed.
    This could be a public cloud provider like AWS, GCP, Azure, etc., or a self-hosted infrastructure.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the cloud provider."""
    name: builtins.str
    """Name of the cloud provider."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["id", b"id", "name", b"name"]
    ) -> None: ...

global___CloudProvider = CloudProvider

@typing_extensions.final
class ComputeCluster(google.protobuf.message.Message):
    """We define a cluster here to be used in Nodepools and by the cloud provider.
    There will be one cloud provider per Cluster.
    This allows us to define Clusters that are VPCs within one physical cloud and have that
    managed by one cloud provider which can list all nodepools for that VPC to deploy them and
    orchestrate work within them.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CLOUD_PROVIDER_FIELD_NUMBER: builtins.int
    REGION_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    CLUSTER_TYPE_FIELD_NUMBER: builtins.int
    MANAGED_BY_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    id: builtins.str
    description: builtins.str
    """Short description of cluster region."""
    @property
    def cloud_provider(self) -> global___CloudProvider:
        """The cloud provider where this cluster is hosted.
        Some example cloud provider IDs may be aws, gcp, azure, local, kubernetes, etc.
        """
    region: builtins.str
    """The region. The naming here depends on the cluster choice above and will be validated
    against which clusters+regions that Clarifai currently supports.
    """
    user_id: builtins.str
    """The user/org that this compute cluster belongs to."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the compute cluster was created."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the compute cluster was last modified."""
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    cluster_type: builtins.str
    """We offer different types of compute clusters such as:
    'shared' which only Clarifai can create.
    'dedicated' where you're in control of defining the nodepools within the cluster
    'local-dev' which means you're responsible for starting runners manually which is great for local
    development but not recommended for production use cases.
    """
    managed_by: builtins.str
    """Managed by represents who is responsible for the cluster.
    This is currently either "clarifai" where we fully manage the infrastructure.
    Or, "user" where the user is responsible for the underlying infrastructure.
    """
    @property
    def key(self) -> global___Key:
        """Key to use within the compute cluster for all requests to the API.
        You can post with the key.id filled in to set the key for the compute cluster.
        The responses will intentionaly only return the description of the key for security
        purposes since you may have other people through orgs/teams having access to this compute
        cluster who should not view your key.
        This must be a valid key created before creating the ComputeCluster.
        Deleting this key will not be prevented, which means all resources in this ComputeCluster
        will lose connection to the API, so delete keys at your own risk.
        The user_id who owns the key must match the user_id provided in the ComputeCluster.
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        description: builtins.str = ...,
        cloud_provider: global___CloudProvider | None = ...,
        region: builtins.str = ...,
        user_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        visibility: global___Visibility | None = ...,
        cluster_type: builtins.str = ...,
        managed_by: builtins.str = ...,
        key: global___Key | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "cloud_provider",
            b"cloud_provider",
            "created_at",
            b"created_at",
            "key",
            b"key",
            "modified_at",
            b"modified_at",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cloud_provider",
            b"cloud_provider",
            "cluster_type",
            b"cluster_type",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "id",
            b"id",
            "key",
            b"key",
            "managed_by",
            b"managed_by",
            "modified_at",
            b"modified_at",
            "region",
            b"region",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___ComputeCluster = ComputeCluster

@typing_extensions.final
class ComputeInfo(google.protobuf.message.Message):
    """These are the resource needs of a given API object such as a model.
    This is what they require as a minimum to run and will be used upon scheduling
    as the request and limit for the k8s pod. If we want to separate limits and requests in the
    future we can allow setting a limits ComputeInfo and a requests ComputeInfo.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CPU_LIMIT_FIELD_NUMBER: builtins.int
    CPU_MEMORY_FIELD_NUMBER: builtins.int
    CPU_REQUESTS_FIELD_NUMBER: builtins.int
    CPU_MEMORY_REQUESTS_FIELD_NUMBER: builtins.int
    NUM_ACCELERATORS_FIELD_NUMBER: builtins.int
    ACCELERATOR_MEMORY_FIELD_NUMBER: builtins.int
    ACCELERATOR_TYPE_FIELD_NUMBER: builtins.int
    ACCELERATOR_TOPOLOGY_FIELD_NUMBER: builtins.int
    cpu_limit: builtins.str
    """Amount of CPUs to use as a limit. This follows kubernetes notation like: "1", "100m", "4.5", etc.
    See https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/
    For instances, this is the instance's CPU count.
    For runners, this is the maximum amount of CPU that the runner pod can use.
    """
    cpu_memory: builtins.str
    """Amount of CPU memory to use as a limit. This follows kubernetes notation like:
    1Ki, 1500Mi, 3Gi, 4Ti, etc.
    See https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/
    For instances, this is the instance's CPU memory.
    For runners, this is the maximum amount of CPU memory that the runner pod can use.
    """
    cpu_requests: builtins.str
    """Amount of CPUs to use as a minimum. This follows kubernetes notation like: "1", "100m", "4.5", etc.
    See https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/
    For runners, this is the minimum amount of CPU requested for the runner pod.
    Optional. If unspecified, a small default is used.
    """
    cpu_memory_requests: builtins.str
    """Amount of CPU memory to use as a minimum. This follows kubernetes notation like:
    1Ki, 1500Mi, 3Gi, 4Ti, etc.
    For runners, this is the minimum amount of CPU memory requested for the runner pod.
    Optional. If unspecified, a small default is used.
    """
    num_accelerators: builtins.int
    """Amount of GPU/TPUs to use."""
    accelerator_memory: builtins.str
    """Amount of accelerator/GPU memory to use as a minimum.
    This is defined per accelerator.
    This follows the format used by kubernetes like 1Ki, 2Mi, 3Gi, 4Ti.
    See https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/
    The supported accelerators that the resource can run on. If the resource requires a specific
    accelerator type then it will only be scheduled on nodes that have that type of accelerator.
    If there is no hard requirements beyond the number of accelerators and their memory then this
    field can be left empty.
    This setting will cause an error if num_accelerators == 0
    """
    @property
    def accelerator_type(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Or should it be removed completely and use the nodepool accelerator type itself.
        These are the supported accelerators that the model can run on.
        """
    @property
    def accelerator_topology(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The number of nodes of this type needed to serve this resource.
        Since 0 is not valid, this will default to 1 if 0 is provided.
        uint32 num_nodes = 6; // FUTURE

        For multi-host accelerators (i.e., TPU Slices), this defines the slice topology.
        Corresponds to the tpu.googleapis.com/topology annotation.
        Example: "2x2x1" for a 16-chip slice using v4 TPUs.
        Leave empty for single-host accelerators like GPUs or non-slice TPUs.
        """
    def __init__(
        self,
        *,
        cpu_limit: builtins.str = ...,
        cpu_memory: builtins.str = ...,
        cpu_requests: builtins.str = ...,
        cpu_memory_requests: builtins.str = ...,
        num_accelerators: builtins.int = ...,
        accelerator_memory: builtins.str = ...,
        accelerator_type: collections.abc.Iterable[builtins.str] | None = ...,
        accelerator_topology: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "accelerator_memory",
            b"accelerator_memory",
            "accelerator_topology",
            b"accelerator_topology",
            "accelerator_type",
            b"accelerator_type",
            "cpu_limit",
            b"cpu_limit",
            "cpu_memory",
            b"cpu_memory",
            "cpu_memory_requests",
            b"cpu_memory_requests",
            "cpu_requests",
            b"cpu_requests",
            "num_accelerators",
            b"num_accelerators",
        ],
    ) -> None: ...

global___ComputeInfo = ComputeInfo

@typing_extensions.final
class AutoscaleConfig(google.protobuf.message.Message):
    """It might be better to do this as runner autoscaling so that resources
    of a model are very simply what that model needs at minimum.
    Note that resources for things like modes inside runners are not
    related to how many replicas of those runners are needed to handle traffic.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_REPLICAS_FIELD_NUMBER: builtins.int
    MAX_REPLICAS_FIELD_NUMBER: builtins.int
    TRAFFIC_HISTORY_SECONDS_FIELD_NUMBER: builtins.int
    SCALE_DOWN_DELAY_SECONDS_FIELD_NUMBER: builtins.int
    SCALE_UP_DELAY_SECONDS_FIELD_NUMBER: builtins.int
    DISABLE_PACKING_FIELD_NUMBER: builtins.int
    SCALE_TO_ZERO_DELAY_SECONDS_FIELD_NUMBER: builtins.int
    min_replicas: builtins.int
    """The minimum number of replicas for the runner to have.
    Defaults to 0 which means autoscaling can scale down to zero.
    If you want a replica always up then set to >= 1.
    """
    max_replicas: builtins.int
    """The maximium number of replicas to scale up the runner to."""
    traffic_history_seconds: builtins.int
    """The number of seconds of traffic history to consider when autoscaling."""
    scale_down_delay_seconds: builtins.int
    """The time to wait before scaling down after the last request."""
    scale_up_delay_seconds: builtins.int
    """The time to wait between scaling up replicas without burst traffic."""
    disable_packing: builtins.bool
    """Depending on your plan you may be able to enable packing of resources into a single node
    for more compute and cost efficiency.
    """
    scale_to_zero_delay_seconds: builtins.int
    """The idle time before scaling down to zero"""
    def __init__(
        self,
        *,
        min_replicas: builtins.int = ...,
        max_replicas: builtins.int = ...,
        traffic_history_seconds: builtins.int = ...,
        scale_down_delay_seconds: builtins.int = ...,
        scale_up_delay_seconds: builtins.int = ...,
        disable_packing: builtins.bool = ...,
        scale_to_zero_delay_seconds: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "disable_packing",
            b"disable_packing",
            "max_replicas",
            b"max_replicas",
            "min_replicas",
            b"min_replicas",
            "scale_down_delay_seconds",
            b"scale_down_delay_seconds",
            "scale_to_zero_delay_seconds",
            b"scale_to_zero_delay_seconds",
            "scale_up_delay_seconds",
            b"scale_up_delay_seconds",
            "traffic_history_seconds",
            b"traffic_history_seconds",
        ],
    ) -> None: ...

global___AutoscaleConfig = AutoscaleConfig

@typing_extensions.final
class Deployment(google.protobuf.message.Message):
    """A deployment allows you to configure how runners for a particular type of resource will
    scale up and down. These are unique per user_id, nodepool and model so for differnet nodepools
    you can scale differently.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SchedulingChoice:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SchedulingChoiceEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            Deployment._SchedulingChoice.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN_SCHEDULING_CHOICE: Deployment._SchedulingChoice.ValueType  # 0
        FAIL: Deployment._SchedulingChoice.ValueType  # 1
        """fail if there is any ambiguity."""
        RANDOM: Deployment._SchedulingChoice.ValueType  # 2
        """randomly pick amongst the nodepools/nodes to assign."""
        PRICE: Deployment._SchedulingChoice.ValueType  # 3
        """choose the compute that is cheaper"""
        PERFORMANCE: Deployment._SchedulingChoice.ValueType  # 4
        """schedule to the fastest known iption."""
        NETWORK: Deployment._SchedulingChoice.ValueType  # 5
        """optimize based on network latency."""
        UTILIZATION: Deployment._SchedulingChoice.ValueType  # 6
        """send to the least used nodepool based on it's capacity."""
        PREFER_SPOT: Deployment._SchedulingChoice.ValueType  # 7
        """choose spot instances over on-demand"""
        PREFER_ONDEMAND: Deployment._SchedulingChoice.ValueType  # 8
        """choose on-demand instances over spot."""

    class SchedulingChoice(_SchedulingChoice, metaclass=_SchedulingChoiceEnumTypeWrapper):
        """In some scenarios it may not be obvous how we should schedule a resource to underlying nodes
        within the nodepool(s) above. The SchedulerChoice allows us to specify how to decide which
        nodepool to use when there are multiple nodepools and how to decide which type of node
        within a nodepool if there are multiple types.
        If here are multiple nondepools then a decision on which to use comes into play
        if it is not specified in the prediction request.
        Even with a single nodepool a choice may come up such as when a resource that needs scheduling
        has not specified the accelerator types it supports and the nodepool has multiple types.
        """

    UNKNOWN_SCHEDULING_CHOICE: Deployment.SchedulingChoice.ValueType  # 0
    FAIL: Deployment.SchedulingChoice.ValueType  # 1
    """fail if there is any ambiguity."""
    RANDOM: Deployment.SchedulingChoice.ValueType  # 2
    """randomly pick amongst the nodepools/nodes to assign."""
    PRICE: Deployment.SchedulingChoice.ValueType  # 3
    """choose the compute that is cheaper"""
    PERFORMANCE: Deployment.SchedulingChoice.ValueType  # 4
    """schedule to the fastest known iption."""
    NETWORK: Deployment.SchedulingChoice.ValueType  # 5
    """optimize based on network latency."""
    UTILIZATION: Deployment.SchedulingChoice.ValueType  # 6
    """send to the least used nodepool based on it's capacity."""
    PREFER_SPOT: Deployment.SchedulingChoice.ValueType  # 7
    """choose spot instances over on-demand"""
    PREFER_ONDEMAND: Deployment.SchedulingChoice.ValueType  # 8
    """choose on-demand instances over spot."""

    ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    AUTOSCALE_CONFIG_FIELD_NUMBER: builtins.int
    NODEPOOLS_FIELD_NUMBER: builtins.int
    SCHEDULING_CHOICE_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    WORKER_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    DEPLOY_LATEST_VERSION_FIELD_NUMBER: builtins.int
    SPECIAL_HANDLING_FIELD_NUMBER: builtins.int
    id: builtins.str
    """An id for this configured deployment."""
    user_id: builtins.str
    """The user who owns the deployment. These live in the user/org account."""
    @property
    def autoscale_config(self) -> global___AutoscaleConfig:
        """How to autoscale the object."""
    @property
    def nodepools(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Nodepool]:
        """You can configure different autoscaling per nodepool(s).
        These nodepools have to be also owned by the same user_id/org as this deployment.
        If there is more than one nodepool we use the model's ComputeInfo to match
        with what the nodepool provides to decide which one can handle it combined with the
        NodepoolRank below. Note: even within a single nodepool if it is heterogeneous then
        we need a way to rank scheduling choices when we don't know how to decide (like a model
        supports
        """
    scheduling_choice: global___Deployment.SchedulingChoice.ValueType
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata:
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    description: builtins.str
    """Short description of deployment."""
    @property
    def worker(self) -> global___Worker:
        """The thing that the autoscaling config applies to for this nodepool.
        For a given user_id, nodepool_id, and object ID we can only have one deployment as it defines
        """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the deployment was created."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the deployment was last modified."""
    deploy_latest_version: builtins.bool
    """When to always deploy latest model version"""
    @property
    def special_handling(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___SpecialHandling
    ]:
        """List of special handling instructions for this deployment."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        user_id: builtins.str = ...,
        autoscale_config: global___AutoscaleConfig | None = ...,
        nodepools: collections.abc.Iterable[global___Nodepool] | None = ...,
        scheduling_choice: global___Deployment.SchedulingChoice.ValueType = ...,
        visibility: global___Visibility | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        description: builtins.str = ...,
        worker: global___Worker | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        deploy_latest_version: builtins.bool = ...,
        special_handling: collections.abc.Iterable[global___SpecialHandling] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "autoscale_config",
            b"autoscale_config",
            "created_at",
            b"created_at",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "visibility",
            b"visibility",
            "worker",
            b"worker",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "autoscale_config",
            b"autoscale_config",
            "created_at",
            b"created_at",
            "deploy_latest_version",
            b"deploy_latest_version",
            "description",
            b"description",
            "id",
            b"id",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "nodepools",
            b"nodepools",
            "scheduling_choice",
            b"scheduling_choice",
            "special_handling",
            b"special_handling",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
            "worker",
            b"worker",
        ],
    ) -> None: ...

global___Deployment = Deployment

@typing_extensions.final
class RunnerSelector(google.protobuf.message.Message):
    """////////////////////////////////////////
    Don't need RunnerSelector if we're opening up endpoints for deployments.
    ////////////////////////////////////////
    The RunnerSelector is an optional field we can provide during runtime
    of model/workflow predictions to specify which particular runner we want to process the work.
    This can optionally be used to select a particular nodepool and then within that nodepool
    a particular runner.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODEPOOL_FIELD_NUMBER: builtins.int
    RUNNER_FIELD_NUMBER: builtins.int
    DEPLOYMENT_FIELD_NUMBER: builtins.int
    @property
    def nodepool(self) -> global___Nodepool:
        """A particular nodepool for the resource to be run within. This request the id and user_id of
        the nodepool to be specified. Runners will be scaled according to a deployment for the given
        resource to be run. There should not be more than one deployment in this nodepool for the
        particular resource to run. If no deployments then default autoscaling will be used.
        """
    @property
    def runner(self) -> global___Runner:
        """Optionally a partcular runner within the nodepool."""
    @property
    def deployment(self) -> global___Deployment:
        """Optionally a partcular deployment within the nodepool.
        In future as we support matching runners based on just labels:
        RunnerLabels runner_labels = 3; // FUTURE
        """
    def __init__(
        self,
        *,
        nodepool: global___Nodepool | None = ...,
        runner: global___Runner | None = ...,
        deployment: global___Deployment | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "deployment", b"deployment", "nodepool", b"nodepool", "runner", b"runner"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "deployment", b"deployment", "nodepool", b"nodepool", "runner", b"runner"
        ],
    ) -> None: ...

global___RunnerSelector = RunnerSelector

@typing_extensions.final
class ProcessingInfo(google.protobuf.message.Message):
    """Processing info tells the runner how to process a RunnerItem"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RUNNER_METHOD_TYPE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    PROCESSING_ID_FIELD_NUMBER: builtins.int
    runner_method_type: global___RunnerMethodType.ValueType
    """The type of method witin the runner to call."""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """A status of the processing. We use this for signalling end of a request stream, a runner
        item's processing should be cancelled, etc.
        """
    processing_id: builtins.str
    """Internal field to track processing. Runners will not have access to this."""
    def __init__(
        self,
        *,
        runner_method_type: global___RunnerMethodType.ValueType = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        processing_id: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["status", b"status"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "processing_id",
            b"processing_id",
            "runner_method_type",
            b"runner_method_type",
            "status",
            b"status",
        ],
    ) -> None: ...

global___ProcessingInfo = ProcessingInfo

@typing_extensions.final
class AuditLogTarget(google.protobuf.message.Message):
    """AuditLogTarget is a resource on which an operation recorded in an
    audit log was performed.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    TEAM_FIELD_NUMBER: builtins.int
    APP_FIELD_NUMBER: builtins.int
    MODULE_FIELD_NUMBER: builtins.int
    MODULE_VERSION_FIELD_NUMBER: builtins.int
    WORKFLOW_FIELD_NUMBER: builtins.int
    WORKFLOW_VERSION_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    MODEL_VERSION_FIELD_NUMBER: builtins.int
    COMPUTE_CLUSTER_FIELD_NUMBER: builtins.int
    NODEPOOL_FIELD_NUMBER: builtins.int
    DEPLOYMENT_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___User: ...
    @property
    def role(self) -> global___Role: ...
    @property
    def team(self) -> global___Team: ...
    @property
    def app(self) -> global___App: ...
    @property
    def module(self) -> global___Module: ...
    @property
    def module_version(self) -> global___ModuleVersion: ...
    @property
    def workflow(self) -> global___Workflow: ...
    @property
    def workflow_version(self) -> global___WorkflowVersion: ...
    @property
    def model(self) -> global___Model: ...
    @property
    def model_version(self) -> global___ModelVersion: ...
    @property
    def compute_cluster(self) -> global___ComputeCluster: ...
    @property
    def nodepool(self) -> global___Nodepool: ...
    @property
    def deployment(self) -> global___Deployment: ...
    def __init__(
        self,
        *,
        user: global___User | None = ...,
        role: global___Role | None = ...,
        team: global___Team | None = ...,
        app: global___App | None = ...,
        module: global___Module | None = ...,
        module_version: global___ModuleVersion | None = ...,
        workflow: global___Workflow | None = ...,
        workflow_version: global___WorkflowVersion | None = ...,
        model: global___Model | None = ...,
        model_version: global___ModelVersion | None = ...,
        compute_cluster: global___ComputeCluster | None = ...,
        nodepool: global___Nodepool | None = ...,
        deployment: global___Deployment | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "app",
            b"app",
            "compute_cluster",
            b"compute_cluster",
            "deployment",
            b"deployment",
            "model",
            b"model",
            "model_version",
            b"model_version",
            "module",
            b"module",
            "module_version",
            b"module_version",
            "nodepool",
            b"nodepool",
            "role",
            b"role",
            "target",
            b"target",
            "team",
            b"team",
            "user",
            b"user",
            "workflow",
            b"workflow",
            "workflow_version",
            b"workflow_version",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app",
            b"app",
            "compute_cluster",
            b"compute_cluster",
            "deployment",
            b"deployment",
            "model",
            b"model",
            "model_version",
            b"model_version",
            "module",
            b"module",
            "module_version",
            b"module_version",
            "nodepool",
            b"nodepool",
            "role",
            b"role",
            "target",
            b"target",
            "team",
            b"team",
            "user",
            b"user",
            "workflow",
            b"workflow",
            "workflow_version",
            b"workflow_version",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["target", b"target"]
    ) -> (
        typing_extensions.Literal[
            "user",
            "role",
            "team",
            "app",
            "module",
            "module_version",
            "workflow",
            "workflow_version",
            "model",
            "model_version",
            "compute_cluster",
            "nodepool",
            "deployment",
        ]
        | None
    ): ...

global___AuditLogTarget = AuditLogTarget

@typing_extensions.final
class AuditLogEntry(google.protobuf.message.Message):
    """AuditLogEntry is a single operation recorded in an audit log."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    USER_FIELD_NUMBER: builtins.int
    OPERATION_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    TARGETS_FIELD_NUMBER: builtins.int
    DETAILS_FIELD_NUMBER: builtins.int
    SUCCESS_FIELD_NUMBER: builtins.int
    REQ_ID_FIELD_NUMBER: builtins.int
    SOURCE_IP_FIELD_NUMBER: builtins.int
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time of the operation."""
    @property
    def user(self) -> global___User:
        """User that performed the operation."""
    operation: global___EventType.ValueType
    """Type of operation that was performed."""
    description: builtins.str
    """A human-readable description of the operation."""
    @property
    def targets(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___AuditLogTarget
    ]:
        """Targets of the operation. For example,
        - when creating a new model, the targets would be the application and the model,
        - when adding a team member, the targets would be the team and the member.
        """
    @property
    def details(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Additional human-readable details of the operation. For example,
        when patching a resource, these would list what was changed.
        """
    success: builtins.bool
    """Was the operation successful?"""
    req_id: builtins.str
    """Request that triggered the operation."""
    source_ip: builtins.str
    """IP address where the request originated from."""
    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        user: global___User | None = ...,
        operation: global___EventType.ValueType = ...,
        description: builtins.str = ...,
        targets: collections.abc.Iterable[global___AuditLogTarget] | None = ...,
        details: collections.abc.Iterable[builtins.str] | None = ...,
        success: builtins.bool = ...,
        req_id: builtins.str = ...,
        source_ip: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["timestamp", b"timestamp", "user", b"user"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "description",
            b"description",
            "details",
            b"details",
            "operation",
            b"operation",
            "req_id",
            b"req_id",
            "source_ip",
            b"source_ip",
            "success",
            b"success",
            "targets",
            b"targets",
            "timestamp",
            b"timestamp",
            "user",
            b"user",
        ],
    ) -> None: ...

global___AuditLogEntry = AuditLogEntry

@typing_extensions.final
class AuditLogQuery(google.protobuf.message.Message):
    """AuditLogQuery is a query for audit log entries."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FROM_FIELD_NUMBER: builtins.int
    TIMESTAMP_TO_FIELD_NUMBER: builtins.int
    USER_IDS_FIELD_NUMBER: builtins.int
    OPERATIONS_FIELD_NUMBER: builtins.int
    TARGETS_FIELD_NUMBER: builtins.int
    SUCCESS_FIELD_NUMBER: builtins.int
    SOURCE_IPS_FIELD_NUMBER: builtins.int
    @property
    def timestamp_from(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Query operations within this time range."""
    @property
    def timestamp_to(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def user_ids(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Query operations by these users."""
    @property
    def operations(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___EventType.ValueType
    ]:
        """Query these types of operations."""
    @property
    def targets(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___AuditLogTarget
    ]:
        """Query operations with these targets."""
    @property
    def success(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Query operations by success."""
    @property
    def source_ips(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Query operations by source IP address."""
    def __init__(
        self,
        *,
        timestamp_from: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        timestamp_to: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        user_ids: collections.abc.Iterable[builtins.str] | None = ...,
        operations: collections.abc.Iterable[global___EventType.ValueType] | None = ...,
        targets: collections.abc.Iterable[global___AuditLogTarget] | None = ...,
        success: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        source_ips: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "success",
            b"success",
            "timestamp_from",
            b"timestamp_from",
            "timestamp_to",
            b"timestamp_to",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "operations",
            b"operations",
            "source_ips",
            b"source_ips",
            "success",
            b"success",
            "targets",
            b"targets",
            "timestamp_from",
            b"timestamp_from",
            "timestamp_to",
            b"timestamp_to",
            "user_ids",
            b"user_ids",
        ],
    ) -> None: ...

global___AuditLogQuery = AuditLogQuery

@typing_extensions.final
class WorkflowVersionEvaluationMetric(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _DataType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DataTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            WorkflowVersionEvaluationMetric._DataType.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DATA_TYPE_NOT_SET: WorkflowVersionEvaluationMetric._DataType.ValueType  # 0
        FLOAT: WorkflowVersionEvaluationMetric._DataType.ValueType  # 1

    class DataType(_DataType, metaclass=_DataTypeEnumTypeWrapper):
        """Enum for data types"""

    DATA_TYPE_NOT_SET: WorkflowVersionEvaluationMetric.DataType.ValueType  # 0
    FLOAT: WorkflowVersionEvaluationMetric.DataType.ValueType  # 1

    class _VisualisationType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _VisualisationTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            WorkflowVersionEvaluationMetric._VisualisationType.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VISUALIZATION_TYPE_NOT_SET: (
            WorkflowVersionEvaluationMetric._VisualisationType.ValueType
        )  # 0
        CONFUSION_MATRIX: WorkflowVersionEvaluationMetric._VisualisationType.ValueType  # 1
        PRECISION_RECALL_CURVE: WorkflowVersionEvaluationMetric._VisualisationType.ValueType  # 2
        ROC_AUC_CURVE: WorkflowVersionEvaluationMetric._VisualisationType.ValueType  # 3

    class VisualisationType(_VisualisationType, metaclass=_VisualisationTypeEnumTypeWrapper):
        """Enum for visualization types"""

    VISUALIZATION_TYPE_NOT_SET: WorkflowVersionEvaluationMetric.VisualisationType.ValueType  # 0
    CONFUSION_MATRIX: WorkflowVersionEvaluationMetric.VisualisationType.ValueType  # 1
    PRECISION_RECALL_CURVE: WorkflowVersionEvaluationMetric.VisualisationType.ValueType  # 2
    ROC_AUC_CURVE: WorkflowVersionEvaluationMetric.VisualisationType.ValueType  # 3

    ID_FIELD_NUMBER: builtins.int
    SUMMARY_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    DATA_TYPE_FIELD_NUMBER: builtins.int
    VISUALISATION_TYPE_FIELD_NUMBER: builtins.int
    id: builtins.str
    summary: builtins.str
    description: builtins.str
    data_type: global___WorkflowVersionEvaluationMetric.DataType.ValueType
    """Metric data type - string, float, int"""
    visualisation_type: global___WorkflowVersionEvaluationMetric.VisualisationType.ValueType
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        summary: builtins.str = ...,
        description: builtins.str = ...,
        data_type: global___WorkflowVersionEvaluationMetric.DataType.ValueType = ...,
        visualisation_type: global___WorkflowVersionEvaluationMetric.VisualisationType.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "data_type",
            b"data_type",
            "description",
            b"description",
            "id",
            b"id",
            "summary",
            b"summary",
            "visualisation_type",
            b"visualisation_type",
        ],
    ) -> None: ...

global___WorkflowVersionEvaluationMetric = WorkflowVersionEvaluationMetric

@typing_extensions.final
class WorkflowVersionEvaluationTemplate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _TaskType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TaskTypeEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            WorkflowVersionEvaluationTemplate._TaskType.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TASK_TYPE_NOT_SET: WorkflowVersionEvaluationTemplate._TaskType.ValueType  # 0
        TEXT_CLASSIFICATION: WorkflowVersionEvaluationTemplate._TaskType.ValueType  # 1

    class TaskType(_TaskType, metaclass=_TaskTypeEnumTypeWrapper): ...
    TASK_TYPE_NOT_SET: WorkflowVersionEvaluationTemplate.TaskType.ValueType  # 0
    TEXT_CLASSIFICATION: WorkflowVersionEvaluationTemplate.TaskType.ValueType  # 1

    ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    TASK_TYPES_FIELD_NUMBER: builtins.int
    WORKFLOW_VERSION_EVALUATION_METRICS_FIELD_NUMBER: builtins.int
    id: builtins.str
    description: builtins.str
    @property
    def task_types(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___WorkflowVersionEvaluationTemplate.TaskType.ValueType
    ]:
        """Applicable for the task types like TextClassification, TextGeneration, etc"""
    @property
    def workflow_version_evaluation_metrics(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___WorkflowVersionEvaluationMetric
    ]:
        """The Workflow Evaluation template metrics"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        description: builtins.str = ...,
        task_types: collections.abc.Iterable[
            global___WorkflowVersionEvaluationTemplate.TaskType.ValueType
        ]
        | None = ...,
        workflow_version_evaluation_metrics: collections.abc.Iterable[
            global___WorkflowVersionEvaluationMetric
        ]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "description",
            b"description",
            "id",
            b"id",
            "task_types",
            b"task_types",
            "workflow_version_evaluation_metrics",
            b"workflow_version_evaluation_metrics",
        ],
    ) -> None: ...

global___WorkflowVersionEvaluationTemplate = WorkflowVersionEvaluationTemplate

@typing_extensions.final
class ComputePlaneMetrics(google.protobuf.message.Message):
    """ComputePlaneMetrics captures the compute plane metrics to send back to the control plane.
    Each message should have the meta filled and one or more of the other fields.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    META_FIELD_NUMBER: builtins.int
    CLOUD_FIELD_NUMBER: builtins.int
    REGION_FIELD_NUMBER: builtins.int
    INSTANCE_TYPE_FIELD_NUMBER: builtins.int
    RESERVATION_TYPE_FIELD_NUMBER: builtins.int
    RESERVATION_PRICE_FIELD_NUMBER: builtins.int
    RUNTIME_S_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    EVENT_TYPE_FIELD_NUMBER: builtins.int
    GPU_METRICS_FIELD_NUMBER: builtins.int
    HOSTNAME_FIELD_NUMBER: builtins.int
    CPU_METRICS_FIELD_NUMBER: builtins.int
    @property
    def meta(self) -> global___ComputeSourceMetadata:
        """Who and where the metrics are from.
        required.
        """
    cloud: builtins.str
    """e.g. aws, azure, on-prem."""
    region: builtins.str
    """e.g. us-east, us-west."""
    instance_type: builtins.str
    """e.g. t3a.medium, g5.xlarge."""
    reservation_type: builtins.str
    """e.g. spot, on-demand."""
    reservation_price: builtins.float
    """Metrics billing
    cost of the reservation. Spot prices may change over time.
    """
    runtime_s: builtins.int
    """Runtime in seconds."""
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Metrics for latency.
        Time of the event.
        """
    event_type: builtins.str
    """e.g. NodeProvisioned, NodeTerminated, ModelDeployed, ModelScheduled, ModelReady."""
    @property
    def gpu_metrics(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GpuMetrics]:
        """GPU metrics."""
    hostname: builtins.str
    """Hostname of the node."""
    @property
    def cpu_metrics(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CpuMetrics]:
        """CPU metrics."""
    def __init__(
        self,
        *,
        meta: global___ComputeSourceMetadata | None = ...,
        cloud: builtins.str = ...,
        region: builtins.str = ...,
        instance_type: builtins.str = ...,
        reservation_type: builtins.str = ...,
        reservation_price: builtins.float = ...,
        runtime_s: builtins.int = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        event_type: builtins.str = ...,
        gpu_metrics: collections.abc.Iterable[global___GpuMetrics] | None = ...,
        hostname: builtins.str = ...,
        cpu_metrics: collections.abc.Iterable[global___CpuMetrics] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["meta", b"meta", "timestamp", b"timestamp"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cloud",
            b"cloud",
            "cpu_metrics",
            b"cpu_metrics",
            "event_type",
            b"event_type",
            "gpu_metrics",
            b"gpu_metrics",
            "hostname",
            b"hostname",
            "instance_type",
            b"instance_type",
            "meta",
            b"meta",
            "region",
            b"region",
            "reservation_price",
            b"reservation_price",
            "reservation_type",
            b"reservation_type",
            "runtime_s",
            b"runtime_s",
            "timestamp",
            b"timestamp",
        ],
    ) -> None: ...

global___ComputePlaneMetrics = ComputePlaneMetrics

@typing_extensions.final
class GpuMetrics(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UUID_FIELD_NUMBER: builtins.int
    MODEL_NAME_FIELD_NUMBER: builtins.int
    UTILIZATION_PCT_FIELD_NUMBER: builtins.int
    TENSOR_UTILIZATION_PCT_FIELD_NUMBER: builtins.int
    MEMORY_UTILIZATION_PCT_FIELD_NUMBER: builtins.int
    uuid: builtins.str
    """GPU UUID."""
    model_name: builtins.str
    """GPU model name. e.g. NVIDIA_A10G"""
    utilization_pct: builtins.float
    """GPU utilization. e.g. DCGM_FI_DEV_GPU_UTIL"""
    tensor_utilization_pct: builtins.float
    """Tensor utilization. e.g. DCGM_FI_PROF_PIPE_TENSOR_ACTIVE"""
    memory_utilization_pct: builtins.float
    """Memory utilization. e.g. DCGM_FI_PROF_DRAM_ACTIVE"""
    def __init__(
        self,
        *,
        uuid: builtins.str = ...,
        model_name: builtins.str = ...,
        utilization_pct: builtins.float = ...,
        tensor_utilization_pct: builtins.float = ...,
        memory_utilization_pct: builtins.float = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "memory_utilization_pct",
            b"memory_utilization_pct",
            "model_name",
            b"model_name",
            "tensor_utilization_pct",
            b"tensor_utilization_pct",
            "utilization_pct",
            b"utilization_pct",
            "uuid",
            b"uuid",
        ],
    ) -> None: ...

global___GpuMetrics = GpuMetrics

@typing_extensions.final
class CpuMetrics(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    CPU_UTILIZATION_PCT_FIELD_NUMBER: builtins.int
    MEMORY_UTILIZATION_PCT_FIELD_NUMBER: builtins.int
    MILLICORES_FIELD_NUMBER: builtins.int
    MEMORY_BYTES_FIELD_NUMBER: builtins.int
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time of the event."""
    cpu_utilization_pct: builtins.float
    """CPU utilization."""
    memory_utilization_pct: builtins.float
    """Memory utilization."""
    millicores: builtins.int
    """CPU millicores."""
    memory_bytes: builtins.int
    """Memory bytes."""
    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        cpu_utilization_pct: builtins.float = ...,
        memory_utilization_pct: builtins.float = ...,
        millicores: builtins.int = ...,
        memory_bytes: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["timestamp", b"timestamp"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "cpu_utilization_pct",
            b"cpu_utilization_pct",
            "memory_bytes",
            b"memory_bytes",
            "memory_utilization_pct",
            b"memory_utilization_pct",
            "millicores",
            b"millicores",
            "timestamp",
            b"timestamp",
        ],
    ) -> None: ...

global___CpuMetrics = CpuMetrics

@typing_extensions.final
class LogEntry(google.protobuf.message.Message):
    """LogEntry is a single technical log entry (e.g. service log, stack traces, etc)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_FIELD_NUMBER: builtins.int
    LOG_TYPE_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    META_FIELD_NUMBER: builtins.int
    message: builtins.str
    """Text of the log entry."""
    log_type: builtins.str
    """The type of log entry. Examples: model, agent, build, training."""
    url: builtins.str
    """URL to log file or stream."""
    @property
    def meta(self) -> global___ComputeSourceMetadata:
        """Who and where the metrics are from."""
    def __init__(
        self,
        *,
        message: builtins.str = ...,
        log_type: builtins.str = ...,
        url: builtins.str = ...,
        meta: global___ComputeSourceMetadata | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["meta", b"meta"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "log_type", b"log_type", "message", b"message", "meta", b"meta", "url", b"url"
        ],
    ) -> None: ...

global___LogEntry = LogEntry

@typing_extensions.final
class ComputeSourceMetadata(google.protobuf.message.Message):
    """ComputeSourceMetadata describes the source of something computed. The who and where."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_APP_ID_FIELD_NUMBER: builtins.int
    MODEL_ID_FIELD_NUMBER: builtins.int
    MODEL_VERSION_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    COMPUTE_CLUSTER_USER_ID_FIELD_NUMBER: builtins.int
    COMPUTE_CLUSTER_ID_FIELD_NUMBER: builtins.int
    NODEPOOL_ID_FIELD_NUMBER: builtins.int
    RUNNER_ID_FIELD_NUMBER: builtins.int
    PIPELINE_ID_FIELD_NUMBER: builtins.int
    PIPELINE_VERSION_ID_FIELD_NUMBER: builtins.int
    PIPELINE_VERSION_RUN_ID_FIELD_NUMBER: builtins.int
    PIPELINE_STEP_ID_FIELD_NUMBER: builtins.int
    PIPELINE_STEP_VERSION_ID_FIELD_NUMBER: builtins.int
    @property
    def user_app_id(self) -> global___UserAppIDSet:
        """The user app id, if any."""
    model_id: builtins.str
    """The Model ID, if any."""
    model_version_id: builtins.str
    """The Version ID, if any."""
    workflow_id: builtins.str
    """Workflow Id, if any."""
    compute_cluster_user_id: builtins.str
    """Compute Cluster, Nodepool, Runner."""
    compute_cluster_id: builtins.str
    nodepool_id: builtins.str
    runner_id: builtins.str
    pipeline_id: builtins.str
    """Pipeline related data, if any"""
    pipeline_version_id: builtins.str
    pipeline_version_run_id: builtins.str
    pipeline_step_id: builtins.str
    """Pipeline step related data for pipeline step builds."""
    pipeline_step_version_id: builtins.str
    def __init__(
        self,
        *,
        user_app_id: global___UserAppIDSet | None = ...,
        model_id: builtins.str = ...,
        model_version_id: builtins.str = ...,
        workflow_id: builtins.str = ...,
        compute_cluster_user_id: builtins.str = ...,
        compute_cluster_id: builtins.str = ...,
        nodepool_id: builtins.str = ...,
        runner_id: builtins.str = ...,
        pipeline_id: builtins.str = ...,
        pipeline_version_id: builtins.str = ...,
        pipeline_version_run_id: builtins.str = ...,
        pipeline_step_id: builtins.str = ...,
        pipeline_step_version_id: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["user_app_id", b"user_app_id"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "compute_cluster_id",
            b"compute_cluster_id",
            "compute_cluster_user_id",
            b"compute_cluster_user_id",
            "model_id",
            b"model_id",
            "model_version_id",
            b"model_version_id",
            "nodepool_id",
            b"nodepool_id",
            "pipeline_id",
            b"pipeline_id",
            "pipeline_step_id",
            b"pipeline_step_id",
            "pipeline_step_version_id",
            b"pipeline_step_version_id",
            "pipeline_version_id",
            b"pipeline_version_id",
            "pipeline_version_run_id",
            b"pipeline_version_run_id",
            "runner_id",
            b"runner_id",
            "user_app_id",
            b"user_app_id",
            "workflow_id",
            b"workflow_id",
        ],
    ) -> None: ...

global___ComputeSourceMetadata = ComputeSourceMetadata

@typing_extensions.final
class WorkflowVersionEvaluation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    WORKFLOW_VERSION_FIELD_NUMBER: builtins.int
    TARGET_NODE_ID_FIELD_NUMBER: builtins.int
    GROUND_TRUTH_DATASET_VERSION_FIELD_NUMBER: builtins.int
    PREDICTIONS_DATASET_VERSION_FIELD_NUMBER: builtins.int
    WORKFLOW_VERSION_EVALUATION_TEMPLATE_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_EVALUATION_RESULT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Customer-Facing / External ID of the workflow version evaluation."""
    @property
    def workflow_version(self) -> global___WorkflowVersion:
        """Workflow version that is being evaluated."""
    target_node_id: builtins.str
    """The target node id that is being evaluated."""
    @property
    def ground_truth_dataset_version(self) -> global___DatasetVersion:
        """The dataset version that contains the ground-truth and is used for evaluation."""
    @property
    def predictions_dataset_version(self) -> global___DatasetVersion:
        """The dataset version that contains the predictions and is used for evaluation."""
    @property
    def workflow_version_evaluation_template(self) -> global___WorkflowVersionEvaluationTemplate:
        """Evaluation template that is used for evaluation."""
    user_id: builtins.str
    """The user the workflow version evaluation belongs to."""
    app_id: builtins.str
    """The app the workflow version evaluation belongs to."""
    @property
    def workflow_evaluation_result(self) -> global___WorkflowEvaluationResult:
        """Results of the evaluation."""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """Status of the evaluation"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the workflow version evaluation was created."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the workflow version evaluation was modified."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        workflow_version: global___WorkflowVersion | None = ...,
        target_node_id: builtins.str = ...,
        ground_truth_dataset_version: global___DatasetVersion | None = ...,
        predictions_dataset_version: global___DatasetVersion | None = ...,
        workflow_version_evaluation_template: global___WorkflowVersionEvaluationTemplate
        | None = ...,
        user_id: builtins.str = ...,
        app_id: builtins.str = ...,
        workflow_evaluation_result: global___WorkflowEvaluationResult | None = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "ground_truth_dataset_version",
            b"ground_truth_dataset_version",
            "modified_at",
            b"modified_at",
            "predictions_dataset_version",
            b"predictions_dataset_version",
            "status",
            b"status",
            "workflow_evaluation_result",
            b"workflow_evaluation_result",
            "workflow_version",
            b"workflow_version",
            "workflow_version_evaluation_template",
            b"workflow_version_evaluation_template",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "created_at",
            b"created_at",
            "ground_truth_dataset_version",
            b"ground_truth_dataset_version",
            "id",
            b"id",
            "modified_at",
            b"modified_at",
            "predictions_dataset_version",
            b"predictions_dataset_version",
            "status",
            b"status",
            "target_node_id",
            b"target_node_id",
            "user_id",
            b"user_id",
            "workflow_evaluation_result",
            b"workflow_evaluation_result",
            "workflow_version",
            b"workflow_version",
            "workflow_version_evaluation_template",
            b"workflow_version_evaluation_template",
        ],
    ) -> None: ...

global___WorkflowVersionEvaluation = WorkflowVersionEvaluation

@typing_extensions.final
class WorkflowEvaluationResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUMMARY_FIELD_NUMBER: builtins.int
    @property
    def summary(self) -> global___WorkflowEvaluationResultSummary:
        """The summary of the evaluation result."""
    def __init__(
        self,
        *,
        summary: global___WorkflowEvaluationResultSummary | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["summary", b"summary"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["summary", b"summary"]) -> None: ...

global___WorkflowEvaluationResult = WorkflowEvaluationResult

@typing_extensions.final
class WorkflowEvaluationResultSummary(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EVALUATION_METRIC_VALUES_FIELD_NUMBER: builtins.int
    @property
    def evaluation_metric_values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___EvaluationMetricValue
    ]:
        """The evaluation metrics."""
    def __init__(
        self,
        *,
        evaluation_metric_values: collections.abc.Iterable[global___EvaluationMetricValue]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "evaluation_metric_values", b"evaluation_metric_values"
        ],
    ) -> None: ...

global___WorkflowEvaluationResultSummary = WorkflowEvaluationResultSummary

@typing_extensions.final
class EvaluationMetricValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class PerConceptValuesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___MetricValue: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___MetricValue | None = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    EVALUATION_METRIC_ID_FIELD_NUMBER: builtins.int
    METRIC_VALUE_FIELD_NUMBER: builtins.int
    EXPLANATION_FIELD_NUMBER: builtins.int
    PER_CONCEPT_VALUES_FIELD_NUMBER: builtins.int
    evaluation_metric_id: builtins.str
    """The metric values"""
    @property
    def metric_value(self) -> global___MetricValue:
        """Aggregated metric value"""
    explanation: builtins.str
    """explanation for the value"""
    @property
    def per_concept_values(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___MetricValue]:
        """Metric values for each concept"""
    def __init__(
        self,
        *,
        evaluation_metric_id: builtins.str = ...,
        metric_value: global___MetricValue | None = ...,
        explanation: builtins.str = ...,
        per_concept_values: collections.abc.Mapping[builtins.str, global___MetricValue]
        | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["metric_value", b"metric_value"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "evaluation_metric_id",
            b"evaluation_metric_id",
            "explanation",
            b"explanation",
            "metric_value",
            b"metric_value",
            "per_concept_values",
            b"per_concept_values",
        ],
    ) -> None: ...

global___EvaluationMetricValue = EvaluationMetricValue

@typing_extensions.final
class InputEvaluationMetricValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class PerRegionValuesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___MetricValue: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___MetricValue | None = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["value", b"value"]
        ) -> builtins.bool: ...
        def ClearField(
            self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
        ) -> None: ...

    EVALUATION_METRIC_ID_FIELD_NUMBER: builtins.int
    METRIC_VALUE_FIELD_NUMBER: builtins.int
    EXPLANATION_FIELD_NUMBER: builtins.int
    PER_REGION_VALUES_FIELD_NUMBER: builtins.int
    evaluation_metric_id: builtins.str
    """The metric values"""
    @property
    def metric_value(self) -> global___MetricValue:
        """Aggregated metric value"""
    explanation: builtins.str
    """explanation for the value"""
    @property
    def per_region_values(
        self,
    ) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___MetricValue]:
        """Metric values for each region"""
    def __init__(
        self,
        *,
        evaluation_metric_id: builtins.str = ...,
        metric_value: global___MetricValue | None = ...,
        explanation: builtins.str = ...,
        per_region_values: collections.abc.Mapping[builtins.str, global___MetricValue]
        | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["metric_value", b"metric_value"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "evaluation_metric_id",
            b"evaluation_metric_id",
            "explanation",
            b"explanation",
            "metric_value",
            b"metric_value",
            "per_region_values",
            b"per_region_values",
        ],
    ) -> None: ...

global___InputEvaluationMetricValue = InputEvaluationMetricValue

@typing_extensions.final
class MetricValue(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STRING_VALUE_FIELD_NUMBER: builtins.int
    FLOAT_VALUE_FIELD_NUMBER: builtins.int
    INT_VALUE_FIELD_NUMBER: builtins.int
    string_value: builtins.str
    float_value: builtins.float
    int_value: builtins.int
    def __init__(
        self,
        *,
        string_value: builtins.str = ...,
        float_value: builtins.float = ...,
        int_value: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "float_value",
            b"float_value",
            "int_value",
            b"int_value",
            "metric_value",
            b"metric_value",
            "string_value",
            b"string_value",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "float_value",
            b"float_value",
            "int_value",
            b"int_value",
            "metric_value",
            b"metric_value",
            "string_value",
            b"string_value",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["metric_value", b"metric_value"]
    ) -> typing_extensions.Literal["string_value", "float_value", "int_value"] | None: ...

global___MetricValue = MetricValue

@typing_extensions.final
class WorkflowEvaluationInputResult(google.protobuf.message.Message):
    """The evaluation result at the input/sample level"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUT_EVALUATION_METRIC_VALUES_FIELD_NUMBER: builtins.int
    @property
    def input_evaluation_metric_values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___InputEvaluationMetricValue
    ]: ...
    def __init__(
        self,
        *,
        input_evaluation_metric_values: collections.abc.Iterable[
            global___InputEvaluationMetricValue
        ]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "input_evaluation_metric_values", b"input_evaluation_metric_values"
        ],
    ) -> None: ...

global___WorkflowEvaluationInputResult = WorkflowEvaluationInputResult

@typing_extensions.final
class WorkflowVersionEvaluationData(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    GROUND_TRUTHS_FIELD_NUMBER: builtins.int
    PREDICTIONS_FIELD_NUMBER: builtins.int
    WORKFLOW_EVALUATION_SAMPLE_RESULT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """the data example id"""
    @property
    def input(self) -> global___Input: ...
    @property
    def ground_truths(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Data]: ...
    @property
    def predictions(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Data]: ...
    @property
    def workflow_evaluation_sample_result(self) -> global___WorkflowEvaluationInputResult: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        input: global___Input | None = ...,
        ground_truths: collections.abc.Iterable[global___Data] | None = ...,
        predictions: collections.abc.Iterable[global___Data] | None = ...,
        workflow_evaluation_sample_result: global___WorkflowEvaluationInputResult | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "input",
            b"input",
            "workflow_evaluation_sample_result",
            b"workflow_evaluation_sample_result",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "ground_truths",
            b"ground_truths",
            "id",
            b"id",
            "input",
            b"input",
            "predictions",
            b"predictions",
            "workflow_evaluation_sample_result",
            b"workflow_evaluation_sample_result",
        ],
    ) -> None: ...

global___WorkflowVersionEvaluationData = WorkflowVersionEvaluationData

@typing_extensions.final
class ArgoOrchestrationSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_VERSION_FIELD_NUMBER: builtins.int
    SPEC_JSON_FIELD_NUMBER: builtins.int
    api_version: builtins.str
    """The API version of the orchestration specification.
    Example: "argoproj.io/v1alpha1", "argoproj.io/v1beta1"
    """
    spec_json: builtins.str
    """The JSON representation of the Argo orchestration specification."""
    def __init__(
        self,
        *,
        api_version: builtins.str = ...,
        spec_json: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "api_version", b"api_version", "spec_json", b"spec_json"
        ],
    ) -> None: ...

global___ArgoOrchestrationSpec = ArgoOrchestrationSpec

@typing_extensions.final
class OrchestrationSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARGO_ORCHESTRATION_SPEC_FIELD_NUMBER: builtins.int
    @property
    def argo_orchestration_spec(self) -> global___ArgoOrchestrationSpec:
        """Argo orchestration specification"""
    def __init__(
        self,
        *,
        argo_orchestration_spec: global___ArgoOrchestrationSpec | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "argo_orchestration_spec",
            b"argo_orchestration_spec",
            "orchestration",
            b"orchestration",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "argo_orchestration_spec",
            b"argo_orchestration_spec",
            "orchestration",
            b"orchestration",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["orchestration", b"orchestration"]
    ) -> typing_extensions.Literal["argo_orchestration_spec"] | None: ...

global___OrchestrationSpec = OrchestrationSpec

@typing_extensions.final
class PipelineStepInputParam(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DEFAULT_VALUE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ACCEPTED_VALUES_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the input parameter."""
    default_value: builtins.str
    """The default value of the input parameter."""
    description: builtins.str
    """The description of the input parameter."""
    @property
    def accepted_values(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The accepted values for the input parameter."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        default_value: builtins.str = ...,
        description: builtins.str = ...,
        accepted_values: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "accepted_values",
            b"accepted_values",
            "default_value",
            b"default_value",
            "description",
            b"description",
            "name",
            b"name",
        ],
    ) -> None: ...

global___PipelineStepInputParam = PipelineStepInputParam

@typing_extensions.final
class PipelineStep(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PIPELINE_STEP_VERSION_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID of the pipeline step."""
    user_id: builtins.str
    """The user the pipeline step belongs to"""
    description: builtins.str
    """Description of the pipeline step"""
    @property
    def pipeline_step_version(self) -> global___PipelineStepVersion:
        """Latest Pipeline Step Version"""
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the pipeline step was created"""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the pipeline step was last modified"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        user_id: builtins.str = ...,
        description: builtins.str = ...,
        pipeline_step_version: global___PipelineStepVersion | None = ...,
        visibility: global___Visibility | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "modified_at",
            b"modified_at",
            "pipeline_step_version",
            b"pipeline_step_version",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "description",
            b"description",
            "id",
            b"id",
            "modified_at",
            b"modified_at",
            "pipeline_step_version",
            b"pipeline_step_version",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___PipelineStep = PipelineStep

@typing_extensions.final
class OrchestrationStepSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARGO_ORCHESTRATION_STEP_SPEC_FIELD_NUMBER: builtins.int
    @property
    def argo_orchestration_step_spec(self) -> global___ArgoOrchestrationStepSpec:
        """Argo orchestration step template"""
    def __init__(
        self,
        *,
        argo_orchestration_step_spec: global___ArgoOrchestrationStepSpec | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "argo_orchestration_step_spec",
            b"argo_orchestration_step_spec",
            "orchestration",
            b"orchestration",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "argo_orchestration_step_spec",
            b"argo_orchestration_step_spec",
            "orchestration",
            b"orchestration",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["orchestration", b"orchestration"]
    ) -> typing_extensions.Literal["argo_orchestration_step_spec"] | None: ...

global___OrchestrationStepSpec = OrchestrationStepSpec

@typing_extensions.final
class ArgoOrchestrationStepSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    API_VERSION_FIELD_NUMBER: builtins.int
    SPEC_JSON_FIELD_NUMBER: builtins.int
    api_version: builtins.str
    """The API version of the orchestration W.
    Example: "argoproj.io/v1alpha1", "argoproj.io/v1beta1"
    """
    spec_json: builtins.str
    """The JSON representation of the Argo Workflow Template"""
    def __init__(
        self,
        *,
        api_version: builtins.str = ...,
        spec_json: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "api_version", b"api_version", "spec_json", b"spec_json"
        ],
    ) -> None: ...

global___ArgoOrchestrationStepSpec = ArgoOrchestrationStepSpec

@typing_extensions.final
class PipelineStepVersion(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PIPELINE_STEP_FIELD_NUMBER: builtins.int
    ORCHESTRATION_STEP_SPEC_FIELD_NUMBER: builtins.int
    PIPELINE_STEP_INPUT_PARAMS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    PIPELINE_STEP_COMPUTE_INFO_FIELD_NUMBER: builtins.int
    BUILD_INFO_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The ID of the pipeline step version."""
    user_id: builtins.str
    """The user the pipeline step version belongs to"""
    app_id: builtins.str
    """The app the pipeline step version belongs to"""
    description: builtins.str
    """Description of the pipeline step version"""
    @property
    def pipeline_step(self) -> global___PipelineStep:
        """Pipeline Step"""
    @property
    def orchestration_step_spec(self) -> global___OrchestrationStepSpec:
        """Orchestration Step Specification using oneof"""
    @property
    def pipeline_step_input_params(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___PipelineStepInputParam
    ]:
        """The pipeline step version input parameters"""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """Pipeline step Status - Created, Building Artifacts, Completed, Failed"""
    @property
    def pipeline_step_compute_info(self) -> global___ComputeInfo:
        """The minimum required compute resource to run the pipeline step as part of a Pipeline"""
    @property
    def build_info(self) -> global___BuildInfo:
        """Build information for the pipeline step"""
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the pipeline step was created"""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the pipeline step was last modified"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        user_id: builtins.str = ...,
        app_id: builtins.str = ...,
        description: builtins.str = ...,
        pipeline_step: global___PipelineStep | None = ...,
        orchestration_step_spec: global___OrchestrationStepSpec | None = ...,
        pipeline_step_input_params: collections.abc.Iterable[global___PipelineStepInputParam]
        | None = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
        pipeline_step_compute_info: global___ComputeInfo | None = ...,
        build_info: global___BuildInfo | None = ...,
        visibility: global___Visibility | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "build_info",
            b"build_info",
            "created_at",
            b"created_at",
            "modified_at",
            b"modified_at",
            "orchestration_step_spec",
            b"orchestration_step_spec",
            "pipeline_step",
            b"pipeline_step",
            "pipeline_step_compute_info",
            b"pipeline_step_compute_info",
            "status",
            b"status",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "build_info",
            b"build_info",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "id",
            b"id",
            "modified_at",
            b"modified_at",
            "orchestration_step_spec",
            b"orchestration_step_spec",
            "pipeline_step",
            b"pipeline_step",
            "pipeline_step_compute_info",
            b"pipeline_step_compute_info",
            "pipeline_step_input_params",
            b"pipeline_step_input_params",
            "status",
            b"status",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___PipelineStepVersion = PipelineStepVersion

@typing_extensions.final
class Pipeline(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    PIPELINE_VERSION_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    NOTES_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    user_id: builtins.str
    """The user the pipeline belongs to"""
    app_id: builtins.str
    """The app the pipeline belongs to"""
    @property
    def pipeline_version(self) -> global___PipelineVersion:
        """Latest Pipeline Version"""
    description: builtins.str
    """Short description about this pipeline"""
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    notes: builtins.str
    """Notes for the Pipeline. This field should be used for in-depth notes and supports up to 64Kbs."""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata, use a struct field
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the pipeline was created"""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the pipeline was last modified"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        user_id: builtins.str = ...,
        app_id: builtins.str = ...,
        pipeline_version: global___PipelineVersion | None = ...,
        description: builtins.str = ...,
        visibility: global___Visibility | None = ...,
        notes: builtins.str = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "pipeline_version",
            b"pipeline_version",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "id",
            b"id",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "notes",
            b"notes",
            "pipeline_version",
            b"pipeline_version",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___Pipeline = Pipeline

@typing_extensions.final
class PipelineVersion(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    ORCHESTRATION_SPEC_FIELD_NUMBER: builtins.int
    PIPELINE_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    VISIBILITY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    app_id: builtins.str
    """The app the pipeline version belongs to."""
    user_id: builtins.str
    """The user the pipeline version belongs to."""
    @property
    def orchestration_spec(self) -> global___OrchestrationSpec:
        """Orchestration Specification using oneof"""
    pipeline_id: builtins.str
    """Pipeline's Id"""
    description: builtins.str
    """Short description about this pipeline version"""
    @property
    def visibility(self) -> global___Visibility:
        """The visibility field represents whether this message is privately/publicly visible.
        To be visible to the public the App that contains it AND the User that contains the App must
        also be publicly visible.
        """
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """To handle arbitrary json metadata, use a struct field
        https://github.com/google/protobuf/blob/master/src/google/protobuf/struct.proto
        """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the pipeline was created"""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the pipeline was last modified"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        app_id: builtins.str = ...,
        user_id: builtins.str = ...,
        orchestration_spec: global___OrchestrationSpec | None = ...,
        pipeline_id: builtins.str = ...,
        description: builtins.str = ...,
        visibility: global___Visibility | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "orchestration_spec",
            b"orchestration_spec",
            "visibility",
            b"visibility",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "created_at",
            b"created_at",
            "description",
            b"description",
            "id",
            b"id",
            "metadata",
            b"metadata",
            "modified_at",
            b"modified_at",
            "orchestration_spec",
            b"orchestration_spec",
            "pipeline_id",
            b"pipeline_id",
            "user_id",
            b"user_id",
            "visibility",
            b"visibility",
        ],
    ) -> None: ...

global___PipelineVersion = PipelineVersion

@typing_extensions.final
class OrchestrationStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARGO_STATUS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    @property
    def argo_status(self) -> global___ArgoOrchestrationStatus:
        """Status for Argo Workflow"""
    @property
    def status(self) -> proto.clarifai.api.status.status_pb2.Status:
        """This will help us with filtering the PipelineVersionRuns based on status"""
    def __init__(
        self,
        *,
        argo_status: global___ArgoOrchestrationStatus | None = ...,
        status: proto.clarifai.api.status.status_pb2.Status | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "argo_status", b"argo_status", "status", b"status", "status_details", b"status_details"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "argo_status", b"argo_status", "status", b"status", "status_details", b"status_details"
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["status_details", b"status_details"]
    ) -> typing_extensions.Literal["argo_status"] | None: ...

global___OrchestrationStatus = OrchestrationStatus

@typing_extensions.final
class ArgoOrchestrationStatus(google.protobuf.message.Message):
    """Argo Workflow Status message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    status: builtins.str
    """Refer https://pkg.go.dev/github.com/argoproj/argo-workflows/v3/pkg/apis/workflow/v1alpha1#WorkflowStatus"""
    def __init__(
        self,
        *,
        status: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["status", b"status"]) -> None: ...

global___ArgoOrchestrationStatus = ArgoOrchestrationStatus

@typing_extensions.final
class PipelineVersionRun(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    PIPELINE_VERSION_FIELD_NUMBER: builtins.int
    NODEPOOLS_FIELD_NUMBER: builtins.int
    ORCHESTRATION_STATUS_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    @property
    def pipeline_version(self) -> global___PipelineVersion:
        """Pipeline Version associated with this run"""
    @property
    def nodepools(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Nodepool]:
        """Nodepool(s) used for the Pipeline Version Run"""
    @property
    def orchestration_status(self) -> global___OrchestrationStatus:
        """Orchestration Status for this run, supporting multiple orchestration systems"""
    user_id: builtins.str
    """The user the pipeline belongs to"""
    app_id: builtins.str
    """The app the pipeline belongs to"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the pipeline was created"""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the pipeline was last modified"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        pipeline_version: global___PipelineVersion | None = ...,
        nodepools: collections.abc.Iterable[global___Nodepool] | None = ...,
        orchestration_status: global___OrchestrationStatus | None = ...,
        user_id: builtins.str = ...,
        app_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "modified_at",
            b"modified_at",
            "orchestration_status",
            b"orchestration_status",
            "pipeline_version",
            b"pipeline_version",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "app_id",
            b"app_id",
            "created_at",
            b"created_at",
            "id",
            b"id",
            "modified_at",
            b"modified_at",
            "nodepools",
            b"nodepools",
            "orchestration_status",
            b"orchestration_status",
            "pipeline_version",
            b"pipeline_version",
            "user_id",
            b"user_id",
        ],
    ) -> None: ...

global___PipelineVersionRun = PipelineVersionRun

@typing_extensions.final
class Secret(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    USER_ID_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The name of the secret, corresponds to id in model_version.output_info.params.secrets"""
    user_id: builtins.str
    """The user the secret belongs to."""
    value: builtins.str
    """The value of the secret."""
    version: builtins.int
    """The version of the secret."""
    description: builtins.str
    """The description of the secret."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the secret was created."""
    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the secret was last modified."""
    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the secret will expire."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        user_id: builtins.str = ...,
        value: builtins.str = ...,
        version: builtins.int = ...,
        description: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "created_at", b"created_at", "expires_at", b"expires_at", "modified_at", b"modified_at"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "created_at",
            b"created_at",
            "description",
            b"description",
            "expires_at",
            b"expires_at",
            "id",
            b"id",
            "modified_at",
            b"modified_at",
            "user_id",
            b"user_id",
            "value",
            b"value",
            "version",
            b"version",
        ],
    ) -> None: ...

global___Secret = Secret

@typing_extensions.final
class MetricData(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Label(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        name: global___MetricLabel.ValueType
        value: builtins.str
        def __init__(
            self,
            *,
            name: global___MetricLabel.ValueType = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing_extensions.Literal["name", b"name", "value", b"value"]
        ) -> None: ...

    @typing_extensions.final
    class MetricSample(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TIMESTAMP_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        @property
        def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
            """The format is https://www.ietf.org/rfc/rfc3339.txt.
            Example: "2006-01-02T15:04:05.999999Z".
            """
        value: builtins.float
        def __init__(
            self,
            *,
            timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
            value: builtins.float = ...,
        ) -> None: ...
        def HasField(
            self, field_name: typing_extensions.Literal["timestamp", b"timestamp"]
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["timestamp", b"timestamp", "value", b"value"],
        ) -> None: ...

    @typing_extensions.final
    class MatrixData(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing_extensions.final
        class TimeSeries(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            LABELS_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            @property
            def labels(
                self,
            ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
                global___MetricData.Label
            ]: ...
            @property
            def value(
                self,
            ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
                global___MetricData.MetricSample
            ]: ...
            def __init__(
                self,
                *,
                labels: collections.abc.Iterable[global___MetricData.Label] | None = ...,
                value: collections.abc.Iterable[global___MetricData.MetricSample] | None = ...,
            ) -> None: ...
            def ClearField(
                self, field_name: typing_extensions.Literal["labels", b"labels", "value", b"value"]
            ) -> None: ...

        SERIES_FIELD_NUMBER: builtins.int
        @property
        def series(
            self,
        ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
            global___MetricData.MatrixData.TimeSeries
        ]: ...
        def __init__(
            self,
            *,
            series: collections.abc.Iterable[global___MetricData.MatrixData.TimeSeries]
            | None = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing_extensions.Literal["series", b"series"]
        ) -> None: ...

    MATRIX_DATA_FIELD_NUMBER: builtins.int
    @property
    def matrix_data(self) -> global___MetricData.MatrixData: ...
    def __init__(
        self,
        *,
        matrix_data: global___MetricData.MatrixData | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["data", b"data", "matrix_data", b"matrix_data"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["data", b"data", "matrix_data", b"matrix_data"]
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["data", b"data"]
    ) -> typing_extensions.Literal["matrix_data"] | None: ...

global___MetricData = MetricData

@typing_extensions.final
class MetricAggregate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Operator:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _OperatorEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            MetricAggregate._Operator.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OPERATOR_NOT_SET: MetricAggregate._Operator.ValueType  # 0
        AVG: MetricAggregate._Operator.ValueType  # 1
        SUM: MetricAggregate._Operator.ValueType  # 2
        MAX: MetricAggregate._Operator.ValueType  # 3
        MIN: MetricAggregate._Operator.ValueType  # 4
        P95: MetricAggregate._Operator.ValueType  # 5
        P99: MetricAggregate._Operator.ValueType  # 6
        P50: MetricAggregate._Operator.ValueType  # 7
        COUNT: MetricAggregate._Operator.ValueType  # 8

    class Operator(_Operator, metaclass=_OperatorEnumTypeWrapper): ...
    OPERATOR_NOT_SET: MetricAggregate.Operator.ValueType  # 0
    AVG: MetricAggregate.Operator.ValueType  # 1
    SUM: MetricAggregate.Operator.ValueType  # 2
    MAX: MetricAggregate.Operator.ValueType  # 3
    MIN: MetricAggregate.Operator.ValueType  # 4
    P95: MetricAggregate.Operator.ValueType  # 5
    P99: MetricAggregate.Operator.ValueType  # 6
    P50: MetricAggregate.Operator.ValueType  # 7
    COUNT: MetricAggregate.Operator.ValueType  # 8

    OPERATOR_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    operator: global___MetricAggregate.Operator.ValueType
    @property
    def labels(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___MetricLabel.ValueType
    ]: ...
    def __init__(
        self,
        *,
        operator: global___MetricAggregate.Operator.ValueType = ...,
        labels: collections.abc.Iterable[global___MetricLabel.ValueType] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["labels", b"labels", "operator", b"operator"]
    ) -> None: ...

global___MetricAggregate = MetricAggregate

@typing_extensions.final
class MetricFilter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class MultiValues(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        IN_FIELD_NUMBER: builtins.int
        def __init__(
            self,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["in", b"in"]) -> None: ...

    LABEL_FIELD_NUMBER: builtins.int
    EQUALS_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    label: global___MetricLabel.ValueType
    equals: builtins.str
    def __init__(
        self,
        *,
        label: global___MetricLabel.ValueType = ...,
        equals: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal["equals", b"equals", "in", b"in", "value", b"value"],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "equals", b"equals", "in", b"in", "label", b"label", "value", b"value"
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["value", b"value"]
    ) -> typing_extensions.Literal["equals", "in"] | None: ...

global___MetricFilter = MetricFilter

@typing_extensions.final
class MetricSearchQuery(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METRIC_TYPE_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    RESOLUTION_FIELD_NUMBER: builtins.int
    FILTERS_FIELD_NUMBER: builtins.int
    AGGREGATE_FIELD_NUMBER: builtins.int
    metric_type: global___MetricType.ValueType
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """start time of the search window"""
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """end time of the search window"""
    resolution: builtins.str
    """duration string https://pkg.go.dev/time#ParseDuration"""
    @property
    def filters(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___MetricFilter
    ]:
        """ANDed"""
    @property
    def aggregate(self) -> global___MetricAggregate: ...
    def __init__(
        self,
        *,
        metric_type: global___MetricType.ValueType = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        resolution: builtins.str = ...,
        filters: collections.abc.Iterable[global___MetricFilter] | None = ...,
        aggregate: global___MetricAggregate | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "aggregate", b"aggregate", "end_time", b"end_time", "start_time", b"start_time"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "aggregate",
            b"aggregate",
            "end_time",
            b"end_time",
            "filters",
            b"filters",
            "metric_type",
            b"metric_type",
            "resolution",
            b"resolution",
            "start_time",
            b"start_time",
        ],
    ) -> None: ...

global___MetricSearchQuery = MetricSearchQuery

@typing_extensions.final
class MetricTypeLabels(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LabelWithValues(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LABEL_FIELD_NUMBER: builtins.int
        VALUES_FIELD_NUMBER: builtins.int
        label: global___MetricLabel.ValueType
        @property
        def values(
            self,
        ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """sample values for this label"""
        def __init__(
            self,
            *,
            label: global___MetricLabel.ValueType = ...,
            values: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(
            self, field_name: typing_extensions.Literal["label", b"label", "values", b"values"]
        ) -> None: ...

    METRIC_TYPE_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    metric_type: global___MetricType.ValueType
    @property
    def labels(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___MetricTypeLabels.LabelWithValues
    ]: ...
    def __init__(
        self,
        *,
        metric_type: global___MetricType.ValueType = ...,
        labels: collections.abc.Iterable[global___MetricTypeLabels.LabelWithValues] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["labels", b"labels", "metric_type", b"metric_type"],
    ) -> None: ...

global___MetricTypeLabels = MetricTypeLabels
