# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccessPolicyArgs', 'AccessPolicy']

@pulumi.input_type
class AccessPolicyArgs:
    def __init__(__self__, *,
                 decision: pulumi.Input[str],
                 includes: pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]],
                 name: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]]] = None,
                 approval_required: Optional[pulumi.Input[bool]] = None,
                 connection_rules: Optional[pulumi.Input['AccessPolicyConnectionRulesArgs']] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]]] = None,
                 isolation_required: Optional[pulumi.Input[bool]] = None,
                 precedence: Optional[pulumi.Input[int]] = None,
                 purpose_justification_prompt: Optional[pulumi.Input[str]] = None,
                 purpose_justification_required: Optional[pulumi.Input[bool]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]]] = None,
                 session_duration: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AccessPolicy resource.
        :param pulumi.Input[str] decision: Defines the action Access will take if the policy matches the user. Available values: `allow`, `deny`, `non_identity`, `bypass`.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]] includes: A series of access conditions, see Access Groups.
        :param pulumi.Input[str] name: Friendly name of the Access Policy.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Conflicts with `zone_id`.
        :param pulumi.Input[str] application_id: The ID of the application the policy is associated with. Required when using `precedence`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input['AccessPolicyConnectionRulesArgs'] connection_rules: The rules that define how users may connect to the targets secured by your application.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]] excludes: A series of access conditions, see Access Groups.
        :param pulumi.Input[bool] isolation_required: Require this application to be served in an isolated browser for users matching this policy.
        :param pulumi.Input[int] precedence: The unique precedence for policies on a single application. Required when using `application_id`.
        :param pulumi.Input[str] purpose_justification_prompt: The prompt to display to the user for a justification for accessing the resource. Required when using `purpose_justification_required`.
        :param pulumi.Input[bool] purpose_justification_required: Whether to prompt the user for a justification for accessing the resource.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]] requires: A series of access conditions, see Access Groups.
        :param pulumi.Input[str] session_duration: How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        pulumi.set(__self__, "decision", decision)
        pulumi.set(__self__, "includes", includes)
        pulumi.set(__self__, "name", name)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if approval_groups is not None:
            pulumi.set(__self__, "approval_groups", approval_groups)
        if approval_required is not None:
            pulumi.set(__self__, "approval_required", approval_required)
        if connection_rules is not None:
            pulumi.set(__self__, "connection_rules", connection_rules)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if isolation_required is not None:
            pulumi.set(__self__, "isolation_required", isolation_required)
        if precedence is not None:
            pulumi.set(__self__, "precedence", precedence)
        if purpose_justification_prompt is not None:
            pulumi.set(__self__, "purpose_justification_prompt", purpose_justification_prompt)
        if purpose_justification_required is not None:
            pulumi.set(__self__, "purpose_justification_required", purpose_justification_required)
        if requires is not None:
            pulumi.set(__self__, "requires", requires)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def decision(self) -> pulumi.Input[str]:
        """
        Defines the action Access will take if the policy matches the user. Available values: `allow`, `deny`, `non_identity`, `bypass`.
        """
        return pulumi.get(self, "decision")

    @decision.setter
    def decision(self, value: pulumi.Input[str]):
        pulumi.set(self, "decision", value)

    @property
    @pulumi.getter
    def includes(self) -> pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]]:
        """
        A series of access conditions, see Access Groups.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]]):
        pulumi.set(self, "includes", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Friendly name of the Access Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource. Conflicts with `zone_id`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the application the policy is associated with. Required when using `precedence`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="approvalGroups")
    def approval_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]]]:
        return pulumi.get(self, "approval_groups")

    @approval_groups.setter
    def approval_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]]]):
        pulumi.set(self, "approval_groups", value)

    @property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "approval_required")

    @approval_required.setter
    def approval_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "approval_required", value)

    @property
    @pulumi.getter(name="connectionRules")
    def connection_rules(self) -> Optional[pulumi.Input['AccessPolicyConnectionRulesArgs']]:
        """
        The rules that define how users may connect to the targets secured by your application.
        """
        return pulumi.get(self, "connection_rules")

    @connection_rules.setter
    def connection_rules(self, value: Optional[pulumi.Input['AccessPolicyConnectionRulesArgs']]):
        pulumi.set(self, "connection_rules", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]]]:
        """
        A series of access conditions, see Access Groups.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="isolationRequired")
    def isolation_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Require this application to be served in an isolated browser for users matching this policy.
        """
        return pulumi.get(self, "isolation_required")

    @isolation_required.setter
    def isolation_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "isolation_required", value)

    @property
    @pulumi.getter
    def precedence(self) -> Optional[pulumi.Input[int]]:
        """
        The unique precedence for policies on a single application. Required when using `application_id`.
        """
        return pulumi.get(self, "precedence")

    @precedence.setter
    def precedence(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "precedence", value)

    @property
    @pulumi.getter(name="purposeJustificationPrompt")
    def purpose_justification_prompt(self) -> Optional[pulumi.Input[str]]:
        """
        The prompt to display to the user for a justification for accessing the resource. Required when using `purpose_justification_required`.
        """
        return pulumi.get(self, "purpose_justification_prompt")

    @purpose_justification_prompt.setter
    def purpose_justification_prompt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purpose_justification_prompt", value)

    @property
    @pulumi.getter(name="purposeJustificationRequired")
    def purpose_justification_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to prompt the user for a justification for accessing the resource.
        """
        return pulumi.get(self, "purpose_justification_required")

    @purpose_justification_required.setter
    def purpose_justification_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "purpose_justification_required", value)

    @property
    @pulumi.getter
    def requires(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]]]:
        """
        A series of access conditions, see Access Groups.
        """
        return pulumi.get(self, "requires")

    @requires.setter
    def requires(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]]]):
        pulumi.set(self, "requires", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[str]]:
        """
        How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_duration", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _AccessPolicyState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]]] = None,
                 approval_required: Optional[pulumi.Input[bool]] = None,
                 connection_rules: Optional[pulumi.Input['AccessPolicyConnectionRulesArgs']] = None,
                 decision: Optional[pulumi.Input[str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]]] = None,
                 isolation_required: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 precedence: Optional[pulumi.Input[int]] = None,
                 purpose_justification_prompt: Optional[pulumi.Input[str]] = None,
                 purpose_justification_required: Optional[pulumi.Input[bool]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]]] = None,
                 session_duration: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AccessPolicy resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Conflicts with `zone_id`.
        :param pulumi.Input[str] application_id: The ID of the application the policy is associated with. Required when using `precedence`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input['AccessPolicyConnectionRulesArgs'] connection_rules: The rules that define how users may connect to the targets secured by your application.
        :param pulumi.Input[str] decision: Defines the action Access will take if the policy matches the user. Available values: `allow`, `deny`, `non_identity`, `bypass`.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]] excludes: A series of access conditions, see Access Groups.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]] includes: A series of access conditions, see Access Groups.
        :param pulumi.Input[bool] isolation_required: Require this application to be served in an isolated browser for users matching this policy.
        :param pulumi.Input[str] name: Friendly name of the Access Policy.
        :param pulumi.Input[int] precedence: The unique precedence for policies on a single application. Required when using `application_id`.
        :param pulumi.Input[str] purpose_justification_prompt: The prompt to display to the user for a justification for accessing the resource. Required when using `purpose_justification_required`.
        :param pulumi.Input[bool] purpose_justification_required: Whether to prompt the user for a justification for accessing the resource.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]] requires: A series of access conditions, see Access Groups.
        :param pulumi.Input[str] session_duration: How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if approval_groups is not None:
            pulumi.set(__self__, "approval_groups", approval_groups)
        if approval_required is not None:
            pulumi.set(__self__, "approval_required", approval_required)
        if connection_rules is not None:
            pulumi.set(__self__, "connection_rules", connection_rules)
        if decision is not None:
            pulumi.set(__self__, "decision", decision)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)
        if isolation_required is not None:
            pulumi.set(__self__, "isolation_required", isolation_required)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if precedence is not None:
            pulumi.set(__self__, "precedence", precedence)
        if purpose_justification_prompt is not None:
            pulumi.set(__self__, "purpose_justification_prompt", purpose_justification_prompt)
        if purpose_justification_required is not None:
            pulumi.set(__self__, "purpose_justification_required", purpose_justification_required)
        if requires is not None:
            pulumi.set(__self__, "requires", requires)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource. Conflicts with `zone_id`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the application the policy is associated with. Required when using `precedence`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="approvalGroups")
    def approval_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]]]:
        return pulumi.get(self, "approval_groups")

    @approval_groups.setter
    def approval_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]]]):
        pulumi.set(self, "approval_groups", value)

    @property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "approval_required")

    @approval_required.setter
    def approval_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "approval_required", value)

    @property
    @pulumi.getter(name="connectionRules")
    def connection_rules(self) -> Optional[pulumi.Input['AccessPolicyConnectionRulesArgs']]:
        """
        The rules that define how users may connect to the targets secured by your application.
        """
        return pulumi.get(self, "connection_rules")

    @connection_rules.setter
    def connection_rules(self, value: Optional[pulumi.Input['AccessPolicyConnectionRulesArgs']]):
        pulumi.set(self, "connection_rules", value)

    @property
    @pulumi.getter
    def decision(self) -> Optional[pulumi.Input[str]]:
        """
        Defines the action Access will take if the policy matches the user. Available values: `allow`, `deny`, `non_identity`, `bypass`.
        """
        return pulumi.get(self, "decision")

    @decision.setter
    def decision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "decision", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]]]:
        """
        A series of access conditions, see Access Groups.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]]]:
        """
        A series of access conditions, see Access Groups.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]]]):
        pulumi.set(self, "includes", value)

    @property
    @pulumi.getter(name="isolationRequired")
    def isolation_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Require this application to be served in an isolated browser for users matching this policy.
        """
        return pulumi.get(self, "isolation_required")

    @isolation_required.setter
    def isolation_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "isolation_required", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the Access Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def precedence(self) -> Optional[pulumi.Input[int]]:
        """
        The unique precedence for policies on a single application. Required when using `application_id`.
        """
        return pulumi.get(self, "precedence")

    @precedence.setter
    def precedence(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "precedence", value)

    @property
    @pulumi.getter(name="purposeJustificationPrompt")
    def purpose_justification_prompt(self) -> Optional[pulumi.Input[str]]:
        """
        The prompt to display to the user for a justification for accessing the resource. Required when using `purpose_justification_required`.
        """
        return pulumi.get(self, "purpose_justification_prompt")

    @purpose_justification_prompt.setter
    def purpose_justification_prompt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purpose_justification_prompt", value)

    @property
    @pulumi.getter(name="purposeJustificationRequired")
    def purpose_justification_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to prompt the user for a justification for accessing the resource.
        """
        return pulumi.get(self, "purpose_justification_required")

    @purpose_justification_required.setter
    def purpose_justification_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "purpose_justification_required", value)

    @property
    @pulumi.getter
    def requires(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]]]:
        """
        A series of access conditions, see Access Groups.
        """
        return pulumi.get(self, "requires")

    @requires.setter
    def requires(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]]]):
        pulumi.set(self, "requires", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[str]]:
        """
        How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_duration", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class AccessPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyApprovalGroupArgs', 'AccessPolicyApprovalGroupArgsDict']]]]] = None,
                 approval_required: Optional[pulumi.Input[bool]] = None,
                 connection_rules: Optional[pulumi.Input[Union['AccessPolicyConnectionRulesArgs', 'AccessPolicyConnectionRulesArgsDict']]] = None,
                 decision: Optional[pulumi.Input[str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyExcludeArgs', 'AccessPolicyExcludeArgsDict']]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyIncludeArgs', 'AccessPolicyIncludeArgsDict']]]]] = None,
                 isolation_required: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 precedence: Optional[pulumi.Input[int]] = None,
                 purpose_justification_prompt: Optional[pulumi.Input[str]] = None,
                 purpose_justification_required: Optional[pulumi.Input[bool]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyRequireArgs', 'AccessPolicyRequireArgsDict']]]]] = None,
                 session_duration: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Access Policy resource. Access Policies are
        used in conjunction with Access Applications to restrict access to
        a particular resource.

        > It's required that an `account_id` or `zone_id` is provided and in most cases using either is fine.
           However, if you're using a scoped access token, you must provide the argument that matches the token's
           scope. For example, an access token that is scoped to the "example.com" zone needs to use the `zone_id` argument.
           If 'application_id' is omitted, the policy created can be reused by multiple access applications.
           Any AccessApplication resource can reference reusable policies through its `policies` argument.
           To destroy a reusable policy and remove it from all applications' policies lists on the same apply, preemptively set the
           lifecycle option `create_before_destroy` to true on the 'cloudflare_access_policy' resource.

        ## Import

        ```sh
        $ pulumi import cloudflare:index/accessPolicy:AccessPolicy example account/<account_id>/<application_id>/<policy_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Conflicts with `zone_id`.
        :param pulumi.Input[str] application_id: The ID of the application the policy is associated with. Required when using `precedence`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[Union['AccessPolicyConnectionRulesArgs', 'AccessPolicyConnectionRulesArgsDict']] connection_rules: The rules that define how users may connect to the targets secured by your application.
        :param pulumi.Input[str] decision: Defines the action Access will take if the policy matches the user. Available values: `allow`, `deny`, `non_identity`, `bypass`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyExcludeArgs', 'AccessPolicyExcludeArgsDict']]]] excludes: A series of access conditions, see Access Groups.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyIncludeArgs', 'AccessPolicyIncludeArgsDict']]]] includes: A series of access conditions, see Access Groups.
        :param pulumi.Input[bool] isolation_required: Require this application to be served in an isolated browser for users matching this policy.
        :param pulumi.Input[str] name: Friendly name of the Access Policy.
        :param pulumi.Input[int] precedence: The unique precedence for policies on a single application. Required when using `application_id`.
        :param pulumi.Input[str] purpose_justification_prompt: The prompt to display to the user for a justification for accessing the resource. Required when using `purpose_justification_required`.
        :param pulumi.Input[bool] purpose_justification_required: Whether to prompt the user for a justification for accessing the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyRequireArgs', 'AccessPolicyRequireArgsDict']]]] requires: A series of access conditions, see Access Groups.
        :param pulumi.Input[str] session_duration: How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Access Policy resource. Access Policies are
        used in conjunction with Access Applications to restrict access to
        a particular resource.

        > It's required that an `account_id` or `zone_id` is provided and in most cases using either is fine.
           However, if you're using a scoped access token, you must provide the argument that matches the token's
           scope. For example, an access token that is scoped to the "example.com" zone needs to use the `zone_id` argument.
           If 'application_id' is omitted, the policy created can be reused by multiple access applications.
           Any AccessApplication resource can reference reusable policies through its `policies` argument.
           To destroy a reusable policy and remove it from all applications' policies lists on the same apply, preemptively set the
           lifecycle option `create_before_destroy` to true on the 'cloudflare_access_policy' resource.

        ## Import

        ```sh
        $ pulumi import cloudflare:index/accessPolicy:AccessPolicy example account/<account_id>/<application_id>/<policy_id>
        ```

        :param str resource_name: The name of the resource.
        :param AccessPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyApprovalGroupArgs', 'AccessPolicyApprovalGroupArgsDict']]]]] = None,
                 approval_required: Optional[pulumi.Input[bool]] = None,
                 connection_rules: Optional[pulumi.Input[Union['AccessPolicyConnectionRulesArgs', 'AccessPolicyConnectionRulesArgsDict']]] = None,
                 decision: Optional[pulumi.Input[str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyExcludeArgs', 'AccessPolicyExcludeArgsDict']]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyIncludeArgs', 'AccessPolicyIncludeArgsDict']]]]] = None,
                 isolation_required: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 precedence: Optional[pulumi.Input[int]] = None,
                 purpose_justification_prompt: Optional[pulumi.Input[str]] = None,
                 purpose_justification_required: Optional[pulumi.Input[bool]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyRequireArgs', 'AccessPolicyRequireArgsDict']]]]] = None,
                 session_duration: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessPolicyArgs.__new__(AccessPolicyArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["approval_groups"] = approval_groups
            __props__.__dict__["approval_required"] = approval_required
            __props__.__dict__["connection_rules"] = connection_rules
            if decision is None and not opts.urn:
                raise TypeError("Missing required property 'decision'")
            __props__.__dict__["decision"] = decision
            __props__.__dict__["excludes"] = excludes
            if includes is None and not opts.urn:
                raise TypeError("Missing required property 'includes'")
            __props__.__dict__["includes"] = includes
            __props__.__dict__["isolation_required"] = isolation_required
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["precedence"] = precedence
            __props__.__dict__["purpose_justification_prompt"] = purpose_justification_prompt
            __props__.__dict__["purpose_justification_required"] = purpose_justification_required
            __props__.__dict__["requires"] = requires
            __props__.__dict__["session_duration"] = session_duration
            __props__.__dict__["zone_id"] = zone_id
        super(AccessPolicy, __self__).__init__(
            'cloudflare:index/accessPolicy:AccessPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyApprovalGroupArgs', 'AccessPolicyApprovalGroupArgsDict']]]]] = None,
            approval_required: Optional[pulumi.Input[bool]] = None,
            connection_rules: Optional[pulumi.Input[Union['AccessPolicyConnectionRulesArgs', 'AccessPolicyConnectionRulesArgsDict']]] = None,
            decision: Optional[pulumi.Input[str]] = None,
            excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyExcludeArgs', 'AccessPolicyExcludeArgsDict']]]]] = None,
            includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyIncludeArgs', 'AccessPolicyIncludeArgsDict']]]]] = None,
            isolation_required: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            precedence: Optional[pulumi.Input[int]] = None,
            purpose_justification_prompt: Optional[pulumi.Input[str]] = None,
            purpose_justification_required: Optional[pulumi.Input[bool]] = None,
            requires: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyRequireArgs', 'AccessPolicyRequireArgsDict']]]]] = None,
            session_duration: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'AccessPolicy':
        """
        Get an existing AccessPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Conflicts with `zone_id`.
        :param pulumi.Input[str] application_id: The ID of the application the policy is associated with. Required when using `precedence`. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[Union['AccessPolicyConnectionRulesArgs', 'AccessPolicyConnectionRulesArgsDict']] connection_rules: The rules that define how users may connect to the targets secured by your application.
        :param pulumi.Input[str] decision: Defines the action Access will take if the policy matches the user. Available values: `allow`, `deny`, `non_identity`, `bypass`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyExcludeArgs', 'AccessPolicyExcludeArgsDict']]]] excludes: A series of access conditions, see Access Groups.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyIncludeArgs', 'AccessPolicyIncludeArgsDict']]]] includes: A series of access conditions, see Access Groups.
        :param pulumi.Input[bool] isolation_required: Require this application to be served in an isolated browser for users matching this policy.
        :param pulumi.Input[str] name: Friendly name of the Access Policy.
        :param pulumi.Input[int] precedence: The unique precedence for policies on a single application. Required when using `application_id`.
        :param pulumi.Input[str] purpose_justification_prompt: The prompt to display to the user for a justification for accessing the resource. Required when using `purpose_justification_required`.
        :param pulumi.Input[bool] purpose_justification_required: Whether to prompt the user for a justification for accessing the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyRequireArgs', 'AccessPolicyRequireArgsDict']]]] requires: A series of access conditions, see Access Groups.
        :param pulumi.Input[str] session_duration: How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessPolicyState.__new__(_AccessPolicyState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["approval_groups"] = approval_groups
        __props__.__dict__["approval_required"] = approval_required
        __props__.__dict__["connection_rules"] = connection_rules
        __props__.__dict__["decision"] = decision
        __props__.__dict__["excludes"] = excludes
        __props__.__dict__["includes"] = includes
        __props__.__dict__["isolation_required"] = isolation_required
        __props__.__dict__["name"] = name
        __props__.__dict__["precedence"] = precedence
        __props__.__dict__["purpose_justification_prompt"] = purpose_justification_prompt
        __props__.__dict__["purpose_justification_required"] = purpose_justification_required
        __props__.__dict__["requires"] = requires
        __props__.__dict__["session_duration"] = session_duration
        __props__.__dict__["zone_id"] = zone_id
        return AccessPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[str]]:
        """
        The account identifier to target for the resource. Conflicts with `zone_id`.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the application the policy is associated with. Required when using `precedence`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="approvalGroups")
    def approval_groups(self) -> pulumi.Output[Optional[Sequence['outputs.AccessPolicyApprovalGroup']]]:
        return pulumi.get(self, "approval_groups")

    @property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "approval_required")

    @property
    @pulumi.getter(name="connectionRules")
    def connection_rules(self) -> pulumi.Output[Optional['outputs.AccessPolicyConnectionRules']]:
        """
        The rules that define how users may connect to the targets secured by your application.
        """
        return pulumi.get(self, "connection_rules")

    @property
    @pulumi.getter
    def decision(self) -> pulumi.Output[str]:
        """
        Defines the action Access will take if the policy matches the user. Available values: `allow`, `deny`, `non_identity`, `bypass`.
        """
        return pulumi.get(self, "decision")

    @property
    @pulumi.getter
    def excludes(self) -> pulumi.Output[Optional[Sequence['outputs.AccessPolicyExclude']]]:
        """
        A series of access conditions, see Access Groups.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> pulumi.Output[Sequence['outputs.AccessPolicyInclude']]:
        """
        A series of access conditions, see Access Groups.
        """
        return pulumi.get(self, "includes")

    @property
    @pulumi.getter(name="isolationRequired")
    def isolation_required(self) -> pulumi.Output[Optional[bool]]:
        """
        Require this application to be served in an isolated browser for users matching this policy.
        """
        return pulumi.get(self, "isolation_required")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Friendly name of the Access Policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def precedence(self) -> pulumi.Output[Optional[int]]:
        """
        The unique precedence for policies on a single application. Required when using `application_id`.
        """
        return pulumi.get(self, "precedence")

    @property
    @pulumi.getter(name="purposeJustificationPrompt")
    def purpose_justification_prompt(self) -> pulumi.Output[Optional[str]]:
        """
        The prompt to display to the user for a justification for accessing the resource. Required when using `purpose_justification_required`.
        """
        return pulumi.get(self, "purpose_justification_prompt")

    @property
    @pulumi.getter(name="purposeJustificationRequired")
    def purpose_justification_required(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to prompt the user for a justification for accessing the resource.
        """
        return pulumi.get(self, "purpose_justification_required")

    @property
    @pulumi.getter
    def requires(self) -> pulumi.Output[Optional[Sequence['outputs.AccessPolicyRequire']]]:
        """
        A series of access conditions, see Access Groups.
        """
        return pulumi.get(self, "requires")

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> pulumi.Output[Optional[str]]:
        """
        How often a user will be forced to re-authorise. Must be in the format `48h` or `2h45m`.
        """
        return pulumi.get(self, "session_duration")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[str]]:
        """
        The zone identifier to target for the resource. Conflicts with `account_id`.
        """
        return pulumi.get(self, "zone_id")

