# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGatewayAppTypesResult',
    'AwaitableGetGatewayAppTypesResult',
    'get_gateway_app_types',
    'get_gateway_app_types_output',
]

@pulumi.output_type
class GetGatewayAppTypesResult:
    """
    A collection of values returned by getGatewayAppTypes.
    """
    def __init__(__self__, account_id=None, app_types=None, id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if app_types and not isinstance(app_types, list):
            raise TypeError("Expected argument 'app_types' to be a list")
        pulumi.set(__self__, "app_types", app_types)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The account ID to fetch Gateway App Types from.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="appTypes")
    def app_types(self) -> Sequence['outputs.GetGatewayAppTypesAppTypeResult']:
        """
        A list of Gateway App Types.
        """
        return pulumi.get(self, "app_types")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetGatewayAppTypesResult(GetGatewayAppTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayAppTypesResult(
            account_id=self.account_id,
            app_types=self.app_types,
            id=self.id)


def get_gateway_app_types(account_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayAppTypesResult:
    """
    Use this data source to retrieve all Gateway application types for an account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example = cloudflare.get_gateway_app_types(account_id="f037e56e89293a057740de681ac9abbe")
    ```


    :param str account_id: The account ID to fetch Gateway App Types from.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getGatewayAppTypes:getGatewayAppTypes', __args__, opts=opts, typ=GetGatewayAppTypesResult).value

    return AwaitableGetGatewayAppTypesResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        app_types=pulumi.get(__ret__, 'app_types'),
        id=pulumi.get(__ret__, 'id'))
def get_gateway_app_types_output(account_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGatewayAppTypesResult]:
    """
    Use this data source to retrieve all Gateway application types for an account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example = cloudflare.get_gateway_app_types(account_id="f037e56e89293a057740de681ac9abbe")
    ```


    :param str account_id: The account ID to fetch Gateway App Types from.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getGatewayAppTypes:getGatewayAppTypes', __args__, opts=opts, typ=GetGatewayAppTypesResult)
    return __ret__.apply(lambda __response__: GetGatewayAppTypesResult(
        account_id=pulumi.get(__response__, 'account_id'),
        app_types=pulumi.get(__response__, 'app_types'),
        id=pulumi.get(__response__, 'id')))
