# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGatewayCategoriesResult',
    'AwaitableGetGatewayCategoriesResult',
    'get_gateway_categories',
    'get_gateway_categories_output',
]

@pulumi.output_type
class GetGatewayCategoriesResult:
    """
    A collection of values returned by getGatewayCategories.
    """
    def __init__(__self__, account_id=None, categories=None, id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The account ID to fetch Gateway Categories from.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetGatewayCategoriesCategoryResult']:
        """
        A list of Gateway Categories.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetGatewayCategoriesResult(GetGatewayCategoriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayCategoriesResult(
            account_id=self.account_id,
            categories=self.categories,
            id=self.id)


def get_gateway_categories(account_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayCategoriesResult:
    """
    Use this data source to retrieve all Gateway categories for an account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example = cloudflare.get_gateway_categories(account_id="f037e56e89293a057740de681ac9abbe")
    ```


    :param str account_id: The account ID to fetch Gateway Categories from.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getGatewayCategories:getGatewayCategories', __args__, opts=opts, typ=GetGatewayCategoriesResult).value

    return AwaitableGetGatewayCategoriesResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        categories=pulumi.get(__ret__, 'categories'),
        id=pulumi.get(__ret__, 'id'))
def get_gateway_categories_output(account_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGatewayCategoriesResult]:
    """
    Use this data source to retrieve all Gateway categories for an account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example = cloudflare.get_gateway_categories(account_id="f037e56e89293a057740de681ac9abbe")
    ```


    :param str account_id: The account ID to fetch Gateway Categories from.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getGatewayCategories:getGatewayCategories', __args__, opts=opts, typ=GetGatewayCategoriesResult)
    return __ret__.apply(lambda __response__: GetGatewayCategoriesResult(
        account_id=pulumi.get(__response__, 'account_id'),
        categories=pulumi.get(__response__, 'categories'),
        id=pulumi.get(__response__, 'id')))
