# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogpushJobArgs', 'LogpushJob']

@pulumi.input_type
class LogpushJobArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[str],
                 destination_conf: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 frequency: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 logpull_options: Optional[pulumi.Input[str]] = None,
                 max_upload_bytes: Optional[pulumi.Input[int]] = None,
                 max_upload_interval_seconds: Optional[pulumi.Input[int]] = None,
                 max_upload_records: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_options: Optional[pulumi.Input['LogpushJobOutputOptionsArgs']] = None,
                 ownership_challenge: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LogpushJob resource.
        :param pulumi.Input[str] dataset: The kind of the dataset to use with the logpush job. Available values: `access_requests`, `casb_findings`, `firewall_events`, `http_requests`, `spectrum_events`, `nel_reports`, `audit_logs`, `gateway_dns`, `gateway_http`, `gateway_network`, `dns_logs`, `network_analytics_logs`, `workers_trace_events`, `device_posture_results`, `zero_trust_network_sessions`, `magic_ids_detections`, `page_shield_events`.
        :param pulumi.Input[str] destination_conf: Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included. See [Logpush destination documentation](https://developers.cloudflare.com/logs/reference/logpush-api-configuration#destination).
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        :param pulumi.Input[bool] enabled: Whether to enable the job.
        :param pulumi.Input[str] filter: Use filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/logpush-api-configuration/filters/).
        :param pulumi.Input[str] frequency: A higher frequency will result in logs being pushed on faster with smaller files. `low` frequency will push logs less often with larger files. Available values: `high`, `low`. Defaults to `high`.
        :param pulumi.Input[str] kind: The kind of logpush job to create. Available values: `edge`, `instant-logs`, `""`.
        :param pulumi.Input[str] logpull_options: Configuration string for the Logshare API. It specifies things like requested fields and timestamp formats. See [Logpush options documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#options).
        :param pulumi.Input[int] max_upload_bytes: The maximum uncompressed file size of a batch of logs. Value must be between 5MB and 1GB.
        :param pulumi.Input[int] max_upload_interval_seconds: The maximum interval in seconds for log batches. Value must be between 30 and 300.
        :param pulumi.Input[int] max_upload_records: The maximum number of log lines per batch. Value must be between 1000 and 1,000,000.
        :param pulumi.Input[str] name: The name of the logpush job to create.
        :param pulumi.Input['LogpushJobOutputOptionsArgs'] output_options: Structured replacement for logpull*options. When including this field, the logpull*option field will be ignored.
        :param pulumi.Input[str] ownership_challenge: Ownership challenge token to prove destination ownership, required when destination is Amazon S3, Google Cloud Storage, Microsoft Azure or Sumo Logic. See [Developer documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#usage).
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "destination_conf", destination_conf)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if frequency is not None:
            warnings.warn("""`frequency` has been deprecated in favour of using `max_upload_interval_seconds` instead.""", DeprecationWarning)
            pulumi.log.warn("""frequency is deprecated: `frequency` has been deprecated in favour of using `max_upload_interval_seconds` instead.""")
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if logpull_options is not None:
            pulumi.set(__self__, "logpull_options", logpull_options)
        if max_upload_bytes is not None:
            pulumi.set(__self__, "max_upload_bytes", max_upload_bytes)
        if max_upload_interval_seconds is not None:
            pulumi.set(__self__, "max_upload_interval_seconds", max_upload_interval_seconds)
        if max_upload_records is not None:
            pulumi.set(__self__, "max_upload_records", max_upload_records)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_options is not None:
            pulumi.set(__self__, "output_options", output_options)
        if ownership_challenge is not None:
            pulumi.set(__self__, "ownership_challenge", ownership_challenge)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[str]:
        """
        The kind of the dataset to use with the logpush job. Available values: `access_requests`, `casb_findings`, `firewall_events`, `http_requests`, `spectrum_events`, `nel_reports`, `audit_logs`, `gateway_dns`, `gateway_http`, `gateway_network`, `dns_logs`, `network_analytics_logs`, `workers_trace_events`, `device_posture_results`, `zero_trust_network_sessions`, `magic_ids_detections`, `page_shield_events`.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="destinationConf")
    def destination_conf(self) -> pulumi.Input[str]:
        """
        Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included. See [Logpush destination documentation](https://developers.cloudflare.com/logs/reference/logpush-api-configuration#destination).
        """
        return pulumi.get(self, "destination_conf")

    @destination_conf.setter
    def destination_conf(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_conf", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable the job.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        Use filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/logpush-api-configuration/filters/).
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`frequency` has been deprecated in favour of using `max_upload_interval_seconds` instead.""")
    def frequency(self) -> Optional[pulumi.Input[str]]:
        """
        A higher frequency will result in logs being pushed on faster with smaller files. `low` frequency will push logs less often with larger files. Available values: `high`, `low`. Defaults to `high`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The kind of logpush job to create. Available values: `edge`, `instant-logs`, `""`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="logpullOptions")
    def logpull_options(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration string for the Logshare API. It specifies things like requested fields and timestamp formats. See [Logpush options documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#options).
        """
        return pulumi.get(self, "logpull_options")

    @logpull_options.setter
    def logpull_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logpull_options", value)

    @property
    @pulumi.getter(name="maxUploadBytes")
    def max_upload_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum uncompressed file size of a batch of logs. Value must be between 5MB and 1GB.
        """
        return pulumi.get(self, "max_upload_bytes")

    @max_upload_bytes.setter
    def max_upload_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_upload_bytes", value)

    @property
    @pulumi.getter(name="maxUploadIntervalSeconds")
    def max_upload_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum interval in seconds for log batches. Value must be between 30 and 300.
        """
        return pulumi.get(self, "max_upload_interval_seconds")

    @max_upload_interval_seconds.setter
    def max_upload_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_upload_interval_seconds", value)

    @property
    @pulumi.getter(name="maxUploadRecords")
    def max_upload_records(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of log lines per batch. Value must be between 1000 and 1,000,000.
        """
        return pulumi.get(self, "max_upload_records")

    @max_upload_records.setter
    def max_upload_records(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_upload_records", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the logpush job to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputOptions")
    def output_options(self) -> Optional[pulumi.Input['LogpushJobOutputOptionsArgs']]:
        """
        Structured replacement for logpull*options. When including this field, the logpull*option field will be ignored.
        """
        return pulumi.get(self, "output_options")

    @output_options.setter
    def output_options(self, value: Optional[pulumi.Input['LogpushJobOutputOptionsArgs']]):
        pulumi.set(self, "output_options", value)

    @property
    @pulumi.getter(name="ownershipChallenge")
    def ownership_challenge(self) -> Optional[pulumi.Input[str]]:
        """
        Ownership challenge token to prove destination ownership, required when destination is Amazon S3, Google Cloud Storage, Microsoft Azure or Sumo Logic. See [Developer documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#usage).
        """
        return pulumi.get(self, "ownership_challenge")

    @ownership_challenge.setter
    def ownership_challenge(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_challenge", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _LogpushJobState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 destination_conf: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 frequency: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 logpull_options: Optional[pulumi.Input[str]] = None,
                 max_upload_bytes: Optional[pulumi.Input[int]] = None,
                 max_upload_interval_seconds: Optional[pulumi.Input[int]] = None,
                 max_upload_records: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_options: Optional[pulumi.Input['LogpushJobOutputOptionsArgs']] = None,
                 ownership_challenge: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LogpushJob resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        :param pulumi.Input[str] dataset: The kind of the dataset to use with the logpush job. Available values: `access_requests`, `casb_findings`, `firewall_events`, `http_requests`, `spectrum_events`, `nel_reports`, `audit_logs`, `gateway_dns`, `gateway_http`, `gateway_network`, `dns_logs`, `network_analytics_logs`, `workers_trace_events`, `device_posture_results`, `zero_trust_network_sessions`, `magic_ids_detections`, `page_shield_events`.
        :param pulumi.Input[str] destination_conf: Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included. See [Logpush destination documentation](https://developers.cloudflare.com/logs/reference/logpush-api-configuration#destination).
        :param pulumi.Input[bool] enabled: Whether to enable the job.
        :param pulumi.Input[str] filter: Use filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/logpush-api-configuration/filters/).
        :param pulumi.Input[str] frequency: A higher frequency will result in logs being pushed on faster with smaller files. `low` frequency will push logs less often with larger files. Available values: `high`, `low`. Defaults to `high`.
        :param pulumi.Input[str] kind: The kind of logpush job to create. Available values: `edge`, `instant-logs`, `""`.
        :param pulumi.Input[str] logpull_options: Configuration string for the Logshare API. It specifies things like requested fields and timestamp formats. See [Logpush options documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#options).
        :param pulumi.Input[int] max_upload_bytes: The maximum uncompressed file size of a batch of logs. Value must be between 5MB and 1GB.
        :param pulumi.Input[int] max_upload_interval_seconds: The maximum interval in seconds for log batches. Value must be between 30 and 300.
        :param pulumi.Input[int] max_upload_records: The maximum number of log lines per batch. Value must be between 1000 and 1,000,000.
        :param pulumi.Input[str] name: The name of the logpush job to create.
        :param pulumi.Input['LogpushJobOutputOptionsArgs'] output_options: Structured replacement for logpull*options. When including this field, the logpull*option field will be ignored.
        :param pulumi.Input[str] ownership_challenge: Ownership challenge token to prove destination ownership, required when destination is Amazon S3, Google Cloud Storage, Microsoft Azure or Sumo Logic. See [Developer documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#usage).
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if destination_conf is not None:
            pulumi.set(__self__, "destination_conf", destination_conf)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if frequency is not None:
            warnings.warn("""`frequency` has been deprecated in favour of using `max_upload_interval_seconds` instead.""", DeprecationWarning)
            pulumi.log.warn("""frequency is deprecated: `frequency` has been deprecated in favour of using `max_upload_interval_seconds` instead.""")
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if logpull_options is not None:
            pulumi.set(__self__, "logpull_options", logpull_options)
        if max_upload_bytes is not None:
            pulumi.set(__self__, "max_upload_bytes", max_upload_bytes)
        if max_upload_interval_seconds is not None:
            pulumi.set(__self__, "max_upload_interval_seconds", max_upload_interval_seconds)
        if max_upload_records is not None:
            pulumi.set(__self__, "max_upload_records", max_upload_records)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_options is not None:
            pulumi.set(__self__, "output_options", output_options)
        if ownership_challenge is not None:
            pulumi.set(__self__, "ownership_challenge", ownership_challenge)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[str]]:
        """
        The kind of the dataset to use with the logpush job. Available values: `access_requests`, `casb_findings`, `firewall_events`, `http_requests`, `spectrum_events`, `nel_reports`, `audit_logs`, `gateway_dns`, `gateway_http`, `gateway_network`, `dns_logs`, `network_analytics_logs`, `workers_trace_events`, `device_posture_results`, `zero_trust_network_sessions`, `magic_ids_detections`, `page_shield_events`.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="destinationConf")
    def destination_conf(self) -> Optional[pulumi.Input[str]]:
        """
        Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included. See [Logpush destination documentation](https://developers.cloudflare.com/logs/reference/logpush-api-configuration#destination).
        """
        return pulumi.get(self, "destination_conf")

    @destination_conf.setter
    def destination_conf(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_conf", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable the job.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        Use filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/logpush-api-configuration/filters/).
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""`frequency` has been deprecated in favour of using `max_upload_interval_seconds` instead.""")
    def frequency(self) -> Optional[pulumi.Input[str]]:
        """
        A higher frequency will result in logs being pushed on faster with smaller files. `low` frequency will push logs less often with larger files. Available values: `high`, `low`. Defaults to `high`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The kind of logpush job to create. Available values: `edge`, `instant-logs`, `""`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="logpullOptions")
    def logpull_options(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration string for the Logshare API. It specifies things like requested fields and timestamp formats. See [Logpush options documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#options).
        """
        return pulumi.get(self, "logpull_options")

    @logpull_options.setter
    def logpull_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logpull_options", value)

    @property
    @pulumi.getter(name="maxUploadBytes")
    def max_upload_bytes(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum uncompressed file size of a batch of logs. Value must be between 5MB and 1GB.
        """
        return pulumi.get(self, "max_upload_bytes")

    @max_upload_bytes.setter
    def max_upload_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_upload_bytes", value)

    @property
    @pulumi.getter(name="maxUploadIntervalSeconds")
    def max_upload_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum interval in seconds for log batches. Value must be between 30 and 300.
        """
        return pulumi.get(self, "max_upload_interval_seconds")

    @max_upload_interval_seconds.setter
    def max_upload_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_upload_interval_seconds", value)

    @property
    @pulumi.getter(name="maxUploadRecords")
    def max_upload_records(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of log lines per batch. Value must be between 1000 and 1,000,000.
        """
        return pulumi.get(self, "max_upload_records")

    @max_upload_records.setter
    def max_upload_records(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_upload_records", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the logpush job to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputOptions")
    def output_options(self) -> Optional[pulumi.Input['LogpushJobOutputOptionsArgs']]:
        """
        Structured replacement for logpull*options. When including this field, the logpull*option field will be ignored.
        """
        return pulumi.get(self, "output_options")

    @output_options.setter
    def output_options(self, value: Optional[pulumi.Input['LogpushJobOutputOptionsArgs']]):
        pulumi.set(self, "output_options", value)

    @property
    @pulumi.getter(name="ownershipChallenge")
    def ownership_challenge(self) -> Optional[pulumi.Input[str]]:
        """
        Ownership challenge token to prove destination ownership, required when destination is Amazon S3, Google Cloud Storage, Microsoft Azure or Sumo Logic. See [Developer documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#usage).
        """
        return pulumi.get(self, "ownership_challenge")

    @ownership_challenge.setter
    def ownership_challenge(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership_challenge", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class LogpushJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 destination_conf: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 frequency: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 logpull_options: Optional[pulumi.Input[str]] = None,
                 max_upload_bytes: Optional[pulumi.Input[int]] = None,
                 max_upload_interval_seconds: Optional[pulumi.Input[int]] = None,
                 max_upload_records: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_options: Optional[pulumi.Input[Union['LogpushJobOutputOptionsArgs', 'LogpushJobOutputOptionsArgsDict']]] = None,
                 ownership_challenge: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        Import an account-scoped job.

        ```sh
        $ pulumi import cloudflare:index/logpushJob:LogpushJob example account/<account_id>/<job_id>
        ```

        Import a zone-scoped job.

        ```sh
        $ pulumi import cloudflare:index/logpushJob:LogpushJob example zone/<zone_id>/<job_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        :param pulumi.Input[str] dataset: The kind of the dataset to use with the logpush job. Available values: `access_requests`, `casb_findings`, `firewall_events`, `http_requests`, `spectrum_events`, `nel_reports`, `audit_logs`, `gateway_dns`, `gateway_http`, `gateway_network`, `dns_logs`, `network_analytics_logs`, `workers_trace_events`, `device_posture_results`, `zero_trust_network_sessions`, `magic_ids_detections`, `page_shield_events`.
        :param pulumi.Input[str] destination_conf: Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included. See [Logpush destination documentation](https://developers.cloudflare.com/logs/reference/logpush-api-configuration#destination).
        :param pulumi.Input[bool] enabled: Whether to enable the job.
        :param pulumi.Input[str] filter: Use filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/logpush-api-configuration/filters/).
        :param pulumi.Input[str] frequency: A higher frequency will result in logs being pushed on faster with smaller files. `low` frequency will push logs less often with larger files. Available values: `high`, `low`. Defaults to `high`.
        :param pulumi.Input[str] kind: The kind of logpush job to create. Available values: `edge`, `instant-logs`, `""`.
        :param pulumi.Input[str] logpull_options: Configuration string for the Logshare API. It specifies things like requested fields and timestamp formats. See [Logpush options documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#options).
        :param pulumi.Input[int] max_upload_bytes: The maximum uncompressed file size of a batch of logs. Value must be between 5MB and 1GB.
        :param pulumi.Input[int] max_upload_interval_seconds: The maximum interval in seconds for log batches. Value must be between 30 and 300.
        :param pulumi.Input[int] max_upload_records: The maximum number of log lines per batch. Value must be between 1000 and 1,000,000.
        :param pulumi.Input[str] name: The name of the logpush job to create.
        :param pulumi.Input[Union['LogpushJobOutputOptionsArgs', 'LogpushJobOutputOptionsArgsDict']] output_options: Structured replacement for logpull*options. When including this field, the logpull*option field will be ignored.
        :param pulumi.Input[str] ownership_challenge: Ownership challenge token to prove destination ownership, required when destination is Amazon S3, Google Cloud Storage, Microsoft Azure or Sumo Logic. See [Developer documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#usage).
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogpushJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        Import an account-scoped job.

        ```sh
        $ pulumi import cloudflare:index/logpushJob:LogpushJob example account/<account_id>/<job_id>
        ```

        Import a zone-scoped job.

        ```sh
        $ pulumi import cloudflare:index/logpushJob:LogpushJob example zone/<zone_id>/<job_id>
        ```

        :param str resource_name: The name of the resource.
        :param LogpushJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogpushJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 destination_conf: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 frequency: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 logpull_options: Optional[pulumi.Input[str]] = None,
                 max_upload_bytes: Optional[pulumi.Input[int]] = None,
                 max_upload_interval_seconds: Optional[pulumi.Input[int]] = None,
                 max_upload_records: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_options: Optional[pulumi.Input[Union['LogpushJobOutputOptionsArgs', 'LogpushJobOutputOptionsArgsDict']]] = None,
                 ownership_challenge: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogpushJobArgs.__new__(LogpushJobArgs)

            __props__.__dict__["account_id"] = account_id
            if dataset is None and not opts.urn:
                raise TypeError("Missing required property 'dataset'")
            __props__.__dict__["dataset"] = dataset
            if destination_conf is None and not opts.urn:
                raise TypeError("Missing required property 'destination_conf'")
            __props__.__dict__["destination_conf"] = destination_conf
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["filter"] = filter
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["kind"] = kind
            __props__.__dict__["logpull_options"] = logpull_options
            __props__.__dict__["max_upload_bytes"] = max_upload_bytes
            __props__.__dict__["max_upload_interval_seconds"] = max_upload_interval_seconds
            __props__.__dict__["max_upload_records"] = max_upload_records
            __props__.__dict__["name"] = name
            __props__.__dict__["output_options"] = output_options
            __props__.__dict__["ownership_challenge"] = ownership_challenge
            __props__.__dict__["zone_id"] = zone_id
        super(LogpushJob, __self__).__init__(
            'cloudflare:index/logpushJob:LogpushJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            dataset: Optional[pulumi.Input[str]] = None,
            destination_conf: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            filter: Optional[pulumi.Input[str]] = None,
            frequency: Optional[pulumi.Input[str]] = None,
            kind: Optional[pulumi.Input[str]] = None,
            logpull_options: Optional[pulumi.Input[str]] = None,
            max_upload_bytes: Optional[pulumi.Input[int]] = None,
            max_upload_interval_seconds: Optional[pulumi.Input[int]] = None,
            max_upload_records: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            output_options: Optional[pulumi.Input[Union['LogpushJobOutputOptionsArgs', 'LogpushJobOutputOptionsArgsDict']]] = None,
            ownership_challenge: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'LogpushJob':
        """
        Get an existing LogpushJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        :param pulumi.Input[str] dataset: The kind of the dataset to use with the logpush job. Available values: `access_requests`, `casb_findings`, `firewall_events`, `http_requests`, `spectrum_events`, `nel_reports`, `audit_logs`, `gateway_dns`, `gateway_http`, `gateway_network`, `dns_logs`, `network_analytics_logs`, `workers_trace_events`, `device_posture_results`, `zero_trust_network_sessions`, `magic_ids_detections`, `page_shield_events`.
        :param pulumi.Input[str] destination_conf: Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included. See [Logpush destination documentation](https://developers.cloudflare.com/logs/reference/logpush-api-configuration#destination).
        :param pulumi.Input[bool] enabled: Whether to enable the job.
        :param pulumi.Input[str] filter: Use filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/logpush-api-configuration/filters/).
        :param pulumi.Input[str] frequency: A higher frequency will result in logs being pushed on faster with smaller files. `low` frequency will push logs less often with larger files. Available values: `high`, `low`. Defaults to `high`.
        :param pulumi.Input[str] kind: The kind of logpush job to create. Available values: `edge`, `instant-logs`, `""`.
        :param pulumi.Input[str] logpull_options: Configuration string for the Logshare API. It specifies things like requested fields and timestamp formats. See [Logpush options documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#options).
        :param pulumi.Input[int] max_upload_bytes: The maximum uncompressed file size of a batch of logs. Value must be between 5MB and 1GB.
        :param pulumi.Input[int] max_upload_interval_seconds: The maximum interval in seconds for log batches. Value must be between 30 and 300.
        :param pulumi.Input[int] max_upload_records: The maximum number of log lines per batch. Value must be between 1000 and 1,000,000.
        :param pulumi.Input[str] name: The name of the logpush job to create.
        :param pulumi.Input[Union['LogpushJobOutputOptionsArgs', 'LogpushJobOutputOptionsArgsDict']] output_options: Structured replacement for logpull*options. When including this field, the logpull*option field will be ignored.
        :param pulumi.Input[str] ownership_challenge: Ownership challenge token to prove destination ownership, required when destination is Amazon S3, Google Cloud Storage, Microsoft Azure or Sumo Logic. See [Developer documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#usage).
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogpushJobState.__new__(_LogpushJobState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["destination_conf"] = destination_conf
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["filter"] = filter
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["kind"] = kind
        __props__.__dict__["logpull_options"] = logpull_options
        __props__.__dict__["max_upload_bytes"] = max_upload_bytes
        __props__.__dict__["max_upload_interval_seconds"] = max_upload_interval_seconds
        __props__.__dict__["max_upload_records"] = max_upload_records
        __props__.__dict__["name"] = name
        __props__.__dict__["output_options"] = output_options
        __props__.__dict__["ownership_challenge"] = ownership_challenge
        __props__.__dict__["zone_id"] = zone_id
        return LogpushJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[str]]:
        """
        The account identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[str]:
        """
        The kind of the dataset to use with the logpush job. Available values: `access_requests`, `casb_findings`, `firewall_events`, `http_requests`, `spectrum_events`, `nel_reports`, `audit_logs`, `gateway_dns`, `gateway_http`, `gateway_network`, `dns_logs`, `network_analytics_logs`, `workers_trace_events`, `device_posture_results`, `zero_trust_network_sessions`, `magic_ids_detections`, `page_shield_events`.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="destinationConf")
    def destination_conf(self) -> pulumi.Output[str]:
        """
        Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included. See [Logpush destination documentation](https://developers.cloudflare.com/logs/reference/logpush-api-configuration#destination).
        """
        return pulumi.get(self, "destination_conf")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable the job.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional[str]]:
        """
        Use filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/logpush-api-configuration/filters/).
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    @_utilities.deprecated("""`frequency` has been deprecated in favour of using `max_upload_interval_seconds` instead.""")
    def frequency(self) -> pulumi.Output[Optional[str]]:
        """
        A higher frequency will result in logs being pushed on faster with smaller files. `low` frequency will push logs less often with larger files. Available values: `high`, `low`. Defaults to `high`.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[str]]:
        """
        The kind of logpush job to create. Available values: `edge`, `instant-logs`, `""`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="logpullOptions")
    def logpull_options(self) -> pulumi.Output[Optional[str]]:
        """
        Configuration string for the Logshare API. It specifies things like requested fields and timestamp formats. See [Logpush options documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#options).
        """
        return pulumi.get(self, "logpull_options")

    @property
    @pulumi.getter(name="maxUploadBytes")
    def max_upload_bytes(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum uncompressed file size of a batch of logs. Value must be between 5MB and 1GB.
        """
        return pulumi.get(self, "max_upload_bytes")

    @property
    @pulumi.getter(name="maxUploadIntervalSeconds")
    def max_upload_interval_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum interval in seconds for log batches. Value must be between 30 and 300.
        """
        return pulumi.get(self, "max_upload_interval_seconds")

    @property
    @pulumi.getter(name="maxUploadRecords")
    def max_upload_records(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of log lines per batch. Value must be between 1000 and 1,000,000.
        """
        return pulumi.get(self, "max_upload_records")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the logpush job to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputOptions")
    def output_options(self) -> pulumi.Output[Optional['outputs.LogpushJobOutputOptions']]:
        """
        Structured replacement for logpull*options. When including this field, the logpull*option field will be ignored.
        """
        return pulumi.get(self, "output_options")

    @property
    @pulumi.getter(name="ownershipChallenge")
    def ownership_challenge(self) -> pulumi.Output[Optional[str]]:
        """
        Ownership challenge token to prove destination ownership, required when destination is Amazon S3, Google Cloud Storage, Microsoft Azure or Sumo Logic. See [Developer documentation](https://developers.cloudflare.com/logs/logpush/logpush-configuration-api/understanding-logpush-api/#usage).
        """
        return pulumi.get(self, "ownership_challenge")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[str]]:
        """
        The zone identifier to target for the resource. Must provide only one of `account_id`, `zone_id`.
        """
        return pulumi.get(self, "zone_id")

