# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WaitingRoomArgs', 'WaitingRoom']

@pulumi.input_type
class WaitingRoomArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[str],
                 name: pulumi.Input[str],
                 new_users_per_minute: pulumi.Input[int],
                 total_active_users: pulumi.Input[int],
                 zone_id: pulumi.Input[str],
                 additional_routes: Optional[pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]]] = None,
                 cookie_suffix: Optional[pulumi.Input[str]] = None,
                 custom_page_html: Optional[pulumi.Input[str]] = None,
                 default_template_language: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[bool]] = None,
                 enabled_origin_commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 json_response_enabled: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 queue_all: Optional[pulumi.Input[bool]] = None,
                 queueing_method: Optional[pulumi.Input[str]] = None,
                 queueing_status_code: Optional[pulumi.Input[int]] = None,
                 session_duration: Optional[pulumi.Input[int]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a WaitingRoom resource.
        :param pulumi.Input[str] host: Host name for which the waiting room will be applied (no wildcards).
        :param pulumi.Input[str] name: A unique name to identify the waiting room. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[int] new_users_per_minute: The number of new users that will be let into the route every minute.
        :param pulumi.Input[int] total_active_users: The total number of active user sessions on the route at a point in time.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]] additional_routes: A list of additional hostname and paths combination to be applied on the waiting room.
        :param pulumi.Input[str] cookie_suffix: A cookie suffix to be appended to the Cloudflare waiting room cookie name.
        :param pulumi.Input[str] custom_page_html: This is a templated html file that will be rendered at the edge.
        :param pulumi.Input[str] default_template_language: The language to use for the default waiting room page. Available values: `de-DE`, `es-ES`, `en-US`, `fr-FR`, `id-ID`, `it-IT`, `ja-JP`, `ko-KR`, `nl-NL`, `pl-PL`, `pt-BR`, `tr-TR`, `zh-CN`, `zh-TW`, `ru-RU`, `fa-IR`. Defaults to `en-US`.
        :param pulumi.Input[str] description: A description to add more details about the waiting room.
        :param pulumi.Input[bool] disable_session_renewal: Disables automatic renewal of session cookies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_origin_commands: The list of enabled origin commands for the waiting room. Available values: `revoke`.
        :param pulumi.Input[bool] json_response_enabled: If true, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object.
        :param pulumi.Input[str] path: The path within the host to enable the waiting room on. Defaults to `/`.
        :param pulumi.Input[bool] queue_all: If queue_all is true, then all traffic will be sent to the waiting room.
        :param pulumi.Input[str] queueing_method: The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`. Defaults to `fifo`.
        :param pulumi.Input[int] queueing_status_code: HTTP status code returned to a user while in the queue. Defaults to `200`.
        :param pulumi.Input[int] session_duration: Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin. Defaults to `5`.
        :param pulumi.Input[bool] suspended: Suspends the waiting room.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "new_users_per_minute", new_users_per_minute)
        pulumi.set(__self__, "total_active_users", total_active_users)
        pulumi.set(__self__, "zone_id", zone_id)
        if additional_routes is not None:
            pulumi.set(__self__, "additional_routes", additional_routes)
        if cookie_suffix is not None:
            pulumi.set(__self__, "cookie_suffix", cookie_suffix)
        if custom_page_html is not None:
            pulumi.set(__self__, "custom_page_html", custom_page_html)
        if default_template_language is not None:
            pulumi.set(__self__, "default_template_language", default_template_language)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_session_renewal is not None:
            pulumi.set(__self__, "disable_session_renewal", disable_session_renewal)
        if enabled_origin_commands is not None:
            pulumi.set(__self__, "enabled_origin_commands", enabled_origin_commands)
        if json_response_enabled is not None:
            pulumi.set(__self__, "json_response_enabled", json_response_enabled)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if queue_all is not None:
            pulumi.set(__self__, "queue_all", queue_all)
        if queueing_method is not None:
            pulumi.set(__self__, "queueing_method", queueing_method)
        if queueing_status_code is not None:
            pulumi.set(__self__, "queueing_status_code", queueing_status_code)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[str]:
        """
        Host name for which the waiting room will be applied (no wildcards).
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A unique name to identify the waiting room. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> pulumi.Input[int]:
        """
        The number of new users that will be let into the route every minute.
        """
        return pulumi.get(self, "new_users_per_minute")

    @new_users_per_minute.setter
    def new_users_per_minute(self, value: pulumi.Input[int]):
        pulumi.set(self, "new_users_per_minute", value)

    @property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> pulumi.Input[int]:
        """
        The total number of active user sessions on the route at a point in time.
        """
        return pulumi.get(self, "total_active_users")

    @total_active_users.setter
    def total_active_users(self, value: pulumi.Input[int]):
        pulumi.set(self, "total_active_users", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="additionalRoutes")
    def additional_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]]]:
        """
        A list of additional hostname and paths combination to be applied on the waiting room.
        """
        return pulumi.get(self, "additional_routes")

    @additional_routes.setter
    def additional_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]]]):
        pulumi.set(self, "additional_routes", value)

    @property
    @pulumi.getter(name="cookieSuffix")
    def cookie_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        A cookie suffix to be appended to the Cloudflare waiting room cookie name.
        """
        return pulumi.get(self, "cookie_suffix")

    @cookie_suffix.setter
    def cookie_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cookie_suffix", value)

    @property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> Optional[pulumi.Input[str]]:
        """
        This is a templated html file that will be rendered at the edge.
        """
        return pulumi.get(self, "custom_page_html")

    @custom_page_html.setter
    def custom_page_html(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_page_html", value)

    @property
    @pulumi.getter(name="defaultTemplateLanguage")
    def default_template_language(self) -> Optional[pulumi.Input[str]]:
        """
        The language to use for the default waiting room page. Available values: `de-DE`, `es-ES`, `en-US`, `fr-FR`, `id-ID`, `it-IT`, `ja-JP`, `ko-KR`, `nl-NL`, `pl-PL`, `pt-BR`, `tr-TR`, `zh-CN`, `zh-TW`, `ru-RU`, `fa-IR`. Defaults to `en-US`.
        """
        return pulumi.get(self, "default_template_language")

    @default_template_language.setter
    def default_template_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_template_language", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description to add more details about the waiting room.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableSessionRenewal")
    def disable_session_renewal(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables automatic renewal of session cookies.
        """
        return pulumi.get(self, "disable_session_renewal")

    @disable_session_renewal.setter
    def disable_session_renewal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_session_renewal", value)

    @property
    @pulumi.getter(name="enabledOriginCommands")
    def enabled_origin_commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of enabled origin commands for the waiting room. Available values: `revoke`.
        """
        return pulumi.get(self, "enabled_origin_commands")

    @enabled_origin_commands.setter
    def enabled_origin_commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_origin_commands", value)

    @property
    @pulumi.getter(name="jsonResponseEnabled")
    def json_response_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object.
        """
        return pulumi.get(self, "json_response_enabled")

    @json_response_enabled.setter
    def json_response_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "json_response_enabled", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path within the host to enable the waiting room on. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="queueAll")
    def queue_all(self) -> Optional[pulumi.Input[bool]]:
        """
        If queue_all is true, then all traffic will be sent to the waiting room.
        """
        return pulumi.get(self, "queue_all")

    @queue_all.setter
    def queue_all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "queue_all", value)

    @property
    @pulumi.getter(name="queueingMethod")
    def queueing_method(self) -> Optional[pulumi.Input[str]]:
        """
        The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`. Defaults to `fifo`.
        """
        return pulumi.get(self, "queueing_method")

    @queueing_method.setter
    def queueing_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queueing_method", value)

    @property
    @pulumi.getter(name="queueingStatusCode")
    def queueing_status_code(self) -> Optional[pulumi.Input[int]]:
        """
        HTTP status code returned to a user while in the queue. Defaults to `200`.
        """
        return pulumi.get(self, "queueing_status_code")

    @queueing_status_code.setter
    def queueing_status_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queueing_status_code", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin. Defaults to `5`.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_duration", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[bool]]:
        """
        Suspends the waiting room.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "suspended", value)


@pulumi.input_type
class _WaitingRoomState:
    def __init__(__self__, *,
                 additional_routes: Optional[pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]]] = None,
                 cookie_suffix: Optional[pulumi.Input[str]] = None,
                 custom_page_html: Optional[pulumi.Input[str]] = None,
                 default_template_language: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[bool]] = None,
                 enabled_origin_commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 json_response_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 queue_all: Optional[pulumi.Input[bool]] = None,
                 queueing_method: Optional[pulumi.Input[str]] = None,
                 queueing_status_code: Optional[pulumi.Input[int]] = None,
                 session_duration: Optional[pulumi.Input[int]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 total_active_users: Optional[pulumi.Input[int]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WaitingRoom resources.
        :param pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]] additional_routes: A list of additional hostname and paths combination to be applied on the waiting room.
        :param pulumi.Input[str] cookie_suffix: A cookie suffix to be appended to the Cloudflare waiting room cookie name.
        :param pulumi.Input[str] custom_page_html: This is a templated html file that will be rendered at the edge.
        :param pulumi.Input[str] default_template_language: The language to use for the default waiting room page. Available values: `de-DE`, `es-ES`, `en-US`, `fr-FR`, `id-ID`, `it-IT`, `ja-JP`, `ko-KR`, `nl-NL`, `pl-PL`, `pt-BR`, `tr-TR`, `zh-CN`, `zh-TW`, `ru-RU`, `fa-IR`. Defaults to `en-US`.
        :param pulumi.Input[str] description: A description to add more details about the waiting room.
        :param pulumi.Input[bool] disable_session_renewal: Disables automatic renewal of session cookies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_origin_commands: The list of enabled origin commands for the waiting room. Available values: `revoke`.
        :param pulumi.Input[str] host: Host name for which the waiting room will be applied (no wildcards).
        :param pulumi.Input[bool] json_response_enabled: If true, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object.
        :param pulumi.Input[str] name: A unique name to identify the waiting room. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[int] new_users_per_minute: The number of new users that will be let into the route every minute.
        :param pulumi.Input[str] path: The path within the host to enable the waiting room on. Defaults to `/`.
        :param pulumi.Input[bool] queue_all: If queue_all is true, then all traffic will be sent to the waiting room.
        :param pulumi.Input[str] queueing_method: The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`. Defaults to `fifo`.
        :param pulumi.Input[int] queueing_status_code: HTTP status code returned to a user while in the queue. Defaults to `200`.
        :param pulumi.Input[int] session_duration: Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin. Defaults to `5`.
        :param pulumi.Input[bool] suspended: Suspends the waiting room.
        :param pulumi.Input[int] total_active_users: The total number of active user sessions on the route at a point in time.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        if additional_routes is not None:
            pulumi.set(__self__, "additional_routes", additional_routes)
        if cookie_suffix is not None:
            pulumi.set(__self__, "cookie_suffix", cookie_suffix)
        if custom_page_html is not None:
            pulumi.set(__self__, "custom_page_html", custom_page_html)
        if default_template_language is not None:
            pulumi.set(__self__, "default_template_language", default_template_language)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_session_renewal is not None:
            pulumi.set(__self__, "disable_session_renewal", disable_session_renewal)
        if enabled_origin_commands is not None:
            pulumi.set(__self__, "enabled_origin_commands", enabled_origin_commands)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if json_response_enabled is not None:
            pulumi.set(__self__, "json_response_enabled", json_response_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_users_per_minute is not None:
            pulumi.set(__self__, "new_users_per_minute", new_users_per_minute)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if queue_all is not None:
            pulumi.set(__self__, "queue_all", queue_all)
        if queueing_method is not None:
            pulumi.set(__self__, "queueing_method", queueing_method)
        if queueing_status_code is not None:
            pulumi.set(__self__, "queueing_status_code", queueing_status_code)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if total_active_users is not None:
            pulumi.set(__self__, "total_active_users", total_active_users)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="additionalRoutes")
    def additional_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]]]:
        """
        A list of additional hostname and paths combination to be applied on the waiting room.
        """
        return pulumi.get(self, "additional_routes")

    @additional_routes.setter
    def additional_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]]]):
        pulumi.set(self, "additional_routes", value)

    @property
    @pulumi.getter(name="cookieSuffix")
    def cookie_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        A cookie suffix to be appended to the Cloudflare waiting room cookie name.
        """
        return pulumi.get(self, "cookie_suffix")

    @cookie_suffix.setter
    def cookie_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cookie_suffix", value)

    @property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> Optional[pulumi.Input[str]]:
        """
        This is a templated html file that will be rendered at the edge.
        """
        return pulumi.get(self, "custom_page_html")

    @custom_page_html.setter
    def custom_page_html(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_page_html", value)

    @property
    @pulumi.getter(name="defaultTemplateLanguage")
    def default_template_language(self) -> Optional[pulumi.Input[str]]:
        """
        The language to use for the default waiting room page. Available values: `de-DE`, `es-ES`, `en-US`, `fr-FR`, `id-ID`, `it-IT`, `ja-JP`, `ko-KR`, `nl-NL`, `pl-PL`, `pt-BR`, `tr-TR`, `zh-CN`, `zh-TW`, `ru-RU`, `fa-IR`. Defaults to `en-US`.
        """
        return pulumi.get(self, "default_template_language")

    @default_template_language.setter
    def default_template_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_template_language", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description to add more details about the waiting room.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableSessionRenewal")
    def disable_session_renewal(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables automatic renewal of session cookies.
        """
        return pulumi.get(self, "disable_session_renewal")

    @disable_session_renewal.setter
    def disable_session_renewal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_session_renewal", value)

    @property
    @pulumi.getter(name="enabledOriginCommands")
    def enabled_origin_commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of enabled origin commands for the waiting room. Available values: `revoke`.
        """
        return pulumi.get(self, "enabled_origin_commands")

    @enabled_origin_commands.setter
    def enabled_origin_commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_origin_commands", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Host name for which the waiting room will be applied (no wildcards).
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="jsonResponseEnabled")
    def json_response_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object.
        """
        return pulumi.get(self, "json_response_enabled")

    @json_response_enabled.setter
    def json_response_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "json_response_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name to identify the waiting room. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> Optional[pulumi.Input[int]]:
        """
        The number of new users that will be let into the route every minute.
        """
        return pulumi.get(self, "new_users_per_minute")

    @new_users_per_minute.setter
    def new_users_per_minute(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "new_users_per_minute", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path within the host to enable the waiting room on. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="queueAll")
    def queue_all(self) -> Optional[pulumi.Input[bool]]:
        """
        If queue_all is true, then all traffic will be sent to the waiting room.
        """
        return pulumi.get(self, "queue_all")

    @queue_all.setter
    def queue_all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "queue_all", value)

    @property
    @pulumi.getter(name="queueingMethod")
    def queueing_method(self) -> Optional[pulumi.Input[str]]:
        """
        The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`. Defaults to `fifo`.
        """
        return pulumi.get(self, "queueing_method")

    @queueing_method.setter
    def queueing_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queueing_method", value)

    @property
    @pulumi.getter(name="queueingStatusCode")
    def queueing_status_code(self) -> Optional[pulumi.Input[int]]:
        """
        HTTP status code returned to a user while in the queue. Defaults to `200`.
        """
        return pulumi.get(self, "queueing_status_code")

    @queueing_status_code.setter
    def queueing_status_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queueing_status_code", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin. Defaults to `5`.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_duration", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[bool]]:
        """
        Suspends the waiting room.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "suspended", value)

    @property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of active user sessions on the route at a point in time.
        """
        return pulumi.get(self, "total_active_users")

    @total_active_users.setter
    def total_active_users(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_active_users", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class WaitingRoom(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WaitingRoomAdditionalRouteArgs', 'WaitingRoomAdditionalRouteArgsDict']]]]] = None,
                 cookie_suffix: Optional[pulumi.Input[str]] = None,
                 custom_page_html: Optional[pulumi.Input[str]] = None,
                 default_template_language: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[bool]] = None,
                 enabled_origin_commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 json_response_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 queue_all: Optional[pulumi.Input[bool]] = None,
                 queueing_method: Optional[pulumi.Input[str]] = None,
                 queueing_status_code: Optional[pulumi.Input[int]] = None,
                 session_duration: Optional[pulumi.Input[int]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 total_active_users: Optional[pulumi.Input[int]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Waiting Room resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        # Waiting Room
        example = cloudflare.WaitingRoom("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            name="foo",
            host="foo.example.com",
            path="/",
            new_users_per_minute=200,
            total_active_users=200,
            cookie_suffix="queue1",
            additional_routes=[
                {
                    "host": "shop1.example.com",
                    "path": "/example-path",
                },
                {
                    "host": "shop2.example.com",
                },
            ],
            queueing_status_code=200,
            enabled_origin_commands=["revoke"])
        ```

        ## Import

        Use the Zone ID and Waiting Room ID to import.

        ```sh
        $ pulumi import cloudflare:index/waitingRoom:WaitingRoom default <zone_id>/<waiting_room_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WaitingRoomAdditionalRouteArgs', 'WaitingRoomAdditionalRouteArgsDict']]]] additional_routes: A list of additional hostname and paths combination to be applied on the waiting room.
        :param pulumi.Input[str] cookie_suffix: A cookie suffix to be appended to the Cloudflare waiting room cookie name.
        :param pulumi.Input[str] custom_page_html: This is a templated html file that will be rendered at the edge.
        :param pulumi.Input[str] default_template_language: The language to use for the default waiting room page. Available values: `de-DE`, `es-ES`, `en-US`, `fr-FR`, `id-ID`, `it-IT`, `ja-JP`, `ko-KR`, `nl-NL`, `pl-PL`, `pt-BR`, `tr-TR`, `zh-CN`, `zh-TW`, `ru-RU`, `fa-IR`. Defaults to `en-US`.
        :param pulumi.Input[str] description: A description to add more details about the waiting room.
        :param pulumi.Input[bool] disable_session_renewal: Disables automatic renewal of session cookies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_origin_commands: The list of enabled origin commands for the waiting room. Available values: `revoke`.
        :param pulumi.Input[str] host: Host name for which the waiting room will be applied (no wildcards).
        :param pulumi.Input[bool] json_response_enabled: If true, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object.
        :param pulumi.Input[str] name: A unique name to identify the waiting room. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[int] new_users_per_minute: The number of new users that will be let into the route every minute.
        :param pulumi.Input[str] path: The path within the host to enable the waiting room on. Defaults to `/`.
        :param pulumi.Input[bool] queue_all: If queue_all is true, then all traffic will be sent to the waiting room.
        :param pulumi.Input[str] queueing_method: The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`. Defaults to `fifo`.
        :param pulumi.Input[int] queueing_status_code: HTTP status code returned to a user while in the queue. Defaults to `200`.
        :param pulumi.Input[int] session_duration: Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin. Defaults to `5`.
        :param pulumi.Input[bool] suspended: Suspends the waiting room.
        :param pulumi.Input[int] total_active_users: The total number of active user sessions on the route at a point in time.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WaitingRoomArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Waiting Room resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        # Waiting Room
        example = cloudflare.WaitingRoom("example",
            zone_id="0da42c8d2132a9ddaf714f9e7c920711",
            name="foo",
            host="foo.example.com",
            path="/",
            new_users_per_minute=200,
            total_active_users=200,
            cookie_suffix="queue1",
            additional_routes=[
                {
                    "host": "shop1.example.com",
                    "path": "/example-path",
                },
                {
                    "host": "shop2.example.com",
                },
            ],
            queueing_status_code=200,
            enabled_origin_commands=["revoke"])
        ```

        ## Import

        Use the Zone ID and Waiting Room ID to import.

        ```sh
        $ pulumi import cloudflare:index/waitingRoom:WaitingRoom default <zone_id>/<waiting_room_id>
        ```

        :param str resource_name: The name of the resource.
        :param WaitingRoomArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WaitingRoomArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WaitingRoomAdditionalRouteArgs', 'WaitingRoomAdditionalRouteArgsDict']]]]] = None,
                 cookie_suffix: Optional[pulumi.Input[str]] = None,
                 custom_page_html: Optional[pulumi.Input[str]] = None,
                 default_template_language: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[bool]] = None,
                 enabled_origin_commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 json_response_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 queue_all: Optional[pulumi.Input[bool]] = None,
                 queueing_method: Optional[pulumi.Input[str]] = None,
                 queueing_status_code: Optional[pulumi.Input[int]] = None,
                 session_duration: Optional[pulumi.Input[int]] = None,
                 suspended: Optional[pulumi.Input[bool]] = None,
                 total_active_users: Optional[pulumi.Input[int]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WaitingRoomArgs.__new__(WaitingRoomArgs)

            __props__.__dict__["additional_routes"] = additional_routes
            __props__.__dict__["cookie_suffix"] = cookie_suffix
            __props__.__dict__["custom_page_html"] = custom_page_html
            __props__.__dict__["default_template_language"] = default_template_language
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_session_renewal"] = disable_session_renewal
            __props__.__dict__["enabled_origin_commands"] = enabled_origin_commands
            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            __props__.__dict__["json_response_enabled"] = json_response_enabled
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if new_users_per_minute is None and not opts.urn:
                raise TypeError("Missing required property 'new_users_per_minute'")
            __props__.__dict__["new_users_per_minute"] = new_users_per_minute
            __props__.__dict__["path"] = path
            __props__.__dict__["queue_all"] = queue_all
            __props__.__dict__["queueing_method"] = queueing_method
            __props__.__dict__["queueing_status_code"] = queueing_status_code
            __props__.__dict__["session_duration"] = session_duration
            __props__.__dict__["suspended"] = suspended
            if total_active_users is None and not opts.urn:
                raise TypeError("Missing required property 'total_active_users'")
            __props__.__dict__["total_active_users"] = total_active_users
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(WaitingRoom, __self__).__init__(
            'cloudflare:index/waitingRoom:WaitingRoom',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WaitingRoomAdditionalRouteArgs', 'WaitingRoomAdditionalRouteArgsDict']]]]] = None,
            cookie_suffix: Optional[pulumi.Input[str]] = None,
            custom_page_html: Optional[pulumi.Input[str]] = None,
            default_template_language: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disable_session_renewal: Optional[pulumi.Input[bool]] = None,
            enabled_origin_commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            host: Optional[pulumi.Input[str]] = None,
            json_response_enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            new_users_per_minute: Optional[pulumi.Input[int]] = None,
            path: Optional[pulumi.Input[str]] = None,
            queue_all: Optional[pulumi.Input[bool]] = None,
            queueing_method: Optional[pulumi.Input[str]] = None,
            queueing_status_code: Optional[pulumi.Input[int]] = None,
            session_duration: Optional[pulumi.Input[int]] = None,
            suspended: Optional[pulumi.Input[bool]] = None,
            total_active_users: Optional[pulumi.Input[int]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'WaitingRoom':
        """
        Get an existing WaitingRoom resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WaitingRoomAdditionalRouteArgs', 'WaitingRoomAdditionalRouteArgsDict']]]] additional_routes: A list of additional hostname and paths combination to be applied on the waiting room.
        :param pulumi.Input[str] cookie_suffix: A cookie suffix to be appended to the Cloudflare waiting room cookie name.
        :param pulumi.Input[str] custom_page_html: This is a templated html file that will be rendered at the edge.
        :param pulumi.Input[str] default_template_language: The language to use for the default waiting room page. Available values: `de-DE`, `es-ES`, `en-US`, `fr-FR`, `id-ID`, `it-IT`, `ja-JP`, `ko-KR`, `nl-NL`, `pl-PL`, `pt-BR`, `tr-TR`, `zh-CN`, `zh-TW`, `ru-RU`, `fa-IR`. Defaults to `en-US`.
        :param pulumi.Input[str] description: A description to add more details about the waiting room.
        :param pulumi.Input[bool] disable_session_renewal: Disables automatic renewal of session cookies.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_origin_commands: The list of enabled origin commands for the waiting room. Available values: `revoke`.
        :param pulumi.Input[str] host: Host name for which the waiting room will be applied (no wildcards).
        :param pulumi.Input[bool] json_response_enabled: If true, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object.
        :param pulumi.Input[str] name: A unique name to identify the waiting room. **Modifying this attribute will force creation of a new resource.**
        :param pulumi.Input[int] new_users_per_minute: The number of new users that will be let into the route every minute.
        :param pulumi.Input[str] path: The path within the host to enable the waiting room on. Defaults to `/`.
        :param pulumi.Input[bool] queue_all: If queue_all is true, then all traffic will be sent to the waiting room.
        :param pulumi.Input[str] queueing_method: The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`. Defaults to `fifo`.
        :param pulumi.Input[int] queueing_status_code: HTTP status code returned to a user while in the queue. Defaults to `200`.
        :param pulumi.Input[int] session_duration: Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin. Defaults to `5`.
        :param pulumi.Input[bool] suspended: Suspends the waiting room.
        :param pulumi.Input[int] total_active_users: The total number of active user sessions on the route at a point in time.
        :param pulumi.Input[str] zone_id: The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WaitingRoomState.__new__(_WaitingRoomState)

        __props__.__dict__["additional_routes"] = additional_routes
        __props__.__dict__["cookie_suffix"] = cookie_suffix
        __props__.__dict__["custom_page_html"] = custom_page_html
        __props__.__dict__["default_template_language"] = default_template_language
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_session_renewal"] = disable_session_renewal
        __props__.__dict__["enabled_origin_commands"] = enabled_origin_commands
        __props__.__dict__["host"] = host
        __props__.__dict__["json_response_enabled"] = json_response_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["new_users_per_minute"] = new_users_per_minute
        __props__.__dict__["path"] = path
        __props__.__dict__["queue_all"] = queue_all
        __props__.__dict__["queueing_method"] = queueing_method
        __props__.__dict__["queueing_status_code"] = queueing_status_code
        __props__.__dict__["session_duration"] = session_duration
        __props__.__dict__["suspended"] = suspended
        __props__.__dict__["total_active_users"] = total_active_users
        __props__.__dict__["zone_id"] = zone_id
        return WaitingRoom(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalRoutes")
    def additional_routes(self) -> pulumi.Output[Optional[Sequence['outputs.WaitingRoomAdditionalRoute']]]:
        """
        A list of additional hostname and paths combination to be applied on the waiting room.
        """
        return pulumi.get(self, "additional_routes")

    @property
    @pulumi.getter(name="cookieSuffix")
    def cookie_suffix(self) -> pulumi.Output[Optional[str]]:
        """
        A cookie suffix to be appended to the Cloudflare waiting room cookie name.
        """
        return pulumi.get(self, "cookie_suffix")

    @property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> pulumi.Output[Optional[str]]:
        """
        This is a templated html file that will be rendered at the edge.
        """
        return pulumi.get(self, "custom_page_html")

    @property
    @pulumi.getter(name="defaultTemplateLanguage")
    def default_template_language(self) -> pulumi.Output[Optional[str]]:
        """
        The language to use for the default waiting room page. Available values: `de-DE`, `es-ES`, `en-US`, `fr-FR`, `id-ID`, `it-IT`, `ja-JP`, `ko-KR`, `nl-NL`, `pl-PL`, `pt-BR`, `tr-TR`, `zh-CN`, `zh-TW`, `ru-RU`, `fa-IR`. Defaults to `en-US`.
        """
        return pulumi.get(self, "default_template_language")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description to add more details about the waiting room.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableSessionRenewal")
    def disable_session_renewal(self) -> pulumi.Output[Optional[bool]]:
        """
        Disables automatic renewal of session cookies.
        """
        return pulumi.get(self, "disable_session_renewal")

    @property
    @pulumi.getter(name="enabledOriginCommands")
    def enabled_origin_commands(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of enabled origin commands for the waiting room. Available values: `revoke`.
        """
        return pulumi.get(self, "enabled_origin_commands")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        Host name for which the waiting room will be applied (no wildcards).
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="jsonResponseEnabled")
    def json_response_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object.
        """
        return pulumi.get(self, "json_response_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name to identify the waiting room. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> pulumi.Output[int]:
        """
        The number of new users that will be let into the route every minute.
        """
        return pulumi.get(self, "new_users_per_minute")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[str]]:
        """
        The path within the host to enable the waiting room on. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="queueAll")
    def queue_all(self) -> pulumi.Output[Optional[bool]]:
        """
        If queue_all is true, then all traffic will be sent to the waiting room.
        """
        return pulumi.get(self, "queue_all")

    @property
    @pulumi.getter(name="queueingMethod")
    def queueing_method(self) -> pulumi.Output[Optional[str]]:
        """
        The queueing method used by the waiting room. Available values: `fifo`, `random`, `passthrough`, `reject`. Defaults to `fifo`.
        """
        return pulumi.get(self, "queueing_method")

    @property
    @pulumi.getter(name="queueingStatusCode")
    def queueing_status_code(self) -> pulumi.Output[Optional[int]]:
        """
        HTTP status code returned to a user while in the queue. Defaults to `200`.
        """
        return pulumi.get(self, "queueing_status_code")

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> pulumi.Output[Optional[int]]:
        """
        Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the origin. Defaults to `5`.
        """
        return pulumi.get(self, "session_duration")

    @property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[Optional[bool]]:
        """
        Suspends the waiting room.
        """
        return pulumi.get(self, "suspended")

    @property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> pulumi.Output[int]:
        """
        The total number of active user sessions on the route at a point in time.
        """
        return pulumi.get(self, "total_active_users")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone identifier to target for the resource. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "zone_id")

