# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ZeroTrustGatewayCertificateArgs', 'ZeroTrustGatewayCertificate']

@pulumi.input_type
class ZeroTrustGatewayCertificateArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 activate: Optional[pulumi.Input[bool]] = None,
                 custom: Optional[pulumi.Input[bool]] = None,
                 gateway_managed: Optional[pulumi.Input[bool]] = None,
                 validity_period_days: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a ZeroTrustGatewayCertificate resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] activate: Whether or not to activate a certificate. A certificate must be activated to use in Gateway certificate settings. Defaults to `false`.
        :param pulumi.Input[bool] custom: The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        :param pulumi.Input[bool] gateway_managed: The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        :param pulumi.Input[int] validity_period_days: Number of days the generated certificate will be valid, minimum 1 day and maximum 30 years. Defaults to 5 years. Defaults to `1826`. Required when using `gateway_managed`. Conflicts with `custom`. **Modifying this attribute will force creation of a new resource.**
        """
        pulumi.set(__self__, "account_id", account_id)
        if activate is not None:
            pulumi.set(__self__, "activate", activate)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if gateway_managed is not None:
            pulumi.set(__self__, "gateway_managed", gateway_managed)
        if validity_period_days is not None:
            pulumi.set(__self__, "validity_period_days", validity_period_days)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def activate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to activate a certificate. A certificate must be activated to use in Gateway certificate settings. Defaults to `false`.
        """
        return pulumi.get(self, "activate")

    @activate.setter
    def activate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "activate", value)

    @property
    @pulumi.getter
    def custom(self) -> Optional[pulumi.Input[bool]]:
        """
        The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        """
        return pulumi.get(self, "custom")

    @custom.setter
    def custom(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom", value)

    @property
    @pulumi.getter(name="gatewayManaged")
    def gateway_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        """
        return pulumi.get(self, "gateway_managed")

    @gateway_managed.setter
    def gateway_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "gateway_managed", value)

    @property
    @pulumi.getter(name="validityPeriodDays")
    def validity_period_days(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days the generated certificate will be valid, minimum 1 day and maximum 30 years. Defaults to 5 years. Defaults to `1826`. Required when using `gateway_managed`. Conflicts with `custom`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "validity_period_days")

    @validity_period_days.setter
    def validity_period_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "validity_period_days", value)


@pulumi.input_type
class _ZeroTrustGatewayCertificateState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 activate: Optional[pulumi.Input[bool]] = None,
                 binding_status: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 custom: Optional[pulumi.Input[bool]] = None,
                 expires_on: Optional[pulumi.Input[str]] = None,
                 gateway_managed: Optional[pulumi.Input[bool]] = None,
                 in_use: Optional[pulumi.Input[bool]] = None,
                 qs_pack_id: Optional[pulumi.Input[str]] = None,
                 uploaded_on: Optional[pulumi.Input[str]] = None,
                 validity_period_days: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustGatewayCertificate resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] activate: Whether or not to activate a certificate. A certificate must be activated to use in Gateway certificate settings. Defaults to `false`.
        :param pulumi.Input[str] binding_status: The deployment status of the certificate on the edge Available values: `IP`, `SERIAL`, `URL`, `DOMAIN`, `EMAIL`.
        :param pulumi.Input[bool] custom: The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        :param pulumi.Input[bool] gateway_managed: The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        :param pulumi.Input[bool] in_use: Whether the certificate is in use by Gateway for TLS interception and the block page.
        :param pulumi.Input[int] validity_period_days: Number of days the generated certificate will be valid, minimum 1 day and maximum 30 years. Defaults to 5 years. Defaults to `1826`. Required when using `gateway_managed`. Conflicts with `custom`. **Modifying this attribute will force creation of a new resource.**
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if activate is not None:
            pulumi.set(__self__, "activate", activate)
        if binding_status is not None:
            pulumi.set(__self__, "binding_status", binding_status)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if expires_on is not None:
            pulumi.set(__self__, "expires_on", expires_on)
        if gateway_managed is not None:
            pulumi.set(__self__, "gateway_managed", gateway_managed)
        if in_use is not None:
            pulumi.set(__self__, "in_use", in_use)
        if qs_pack_id is not None:
            pulumi.set(__self__, "qs_pack_id", qs_pack_id)
        if uploaded_on is not None:
            pulumi.set(__self__, "uploaded_on", uploaded_on)
        if validity_period_days is not None:
            pulumi.set(__self__, "validity_period_days", validity_period_days)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def activate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to activate a certificate. A certificate must be activated to use in Gateway certificate settings. Defaults to `false`.
        """
        return pulumi.get(self, "activate")

    @activate.setter
    def activate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "activate", value)

    @property
    @pulumi.getter(name="bindingStatus")
    def binding_status(self) -> Optional[pulumi.Input[str]]:
        """
        The deployment status of the certificate on the edge Available values: `IP`, `SERIAL`, `URL`, `DOMAIN`, `EMAIL`.
        """
        return pulumi.get(self, "binding_status")

    @binding_status.setter
    def binding_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "binding_status", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def custom(self) -> Optional[pulumi.Input[bool]]:
        """
        The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        """
        return pulumi.get(self, "custom")

    @custom.setter
    def custom(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom", value)

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "expires_on")

    @expires_on.setter
    def expires_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expires_on", value)

    @property
    @pulumi.getter(name="gatewayManaged")
    def gateway_managed(self) -> Optional[pulumi.Input[bool]]:
        """
        The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        """
        return pulumi.get(self, "gateway_managed")

    @gateway_managed.setter
    def gateway_managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "gateway_managed", value)

    @property
    @pulumi.getter(name="inUse")
    def in_use(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the certificate is in use by Gateway for TLS interception and the block page.
        """
        return pulumi.get(self, "in_use")

    @in_use.setter
    def in_use(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "in_use", value)

    @property
    @pulumi.getter(name="qsPackId")
    def qs_pack_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "qs_pack_id")

    @qs_pack_id.setter
    def qs_pack_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qs_pack_id", value)

    @property
    @pulumi.getter(name="uploadedOn")
    def uploaded_on(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "uploaded_on")

    @uploaded_on.setter
    def uploaded_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uploaded_on", value)

    @property
    @pulumi.getter(name="validityPeriodDays")
    def validity_period_days(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days the generated certificate will be valid, minimum 1 day and maximum 30 years. Defaults to 5 years. Defaults to `1826`. Required when using `gateway_managed`. Conflicts with `custom`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "validity_period_days")

    @validity_period_days.setter
    def validity_period_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "validity_period_days", value)


class ZeroTrustGatewayCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 activate: Optional[pulumi.Input[bool]] = None,
                 custom: Optional[pulumi.Input[bool]] = None,
                 gateway_managed: Optional[pulumi.Input[bool]] = None,
                 validity_period_days: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a Cloudflare Teams Gateway Certificate resource. A Teams Certificate can
        be specified for Gateway TLS interception and block pages.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] activate: Whether or not to activate a certificate. A certificate must be activated to use in Gateway certificate settings. Defaults to `false`.
        :param pulumi.Input[bool] custom: The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        :param pulumi.Input[bool] gateway_managed: The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        :param pulumi.Input[int] validity_period_days: Number of days the generated certificate will be valid, minimum 1 day and maximum 30 years. Defaults to 5 years. Defaults to `1826`. Required when using `gateway_managed`. Conflicts with `custom`. **Modifying this attribute will force creation of a new resource.**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustGatewayCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloudflare Teams Gateway Certificate resource. A Teams Certificate can
        be specified for Gateway TLS interception and block pages.

        :param str resource_name: The name of the resource.
        :param ZeroTrustGatewayCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustGatewayCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 activate: Optional[pulumi.Input[bool]] = None,
                 custom: Optional[pulumi.Input[bool]] = None,
                 gateway_managed: Optional[pulumi.Input[bool]] = None,
                 validity_period_days: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustGatewayCertificateArgs.__new__(ZeroTrustGatewayCertificateArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["activate"] = activate
            __props__.__dict__["custom"] = custom
            __props__.__dict__["gateway_managed"] = gateway_managed
            __props__.__dict__["validity_period_days"] = validity_period_days
            __props__.__dict__["binding_status"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["expires_on"] = None
            __props__.__dict__["in_use"] = None
            __props__.__dict__["qs_pack_id"] = None
            __props__.__dict__["uploaded_on"] = None
        super(ZeroTrustGatewayCertificate, __self__).__init__(
            'cloudflare:index/zeroTrustGatewayCertificate:ZeroTrustGatewayCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            activate: Optional[pulumi.Input[bool]] = None,
            binding_status: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            custom: Optional[pulumi.Input[bool]] = None,
            expires_on: Optional[pulumi.Input[str]] = None,
            gateway_managed: Optional[pulumi.Input[bool]] = None,
            in_use: Optional[pulumi.Input[bool]] = None,
            qs_pack_id: Optional[pulumi.Input[str]] = None,
            uploaded_on: Optional[pulumi.Input[str]] = None,
            validity_period_days: Optional[pulumi.Input[int]] = None) -> 'ZeroTrustGatewayCertificate':
        """
        Get an existing ZeroTrustGatewayCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] activate: Whether or not to activate a certificate. A certificate must be activated to use in Gateway certificate settings. Defaults to `false`.
        :param pulumi.Input[str] binding_status: The deployment status of the certificate on the edge Available values: `IP`, `SERIAL`, `URL`, `DOMAIN`, `EMAIL`.
        :param pulumi.Input[bool] custom: The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        :param pulumi.Input[bool] gateway_managed: The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        :param pulumi.Input[bool] in_use: Whether the certificate is in use by Gateway for TLS interception and the block page.
        :param pulumi.Input[int] validity_period_days: Number of days the generated certificate will be valid, minimum 1 day and maximum 30 years. Defaults to 5 years. Defaults to `1826`. Required when using `gateway_managed`. Conflicts with `custom`. **Modifying this attribute will force creation of a new resource.**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustGatewayCertificateState.__new__(_ZeroTrustGatewayCertificateState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["activate"] = activate
        __props__.__dict__["binding_status"] = binding_status
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["custom"] = custom
        __props__.__dict__["expires_on"] = expires_on
        __props__.__dict__["gateway_managed"] = gateway_managed
        __props__.__dict__["in_use"] = in_use
        __props__.__dict__["qs_pack_id"] = qs_pack_id
        __props__.__dict__["uploaded_on"] = uploaded_on
        __props__.__dict__["validity_period_days"] = validity_period_days
        return ZeroTrustGatewayCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def activate(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not to activate a certificate. A certificate must be activated to use in Gateway certificate settings. Defaults to `false`.
        """
        return pulumi.get(self, "activate")

    @property
    @pulumi.getter(name="bindingStatus")
    def binding_status(self) -> pulumi.Output[str]:
        """
        The deployment status of the certificate on the edge Available values: `IP`, `SERIAL`, `URL`, `DOMAIN`, `EMAIL`.
        """
        return pulumi.get(self, "binding_status")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def custom(self) -> pulumi.Output[Optional[bool]]:
        """
        The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        """
        return pulumi.get(self, "custom")

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> pulumi.Output[str]:
        return pulumi.get(self, "expires_on")

    @property
    @pulumi.getter(name="gatewayManaged")
    def gateway_managed(self) -> pulumi.Output[Optional[bool]]:
        """
        The type of certificate (custom or Gateway-managed). Must provide only one of `custom`, `gateway_managed`.
        """
        return pulumi.get(self, "gateway_managed")

    @property
    @pulumi.getter(name="inUse")
    def in_use(self) -> pulumi.Output[bool]:
        """
        Whether the certificate is in use by Gateway for TLS interception and the block page.
        """
        return pulumi.get(self, "in_use")

    @property
    @pulumi.getter(name="qsPackId")
    def qs_pack_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "qs_pack_id")

    @property
    @pulumi.getter(name="uploadedOn")
    def uploaded_on(self) -> pulumi.Output[str]:
        return pulumi.get(self, "uploaded_on")

    @property
    @pulumi.getter(name="validityPeriodDays")
    def validity_period_days(self) -> pulumi.Output[Optional[int]]:
        """
        Number of days the generated certificate will be valid, minimum 1 day and maximum 30 years. Defaults to 5 years. Defaults to `1826`. Required when using `gateway_managed`. Conflicts with `custom`. **Modifying this attribute will force creation of a new resource.**
        """
        return pulumi.get(self, "validity_period_days")

